<?php
/**
 * GeneralDataProtectionRegulationApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use \PureCloudSDK\Configuration;
use \PureCloudSDK\ApiClient;
use \PureCloudSDK\ApiException;
use \PureCloudSDK\ObjectSerializer;

/**
 * GeneralDataProtectionRegulationApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GeneralDataProtectionRegulationApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.ie');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return GeneralDataProtectionRegulationApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation getGdprRequest
     *
     * Get an existing GDPR request
     *
     * @param string $requestId Request id (required)
     * @return \PureCloudSDK\GDPRRequest
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getGdprRequest($requestId)
    {
        list($response) = $this->getGdprRequestWithHttpInfo($requestId);
        return $response;
    }

    /**
     * Operation getGdprRequestWithHttpInfo
     *
     * Get an existing GDPR request
     *
     * @param string $requestId Request id (required)
     * @return Array of \PureCloudSDK\GDPRRequest, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getGdprRequestWithHttpInfo($requestId)
    {
        // verify the required parameter 'requestId' is set
        if ($requestId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $requestId when calling getGdprRequest');
        }
        // parse inputs
        $resourcePath = "/api/v2/gdpr/requests/{requestId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($requestId !== null) {
            $resourcePath = str_replace(
                "{" . "requestId" . "}",
                $this->apiClient->getSerializer()->toPathValue($requestId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\GDPRRequest',
                '/api/v2/gdpr/requests/{requestId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\GDPRRequest', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\GDPRRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getGdprRequests
     *
     * Get all GDPR requests
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @return \PureCloudSDK\GDPRRequestEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getGdprRequests($pageSize = null, $pageNumber = null)
    {
        list($response) = $this->getGdprRequestsWithHttpInfo($pageSize, $pageNumber);
        return $response;
    }

    /**
     * Operation getGdprRequestsWithHttpInfo
     *
     * Get all GDPR requests
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @return Array of \PureCloudSDK\GDPRRequestEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getGdprRequestsWithHttpInfo($pageSize = null, $pageNumber = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/gdpr/requests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\GDPRRequestEntityListing',
                '/api/v2/gdpr/requests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\GDPRRequestEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\GDPRRequestEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getGdprSubjects
     *
     * Get GDPR subjects
     *
     * @param string $searchType Search Type (required)
     * @param string $searchValue Search Value (required)
     * @return \PureCloudSDK\GDPRSubjectEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getGdprSubjects($searchType, $searchValue)
    {
        list($response) = $this->getGdprSubjectsWithHttpInfo($searchType, $searchValue);
        return $response;
    }

    /**
     * Operation getGdprSubjectsWithHttpInfo
     *
     * Get GDPR subjects
     *
     * @param string $searchType Search Type (required)
     * @param string $searchValue Search Value (required)
     * @return Array of \PureCloudSDK\GDPRSubjectEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getGdprSubjectsWithHttpInfo($searchType, $searchValue)
    {
        // verify the required parameter 'searchType' is set
        if ($searchType === null) {
            throw new \InvalidArgumentException('Missing the required parameter $searchType when calling getGdprSubjects');
        }
        // verify the required parameter 'searchValue' is set
        if ($searchValue === null) {
            throw new \InvalidArgumentException('Missing the required parameter $searchValue when calling getGdprSubjects');
        }
        // parse inputs
        $resourcePath = "/api/v2/gdpr/subjects";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($searchType !== null) {
            $queryParams['searchType'] = $this->apiClient->getSerializer()->toQueryValue($searchType);
        }
        // query params
        if ($searchValue !== null) {
            $queryParams['searchValue'] = $this->apiClient->getSerializer()->toQueryValue($searchValue);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\GDPRSubjectEntityListing',
                '/api/v2/gdpr/subjects'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\GDPRSubjectEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\GDPRSubjectEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postGdprRequests
     *
     * Submit a new GDPR request
     *
     * @param \PureCloudSDK\GDPRRequest $body GDPR request (required)
     * @param bool $deleteConfirmed Confirm delete (optional, default to false)
     * @return \PureCloudSDK\GDPRRequest
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postGdprRequests($body, $deleteConfirmed = null)
    {
        list($response) = $this->postGdprRequestsWithHttpInfo($body, $deleteConfirmed);
        return $response;
    }

    /**
     * Operation postGdprRequestsWithHttpInfo
     *
     * Submit a new GDPR request
     *
     * @param \PureCloudSDK\GDPRRequest $body GDPR request (required)
     * @param bool $deleteConfirmed Confirm delete (optional, default to false)
     * @return Array of \PureCloudSDK\GDPRRequest, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postGdprRequestsWithHttpInfo($body, $deleteConfirmed = null)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postGdprRequests');
        }
        // parse inputs
        $resourcePath = "/api/v2/gdpr/requests";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($deleteConfirmed !== null) {
            $queryParams['deleteConfirmed'] = $this->apiClient->getSerializer()->toQueryValue($deleteConfirmed);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\GDPRRequest',
                '/api/v2/gdpr/requests'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\GDPRRequest', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\GDPRRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\GDPRRequest', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
