<?php
/**
 * CampaignRule
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CampaignRule Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CampaignRule implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CampaignRule';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'version' => 'int',
        'campaignRuleEntities' => '\PureCloudSDK\CampaignRuleEntities',
        'campaignRuleConditions' => '\PureCloudSDK\CampaignRuleCondition[]',
        'campaignRuleActions' => '\PureCloudSDK\CampaignRuleAction[]',
        'matchAnyConditions' => 'bool',
        'enabled' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'version' => 'version',
        'campaignRuleEntities' => 'campaignRuleEntities',
        'campaignRuleConditions' => 'campaignRuleConditions',
        'campaignRuleActions' => 'campaignRuleActions',
        'matchAnyConditions' => 'matchAnyConditions',
        'enabled' => 'enabled',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'version' => 'setVersion',
        'campaignRuleEntities' => 'setCampaignRuleEntities',
        'campaignRuleConditions' => 'setCampaignRuleConditions',
        'campaignRuleActions' => 'setCampaignRuleActions',
        'matchAnyConditions' => 'setMatchAnyConditions',
        'enabled' => 'setEnabled',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'version' => 'getVersion',
        'campaignRuleEntities' => 'getCampaignRuleEntities',
        'campaignRuleConditions' => 'getCampaignRuleConditions',
        'campaignRuleActions' => 'getCampaignRuleActions',
        'matchAnyConditions' => 'getMatchAnyConditions',
        'enabled' => 'getEnabled',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['campaignRuleEntities'] = isset($data['campaignRuleEntities']) ? $data['campaignRuleEntities'] : null;
        $this->container['campaignRuleConditions'] = isset($data['campaignRuleConditions']) ? $data['campaignRuleConditions'] : null;
        $this->container['campaignRuleActions'] = isset($data['campaignRuleActions']) ? $data['campaignRuleActions'] : null;
        $this->container['matchAnyConditions'] = isset($data['matchAnyConditions']) ? $data['matchAnyConditions'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['campaignRuleEntities'] === null) {
            $invalid_properties[] = "'campaignRuleEntities' can't be null";
        }
        if ($this->container['campaignRuleConditions'] === null) {
            $invalid_properties[] = "'campaignRuleConditions' can't be null";
        }
        if ($this->container['campaignRuleActions'] === null) {
            $invalid_properties[] = "'campaignRuleActions' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['campaignRuleEntities'] === null) {
            return false;
        }
        if ($this->container['campaignRuleConditions'] === null) {
            return false;
        }
        if ($this->container['campaignRuleActions'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the CampaignRule.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required for updates, must match the version number of the most recent update
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets campaignRuleEntities
     * @return \PureCloudSDK\CampaignRuleEntities
     */
    public function getCampaignRuleEntities()
    {
        return $this->container['campaignRuleEntities'];
    }

    /**
     * Sets campaignRuleEntities
     * @param \PureCloudSDK\CampaignRuleEntities $campaignRuleEntities The list of entities that this CampaignRule monitors.
     * @return $this
     */
    public function setCampaignRuleEntities($campaignRuleEntities)
    {
        $this->container['campaignRuleEntities'] = $campaignRuleEntities;

        return $this;
    }

    /**
     * Gets campaignRuleConditions
     * @return \PureCloudSDK\CampaignRuleCondition[]
     */
    public function getCampaignRuleConditions()
    {
        return $this->container['campaignRuleConditions'];
    }

    /**
     * Sets campaignRuleConditions
     * @param \PureCloudSDK\CampaignRuleCondition[] $campaignRuleConditions The list of conditions that are evaluated on the entities.
     * @return $this
     */
    public function setCampaignRuleConditions($campaignRuleConditions)
    {
        $this->container['campaignRuleConditions'] = $campaignRuleConditions;

        return $this;
    }

    /**
     * Gets campaignRuleActions
     * @return \PureCloudSDK\CampaignRuleAction[]
     */
    public function getCampaignRuleActions()
    {
        return $this->container['campaignRuleActions'];
    }

    /**
     * Sets campaignRuleActions
     * @param \PureCloudSDK\CampaignRuleAction[] $campaignRuleActions The list of actions that are executed if the conditions are satisfied.
     * @return $this
     */
    public function setCampaignRuleActions($campaignRuleActions)
    {
        $this->container['campaignRuleActions'] = $campaignRuleActions;

        return $this;
    }

    /**
     * Gets matchAnyConditions
     * @return bool
     */
    public function getMatchAnyConditions()
    {
        return $this->container['matchAnyConditions'];
    }

    /**
     * Sets matchAnyConditions
     * @param bool $matchAnyConditions
     * @return $this
     */
    public function setMatchAnyConditions($matchAnyConditions)
    {
        $this->container['matchAnyConditions'] = $matchAnyConditions;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled Whether or not this CampaignRule is currently enabled. Required on updates.
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


