<?php
/**
 * ContactListFilterPredicate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ContactListFilterPredicate Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ContactListFilterPredicate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ContactListFilterPredicate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'column' => 'string',
        'columnType' => 'string',
        'operator' => 'string',
        'value' => 'string',
        'range' => '\PureCloudSDK\ContactListFilterRange',
        'inverted' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'column' => 'column',
        'columnType' => 'columnType',
        'operator' => 'operator',
        'value' => 'value',
        'range' => 'range',
        'inverted' => 'inverted'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'column' => 'setColumn',
        'columnType' => 'setColumnType',
        'operator' => 'setOperator',
        'value' => 'setValue',
        'range' => 'setRange',
        'inverted' => 'setInverted'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'column' => 'getColumn',
        'columnType' => 'getColumnType',
        'operator' => 'getOperator',
        'value' => 'getValue',
        'range' => 'getRange',
        'inverted' => 'getInverted'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const COLUMN_TYPE_NUMERIC = 'numeric';
    const COLUMN_TYPE_ALPHABETIC = 'alphabetic';
    const OPERATOR_EQUALS = 'EQUALS';
    const OPERATOR_LESS_THAN = 'LESS_THAN';
    const OPERATOR_LESS_THAN_EQUALS = 'LESS_THAN_EQUALS';
    const OPERATOR_GREATER_THAN = 'GREATER_THAN';
    const OPERATOR_GREATER_THAN_EQUALS = 'GREATER_THAN_EQUALS';
    const OPERATOR_CONTAINS = 'CONTAINS';
    const OPERATOR_BEGINS_WITH = 'BEGINS_WITH';
    const OPERATOR_ENDS_WITH = 'ENDS_WITH';
    const OPERATOR_BEFORE = 'BEFORE';
    const OPERATOR_AFTER = 'AFTER';
    const OPERATOR_BETWEEN = 'BETWEEN';
    const OPERATOR_IN = 'IN';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getColumnTypeAllowableValues()
    {
        return [
            self::COLUMN_TYPE_NUMERIC,
            self::COLUMN_TYPE_ALPHABETIC,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_EQUALS,
            self::OPERATOR_LESS_THAN,
            self::OPERATOR_LESS_THAN_EQUALS,
            self::OPERATOR_GREATER_THAN,
            self::OPERATOR_GREATER_THAN_EQUALS,
            self::OPERATOR_CONTAINS,
            self::OPERATOR_BEGINS_WITH,
            self::OPERATOR_ENDS_WITH,
            self::OPERATOR_BEFORE,
            self::OPERATOR_AFTER,
            self::OPERATOR_BETWEEN,
            self::OPERATOR_IN,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['column'] = isset($data['column']) ? $data['column'] : null;
        $this->container['columnType'] = isset($data['columnType']) ? $data['columnType'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['range'] = isset($data['range']) ? $data['range'] : null;
        $this->container['inverted'] = isset($data['inverted']) ? $data['inverted'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("numeric", "alphabetic");
        if (!in_array($this->container['columnType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'columnType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("EQUALS", "LESS_THAN", "LESS_THAN_EQUALS", "GREATER_THAN", "GREATER_THAN_EQUALS", "CONTAINS", "BEGINS_WITH", "ENDS_WITH", "BEFORE", "AFTER", "BETWEEN", "IN");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("numeric", "alphabetic");
        if (!in_array($this->container['columnType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("EQUALS", "LESS_THAN", "LESS_THAN_EQUALS", "GREATER_THAN", "GREATER_THAN_EQUALS", "CONTAINS", "BEGINS_WITH", "ENDS_WITH", "BEFORE", "AFTER", "BETWEEN", "IN");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets column
     * @return string
     */
    public function getColumn()
    {
        return $this->container['column'];
    }

    /**
     * Sets column
     * @param string $column Contact list column from the ContactListFilter's contactList.
     * @return $this
     */
    public function setColumn($column)
    {
        $this->container['column'] = $column;

        return $this;
    }

    /**
     * Gets columnType
     * @return string
     */
    public function getColumnType()
    {
        return $this->container['columnType'];
    }

    /**
     * Sets columnType
     * @param string $columnType The type of data in the contact column.
     * @return $this
     */
    public function setColumnType($columnType)
    {
        $allowed_values = array('numeric', 'alphabetic');
        if (!in_array($columnType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'columnType', must be one of 'numeric', 'alphabetic'");
        }
        $this->container['columnType'] = $columnType;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator The operator for this ContactListFilterPredicate.
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('EQUALS', 'LESS_THAN', 'LESS_THAN_EQUALS', 'GREATER_THAN', 'GREATER_THAN_EQUALS', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', 'BEFORE', 'AFTER', 'BETWEEN', 'IN');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'EQUALS', 'LESS_THAN', 'LESS_THAN_EQUALS', 'GREATER_THAN', 'GREATER_THAN_EQUALS', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', 'BEFORE', 'AFTER', 'BETWEEN', 'IN'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value Value with which to compare the contact's data. This could be text, a number, or a relative time. A value for relative time should follow the format PxxDTyyHzzM, where xx, yy, and zz specify the days, hours and minutes. For example, a value of P01DT08H30M corresponds to 1 day, 8 hours, and 30 minutes from now. To specify a time in the past, include a negative sign before each numeric value. For example, a value of P-01DT-08H-30M corresponds to 1 day, 8 hours, and 30 minutes in the past. You can also do things like P01DT00H-30M, which would correspond to 23 hours and 30 minutes from now (1 day - 30 minutes).
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets range
     * @return \PureCloudSDK\ContactListFilterRange
     */
    public function getRange()
    {
        return $this->container['range'];
    }

    /**
     * Sets range
     * @param \PureCloudSDK\ContactListFilterRange $range A range of values. Required for operators BETWEEN and IN.
     * @return $this
     */
    public function setRange($range)
    {
        $this->container['range'] = $range;

        return $this;
    }

    /**
     * Gets inverted
     * @return bool
     */
    public function getInverted()
    {
        return $this->container['inverted'];
    }

    /**
     * Sets inverted
     * @param bool $inverted Inverts the result of the predicate (i.e., if the predicate returns true, inverting it will return false).
     * @return $this
     */
    public function setInverted($inverted)
    {
        $this->container['inverted'] = $inverted;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


