<?php
/**
 * CreateAgentTimeOffRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CreateAgentTimeOffRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateAgentTimeOffRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateAgentTimeOffRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'activityCodeId' => 'string',
        'notes' => 'string',
        'fullDayManagementUnitDates' => 'string[]',
        'partialDayStartDateTimes' => '\DateTime[]',
        'dailyDurationMinutes' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'activityCodeId' => 'activityCodeId',
        'notes' => 'notes',
        'fullDayManagementUnitDates' => 'fullDayManagementUnitDates',
        'partialDayStartDateTimes' => 'partialDayStartDateTimes',
        'dailyDurationMinutes' => 'dailyDurationMinutes'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'activityCodeId' => 'setActivityCodeId',
        'notes' => 'setNotes',
        'fullDayManagementUnitDates' => 'setFullDayManagementUnitDates',
        'partialDayStartDateTimes' => 'setPartialDayStartDateTimes',
        'dailyDurationMinutes' => 'setDailyDurationMinutes'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'activityCodeId' => 'getActivityCodeId',
        'notes' => 'getNotes',
        'fullDayManagementUnitDates' => 'getFullDayManagementUnitDates',
        'partialDayStartDateTimes' => 'getPartialDayStartDateTimes',
        'dailyDurationMinutes' => 'getDailyDurationMinutes'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['activityCodeId'] = isset($data['activityCodeId']) ? $data['activityCodeId'] : null;
        $this->container['notes'] = isset($data['notes']) ? $data['notes'] : null;
        $this->container['fullDayManagementUnitDates'] = isset($data['fullDayManagementUnitDates']) ? $data['fullDayManagementUnitDates'] : null;
        $this->container['partialDayStartDateTimes'] = isset($data['partialDayStartDateTimes']) ? $data['partialDayStartDateTimes'] : null;
        $this->container['dailyDurationMinutes'] = isset($data['dailyDurationMinutes']) ? $data['dailyDurationMinutes'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['activityCodeId'] === null) {
            $invalid_properties[] = "'activityCodeId' can't be null";
        }
        if ($this->container['dailyDurationMinutes'] === null) {
            $invalid_properties[] = "'dailyDurationMinutes' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['activityCodeId'] === null) {
            return false;
        }
        if ($this->container['dailyDurationMinutes'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets activityCodeId
     * @return string
     */
    public function getActivityCodeId()
    {
        return $this->container['activityCodeId'];
    }

    /**
     * Sets activityCodeId
     * @param string $activityCodeId The ID of the activity code associated with this time off request. Activity code must be of the TimeOff category
     * @return $this
     */
    public function setActivityCodeId($activityCodeId)
    {
        $this->container['activityCodeId'] = $activityCodeId;

        return $this;
    }

    /**
     * Gets notes
     * @return string
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     * @param string $notes Notes about the time off request
     * @return $this
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets fullDayManagementUnitDates
     * @return string[]
     */
    public function getFullDayManagementUnitDates()
    {
        return $this->container['fullDayManagementUnitDates'];
    }

    /**
     * Sets fullDayManagementUnitDates
     * @param string[] $fullDayManagementUnitDates A set of dates in yyyy-MM-dd format.  Should be interpreted in the management unit's configured time zone.
     * @return $this
     */
    public function setFullDayManagementUnitDates($fullDayManagementUnitDates)
    {
        $this->container['fullDayManagementUnitDates'] = $fullDayManagementUnitDates;

        return $this;
    }

    /**
     * Gets partialDayStartDateTimes
     * @return \DateTime[]
     */
    public function getPartialDayStartDateTimes()
    {
        return $this->container['partialDayStartDateTimes'];
    }

    /**
     * Sets partialDayStartDateTimes
     * @param \DateTime[] $partialDayStartDateTimes A set of start date-times in ISO-8601 format for partial day requests.
     * @return $this
     */
    public function setPartialDayStartDateTimes($partialDayStartDateTimes)
    {
        $this->container['partialDayStartDateTimes'] = $partialDayStartDateTimes;

        return $this;
    }

    /**
     * Gets dailyDurationMinutes
     * @return int
     */
    public function getDailyDurationMinutes()
    {
        return $this->container['dailyDurationMinutes'];
    }

    /**
     * Sets dailyDurationMinutes
     * @param int $dailyDurationMinutes The daily duration of this time off request in minutes
     * @return $this
     */
    public function setDailyDurationMinutes($dailyDurationMinutes)
    {
        $this->container['dailyDurationMinutes'] = $dailyDurationMinutes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


