<?php
/**
 * CreateWebChatConversationRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CreateWebChatConversationRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateWebChatConversationRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateWebChatConversationRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'organizationId' => 'string',
        'deploymentId' => 'string',
        'routingTarget' => '\PureCloudSDK\WebChatRoutingTarget',
        'memberInfo' => '\PureCloudSDK\GuestMemberInfo',
        'memberAuthToken' => 'string',
        'journeyContext' => '\PureCloudSDK\JourneyContext'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'organizationId' => 'organizationId',
        'deploymentId' => 'deploymentId',
        'routingTarget' => 'routingTarget',
        'memberInfo' => 'memberInfo',
        'memberAuthToken' => 'memberAuthToken',
        'journeyContext' => 'journeyContext'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'organizationId' => 'setOrganizationId',
        'deploymentId' => 'setDeploymentId',
        'routingTarget' => 'setRoutingTarget',
        'memberInfo' => 'setMemberInfo',
        'memberAuthToken' => 'setMemberAuthToken',
        'journeyContext' => 'setJourneyContext'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'organizationId' => 'getOrganizationId',
        'deploymentId' => 'getDeploymentId',
        'routingTarget' => 'getRoutingTarget',
        'memberInfo' => 'getMemberInfo',
        'memberAuthToken' => 'getMemberAuthToken',
        'journeyContext' => 'getJourneyContext'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['organizationId'] = isset($data['organizationId']) ? $data['organizationId'] : null;
        $this->container['deploymentId'] = isset($data['deploymentId']) ? $data['deploymentId'] : null;
        $this->container['routingTarget'] = isset($data['routingTarget']) ? $data['routingTarget'] : null;
        $this->container['memberInfo'] = isset($data['memberInfo']) ? $data['memberInfo'] : null;
        $this->container['memberAuthToken'] = isset($data['memberAuthToken']) ? $data['memberAuthToken'] : null;
        $this->container['journeyContext'] = isset($data['journeyContext']) ? $data['journeyContext'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['organizationId'] === null) {
            $invalid_properties[] = "'organizationId' can't be null";
        }
        if ($this->container['deploymentId'] === null) {
            $invalid_properties[] = "'deploymentId' can't be null";
        }
        if ($this->container['routingTarget'] === null) {
            $invalid_properties[] = "'routingTarget' can't be null";
        }
        if ($this->container['memberInfo'] === null) {
            $invalid_properties[] = "'memberInfo' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['organizationId'] === null) {
            return false;
        }
        if ($this->container['deploymentId'] === null) {
            return false;
        }
        if ($this->container['routingTarget'] === null) {
            return false;
        }
        if ($this->container['memberInfo'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets organizationId
     * @return string
     */
    public function getOrganizationId()
    {
        return $this->container['organizationId'];
    }

    /**
     * Sets organizationId
     * @param string $organizationId The organization identifier.
     * @return $this
     */
    public function setOrganizationId($organizationId)
    {
        $this->container['organizationId'] = $organizationId;

        return $this;
    }

    /**
     * Gets deploymentId
     * @return string
     */
    public function getDeploymentId()
    {
        return $this->container['deploymentId'];
    }

    /**
     * Sets deploymentId
     * @param string $deploymentId The web chat Deployment ID which contains the appropriate settings for this chat conversation.
     * @return $this
     */
    public function setDeploymentId($deploymentId)
    {
        $this->container['deploymentId'] = $deploymentId;

        return $this;
    }

    /**
     * Gets routingTarget
     * @return \PureCloudSDK\WebChatRoutingTarget
     */
    public function getRoutingTarget()
    {
        return $this->container['routingTarget'];
    }

    /**
     * Sets routingTarget
     * @param \PureCloudSDK\WebChatRoutingTarget $routingTarget The routing information to use for the new chat conversation.
     * @return $this
     */
    public function setRoutingTarget($routingTarget)
    {
        $this->container['routingTarget'] = $routingTarget;

        return $this;
    }

    /**
     * Gets memberInfo
     * @return \PureCloudSDK\GuestMemberInfo
     */
    public function getMemberInfo()
    {
        return $this->container['memberInfo'];
    }

    /**
     * Sets memberInfo
     * @param \PureCloudSDK\GuestMemberInfo $memberInfo The guest member info to use for the new chat conversation.
     * @return $this
     */
    public function setMemberInfo($memberInfo)
    {
        $this->container['memberInfo'] = $memberInfo;

        return $this;
    }

    /**
     * Gets memberAuthToken
     * @return string
     */
    public function getMemberAuthToken()
    {
        return $this->container['memberAuthToken'];
    }

    /**
     * Sets memberAuthToken
     * @param string $memberAuthToken If the guest member is an authenticated member (ie, not anonymous) his JWT is provided here. The token will have been previously generated with the \"POST /api/v2/signeddata\" resource.
     * @return $this
     */
    public function setMemberAuthToken($memberAuthToken)
    {
        $this->container['memberAuthToken'] = $memberAuthToken;

        return $this;
    }

    /**
     * Gets journeyContext
     * @return \PureCloudSDK\JourneyContext
     */
    public function getJourneyContext()
    {
        return $this->container['journeyContext'];
    }

    /**
     * Sets journeyContext
     * @param \PureCloudSDK\JourneyContext $journeyContext A subset of the Journey System's data relevant to this conversation/session request (for external linkage and internal usage/context).
     * @return $this
     */
    public function setJourneyContext($journeyContext)
    {
        $this->container['journeyContext'] = $journeyContext;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


