<?php
/**
 * Integration
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Integration Class Doc Comment
 *
 * @category    Class */
 // @description Details for an Integration
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Integration implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Integration';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'integrationType' => '\PureCloudSDK\IntegrationType',
        'notes' => 'string',
        'intendedState' => 'string',
        'config' => '\PureCloudSDK\IntegrationConfigurationInfo',
        'reportedState' => '\PureCloudSDK\IntegrationStatusInfo',
        'attributes' => 'map[string,string]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'integrationType' => 'integrationType',
        'notes' => 'notes',
        'intendedState' => 'intendedState',
        'config' => 'config',
        'reportedState' => 'reportedState',
        'attributes' => 'attributes',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'integrationType' => 'setIntegrationType',
        'notes' => 'setNotes',
        'intendedState' => 'setIntendedState',
        'config' => 'setConfig',
        'reportedState' => 'setReportedState',
        'attributes' => 'setAttributes',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'integrationType' => 'getIntegrationType',
        'notes' => 'getNotes',
        'intendedState' => 'getIntendedState',
        'config' => 'getConfig',
        'reportedState' => 'getReportedState',
        'attributes' => 'getAttributes',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const INTENDED_STATE_ENABLED = 'ENABLED';
    const INTENDED_STATE_DISABLED = 'DISABLED';
    const INTENDED_STATE_DELETED = 'DELETED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getIntendedStateAllowableValues()
    {
        return [
            self::INTENDED_STATE_ENABLED,
            self::INTENDED_STATE_DISABLED,
            self::INTENDED_STATE_DELETED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['integrationType'] = isset($data['integrationType']) ? $data['integrationType'] : null;
        $this->container['notes'] = isset($data['notes']) ? $data['notes'] : null;
        $this->container['intendedState'] = isset($data['intendedState']) ? $data['intendedState'] : null;
        $this->container['config'] = isset($data['config']) ? $data['config'] : null;
        $this->container['reportedState'] = isset($data['reportedState']) ? $data['reportedState'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['intendedState'] === null) {
            $invalid_properties[] = "'intendedState' can't be null";
        }
        $allowed_values = array("ENABLED", "DISABLED", "DELETED");
        if (!in_array($this->container['intendedState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'intendedState', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['intendedState'] === null) {
            return false;
        }
        $allowed_values = array("ENABLED", "DISABLED", "DELETED");
        if (!in_array($this->container['intendedState'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the integration, used to distinguish this integration from others of the same type.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets integrationType
     * @return \PureCloudSDK\IntegrationType
     */
    public function getIntegrationType()
    {
        return $this->container['integrationType'];
    }

    /**
     * Sets integrationType
     * @param \PureCloudSDK\IntegrationType $integrationType Type of the integration
     * @return $this
     */
    public function setIntegrationType($integrationType)
    {
        $this->container['integrationType'] = $integrationType;

        return $this;
    }

    /**
     * Gets notes
     * @return string
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     * @param string $notes Notes about the integration.
     * @return $this
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets intendedState
     * @return string
     */
    public function getIntendedState()
    {
        return $this->container['intendedState'];
    }

    /**
     * Sets intendedState
     * @param string $intendedState Configured state of the integration.
     * @return $this
     */
    public function setIntendedState($intendedState)
    {
        $allowed_values = array('ENABLED', 'DISABLED', 'DELETED');
        if (!in_array($intendedState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'intendedState', must be one of 'ENABLED', 'DISABLED', 'DELETED'");
        }
        $this->container['intendedState'] = $intendedState;

        return $this;
    }

    /**
     * Gets config
     * @return \PureCloudSDK\IntegrationConfigurationInfo
     */
    public function getConfig()
    {
        return $this->container['config'];
    }

    /**
     * Sets config
     * @param \PureCloudSDK\IntegrationConfigurationInfo $config Configuration information for the integration.
     * @return $this
     */
    public function setConfig($config)
    {
        $this->container['config'] = $config;

        return $this;
    }

    /**
     * Gets reportedState
     * @return \PureCloudSDK\IntegrationStatusInfo
     */
    public function getReportedState()
    {
        return $this->container['reportedState'];
    }

    /**
     * Sets reportedState
     * @param \PureCloudSDK\IntegrationStatusInfo $reportedState Last reported status of the integration.
     * @return $this
     */
    public function setReportedState($reportedState)
    {
        $this->container['reportedState'] = $reportedState;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes Read-only attributes for the integration.
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


