<?php
/**
 * PolicyActions
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PolicyActions Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PolicyActions implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PolicyActions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'retainRecording' => 'bool',
        'deleteRecording' => 'bool',
        'alwaysDelete' => 'bool',
        'assignEvaluations' => '\PureCloudSDK\EvaluationAssignment[]',
        'assignMeteredEvaluations' => '\PureCloudSDK\MeteredEvaluationAssignment[]',
        'assignMeteredAssignmentByAgent' => '\PureCloudSDK\MeteredAssignmentByAgent[]',
        'assignCalibrations' => '\PureCloudSDK\CalibrationAssignment[]',
        'assignSurveys' => '\PureCloudSDK\SurveyAssignment[]',
        'retentionDuration' => '\PureCloudSDK\RetentionDuration',
        'initiateScreenRecording' => '\PureCloudSDK\InitiateScreenRecording',
        'mediaTranscriptions' => '\PureCloudSDK\MediaTranscription[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'retainRecording' => 'retainRecording',
        'deleteRecording' => 'deleteRecording',
        'alwaysDelete' => 'alwaysDelete',
        'assignEvaluations' => 'assignEvaluations',
        'assignMeteredEvaluations' => 'assignMeteredEvaluations',
        'assignMeteredAssignmentByAgent' => 'assignMeteredAssignmentByAgent',
        'assignCalibrations' => 'assignCalibrations',
        'assignSurveys' => 'assignSurveys',
        'retentionDuration' => 'retentionDuration',
        'initiateScreenRecording' => 'initiateScreenRecording',
        'mediaTranscriptions' => 'mediaTranscriptions'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'retainRecording' => 'setRetainRecording',
        'deleteRecording' => 'setDeleteRecording',
        'alwaysDelete' => 'setAlwaysDelete',
        'assignEvaluations' => 'setAssignEvaluations',
        'assignMeteredEvaluations' => 'setAssignMeteredEvaluations',
        'assignMeteredAssignmentByAgent' => 'setAssignMeteredAssignmentByAgent',
        'assignCalibrations' => 'setAssignCalibrations',
        'assignSurveys' => 'setAssignSurveys',
        'retentionDuration' => 'setRetentionDuration',
        'initiateScreenRecording' => 'setInitiateScreenRecording',
        'mediaTranscriptions' => 'setMediaTranscriptions'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'retainRecording' => 'getRetainRecording',
        'deleteRecording' => 'getDeleteRecording',
        'alwaysDelete' => 'getAlwaysDelete',
        'assignEvaluations' => 'getAssignEvaluations',
        'assignMeteredEvaluations' => 'getAssignMeteredEvaluations',
        'assignMeteredAssignmentByAgent' => 'getAssignMeteredAssignmentByAgent',
        'assignCalibrations' => 'getAssignCalibrations',
        'assignSurveys' => 'getAssignSurveys',
        'retentionDuration' => 'getRetentionDuration',
        'initiateScreenRecording' => 'getInitiateScreenRecording',
        'mediaTranscriptions' => 'getMediaTranscriptions'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['retainRecording'] = isset($data['retainRecording']) ? $data['retainRecording'] : null;
        $this->container['deleteRecording'] = isset($data['deleteRecording']) ? $data['deleteRecording'] : null;
        $this->container['alwaysDelete'] = isset($data['alwaysDelete']) ? $data['alwaysDelete'] : null;
        $this->container['assignEvaluations'] = isset($data['assignEvaluations']) ? $data['assignEvaluations'] : null;
        $this->container['assignMeteredEvaluations'] = isset($data['assignMeteredEvaluations']) ? $data['assignMeteredEvaluations'] : null;
        $this->container['assignMeteredAssignmentByAgent'] = isset($data['assignMeteredAssignmentByAgent']) ? $data['assignMeteredAssignmentByAgent'] : null;
        $this->container['assignCalibrations'] = isset($data['assignCalibrations']) ? $data['assignCalibrations'] : null;
        $this->container['assignSurveys'] = isset($data['assignSurveys']) ? $data['assignSurveys'] : null;
        $this->container['retentionDuration'] = isset($data['retentionDuration']) ? $data['retentionDuration'] : null;
        $this->container['initiateScreenRecording'] = isset($data['initiateScreenRecording']) ? $data['initiateScreenRecording'] : null;
        $this->container['mediaTranscriptions'] = isset($data['mediaTranscriptions']) ? $data['mediaTranscriptions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets retainRecording
     * @return bool
     */
    public function getRetainRecording()
    {
        return $this->container['retainRecording'];
    }

    /**
     * Sets retainRecording
     * @param bool $retainRecording true to retain the recording associated with the conversation. Default = true
     * @return $this
     */
    public function setRetainRecording($retainRecording)
    {
        $this->container['retainRecording'] = $retainRecording;

        return $this;
    }

    /**
     * Gets deleteRecording
     * @return bool
     */
    public function getDeleteRecording()
    {
        return $this->container['deleteRecording'];
    }

    /**
     * Sets deleteRecording
     * @param bool $deleteRecording true to delete the recording associated with the conversation. If retainRecording = true, this will be ignored. Default = false
     * @return $this
     */
    public function setDeleteRecording($deleteRecording)
    {
        $this->container['deleteRecording'] = $deleteRecording;

        return $this;
    }

    /**
     * Gets alwaysDelete
     * @return bool
     */
    public function getAlwaysDelete()
    {
        return $this->container['alwaysDelete'];
    }

    /**
     * Sets alwaysDelete
     * @param bool $alwaysDelete true to delete the recording associated with the conversation regardless of the values of retainRecording or deleteRecording. Default = false
     * @return $this
     */
    public function setAlwaysDelete($alwaysDelete)
    {
        $this->container['alwaysDelete'] = $alwaysDelete;

        return $this;
    }

    /**
     * Gets assignEvaluations
     * @return \PureCloudSDK\EvaluationAssignment[]
     */
    public function getAssignEvaluations()
    {
        return $this->container['assignEvaluations'];
    }

    /**
     * Sets assignEvaluations
     * @param \PureCloudSDK\EvaluationAssignment[] $assignEvaluations
     * @return $this
     */
    public function setAssignEvaluations($assignEvaluations)
    {
        $this->container['assignEvaluations'] = $assignEvaluations;

        return $this;
    }

    /**
     * Gets assignMeteredEvaluations
     * @return \PureCloudSDK\MeteredEvaluationAssignment[]
     */
    public function getAssignMeteredEvaluations()
    {
        return $this->container['assignMeteredEvaluations'];
    }

    /**
     * Sets assignMeteredEvaluations
     * @param \PureCloudSDK\MeteredEvaluationAssignment[] $assignMeteredEvaluations
     * @return $this
     */
    public function setAssignMeteredEvaluations($assignMeteredEvaluations)
    {
        $this->container['assignMeteredEvaluations'] = $assignMeteredEvaluations;

        return $this;
    }

    /**
     * Gets assignMeteredAssignmentByAgent
     * @return \PureCloudSDK\MeteredAssignmentByAgent[]
     */
    public function getAssignMeteredAssignmentByAgent()
    {
        return $this->container['assignMeteredAssignmentByAgent'];
    }

    /**
     * Sets assignMeteredAssignmentByAgent
     * @param \PureCloudSDK\MeteredAssignmentByAgent[] $assignMeteredAssignmentByAgent
     * @return $this
     */
    public function setAssignMeteredAssignmentByAgent($assignMeteredAssignmentByAgent)
    {
        $this->container['assignMeteredAssignmentByAgent'] = $assignMeteredAssignmentByAgent;

        return $this;
    }

    /**
     * Gets assignCalibrations
     * @return \PureCloudSDK\CalibrationAssignment[]
     */
    public function getAssignCalibrations()
    {
        return $this->container['assignCalibrations'];
    }

    /**
     * Sets assignCalibrations
     * @param \PureCloudSDK\CalibrationAssignment[] $assignCalibrations
     * @return $this
     */
    public function setAssignCalibrations($assignCalibrations)
    {
        $this->container['assignCalibrations'] = $assignCalibrations;

        return $this;
    }

    /**
     * Gets assignSurveys
     * @return \PureCloudSDK\SurveyAssignment[]
     */
    public function getAssignSurveys()
    {
        return $this->container['assignSurveys'];
    }

    /**
     * Sets assignSurveys
     * @param \PureCloudSDK\SurveyAssignment[] $assignSurveys
     * @return $this
     */
    public function setAssignSurveys($assignSurveys)
    {
        $this->container['assignSurveys'] = $assignSurveys;

        return $this;
    }

    /**
     * Gets retentionDuration
     * @return \PureCloudSDK\RetentionDuration
     */
    public function getRetentionDuration()
    {
        return $this->container['retentionDuration'];
    }

    /**
     * Sets retentionDuration
     * @param \PureCloudSDK\RetentionDuration $retentionDuration
     * @return $this
     */
    public function setRetentionDuration($retentionDuration)
    {
        $this->container['retentionDuration'] = $retentionDuration;

        return $this;
    }

    /**
     * Gets initiateScreenRecording
     * @return \PureCloudSDK\InitiateScreenRecording
     */
    public function getInitiateScreenRecording()
    {
        return $this->container['initiateScreenRecording'];
    }

    /**
     * Sets initiateScreenRecording
     * @param \PureCloudSDK\InitiateScreenRecording $initiateScreenRecording
     * @return $this
     */
    public function setInitiateScreenRecording($initiateScreenRecording)
    {
        $this->container['initiateScreenRecording'] = $initiateScreenRecording;

        return $this;
    }

    /**
     * Gets mediaTranscriptions
     * @return \PureCloudSDK\MediaTranscription[]
     */
    public function getMediaTranscriptions()
    {
        return $this->container['mediaTranscriptions'];
    }

    /**
     * Sets mediaTranscriptions
     * @param \PureCloudSDK\MediaTranscription[] $mediaTranscriptions
     * @return $this
     */
    public function setMediaTranscriptions($mediaTranscriptions)
    {
        $this->container['mediaTranscriptions'] = $mediaTranscriptions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


