<?php
/**
 * ScheduleGenerationWarning
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ScheduleGenerationWarning Class Doc Comment
 *
 * @category    Class */
 // @description Schedule generation warning
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ScheduleGenerationWarning implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ScheduleGenerationWarning';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'userId' => 'string',
        'userNotLicensed' => 'bool',
        'unableToMeetMaxDays' => 'bool',
        'unableToScheduleRequiredDays' => 'string[]',
        'unableToMeetMinPaidForTheWeek' => 'bool',
        'unableToMeetMaxPaidForTheWeek' => 'bool',
        'noNeedDays' => 'string[]',
        'shiftsTooCloseTogether' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'userId' => 'userId',
        'userNotLicensed' => 'userNotLicensed',
        'unableToMeetMaxDays' => 'unableToMeetMaxDays',
        'unableToScheduleRequiredDays' => 'unableToScheduleRequiredDays',
        'unableToMeetMinPaidForTheWeek' => 'unableToMeetMinPaidForTheWeek',
        'unableToMeetMaxPaidForTheWeek' => 'unableToMeetMaxPaidForTheWeek',
        'noNeedDays' => 'noNeedDays',
        'shiftsTooCloseTogether' => 'shiftsTooCloseTogether'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'userId' => 'setUserId',
        'userNotLicensed' => 'setUserNotLicensed',
        'unableToMeetMaxDays' => 'setUnableToMeetMaxDays',
        'unableToScheduleRequiredDays' => 'setUnableToScheduleRequiredDays',
        'unableToMeetMinPaidForTheWeek' => 'setUnableToMeetMinPaidForTheWeek',
        'unableToMeetMaxPaidForTheWeek' => 'setUnableToMeetMaxPaidForTheWeek',
        'noNeedDays' => 'setNoNeedDays',
        'shiftsTooCloseTogether' => 'setShiftsTooCloseTogether'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'userId' => 'getUserId',
        'userNotLicensed' => 'getUserNotLicensed',
        'unableToMeetMaxDays' => 'getUnableToMeetMaxDays',
        'unableToScheduleRequiredDays' => 'getUnableToScheduleRequiredDays',
        'unableToMeetMinPaidForTheWeek' => 'getUnableToMeetMinPaidForTheWeek',
        'unableToMeetMaxPaidForTheWeek' => 'getUnableToMeetMaxPaidForTheWeek',
        'noNeedDays' => 'getNoNeedDays',
        'shiftsTooCloseTogether' => 'getShiftsTooCloseTogether'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const UNABLE_TO_SCHEDULE_REQUIRED_DAYS_SUNDAY = 'Sunday';
    const UNABLE_TO_SCHEDULE_REQUIRED_DAYS_MONDAY = 'Monday';
    const UNABLE_TO_SCHEDULE_REQUIRED_DAYS_TUESDAY = 'Tuesday';
    const UNABLE_TO_SCHEDULE_REQUIRED_DAYS_WEDNESDAY = 'Wednesday';
    const UNABLE_TO_SCHEDULE_REQUIRED_DAYS_THURSDAY = 'Thursday';
    const UNABLE_TO_SCHEDULE_REQUIRED_DAYS_FRIDAY = 'Friday';
    const UNABLE_TO_SCHEDULE_REQUIRED_DAYS_SATURDAY = 'Saturday';
    const NO_NEED_DAYS_SUNDAY = 'Sunday';
    const NO_NEED_DAYS_MONDAY = 'Monday';
    const NO_NEED_DAYS_TUESDAY = 'Tuesday';
    const NO_NEED_DAYS_WEDNESDAY = 'Wednesday';
    const NO_NEED_DAYS_THURSDAY = 'Thursday';
    const NO_NEED_DAYS_FRIDAY = 'Friday';
    const NO_NEED_DAYS_SATURDAY = 'Saturday';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getUnableToScheduleRequiredDaysAllowableValues()
    {
        return [
            self::UNABLE_TO_SCHEDULE_REQUIRED_DAYS_SUNDAY,
            self::UNABLE_TO_SCHEDULE_REQUIRED_DAYS_MONDAY,
            self::UNABLE_TO_SCHEDULE_REQUIRED_DAYS_TUESDAY,
            self::UNABLE_TO_SCHEDULE_REQUIRED_DAYS_WEDNESDAY,
            self::UNABLE_TO_SCHEDULE_REQUIRED_DAYS_THURSDAY,
            self::UNABLE_TO_SCHEDULE_REQUIRED_DAYS_FRIDAY,
            self::UNABLE_TO_SCHEDULE_REQUIRED_DAYS_SATURDAY,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getNoNeedDaysAllowableValues()
    {
        return [
            self::NO_NEED_DAYS_SUNDAY,
            self::NO_NEED_DAYS_MONDAY,
            self::NO_NEED_DAYS_TUESDAY,
            self::NO_NEED_DAYS_WEDNESDAY,
            self::NO_NEED_DAYS_THURSDAY,
            self::NO_NEED_DAYS_FRIDAY,
            self::NO_NEED_DAYS_SATURDAY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['userId'] = isset($data['userId']) ? $data['userId'] : null;
        $this->container['userNotLicensed'] = isset($data['userNotLicensed']) ? $data['userNotLicensed'] : null;
        $this->container['unableToMeetMaxDays'] = isset($data['unableToMeetMaxDays']) ? $data['unableToMeetMaxDays'] : null;
        $this->container['unableToScheduleRequiredDays'] = isset($data['unableToScheduleRequiredDays']) ? $data['unableToScheduleRequiredDays'] : null;
        $this->container['unableToMeetMinPaidForTheWeek'] = isset($data['unableToMeetMinPaidForTheWeek']) ? $data['unableToMeetMinPaidForTheWeek'] : null;
        $this->container['unableToMeetMaxPaidForTheWeek'] = isset($data['unableToMeetMaxPaidForTheWeek']) ? $data['unableToMeetMaxPaidForTheWeek'] : null;
        $this->container['noNeedDays'] = isset($data['noNeedDays']) ? $data['noNeedDays'] : null;
        $this->container['shiftsTooCloseTogether'] = isset($data['shiftsTooCloseTogether']) ? $data['shiftsTooCloseTogether'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets userId
     * @return string
     */
    public function getUserId()
    {
        return $this->container['userId'];
    }

    /**
     * Sets userId
     * @param string $userId ID of the user in the warning
     * @return $this
     */
    public function setUserId($userId)
    {
        $this->container['userId'] = $userId;

        return $this;
    }

    /**
     * Gets userNotLicensed
     * @return bool
     */
    public function getUserNotLicensed()
    {
        return $this->container['userNotLicensed'];
    }

    /**
     * Sets userNotLicensed
     * @param bool $userNotLicensed Whether the user does not have the appropriate license to be scheduled
     * @return $this
     */
    public function setUserNotLicensed($userNotLicensed)
    {
        $this->container['userNotLicensed'] = $userNotLicensed;

        return $this;
    }

    /**
     * Gets unableToMeetMaxDays
     * @return bool
     */
    public function getUnableToMeetMaxDays()
    {
        return $this->container['unableToMeetMaxDays'];
    }

    /**
     * Sets unableToMeetMaxDays
     * @param bool $unableToMeetMaxDays Whether the number of scheduled days exceeded the maximum days to schedule defined in the agent work plan
     * @return $this
     */
    public function setUnableToMeetMaxDays($unableToMeetMaxDays)
    {
        $this->container['unableToMeetMaxDays'] = $unableToMeetMaxDays;

        return $this;
    }

    /**
     * Gets unableToScheduleRequiredDays
     * @return string[]
     */
    public function getUnableToScheduleRequiredDays()
    {
        return $this->container['unableToScheduleRequiredDays'];
    }

    /**
     * Sets unableToScheduleRequiredDays
     * @param string[] $unableToScheduleRequiredDays Days indicated as required to work in agent work plan where no viable shift was found to schedule
     * @return $this
     */
    public function setUnableToScheduleRequiredDays($unableToScheduleRequiredDays)
    {
        $allowed_values = array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
        if (!in_array($unableToScheduleRequiredDays, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'unableToScheduleRequiredDays', must be one of 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'");
        }
        $this->container['unableToScheduleRequiredDays'] = $unableToScheduleRequiredDays;

        return $this;
    }

    /**
     * Gets unableToMeetMinPaidForTheWeek
     * @return bool
     */
    public function getUnableToMeetMinPaidForTheWeek()
    {
        return $this->container['unableToMeetMinPaidForTheWeek'];
    }

    /**
     * Sets unableToMeetMinPaidForTheWeek
     * @param bool $unableToMeetMinPaidForTheWeek Whether the schedule did not meet the minimum paid time for the week defined in the agent work plan
     * @return $this
     */
    public function setUnableToMeetMinPaidForTheWeek($unableToMeetMinPaidForTheWeek)
    {
        $this->container['unableToMeetMinPaidForTheWeek'] = $unableToMeetMinPaidForTheWeek;

        return $this;
    }

    /**
     * Gets unableToMeetMaxPaidForTheWeek
     * @return bool
     */
    public function getUnableToMeetMaxPaidForTheWeek()
    {
        return $this->container['unableToMeetMaxPaidForTheWeek'];
    }

    /**
     * Sets unableToMeetMaxPaidForTheWeek
     * @param bool $unableToMeetMaxPaidForTheWeek Whether the schedule exceeded the maximum paid time for the week defined in the agent work plan
     * @return $this
     */
    public function setUnableToMeetMaxPaidForTheWeek($unableToMeetMaxPaidForTheWeek)
    {
        $this->container['unableToMeetMaxPaidForTheWeek'] = $unableToMeetMaxPaidForTheWeek;

        return $this;
    }

    /**
     * Gets noNeedDays
     * @return string[]
     */
    public function getNoNeedDays()
    {
        return $this->container['noNeedDays'];
    }

    /**
     * Sets noNeedDays
     * @param string[] $noNeedDays Days agent was scheduled but there was no need to meet. The scheduled days have no effect on service levels
     * @return $this
     */
    public function setNoNeedDays($noNeedDays)
    {
        $allowed_values = array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
        if (!in_array($noNeedDays, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'noNeedDays', must be one of 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'");
        }
        $this->container['noNeedDays'] = $noNeedDays;

        return $this;
    }

    /**
     * Gets shiftsTooCloseTogether
     * @return bool
     */
    public function getShiftsTooCloseTogether()
    {
        return $this->container['shiftsTooCloseTogether'];
    }

    /**
     * Sets shiftsTooCloseTogether
     * @param bool $shiftsTooCloseTogether Whether the schedule did not meet the minimum time between shifts defined in the agent work plan
     * @return $this
     */
    public function setShiftsTooCloseTogether($shiftsTooCloseTogether)
    {
        $this->container['shiftsTooCloseTogether'] = $shiftsTooCloseTogether;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


