<?php
/**
 * UserExpands
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UserExpands Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserExpands implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserExpands';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'routingStatus' => '\PureCloudSDK\RoutingStatus',
        'presence' => '\PureCloudSDK\UserPresence',
        'conversationSummary' => '\PureCloudSDK\UserConversationSummary',
        'outOfOffice' => '\PureCloudSDK\OutOfOffice',
        'geolocation' => '\PureCloudSDK\Geolocation',
        'station' => '\PureCloudSDK\UserStations',
        'authorization' => '\PureCloudSDK\UserAuthorization'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'routingStatus' => 'routingStatus',
        'presence' => 'presence',
        'conversationSummary' => 'conversationSummary',
        'outOfOffice' => 'outOfOffice',
        'geolocation' => 'geolocation',
        'station' => 'station',
        'authorization' => 'authorization'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'routingStatus' => 'setRoutingStatus',
        'presence' => 'setPresence',
        'conversationSummary' => 'setConversationSummary',
        'outOfOffice' => 'setOutOfOffice',
        'geolocation' => 'setGeolocation',
        'station' => 'setStation',
        'authorization' => 'setAuthorization'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'routingStatus' => 'getRoutingStatus',
        'presence' => 'getPresence',
        'conversationSummary' => 'getConversationSummary',
        'outOfOffice' => 'getOutOfOffice',
        'geolocation' => 'getGeolocation',
        'station' => 'getStation',
        'authorization' => 'getAuthorization'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['routingStatus'] = isset($data['routingStatus']) ? $data['routingStatus'] : null;
        $this->container['presence'] = isset($data['presence']) ? $data['presence'] : null;
        $this->container['conversationSummary'] = isset($data['conversationSummary']) ? $data['conversationSummary'] : null;
        $this->container['outOfOffice'] = isset($data['outOfOffice']) ? $data['outOfOffice'] : null;
        $this->container['geolocation'] = isset($data['geolocation']) ? $data['geolocation'] : null;
        $this->container['station'] = isset($data['station']) ? $data['station'] : null;
        $this->container['authorization'] = isset($data['authorization']) ? $data['authorization'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets routingStatus
     * @return \PureCloudSDK\RoutingStatus
     */
    public function getRoutingStatus()
    {
        return $this->container['routingStatus'];
    }

    /**
     * Sets routingStatus
     * @param \PureCloudSDK\RoutingStatus $routingStatus ACD routing status
     * @return $this
     */
    public function setRoutingStatus($routingStatus)
    {
        $this->container['routingStatus'] = $routingStatus;

        return $this;
    }

    /**
     * Gets presence
     * @return \PureCloudSDK\UserPresence
     */
    public function getPresence()
    {
        return $this->container['presence'];
    }

    /**
     * Sets presence
     * @param \PureCloudSDK\UserPresence $presence Active presence
     * @return $this
     */
    public function setPresence($presence)
    {
        $this->container['presence'] = $presence;

        return $this;
    }

    /**
     * Gets conversationSummary
     * @return \PureCloudSDK\UserConversationSummary
     */
    public function getConversationSummary()
    {
        return $this->container['conversationSummary'];
    }

    /**
     * Sets conversationSummary
     * @param \PureCloudSDK\UserConversationSummary $conversationSummary Summary of conversion statistics for conversation types.
     * @return $this
     */
    public function setConversationSummary($conversationSummary)
    {
        $this->container['conversationSummary'] = $conversationSummary;

        return $this;
    }

    /**
     * Gets outOfOffice
     * @return \PureCloudSDK\OutOfOffice
     */
    public function getOutOfOffice()
    {
        return $this->container['outOfOffice'];
    }

    /**
     * Sets outOfOffice
     * @param \PureCloudSDK\OutOfOffice $outOfOffice Determine if out of office is enabled
     * @return $this
     */
    public function setOutOfOffice($outOfOffice)
    {
        $this->container['outOfOffice'] = $outOfOffice;

        return $this;
    }

    /**
     * Gets geolocation
     * @return \PureCloudSDK\Geolocation
     */
    public function getGeolocation()
    {
        return $this->container['geolocation'];
    }

    /**
     * Sets geolocation
     * @param \PureCloudSDK\Geolocation $geolocation Current geolocation position
     * @return $this
     */
    public function setGeolocation($geolocation)
    {
        $this->container['geolocation'] = $geolocation;

        return $this;
    }

    /**
     * Gets station
     * @return \PureCloudSDK\UserStations
     */
    public function getStation()
    {
        return $this->container['station'];
    }

    /**
     * Sets station
     * @param \PureCloudSDK\UserStations $station Effective, default, and last station information
     * @return $this
     */
    public function setStation($station)
    {
        $this->container['station'] = $station;

        return $this;
    }

    /**
     * Gets authorization
     * @return \PureCloudSDK\UserAuthorization
     */
    public function getAuthorization()
    {
        return $this->container['authorization'];
    }

    /**
     * Sets authorization
     * @param \PureCloudSDK\UserAuthorization $authorization Roles and permissions assigned to the user
     * @return $this
     */
    public function setAuthorization($authorization)
    {
        $this->container['authorization'] = $authorization;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


