<?php
/**
 * UserMe
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UserMe Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserMe implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserMe';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'division' => '\PureCloudSDK\Division',
        'chat' => '\PureCloudSDK\Chat',
        'department' => 'string',
        'email' => 'string',
        'primaryContactInfo' => '\PureCloudSDK\Contact[]',
        'addresses' => '\PureCloudSDK\Contact[]',
        'state' => 'string',
        'title' => 'string',
        'username' => 'string',
        'manager' => '\PureCloudSDK\User',
        'images' => '\PureCloudSDK\UserImage[]',
        'version' => 'int',
        'certifications' => 'string[]',
        'biography' => '\PureCloudSDK\Biography',
        'employerInfo' => '\PureCloudSDK\EmployerInfo',
        'routingStatus' => '\PureCloudSDK\RoutingStatus',
        'presence' => '\PureCloudSDK\UserPresence',
        'conversationSummary' => '\PureCloudSDK\UserConversationSummary',
        'outOfOffice' => '\PureCloudSDK\OutOfOffice',
        'geolocation' => '\PureCloudSDK\Geolocation',
        'station' => '\PureCloudSDK\UserStations',
        'authorization' => '\PureCloudSDK\UserAuthorization',
        'profileSkills' => 'string[]',
        'locations' => '\PureCloudSDK\Location[]',
        'groups' => '\PureCloudSDK\Group[]',
        'skills' => '\PureCloudSDK\UserRoutingSkill[]',
        'languages' => '\PureCloudSDK\UserRoutingLanguage[]',
        'acdAutoAnswer' => 'bool',
        'languagePreference' => 'string',
        'date' => '\PureCloudSDK\ServerDate',
        'geolocationSettings' => '\PureCloudSDK\GeolocationSettings',
        'organization' => '\PureCloudSDK\Organization',
        'presenceDefinitions' => '\PureCloudSDK\OrganizationPresence[]',
        'locationDefinitions' => '\PureCloudSDK\LocationDefinition[]',
        'orgAuthorization' => '\PureCloudSDK\DomainOrganizationRole[]',
        'favorites' => '\PureCloudSDK\User[]',
        'superiors' => '\PureCloudSDK\User[]',
        'directReports' => '\PureCloudSDK\User[]',
        'adjacents' => '\PureCloudSDK\Adjacents',
        'routingSkills' => '\PureCloudSDK\RoutingSkill[]',
        'fieldConfigs' => '\PureCloudSDK\FieldConfigs',
        'token' => '\PureCloudSDK\TokenInfo',
        'trustors' => '\PureCloudSDK\Trustor[]',
        'orgProducts' => '\PureCloudSDK\DomainOrganizationProduct[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'division' => 'division',
        'chat' => 'chat',
        'department' => 'department',
        'email' => 'email',
        'primaryContactInfo' => 'primaryContactInfo',
        'addresses' => 'addresses',
        'state' => 'state',
        'title' => 'title',
        'username' => 'username',
        'manager' => 'manager',
        'images' => 'images',
        'version' => 'version',
        'certifications' => 'certifications',
        'biography' => 'biography',
        'employerInfo' => 'employerInfo',
        'routingStatus' => 'routingStatus',
        'presence' => 'presence',
        'conversationSummary' => 'conversationSummary',
        'outOfOffice' => 'outOfOffice',
        'geolocation' => 'geolocation',
        'station' => 'station',
        'authorization' => 'authorization',
        'profileSkills' => 'profileSkills',
        'locations' => 'locations',
        'groups' => 'groups',
        'skills' => 'skills',
        'languages' => 'languages',
        'acdAutoAnswer' => 'acdAutoAnswer',
        'languagePreference' => 'languagePreference',
        'date' => 'date',
        'geolocationSettings' => 'geolocationSettings',
        'organization' => 'organization',
        'presenceDefinitions' => 'presenceDefinitions',
        'locationDefinitions' => 'locationDefinitions',
        'orgAuthorization' => 'orgAuthorization',
        'favorites' => 'favorites',
        'superiors' => 'superiors',
        'directReports' => 'directReports',
        'adjacents' => 'adjacents',
        'routingSkills' => 'routingSkills',
        'fieldConfigs' => 'fieldConfigs',
        'token' => 'token',
        'trustors' => 'trustors',
        'orgProducts' => 'orgProducts',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'division' => 'setDivision',
        'chat' => 'setChat',
        'department' => 'setDepartment',
        'email' => 'setEmail',
        'primaryContactInfo' => 'setPrimaryContactInfo',
        'addresses' => 'setAddresses',
        'state' => 'setState',
        'title' => 'setTitle',
        'username' => 'setUsername',
        'manager' => 'setManager',
        'images' => 'setImages',
        'version' => 'setVersion',
        'certifications' => 'setCertifications',
        'biography' => 'setBiography',
        'employerInfo' => 'setEmployerInfo',
        'routingStatus' => 'setRoutingStatus',
        'presence' => 'setPresence',
        'conversationSummary' => 'setConversationSummary',
        'outOfOffice' => 'setOutOfOffice',
        'geolocation' => 'setGeolocation',
        'station' => 'setStation',
        'authorization' => 'setAuthorization',
        'profileSkills' => 'setProfileSkills',
        'locations' => 'setLocations',
        'groups' => 'setGroups',
        'skills' => 'setSkills',
        'languages' => 'setLanguages',
        'acdAutoAnswer' => 'setAcdAutoAnswer',
        'languagePreference' => 'setLanguagePreference',
        'date' => 'setDate',
        'geolocationSettings' => 'setGeolocationSettings',
        'organization' => 'setOrganization',
        'presenceDefinitions' => 'setPresenceDefinitions',
        'locationDefinitions' => 'setLocationDefinitions',
        'orgAuthorization' => 'setOrgAuthorization',
        'favorites' => 'setFavorites',
        'superiors' => 'setSuperiors',
        'directReports' => 'setDirectReports',
        'adjacents' => 'setAdjacents',
        'routingSkills' => 'setRoutingSkills',
        'fieldConfigs' => 'setFieldConfigs',
        'token' => 'setToken',
        'trustors' => 'setTrustors',
        'orgProducts' => 'setOrgProducts',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'division' => 'getDivision',
        'chat' => 'getChat',
        'department' => 'getDepartment',
        'email' => 'getEmail',
        'primaryContactInfo' => 'getPrimaryContactInfo',
        'addresses' => 'getAddresses',
        'state' => 'getState',
        'title' => 'getTitle',
        'username' => 'getUsername',
        'manager' => 'getManager',
        'images' => 'getImages',
        'version' => 'getVersion',
        'certifications' => 'getCertifications',
        'biography' => 'getBiography',
        'employerInfo' => 'getEmployerInfo',
        'routingStatus' => 'getRoutingStatus',
        'presence' => 'getPresence',
        'conversationSummary' => 'getConversationSummary',
        'outOfOffice' => 'getOutOfOffice',
        'geolocation' => 'getGeolocation',
        'station' => 'getStation',
        'authorization' => 'getAuthorization',
        'profileSkills' => 'getProfileSkills',
        'locations' => 'getLocations',
        'groups' => 'getGroups',
        'skills' => 'getSkills',
        'languages' => 'getLanguages',
        'acdAutoAnswer' => 'getAcdAutoAnswer',
        'languagePreference' => 'getLanguagePreference',
        'date' => 'getDate',
        'geolocationSettings' => 'getGeolocationSettings',
        'organization' => 'getOrganization',
        'presenceDefinitions' => 'getPresenceDefinitions',
        'locationDefinitions' => 'getLocationDefinitions',
        'orgAuthorization' => 'getOrgAuthorization',
        'favorites' => 'getFavorites',
        'superiors' => 'getSuperiors',
        'directReports' => 'getDirectReports',
        'adjacents' => 'getAdjacents',
        'routingSkills' => 'getRoutingSkills',
        'fieldConfigs' => 'getFieldConfigs',
        'token' => 'getToken',
        'trustors' => 'getTrustors',
        'orgProducts' => 'getOrgProducts',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['division'] = isset($data['division']) ? $data['division'] : null;
        $this->container['chat'] = isset($data['chat']) ? $data['chat'] : null;
        $this->container['department'] = isset($data['department']) ? $data['department'] : null;
        $this->container['email'] = isset($data['email']) ? $data['email'] : null;
        $this->container['primaryContactInfo'] = isset($data['primaryContactInfo']) ? $data['primaryContactInfo'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['username'] = isset($data['username']) ? $data['username'] : null;
        $this->container['manager'] = isset($data['manager']) ? $data['manager'] : null;
        $this->container['images'] = isset($data['images']) ? $data['images'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['certifications'] = isset($data['certifications']) ? $data['certifications'] : null;
        $this->container['biography'] = isset($data['biography']) ? $data['biography'] : null;
        $this->container['employerInfo'] = isset($data['employerInfo']) ? $data['employerInfo'] : null;
        $this->container['routingStatus'] = isset($data['routingStatus']) ? $data['routingStatus'] : null;
        $this->container['presence'] = isset($data['presence']) ? $data['presence'] : null;
        $this->container['conversationSummary'] = isset($data['conversationSummary']) ? $data['conversationSummary'] : null;
        $this->container['outOfOffice'] = isset($data['outOfOffice']) ? $data['outOfOffice'] : null;
        $this->container['geolocation'] = isset($data['geolocation']) ? $data['geolocation'] : null;
        $this->container['station'] = isset($data['station']) ? $data['station'] : null;
        $this->container['authorization'] = isset($data['authorization']) ? $data['authorization'] : null;
        $this->container['profileSkills'] = isset($data['profileSkills']) ? $data['profileSkills'] : null;
        $this->container['locations'] = isset($data['locations']) ? $data['locations'] : null;
        $this->container['groups'] = isset($data['groups']) ? $data['groups'] : null;
        $this->container['skills'] = isset($data['skills']) ? $data['skills'] : null;
        $this->container['languages'] = isset($data['languages']) ? $data['languages'] : null;
        $this->container['acdAutoAnswer'] = isset($data['acdAutoAnswer']) ? $data['acdAutoAnswer'] : null;
        $this->container['languagePreference'] = isset($data['languagePreference']) ? $data['languagePreference'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
        $this->container['geolocationSettings'] = isset($data['geolocationSettings']) ? $data['geolocationSettings'] : null;
        $this->container['organization'] = isset($data['organization']) ? $data['organization'] : null;
        $this->container['presenceDefinitions'] = isset($data['presenceDefinitions']) ? $data['presenceDefinitions'] : null;
        $this->container['locationDefinitions'] = isset($data['locationDefinitions']) ? $data['locationDefinitions'] : null;
        $this->container['orgAuthorization'] = isset($data['orgAuthorization']) ? $data['orgAuthorization'] : null;
        $this->container['favorites'] = isset($data['favorites']) ? $data['favorites'] : null;
        $this->container['superiors'] = isset($data['superiors']) ? $data['superiors'] : null;
        $this->container['directReports'] = isset($data['directReports']) ? $data['directReports'] : null;
        $this->container['adjacents'] = isset($data['adjacents']) ? $data['adjacents'] : null;
        $this->container['routingSkills'] = isset($data['routingSkills']) ? $data['routingSkills'] : null;
        $this->container['fieldConfigs'] = isset($data['fieldConfigs']) ? $data['fieldConfigs'] : null;
        $this->container['token'] = isset($data['token']) ? $data['token'] : null;
        $this->container['trustors'] = isset($data['trustors']) ? $data['trustors'] : null;
        $this->container['orgProducts'] = isset($data['orgProducts']) ? $data['orgProducts'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['version'] === null) {
            $invalid_properties[] = "'version' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['version'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets division
     * @return \PureCloudSDK\Division
     */
    public function getDivision()
    {
        return $this->container['division'];
    }

    /**
     * Sets division
     * @param \PureCloudSDK\Division $division The division to which this entity belongs.
     * @return $this
     */
    public function setDivision($division)
    {
        $this->container['division'] = $division;

        return $this;
    }

    /**
     * Gets chat
     * @return \PureCloudSDK\Chat
     */
    public function getChat()
    {
        return $this->container['chat'];
    }

    /**
     * Sets chat
     * @param \PureCloudSDK\Chat $chat
     * @return $this
     */
    public function setChat($chat)
    {
        $this->container['chat'] = $chat;

        return $this;
    }

    /**
     * Gets department
     * @return string
     */
    public function getDepartment()
    {
        return $this->container['department'];
    }

    /**
     * Sets department
     * @param string $department
     * @return $this
     */
    public function setDepartment($department)
    {
        $this->container['department'] = $department;

        return $this;
    }

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     * @param string $email
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets primaryContactInfo
     * @return \PureCloudSDK\Contact[]
     */
    public function getPrimaryContactInfo()
    {
        return $this->container['primaryContactInfo'];
    }

    /**
     * Sets primaryContactInfo
     * @param \PureCloudSDK\Contact[] $primaryContactInfo Auto populated from addresses.
     * @return $this
     */
    public function setPrimaryContactInfo($primaryContactInfo)
    {
        $this->container['primaryContactInfo'] = $primaryContactInfo;

        return $this;
    }

    /**
     * Gets addresses
     * @return \PureCloudSDK\Contact[]
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     * @param \PureCloudSDK\Contact[] $addresses Email addresses and phone numbers for this user
     * @return $this
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The current state for this user.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets username
     * @return string
     */
    public function getUsername()
    {
        return $this->container['username'];
    }

    /**
     * Sets username
     * @param string $username
     * @return $this
     */
    public function setUsername($username)
    {
        $this->container['username'] = $username;

        return $this;
    }

    /**
     * Gets manager
     * @return \PureCloudSDK\User
     */
    public function getManager()
    {
        return $this->container['manager'];
    }

    /**
     * Sets manager
     * @param \PureCloudSDK\User $manager
     * @return $this
     */
    public function setManager($manager)
    {
        $this->container['manager'] = $manager;

        return $this;
    }

    /**
     * Gets images
     * @return \PureCloudSDK\UserImage[]
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     * @param \PureCloudSDK\UserImage[] $images
     * @return $this
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required when updating a user, this value should be the current version of the user.  The current version can be obtained with a GET on the user before doing a PATCH.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets certifications
     * @return string[]
     */
    public function getCertifications()
    {
        return $this->container['certifications'];
    }

    /**
     * Sets certifications
     * @param string[] $certifications
     * @return $this
     */
    public function setCertifications($certifications)
    {
        $this->container['certifications'] = $certifications;

        return $this;
    }

    /**
     * Gets biography
     * @return \PureCloudSDK\Biography
     */
    public function getBiography()
    {
        return $this->container['biography'];
    }

    /**
     * Sets biography
     * @param \PureCloudSDK\Biography $biography
     * @return $this
     */
    public function setBiography($biography)
    {
        $this->container['biography'] = $biography;

        return $this;
    }

    /**
     * Gets employerInfo
     * @return \PureCloudSDK\EmployerInfo
     */
    public function getEmployerInfo()
    {
        return $this->container['employerInfo'];
    }

    /**
     * Sets employerInfo
     * @param \PureCloudSDK\EmployerInfo $employerInfo
     * @return $this
     */
    public function setEmployerInfo($employerInfo)
    {
        $this->container['employerInfo'] = $employerInfo;

        return $this;
    }

    /**
     * Gets routingStatus
     * @return \PureCloudSDK\RoutingStatus
     */
    public function getRoutingStatus()
    {
        return $this->container['routingStatus'];
    }

    /**
     * Sets routingStatus
     * @param \PureCloudSDK\RoutingStatus $routingStatus ACD routing status
     * @return $this
     */
    public function setRoutingStatus($routingStatus)
    {
        $this->container['routingStatus'] = $routingStatus;

        return $this;
    }

    /**
     * Gets presence
     * @return \PureCloudSDK\UserPresence
     */
    public function getPresence()
    {
        return $this->container['presence'];
    }

    /**
     * Sets presence
     * @param \PureCloudSDK\UserPresence $presence Active presence
     * @return $this
     */
    public function setPresence($presence)
    {
        $this->container['presence'] = $presence;

        return $this;
    }

    /**
     * Gets conversationSummary
     * @return \PureCloudSDK\UserConversationSummary
     */
    public function getConversationSummary()
    {
        return $this->container['conversationSummary'];
    }

    /**
     * Sets conversationSummary
     * @param \PureCloudSDK\UserConversationSummary $conversationSummary Summary of conversion statistics for conversation types.
     * @return $this
     */
    public function setConversationSummary($conversationSummary)
    {
        $this->container['conversationSummary'] = $conversationSummary;

        return $this;
    }

    /**
     * Gets outOfOffice
     * @return \PureCloudSDK\OutOfOffice
     */
    public function getOutOfOffice()
    {
        return $this->container['outOfOffice'];
    }

    /**
     * Sets outOfOffice
     * @param \PureCloudSDK\OutOfOffice $outOfOffice Determine if out of office is enabled
     * @return $this
     */
    public function setOutOfOffice($outOfOffice)
    {
        $this->container['outOfOffice'] = $outOfOffice;

        return $this;
    }

    /**
     * Gets geolocation
     * @return \PureCloudSDK\Geolocation
     */
    public function getGeolocation()
    {
        return $this->container['geolocation'];
    }

    /**
     * Sets geolocation
     * @param \PureCloudSDK\Geolocation $geolocation Current geolocation position
     * @return $this
     */
    public function setGeolocation($geolocation)
    {
        $this->container['geolocation'] = $geolocation;

        return $this;
    }

    /**
     * Gets station
     * @return \PureCloudSDK\UserStations
     */
    public function getStation()
    {
        return $this->container['station'];
    }

    /**
     * Sets station
     * @param \PureCloudSDK\UserStations $station Effective, default, and last station information
     * @return $this
     */
    public function setStation($station)
    {
        $this->container['station'] = $station;

        return $this;
    }

    /**
     * Gets authorization
     * @return \PureCloudSDK\UserAuthorization
     */
    public function getAuthorization()
    {
        return $this->container['authorization'];
    }

    /**
     * Sets authorization
     * @param \PureCloudSDK\UserAuthorization $authorization Roles and permissions assigned to the user
     * @return $this
     */
    public function setAuthorization($authorization)
    {
        $this->container['authorization'] = $authorization;

        return $this;
    }

    /**
     * Gets profileSkills
     * @return string[]
     */
    public function getProfileSkills()
    {
        return $this->container['profileSkills'];
    }

    /**
     * Sets profileSkills
     * @param string[] $profileSkills Profile skills possessed by the user
     * @return $this
     */
    public function setProfileSkills($profileSkills)
    {
        $this->container['profileSkills'] = $profileSkills;

        return $this;
    }

    /**
     * Gets locations
     * @return \PureCloudSDK\Location[]
     */
    public function getLocations()
    {
        return $this->container['locations'];
    }

    /**
     * Sets locations
     * @param \PureCloudSDK\Location[] $locations The user placement at each site location.
     * @return $this
     */
    public function setLocations($locations)
    {
        $this->container['locations'] = $locations;

        return $this;
    }

    /**
     * Gets groups
     * @return \PureCloudSDK\Group[]
     */
    public function getGroups()
    {
        return $this->container['groups'];
    }

    /**
     * Sets groups
     * @param \PureCloudSDK\Group[] $groups The groups the user is a member of
     * @return $this
     */
    public function setGroups($groups)
    {
        $this->container['groups'] = $groups;

        return $this;
    }

    /**
     * Gets skills
     * @return \PureCloudSDK\UserRoutingSkill[]
     */
    public function getSkills()
    {
        return $this->container['skills'];
    }

    /**
     * Sets skills
     * @param \PureCloudSDK\UserRoutingSkill[] $skills Routing (ACD) skills possessed by the user
     * @return $this
     */
    public function setSkills($skills)
    {
        $this->container['skills'] = $skills;

        return $this;
    }

    /**
     * Gets languages
     * @return \PureCloudSDK\UserRoutingLanguage[]
     */
    public function getLanguages()
    {
        return $this->container['languages'];
    }

    /**
     * Sets languages
     * @param \PureCloudSDK\UserRoutingLanguage[] $languages Routing (ACD) languages possessed by the user
     * @return $this
     */
    public function setLanguages($languages)
    {
        $this->container['languages'] = $languages;

        return $this;
    }

    /**
     * Gets acdAutoAnswer
     * @return bool
     */
    public function getAcdAutoAnswer()
    {
        return $this->container['acdAutoAnswer'];
    }

    /**
     * Sets acdAutoAnswer
     * @param bool $acdAutoAnswer acd auto answer
     * @return $this
     */
    public function setAcdAutoAnswer($acdAutoAnswer)
    {
        $this->container['acdAutoAnswer'] = $acdAutoAnswer;

        return $this;
    }

    /**
     * Gets languagePreference
     * @return string
     */
    public function getLanguagePreference()
    {
        return $this->container['languagePreference'];
    }

    /**
     * Sets languagePreference
     * @param string $languagePreference preferred language by the user
     * @return $this
     */
    public function setLanguagePreference($languagePreference)
    {
        $this->container['languagePreference'] = $languagePreference;

        return $this;
    }

    /**
     * Gets date
     * @return \PureCloudSDK\ServerDate
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     * @param \PureCloudSDK\ServerDate $date The PureCloud system date time.
     * @return $this
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets geolocationSettings
     * @return \PureCloudSDK\GeolocationSettings
     */
    public function getGeolocationSettings()
    {
        return $this->container['geolocationSettings'];
    }

    /**
     * Sets geolocationSettings
     * @param \PureCloudSDK\GeolocationSettings $geolocationSettings Geolocation settings for user's organization.
     * @return $this
     */
    public function setGeolocationSettings($geolocationSettings)
    {
        $this->container['geolocationSettings'] = $geolocationSettings;

        return $this;
    }

    /**
     * Gets organization
     * @return \PureCloudSDK\Organization
     */
    public function getOrganization()
    {
        return $this->container['organization'];
    }

    /**
     * Sets organization
     * @param \PureCloudSDK\Organization $organization Organization details for this user.
     * @return $this
     */
    public function setOrganization($organization)
    {
        $this->container['organization'] = $organization;

        return $this;
    }

    /**
     * Gets presenceDefinitions
     * @return \PureCloudSDK\OrganizationPresence[]
     */
    public function getPresenceDefinitions()
    {
        return $this->container['presenceDefinitions'];
    }

    /**
     * Sets presenceDefinitions
     * @param \PureCloudSDK\OrganizationPresence[] $presenceDefinitions The first 100 presence definitions for user's organization.
     * @return $this
     */
    public function setPresenceDefinitions($presenceDefinitions)
    {
        $this->container['presenceDefinitions'] = $presenceDefinitions;

        return $this;
    }

    /**
     * Gets locationDefinitions
     * @return \PureCloudSDK\LocationDefinition[]
     */
    public function getLocationDefinitions()
    {
        return $this->container['locationDefinitions'];
    }

    /**
     * Sets locationDefinitions
     * @param \PureCloudSDK\LocationDefinition[] $locationDefinitions The first 100 site locations for user's organization
     * @return $this
     */
    public function setLocationDefinitions($locationDefinitions)
    {
        $this->container['locationDefinitions'] = $locationDefinitions;

        return $this;
    }

    /**
     * Gets orgAuthorization
     * @return \PureCloudSDK\DomainOrganizationRole[]
     */
    public function getOrgAuthorization()
    {
        return $this->container['orgAuthorization'];
    }

    /**
     * Sets orgAuthorization
     * @param \PureCloudSDK\DomainOrganizationRole[] $orgAuthorization The first 100 organization roles, with applicable permission policies, for user's organization.
     * @return $this
     */
    public function setOrgAuthorization($orgAuthorization)
    {
        $this->container['orgAuthorization'] = $orgAuthorization;

        return $this;
    }

    /**
     * Gets favorites
     * @return \PureCloudSDK\User[]
     */
    public function getFavorites()
    {
        return $this->container['favorites'];
    }

    /**
     * Sets favorites
     * @param \PureCloudSDK\User[] $favorites The first 50 favorited users.
     * @return $this
     */
    public function setFavorites($favorites)
    {
        $this->container['favorites'] = $favorites;

        return $this;
    }

    /**
     * Gets superiors
     * @return \PureCloudSDK\User[]
     */
    public function getSuperiors()
    {
        return $this->container['superiors'];
    }

    /**
     * Sets superiors
     * @param \PureCloudSDK\User[] $superiors The first 50 superiors of this user.
     * @return $this
     */
    public function setSuperiors($superiors)
    {
        $this->container['superiors'] = $superiors;

        return $this;
    }

    /**
     * Gets directReports
     * @return \PureCloudSDK\User[]
     */
    public function getDirectReports()
    {
        return $this->container['directReports'];
    }

    /**
     * Sets directReports
     * @param \PureCloudSDK\User[] $directReports The first 50 direct reports to this user.
     * @return $this
     */
    public function setDirectReports($directReports)
    {
        $this->container['directReports'] = $directReports;

        return $this;
    }

    /**
     * Gets adjacents
     * @return \PureCloudSDK\Adjacents
     */
    public function getAdjacents()
    {
        return $this->container['adjacents'];
    }

    /**
     * Sets adjacents
     * @param \PureCloudSDK\Adjacents $adjacents The first 50 superiors, direct reports, and siblings of this user. Mutually exclusive with superiors and direct reports expands.
     * @return $this
     */
    public function setAdjacents($adjacents)
    {
        $this->container['adjacents'] = $adjacents;

        return $this;
    }

    /**
     * Gets routingSkills
     * @return \PureCloudSDK\RoutingSkill[]
     */
    public function getRoutingSkills()
    {
        return $this->container['routingSkills'];
    }

    /**
     * Sets routingSkills
     * @param \PureCloudSDK\RoutingSkill[] $routingSkills The first 50 routing skills for user's organizations
     * @return $this
     */
    public function setRoutingSkills($routingSkills)
    {
        $this->container['routingSkills'] = $routingSkills;

        return $this;
    }

    /**
     * Gets fieldConfigs
     * @return \PureCloudSDK\FieldConfigs
     */
    public function getFieldConfigs()
    {
        return $this->container['fieldConfigs'];
    }

    /**
     * Sets fieldConfigs
     * @param \PureCloudSDK\FieldConfigs $fieldConfigs The field config for all entities types of user's organization
     * @return $this
     */
    public function setFieldConfigs($fieldConfigs)
    {
        $this->container['fieldConfigs'] = $fieldConfigs;

        return $this;
    }

    /**
     * Gets token
     * @return \PureCloudSDK\TokenInfo
     */
    public function getToken()
    {
        return $this->container['token'];
    }

    /**
     * Sets token
     * @param \PureCloudSDK\TokenInfo $token Information about the current token
     * @return $this
     */
    public function setToken($token)
    {
        $this->container['token'] = $token;

        return $this;
    }

    /**
     * Gets trustors
     * @return \PureCloudSDK\Trustor[]
     */
    public function getTrustors()
    {
        return $this->container['trustors'];
    }

    /**
     * Sets trustors
     * @param \PureCloudSDK\Trustor[] $trustors Organizations having this user as a trustee
     * @return $this
     */
    public function setTrustors($trustors)
    {
        $this->container['trustors'] = $trustors;

        return $this;
    }

    /**
     * Gets orgProducts
     * @return \PureCloudSDK\DomainOrganizationProduct[]
     */
    public function getOrgProducts()
    {
        return $this->container['orgProducts'];
    }

    /**
     * Sets orgProducts
     * @param \PureCloudSDK\DomainOrganizationProduct[] $orgProducts Products enabled in this organization
     * @return $this
     */
    public function setOrgProducts($orgProducts)
    {
        $this->container['orgProducts'] = $orgProducts;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


