<?php
/**
 * WebChatMemberInfo
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * WebChatMemberInfo Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WebChatMemberInfo implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WebChatMemberInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'displayName' => 'string',
        'avatarImageUrl' => 'string',
        'role' => 'string',
        'joinDate' => '\DateTime',
        'leaveDate' => '\DateTime',
        'authenticatedGuest' => 'bool',
        'customFields' => 'map[string,string]',
        'state' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'displayName' => 'displayName',
        'avatarImageUrl' => 'avatarImageUrl',
        'role' => 'role',
        'joinDate' => 'joinDate',
        'leaveDate' => 'leaveDate',
        'authenticatedGuest' => 'authenticatedGuest',
        'customFields' => 'customFields',
        'state' => 'state'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'displayName' => 'setDisplayName',
        'avatarImageUrl' => 'setAvatarImageUrl',
        'role' => 'setRole',
        'joinDate' => 'setJoinDate',
        'leaveDate' => 'setLeaveDate',
        'authenticatedGuest' => 'setAuthenticatedGuest',
        'customFields' => 'setCustomFields',
        'state' => 'setState'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'displayName' => 'getDisplayName',
        'avatarImageUrl' => 'getAvatarImageUrl',
        'role' => 'getRole',
        'joinDate' => 'getJoinDate',
        'leaveDate' => 'getLeaveDate',
        'authenticatedGuest' => 'getAuthenticatedGuest',
        'customFields' => 'getCustomFields',
        'state' => 'getState'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ROLE_AGENT = 'AGENT';
    const ROLE_CUSTOMER = 'CUSTOMER';
    const ROLE_WORKFLOW = 'WORKFLOW';
    const ROLE_ACD = 'ACD';
    const STATE_CONNECTED = 'CONNECTED';
    const STATE_DISCONNECTED = 'DISCONNECTED';
    const STATE_ALERTING = 'ALERTING';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRoleAllowableValues()
    {
        return [
            self::ROLE_AGENT,
            self::ROLE_CUSTOMER,
            self::ROLE_WORKFLOW,
            self::ROLE_ACD,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_ALERTING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['displayName'] = isset($data['displayName']) ? $data['displayName'] : null;
        $this->container['avatarImageUrl'] = isset($data['avatarImageUrl']) ? $data['avatarImageUrl'] : null;
        $this->container['role'] = isset($data['role']) ? $data['role'] : null;
        $this->container['joinDate'] = isset($data['joinDate']) ? $data['joinDate'] : null;
        $this->container['leaveDate'] = isset($data['leaveDate']) ? $data['leaveDate'] : null;
        $this->container['authenticatedGuest'] = isset($data['authenticatedGuest']) ? $data['authenticatedGuest'] : null;
        $this->container['customFields'] = isset($data['customFields']) ? $data['customFields'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['role'] === null) {
            $invalid_properties[] = "'role' can't be null";
        }
        $allowed_values = array("AGENT", "CUSTOMER", "WORKFLOW", "ACD");
        if (!in_array($this->container['role'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'role', must be one of #{allowed_values}.";
        }

        $allowed_values = array("CONNECTED", "DISCONNECTED", "ALERTING");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['role'] === null) {
            return false;
        }
        $allowed_values = array("AGENT", "CUSTOMER", "WORKFLOW", "ACD");
        if (!in_array($this->container['role'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("CONNECTED", "DISCONNECTED", "ALERTING");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The communicationId of this member.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayName
     * @return string
     */
    public function getDisplayName()
    {
        return $this->container['displayName'];
    }

    /**
     * Sets displayName
     * @param string $displayName The display name of the member.
     * @return $this
     */
    public function setDisplayName($displayName)
    {
        $this->container['displayName'] = $displayName;

        return $this;
    }

    /**
     * Gets avatarImageUrl
     * @return string
     */
    public function getAvatarImageUrl()
    {
        return $this->container['avatarImageUrl'];
    }

    /**
     * Sets avatarImageUrl
     * @param string $avatarImageUrl The url to the avatar image of the member.
     * @return $this
     */
    public function setAvatarImageUrl($avatarImageUrl)
    {
        $this->container['avatarImageUrl'] = $avatarImageUrl;

        return $this;
    }

    /**
     * Gets role
     * @return string
     */
    public function getRole()
    {
        return $this->container['role'];
    }

    /**
     * Sets role
     * @param string $role The role of the member, one of [agent, customer, acd, workflow]
     * @return $this
     */
    public function setRole($role)
    {
        $allowed_values = array('AGENT', 'CUSTOMER', 'WORKFLOW', 'ACD');
        if (!in_array($role, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'role', must be one of 'AGENT', 'CUSTOMER', 'WORKFLOW', 'ACD'");
        }
        $this->container['role'] = $role;

        return $this;
    }

    /**
     * Gets joinDate
     * @return \DateTime
     */
    public function getJoinDate()
    {
        return $this->container['joinDate'];
    }

    /**
     * Sets joinDate
     * @param \DateTime $joinDate The time the member joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setJoinDate($joinDate)
    {
        $this->container['joinDate'] = $joinDate;

        return $this;
    }

    /**
     * Gets leaveDate
     * @return \DateTime
     */
    public function getLeaveDate()
    {
        return $this->container['leaveDate'];
    }

    /**
     * Sets leaveDate
     * @param \DateTime $leaveDate The time the member left the conversation, or null if the member is still active in the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setLeaveDate($leaveDate)
    {
        $this->container['leaveDate'] = $leaveDate;

        return $this;
    }

    /**
     * Gets authenticatedGuest
     * @return bool
     */
    public function getAuthenticatedGuest()
    {
        return $this->container['authenticatedGuest'];
    }

    /**
     * Sets authenticatedGuest
     * @param bool $authenticatedGuest If true, the guest member is an authenticated guest.
     * @return $this
     */
    public function setAuthenticatedGuest($authenticatedGuest)
    {
        $this->container['authenticatedGuest'] = $authenticatedGuest;

        return $this;
    }

    /**
     * Gets customFields
     * @return map[string,string]
     */
    public function getCustomFields()
    {
        return $this->container['customFields'];
    }

    /**
     * Sets customFields
     * @param map[string,string] $customFields Any custom fields of information pertaining to this member.
     * @return $this
     */
    public function setCustomFields($customFields)
    {
        $this->container['customFields'] = $customFields;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The connection state of this member.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('CONNECTED', 'DISCONNECTED', 'ALERTING');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'CONNECTED', 'DISCONNECTED', 'ALERTING'");
        }
        $this->container['state'] = $state;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


