<?php
/**
 * WfmAgent
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * WfmAgent Class Doc Comment
 *
 * @category    Class */
 // @description Workforce management agent data
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WfmAgent implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WfmAgent';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'user' => '\PureCloudSDK\UserReference',
        'workPlan' => '\PureCloudSDK\WorkPlanReference',
        'timeZone' => '\PureCloudSDK\WfmTimeZone',
        'acceptDirectShiftTrades' => 'bool',
        'metadata' => '\PureCloudSDK\WfmVersionedEntityMetadata',
        'queues' => '\PureCloudSDK\QueueReference[]',
        'languages' => '\PureCloudSDK\LanguageReference[]',
        'skills' => '\PureCloudSDK\RoutingSkillReference[]',
        'schedulable' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'user' => 'user',
        'workPlan' => 'workPlan',
        'timeZone' => 'timeZone',
        'acceptDirectShiftTrades' => 'acceptDirectShiftTrades',
        'metadata' => 'metadata',
        'queues' => 'queues',
        'languages' => 'languages',
        'skills' => 'skills',
        'schedulable' => 'schedulable',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'user' => 'setUser',
        'workPlan' => 'setWorkPlan',
        'timeZone' => 'setTimeZone',
        'acceptDirectShiftTrades' => 'setAcceptDirectShiftTrades',
        'metadata' => 'setMetadata',
        'queues' => 'setQueues',
        'languages' => 'setLanguages',
        'skills' => 'setSkills',
        'schedulable' => 'setSchedulable',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'user' => 'getUser',
        'workPlan' => 'getWorkPlan',
        'timeZone' => 'getTimeZone',
        'acceptDirectShiftTrades' => 'getAcceptDirectShiftTrades',
        'metadata' => 'getMetadata',
        'queues' => 'getQueues',
        'languages' => 'getLanguages',
        'skills' => 'getSkills',
        'schedulable' => 'getSchedulable',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['workPlan'] = isset($data['workPlan']) ? $data['workPlan'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['acceptDirectShiftTrades'] = isset($data['acceptDirectShiftTrades']) ? $data['acceptDirectShiftTrades'] : null;
        $this->container['metadata'] = isset($data['metadata']) ? $data['metadata'] : null;
        $this->container['queues'] = isset($data['queues']) ? $data['queues'] : null;
        $this->container['languages'] = isset($data['languages']) ? $data['languages'] : null;
        $this->container['skills'] = isset($data['skills']) ? $data['skills'] : null;
        $this->container['schedulable'] = isset($data['schedulable']) ? $data['schedulable'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\UserReference
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\UserReference $user The user associated with this data
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets workPlan
     * @return \PureCloudSDK\WorkPlanReference
     */
    public function getWorkPlan()
    {
        return $this->container['workPlan'];
    }

    /**
     * Sets workPlan
     * @param \PureCloudSDK\WorkPlanReference $workPlan The work plan associated with this agent
     * @return $this
     */
    public function setWorkPlan($workPlan)
    {
        $this->container['workPlan'] = $workPlan;

        return $this;
    }

    /**
     * Gets timeZone
     * @return \PureCloudSDK\WfmTimeZone
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param \PureCloudSDK\WfmTimeZone $timeZone The time zone for this agent. Defaults to the time zone of the management unit to which the agent belongs
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets acceptDirectShiftTrades
     * @return bool
     */
    public function getAcceptDirectShiftTrades()
    {
        return $this->container['acceptDirectShiftTrades'];
    }

    /**
     * Sets acceptDirectShiftTrades
     * @param bool $acceptDirectShiftTrades Whether the agent accepts direct shift trade requests
     * @return $this
     */
    public function setAcceptDirectShiftTrades($acceptDirectShiftTrades)
    {
        $this->container['acceptDirectShiftTrades'] = $acceptDirectShiftTrades;

        return $this;
    }

    /**
     * Gets metadata
     * @return \PureCloudSDK\WfmVersionedEntityMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     * @param \PureCloudSDK\WfmVersionedEntityMetadata $metadata Metadata for this agent
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets queues
     * @return \PureCloudSDK\QueueReference[]
     */
    public function getQueues()
    {
        return $this->container['queues'];
    }

    /**
     * Sets queues
     * @param \PureCloudSDK\QueueReference[] $queues List of queues to which the agent belongs and which are defined in the service goal groups in this management unit
     * @return $this
     */
    public function setQueues($queues)
    {
        $this->container['queues'] = $queues;

        return $this;
    }

    /**
     * Gets languages
     * @return \PureCloudSDK\LanguageReference[]
     */
    public function getLanguages()
    {
        return $this->container['languages'];
    }

    /**
     * Sets languages
     * @param \PureCloudSDK\LanguageReference[] $languages The list of languages
     * @return $this
     */
    public function setLanguages($languages)
    {
        $this->container['languages'] = $languages;

        return $this;
    }

    /**
     * Gets skills
     * @return \PureCloudSDK\RoutingSkillReference[]
     */
    public function getSkills()
    {
        return $this->container['skills'];
    }

    /**
     * Sets skills
     * @param \PureCloudSDK\RoutingSkillReference[] $skills The list of skills
     * @return $this
     */
    public function setSkills($skills)
    {
        $this->container['skills'] = $skills;

        return $this;
    }

    /**
     * Gets schedulable
     * @return bool
     */
    public function getSchedulable()
    {
        return $this->container['schedulable'];
    }

    /**
     * Sets schedulable
     * @param bool $schedulable Whether the agent has the permission to be included in schedule generation
     * @return $this
     */
    public function setSchedulable($schedulable)
    {
        $this->container['schedulable'] = $schedulable;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


