<?php
/**
 * WorkPlan
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * WorkPlan Class Doc Comment
 *
 * @category    Class */
 // @description Work plan information
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WorkPlan implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WorkPlan';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'enabled' => 'bool',
        'constrainWeeklyPaidTime' => 'bool',
        'flexibleWeeklyPaidTime' => 'bool',
        'weeklyExactPaidMinutes' => 'int',
        'weeklyMinimumPaidMinutes' => 'int',
        'weeklyMaximumPaidMinutes' => 'int',
        'constrainPaidTimeGranularity' => 'bool',
        'paidTimeGranularityMinutes' => 'int',
        'constrainMinimumTimeBetweenShifts' => 'bool',
        'minimumTimeBetweenShiftsMinutes' => 'int',
        'maximumDays' => 'int',
        'optionalDays' => '\PureCloudSDK\SetWrapperDayOfWeek',
        'shiftStartVariances' => '\PureCloudSDK\ListWrapperShiftStartVariance',
        'shifts' => '\PureCloudSDK\WorkPlanShift[]',
        'agents' => '\PureCloudSDK\DeletableUserReference[]',
        'metadata' => '\PureCloudSDK\WfmVersionedEntityMetadata',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'enabled' => 'enabled',
        'constrainWeeklyPaidTime' => 'constrainWeeklyPaidTime',
        'flexibleWeeklyPaidTime' => 'flexibleWeeklyPaidTime',
        'weeklyExactPaidMinutes' => 'weeklyExactPaidMinutes',
        'weeklyMinimumPaidMinutes' => 'weeklyMinimumPaidMinutes',
        'weeklyMaximumPaidMinutes' => 'weeklyMaximumPaidMinutes',
        'constrainPaidTimeGranularity' => 'constrainPaidTimeGranularity',
        'paidTimeGranularityMinutes' => 'paidTimeGranularityMinutes',
        'constrainMinimumTimeBetweenShifts' => 'constrainMinimumTimeBetweenShifts',
        'minimumTimeBetweenShiftsMinutes' => 'minimumTimeBetweenShiftsMinutes',
        'maximumDays' => 'maximumDays',
        'optionalDays' => 'optionalDays',
        'shiftStartVariances' => 'shiftStartVariances',
        'shifts' => 'shifts',
        'agents' => 'agents',
        'metadata' => 'metadata',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'enabled' => 'setEnabled',
        'constrainWeeklyPaidTime' => 'setConstrainWeeklyPaidTime',
        'flexibleWeeklyPaidTime' => 'setFlexibleWeeklyPaidTime',
        'weeklyExactPaidMinutes' => 'setWeeklyExactPaidMinutes',
        'weeklyMinimumPaidMinutes' => 'setWeeklyMinimumPaidMinutes',
        'weeklyMaximumPaidMinutes' => 'setWeeklyMaximumPaidMinutes',
        'constrainPaidTimeGranularity' => 'setConstrainPaidTimeGranularity',
        'paidTimeGranularityMinutes' => 'setPaidTimeGranularityMinutes',
        'constrainMinimumTimeBetweenShifts' => 'setConstrainMinimumTimeBetweenShifts',
        'minimumTimeBetweenShiftsMinutes' => 'setMinimumTimeBetweenShiftsMinutes',
        'maximumDays' => 'setMaximumDays',
        'optionalDays' => 'setOptionalDays',
        'shiftStartVariances' => 'setShiftStartVariances',
        'shifts' => 'setShifts',
        'agents' => 'setAgents',
        'metadata' => 'setMetadata',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'enabled' => 'getEnabled',
        'constrainWeeklyPaidTime' => 'getConstrainWeeklyPaidTime',
        'flexibleWeeklyPaidTime' => 'getFlexibleWeeklyPaidTime',
        'weeklyExactPaidMinutes' => 'getWeeklyExactPaidMinutes',
        'weeklyMinimumPaidMinutes' => 'getWeeklyMinimumPaidMinutes',
        'weeklyMaximumPaidMinutes' => 'getWeeklyMaximumPaidMinutes',
        'constrainPaidTimeGranularity' => 'getConstrainPaidTimeGranularity',
        'paidTimeGranularityMinutes' => 'getPaidTimeGranularityMinutes',
        'constrainMinimumTimeBetweenShifts' => 'getConstrainMinimumTimeBetweenShifts',
        'minimumTimeBetweenShiftsMinutes' => 'getMinimumTimeBetweenShiftsMinutes',
        'maximumDays' => 'getMaximumDays',
        'optionalDays' => 'getOptionalDays',
        'shiftStartVariances' => 'getShiftStartVariances',
        'shifts' => 'getShifts',
        'agents' => 'getAgents',
        'metadata' => 'getMetadata',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : null;
        $this->container['constrainWeeklyPaidTime'] = isset($data['constrainWeeklyPaidTime']) ? $data['constrainWeeklyPaidTime'] : null;
        $this->container['flexibleWeeklyPaidTime'] = isset($data['flexibleWeeklyPaidTime']) ? $data['flexibleWeeklyPaidTime'] : null;
        $this->container['weeklyExactPaidMinutes'] = isset($data['weeklyExactPaidMinutes']) ? $data['weeklyExactPaidMinutes'] : null;
        $this->container['weeklyMinimumPaidMinutes'] = isset($data['weeklyMinimumPaidMinutes']) ? $data['weeklyMinimumPaidMinutes'] : null;
        $this->container['weeklyMaximumPaidMinutes'] = isset($data['weeklyMaximumPaidMinutes']) ? $data['weeklyMaximumPaidMinutes'] : null;
        $this->container['constrainPaidTimeGranularity'] = isset($data['constrainPaidTimeGranularity']) ? $data['constrainPaidTimeGranularity'] : null;
        $this->container['paidTimeGranularityMinutes'] = isset($data['paidTimeGranularityMinutes']) ? $data['paidTimeGranularityMinutes'] : null;
        $this->container['constrainMinimumTimeBetweenShifts'] = isset($data['constrainMinimumTimeBetweenShifts']) ? $data['constrainMinimumTimeBetweenShifts'] : null;
        $this->container['minimumTimeBetweenShiftsMinutes'] = isset($data['minimumTimeBetweenShiftsMinutes']) ? $data['minimumTimeBetweenShiftsMinutes'] : null;
        $this->container['maximumDays'] = isset($data['maximumDays']) ? $data['maximumDays'] : null;
        $this->container['optionalDays'] = isset($data['optionalDays']) ? $data['optionalDays'] : null;
        $this->container['shiftStartVariances'] = isset($data['shiftStartVariances']) ? $data['shiftStartVariances'] : null;
        $this->container['shifts'] = isset($data['shifts']) ? $data['shifts'] : null;
        $this->container['agents'] = isset($data['agents']) ? $data['agents'] : null;
        $this->container['metadata'] = isset($data['metadata']) ? $data['metadata'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['metadata'] === null) {
            $invalid_properties[] = "'metadata' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['metadata'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled Whether the work plan is enabled for scheduling
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets constrainWeeklyPaidTime
     * @return bool
     */
    public function getConstrainWeeklyPaidTime()
    {
        return $this->container['constrainWeeklyPaidTime'];
    }

    /**
     * Sets constrainWeeklyPaidTime
     * @param bool $constrainWeeklyPaidTime Whether the weekly paid time constraint is enabled for this work plan
     * @return $this
     */
    public function setConstrainWeeklyPaidTime($constrainWeeklyPaidTime)
    {
        $this->container['constrainWeeklyPaidTime'] = $constrainWeeklyPaidTime;

        return $this;
    }

    /**
     * Gets flexibleWeeklyPaidTime
     * @return bool
     */
    public function getFlexibleWeeklyPaidTime()
    {
        return $this->container['flexibleWeeklyPaidTime'];
    }

    /**
     * Sets flexibleWeeklyPaidTime
     * @param bool $flexibleWeeklyPaidTime Whether the weekly paid time constraint is flexible for this work plan
     * @return $this
     */
    public function setFlexibleWeeklyPaidTime($flexibleWeeklyPaidTime)
    {
        $this->container['flexibleWeeklyPaidTime'] = $flexibleWeeklyPaidTime;

        return $this;
    }

    /**
     * Gets weeklyExactPaidMinutes
     * @return int
     */
    public function getWeeklyExactPaidMinutes()
    {
        return $this->container['weeklyExactPaidMinutes'];
    }

    /**
     * Sets weeklyExactPaidMinutes
     * @param int $weeklyExactPaidMinutes Exact weekly paid time in minutes for this work plan. Used if flexibleWeeklyPaidTime == false
     * @return $this
     */
    public function setWeeklyExactPaidMinutes($weeklyExactPaidMinutes)
    {
        $this->container['weeklyExactPaidMinutes'] = $weeklyExactPaidMinutes;

        return $this;
    }

    /**
     * Gets weeklyMinimumPaidMinutes
     * @return int
     */
    public function getWeeklyMinimumPaidMinutes()
    {
        return $this->container['weeklyMinimumPaidMinutes'];
    }

    /**
     * Sets weeklyMinimumPaidMinutes
     * @param int $weeklyMinimumPaidMinutes Minimum weekly paid time in minutes for this work plan. Used if flexibleWeeklyPaidTime == true
     * @return $this
     */
    public function setWeeklyMinimumPaidMinutes($weeklyMinimumPaidMinutes)
    {
        $this->container['weeklyMinimumPaidMinutes'] = $weeklyMinimumPaidMinutes;

        return $this;
    }

    /**
     * Gets weeklyMaximumPaidMinutes
     * @return int
     */
    public function getWeeklyMaximumPaidMinutes()
    {
        return $this->container['weeklyMaximumPaidMinutes'];
    }

    /**
     * Sets weeklyMaximumPaidMinutes
     * @param int $weeklyMaximumPaidMinutes Maximum weekly paid time in minutes for this work plan. Used if flexibleWeeklyPaidTime == true
     * @return $this
     */
    public function setWeeklyMaximumPaidMinutes($weeklyMaximumPaidMinutes)
    {
        $this->container['weeklyMaximumPaidMinutes'] = $weeklyMaximumPaidMinutes;

        return $this;
    }

    /**
     * Gets constrainPaidTimeGranularity
     * @return bool
     */
    public function getConstrainPaidTimeGranularity()
    {
        return $this->container['constrainPaidTimeGranularity'];
    }

    /**
     * Sets constrainPaidTimeGranularity
     * @param bool $constrainPaidTimeGranularity Whether paid time granularity is constrained for this workplan
     * @return $this
     */
    public function setConstrainPaidTimeGranularity($constrainPaidTimeGranularity)
    {
        $this->container['constrainPaidTimeGranularity'] = $constrainPaidTimeGranularity;

        return $this;
    }

    /**
     * Gets paidTimeGranularityMinutes
     * @return int
     */
    public function getPaidTimeGranularityMinutes()
    {
        return $this->container['paidTimeGranularityMinutes'];
    }

    /**
     * Sets paidTimeGranularityMinutes
     * @param int $paidTimeGranularityMinutes Granularity in minutes allowed for shift paid time in this work plan. Used if constrainPaidTimeGranularity == true
     * @return $this
     */
    public function setPaidTimeGranularityMinutes($paidTimeGranularityMinutes)
    {
        $this->container['paidTimeGranularityMinutes'] = $paidTimeGranularityMinutes;

        return $this;
    }

    /**
     * Gets constrainMinimumTimeBetweenShifts
     * @return bool
     */
    public function getConstrainMinimumTimeBetweenShifts()
    {
        return $this->container['constrainMinimumTimeBetweenShifts'];
    }

    /**
     * Sets constrainMinimumTimeBetweenShifts
     * @param bool $constrainMinimumTimeBetweenShifts Whether the minimum time between shifts constraint is enabled for this work plan
     * @return $this
     */
    public function setConstrainMinimumTimeBetweenShifts($constrainMinimumTimeBetweenShifts)
    {
        $this->container['constrainMinimumTimeBetweenShifts'] = $constrainMinimumTimeBetweenShifts;

        return $this;
    }

    /**
     * Gets minimumTimeBetweenShiftsMinutes
     * @return int
     */
    public function getMinimumTimeBetweenShiftsMinutes()
    {
        return $this->container['minimumTimeBetweenShiftsMinutes'];
    }

    /**
     * Sets minimumTimeBetweenShiftsMinutes
     * @param int $minimumTimeBetweenShiftsMinutes Minimum time between shifts in minutes defined in this work plan. Used if constrainMinimumTimeBetweenShifts == true
     * @return $this
     */
    public function setMinimumTimeBetweenShiftsMinutes($minimumTimeBetweenShiftsMinutes)
    {
        $this->container['minimumTimeBetweenShiftsMinutes'] = $minimumTimeBetweenShiftsMinutes;

        return $this;
    }

    /**
     * Gets maximumDays
     * @return int
     */
    public function getMaximumDays()
    {
        return $this->container['maximumDays'];
    }

    /**
     * Sets maximumDays
     * @param int $maximumDays Maximum number days in a week allowed to be scheduled for this work plan
     * @return $this
     */
    public function setMaximumDays($maximumDays)
    {
        $this->container['maximumDays'] = $maximumDays;

        return $this;
    }

    /**
     * Gets optionalDays
     * @return \PureCloudSDK\SetWrapperDayOfWeek
     */
    public function getOptionalDays()
    {
        return $this->container['optionalDays'];
    }

    /**
     * Sets optionalDays
     * @param \PureCloudSDK\SetWrapperDayOfWeek $optionalDays Optional days to schedule for this work plan
     * @return $this
     */
    public function setOptionalDays($optionalDays)
    {
        $this->container['optionalDays'] = $optionalDays;

        return $this;
    }

    /**
     * Gets shiftStartVariances
     * @return \PureCloudSDK\ListWrapperShiftStartVariance
     */
    public function getShiftStartVariances()
    {
        return $this->container['shiftStartVariances'];
    }

    /**
     * Sets shiftStartVariances
     * @param \PureCloudSDK\ListWrapperShiftStartVariance $shiftStartVariances Variance in minutes among start times of shifts in this work plan
     * @return $this
     */
    public function setShiftStartVariances($shiftStartVariances)
    {
        $this->container['shiftStartVariances'] = $shiftStartVariances;

        return $this;
    }

    /**
     * Gets shifts
     * @return \PureCloudSDK\WorkPlanShift[]
     */
    public function getShifts()
    {
        return $this->container['shifts'];
    }

    /**
     * Sets shifts
     * @param \PureCloudSDK\WorkPlanShift[] $shifts Shifts in this work plan
     * @return $this
     */
    public function setShifts($shifts)
    {
        $this->container['shifts'] = $shifts;

        return $this;
    }

    /**
     * Gets agents
     * @return \PureCloudSDK\DeletableUserReference[]
     */
    public function getAgents()
    {
        return $this->container['agents'];
    }

    /**
     * Sets agents
     * @param \PureCloudSDK\DeletableUserReference[] $agents Agents in this work plan
     * @return $this
     */
    public function setAgents($agents)
    {
        $this->container['agents'] = $agents;

        return $this;
    }

    /**
     * Gets metadata
     * @return \PureCloudSDK\WfmVersionedEntityMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     * @param \PureCloudSDK\WfmVersionedEntityMetadata $metadata Version metadata for this work plan
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


