<?php

/**
 * BuPlanningGroupHeadcountForecast
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuPlanningGroupHeadcountForecast Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuPlanningGroupHeadcountForecast implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuPlanningGroupHeadcountForecast';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'planningGroup' => '\PureCloudSDK\PlanningGroupReference',
        'requiredPerInterval' => 'double[]',
        'requiredWithoutShrinkagePerInterval' => 'double[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'planningGroup' => 'planningGroup',
        'requiredPerInterval' => 'requiredPerInterval',
        'requiredWithoutShrinkagePerInterval' => 'requiredWithoutShrinkagePerInterval'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'planningGroup' => 'setPlanningGroup',
        'requiredPerInterval' => 'setRequiredPerInterval',
        'requiredWithoutShrinkagePerInterval' => 'setRequiredWithoutShrinkagePerInterval'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'planningGroup' => 'getPlanningGroup',
        'requiredPerInterval' => 'getRequiredPerInterval',
        'requiredWithoutShrinkagePerInterval' => 'getRequiredWithoutShrinkagePerInterval'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['planningGroup'] = isset($data['planningGroup']) ? $data['planningGroup'] : null;
        $this->container['requiredPerInterval'] = isset($data['requiredPerInterval']) ? $data['requiredPerInterval'] : null;
        $this->container['requiredWithoutShrinkagePerInterval'] = isset($data['requiredWithoutShrinkagePerInterval']) ? $data['requiredWithoutShrinkagePerInterval'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets planningGroup
     * @return \PureCloudSDK\PlanningGroupReference
     */
    public function getPlanningGroup()
    {
        return $this->container['planningGroup'];
    }

    /**
     * Sets planningGroup
     * @param \PureCloudSDK\PlanningGroupReference $planningGroup The planning group to which this portion of the headcount forecast applies
     * @return $this
     */
    public function setPlanningGroup($planningGroup)
    {
        $this->container['planningGroup'] = $planningGroup;

        return $this;
    }

    /**
     * Gets requiredPerInterval
     * @return double[]
     */
    public function getRequiredPerInterval()
    {
        return $this->container['requiredPerInterval'];
    }

    /**
     * Sets requiredPerInterval
     * @param double[] $requiredPerInterval Required headcount per interval, referenced against the reference start date
     * @return $this
     */
    public function setRequiredPerInterval($requiredPerInterval)
    {
        $this->container['requiredPerInterval'] = $requiredPerInterval;

        return $this;
    }

    /**
     * Gets requiredWithoutShrinkagePerInterval
     * @return double[]
     */
    public function getRequiredWithoutShrinkagePerInterval()
    {
        return $this->container['requiredWithoutShrinkagePerInterval'];
    }

    /**
     * Sets requiredWithoutShrinkagePerInterval
     * @param double[] $requiredWithoutShrinkagePerInterval Required headcount per interval without accounting for shrinkage, referenced against the reference start date
     * @return $this
     */
    public function setRequiredWithoutShrinkagePerInterval($requiredWithoutShrinkagePerInterval)
    {
        $this->container['requiredWithoutShrinkagePerInterval'] = $requiredWithoutShrinkagePerInterval;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
