<?php

/**
 * CallbackMediaParticipant
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CallbackMediaParticipant Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CallbackMediaParticipant implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CallbackMediaParticipant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'address' => 'string',
        'startTime' => '\DateTime',
        'connectedTime' => '\DateTime',
        'endTime' => '\DateTime',
        'startHoldTime' => '\DateTime',
        'purpose' => 'string',
        'state' => 'string',
        'direction' => 'string',
        'disconnectType' => 'string',
        'held' => 'bool',
        'wrapupRequired' => 'bool',
        'wrapupPrompt' => 'string',
        'user' => '\PureCloudSDK\DomainEntityRef',
        'queue' => '\PureCloudSDK\DomainEntityRef',
        'team' => '\PureCloudSDK\DomainEntityRef',
        'attributes' => 'map[string,string]',
        'errorInfo' => '\PureCloudSDK\ErrorInfo',
        'script' => '\PureCloudSDK\DomainEntityRef',
        'wrapupTimeoutMs' => 'int',
        'wrapupSkipped' => 'bool',
        'alertingTimeoutMs' => 'int',
        'provider' => 'string',
        'externalContact' => '\PureCloudSDK\DomainEntityRef',
        'externalOrganization' => '\PureCloudSDK\DomainEntityRef',
        'wrapup' => '\PureCloudSDK\Wrapup',
        'peer' => 'string',
        'flaggedReason' => 'string',
        'journeyContext' => '\PureCloudSDK\JourneyContext',
        'conversationRoutingData' => '\PureCloudSDK\ConversationRoutingData',
        'startAcwTime' => '\DateTime',
        'endAcwTime' => '\DateTime',
        'outboundPreview' => '\PureCloudSDK\DialerPreview',
        'voicemail' => '\PureCloudSDK\Voicemail',
        'callbackNumbers' => 'string[]',
        'callbackUserName' => 'string',
        'externalCampaign' => 'bool',
        'skipEnabled' => 'bool',
        'timeoutSeconds' => 'int',
        'automatedCallbackConfigId' => 'string',
        'callbackScheduledTime' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'address' => 'address',
        'startTime' => 'startTime',
        'connectedTime' => 'connectedTime',
        'endTime' => 'endTime',
        'startHoldTime' => 'startHoldTime',
        'purpose' => 'purpose',
        'state' => 'state',
        'direction' => 'direction',
        'disconnectType' => 'disconnectType',
        'held' => 'held',
        'wrapupRequired' => 'wrapupRequired',
        'wrapupPrompt' => 'wrapupPrompt',
        'user' => 'user',
        'queue' => 'queue',
        'team' => 'team',
        'attributes' => 'attributes',
        'errorInfo' => 'errorInfo',
        'script' => 'script',
        'wrapupTimeoutMs' => 'wrapupTimeoutMs',
        'wrapupSkipped' => 'wrapupSkipped',
        'alertingTimeoutMs' => 'alertingTimeoutMs',
        'provider' => 'provider',
        'externalContact' => 'externalContact',
        'externalOrganization' => 'externalOrganization',
        'wrapup' => 'wrapup',
        'peer' => 'peer',
        'flaggedReason' => 'flaggedReason',
        'journeyContext' => 'journeyContext',
        'conversationRoutingData' => 'conversationRoutingData',
        'startAcwTime' => 'startAcwTime',
        'endAcwTime' => 'endAcwTime',
        'outboundPreview' => 'outboundPreview',
        'voicemail' => 'voicemail',
        'callbackNumbers' => 'callbackNumbers',
        'callbackUserName' => 'callbackUserName',
        'externalCampaign' => 'externalCampaign',
        'skipEnabled' => 'skipEnabled',
        'timeoutSeconds' => 'timeoutSeconds',
        'automatedCallbackConfigId' => 'automatedCallbackConfigId',
        'callbackScheduledTime' => 'callbackScheduledTime'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'address' => 'setAddress',
        'startTime' => 'setStartTime',
        'connectedTime' => 'setConnectedTime',
        'endTime' => 'setEndTime',
        'startHoldTime' => 'setStartHoldTime',
        'purpose' => 'setPurpose',
        'state' => 'setState',
        'direction' => 'setDirection',
        'disconnectType' => 'setDisconnectType',
        'held' => 'setHeld',
        'wrapupRequired' => 'setWrapupRequired',
        'wrapupPrompt' => 'setWrapupPrompt',
        'user' => 'setUser',
        'queue' => 'setQueue',
        'team' => 'setTeam',
        'attributes' => 'setAttributes',
        'errorInfo' => 'setErrorInfo',
        'script' => 'setScript',
        'wrapupTimeoutMs' => 'setWrapupTimeoutMs',
        'wrapupSkipped' => 'setWrapupSkipped',
        'alertingTimeoutMs' => 'setAlertingTimeoutMs',
        'provider' => 'setProvider',
        'externalContact' => 'setExternalContact',
        'externalOrganization' => 'setExternalOrganization',
        'wrapup' => 'setWrapup',
        'peer' => 'setPeer',
        'flaggedReason' => 'setFlaggedReason',
        'journeyContext' => 'setJourneyContext',
        'conversationRoutingData' => 'setConversationRoutingData',
        'startAcwTime' => 'setStartAcwTime',
        'endAcwTime' => 'setEndAcwTime',
        'outboundPreview' => 'setOutboundPreview',
        'voicemail' => 'setVoicemail',
        'callbackNumbers' => 'setCallbackNumbers',
        'callbackUserName' => 'setCallbackUserName',
        'externalCampaign' => 'setExternalCampaign',
        'skipEnabled' => 'setSkipEnabled',
        'timeoutSeconds' => 'setTimeoutSeconds',
        'automatedCallbackConfigId' => 'setAutomatedCallbackConfigId',
        'callbackScheduledTime' => 'setCallbackScheduledTime'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'address' => 'getAddress',
        'startTime' => 'getStartTime',
        'connectedTime' => 'getConnectedTime',
        'endTime' => 'getEndTime',
        'startHoldTime' => 'getStartHoldTime',
        'purpose' => 'getPurpose',
        'state' => 'getState',
        'direction' => 'getDirection',
        'disconnectType' => 'getDisconnectType',
        'held' => 'getHeld',
        'wrapupRequired' => 'getWrapupRequired',
        'wrapupPrompt' => 'getWrapupPrompt',
        'user' => 'getUser',
        'queue' => 'getQueue',
        'team' => 'getTeam',
        'attributes' => 'getAttributes',
        'errorInfo' => 'getErrorInfo',
        'script' => 'getScript',
        'wrapupTimeoutMs' => 'getWrapupTimeoutMs',
        'wrapupSkipped' => 'getWrapupSkipped',
        'alertingTimeoutMs' => 'getAlertingTimeoutMs',
        'provider' => 'getProvider',
        'externalContact' => 'getExternalContact',
        'externalOrganization' => 'getExternalOrganization',
        'wrapup' => 'getWrapup',
        'peer' => 'getPeer',
        'flaggedReason' => 'getFlaggedReason',
        'journeyContext' => 'getJourneyContext',
        'conversationRoutingData' => 'getConversationRoutingData',
        'startAcwTime' => 'getStartAcwTime',
        'endAcwTime' => 'getEndAcwTime',
        'outboundPreview' => 'getOutboundPreview',
        'voicemail' => 'getVoicemail',
        'callbackNumbers' => 'getCallbackNumbers',
        'callbackUserName' => 'getCallbackUserName',
        'externalCampaign' => 'getExternalCampaign',
        'skipEnabled' => 'getSkipEnabled',
        'timeoutSeconds' => 'getTimeoutSeconds',
        'automatedCallbackConfigId' => 'getAutomatedCallbackConfigId',
        'callbackScheduledTime' => 'getCallbackScheduledTime'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_ALERTING = 'alerting';
    public const STATE_DIALING = 'dialing';
    public const STATE_CONTACTING = 'contacting';
    public const STATE_OFFERING = 'offering';
    public const STATE_CONNECTED = 'connected';
    public const STATE_DISCONNECTED = 'disconnected';
    public const STATE_TERMINATED = 'terminated';
    public const STATE_CONVERTING = 'converting';
    public const STATE_UPLOADING = 'uploading';
    public const STATE_TRANSMITTING = 'transmitting';
    public const STATE_NONE = 'none';
    public const DIRECTION_INBOUND = 'inbound';
    public const DIRECTION_OUTBOUND = 'outbound';
    public const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    public const DISCONNECT_TYPE_CLIENT = 'client';
    public const DISCONNECT_TYPE_SYSTEM = 'system';
    public const DISCONNECT_TYPE_TRANSFER = 'transfer';
    public const DISCONNECT_TYPE_TRANSFERCONFERENCE = 'transfer.conference';
    public const DISCONNECT_TYPE_TRANSFERCONSULT = 'transfer.consult';
    public const DISCONNECT_TYPE_TRANSFERFORWARD = 'transfer.forward';
    public const DISCONNECT_TYPE_TRANSFERNOANSWER = 'transfer.noanswer';
    public const DISCONNECT_TYPE_TRANSFERNOTAVAILABLE = 'transfer.notavailable';
    public const DISCONNECT_TYPE_TRANSPORTFAILURE = 'transport.failure';
    public const DISCONNECT_TYPE_ERROR = 'error';
    public const DISCONNECT_TYPE_PEER = 'peer';
    public const DISCONNECT_TYPE_OTHER = 'other';
    public const DISCONNECT_TYPE_SPAM = 'spam';
    public const FLAGGED_REASON_GENERAL = 'general';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_CONVERTING,
            self::STATE_UPLOADING,
            self::STATE_TRANSMITTING,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFERCONFERENCE,
            self::DISCONNECT_TYPE_TRANSFERCONSULT,
            self::DISCONNECT_TYPE_TRANSFERFORWARD,
            self::DISCONNECT_TYPE_TRANSFERNOANSWER,
            self::DISCONNECT_TYPE_TRANSFERNOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORTFAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlaggedReasonAllowableValues()
    {
        return [
            self::FLAGGED_REASON_GENERAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['startTime'] = isset($data['startTime']) ? $data['startTime'] : null;
        $this->container['connectedTime'] = isset($data['connectedTime']) ? $data['connectedTime'] : null;
        $this->container['endTime'] = isset($data['endTime']) ? $data['endTime'] : null;
        $this->container['startHoldTime'] = isset($data['startHoldTime']) ? $data['startHoldTime'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['disconnectType'] = isset($data['disconnectType']) ? $data['disconnectType'] : null;
        $this->container['held'] = isset($data['held']) ? $data['held'] : null;
        $this->container['wrapupRequired'] = isset($data['wrapupRequired']) ? $data['wrapupRequired'] : null;
        $this->container['wrapupPrompt'] = isset($data['wrapupPrompt']) ? $data['wrapupPrompt'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['team'] = isset($data['team']) ? $data['team'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['errorInfo'] = isset($data['errorInfo']) ? $data['errorInfo'] : null;
        $this->container['script'] = isset($data['script']) ? $data['script'] : null;
        $this->container['wrapupTimeoutMs'] = isset($data['wrapupTimeoutMs']) ? $data['wrapupTimeoutMs'] : null;
        $this->container['wrapupSkipped'] = isset($data['wrapupSkipped']) ? $data['wrapupSkipped'] : null;
        $this->container['alertingTimeoutMs'] = isset($data['alertingTimeoutMs']) ? $data['alertingTimeoutMs'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['externalContact'] = isset($data['externalContact']) ? $data['externalContact'] : null;
        $this->container['externalOrganization'] = isset($data['externalOrganization']) ? $data['externalOrganization'] : null;
        $this->container['wrapup'] = isset($data['wrapup']) ? $data['wrapup'] : null;
        $this->container['peer'] = isset($data['peer']) ? $data['peer'] : null;
        $this->container['flaggedReason'] = isset($data['flaggedReason']) ? $data['flaggedReason'] : null;
        $this->container['journeyContext'] = isset($data['journeyContext']) ? $data['journeyContext'] : null;
        $this->container['conversationRoutingData'] = isset($data['conversationRoutingData']) ? $data['conversationRoutingData'] : null;
        $this->container['startAcwTime'] = isset($data['startAcwTime']) ? $data['startAcwTime'] : null;
        $this->container['endAcwTime'] = isset($data['endAcwTime']) ? $data['endAcwTime'] : null;
        $this->container['outboundPreview'] = isset($data['outboundPreview']) ? $data['outboundPreview'] : null;
        $this->container['voicemail'] = isset($data['voicemail']) ? $data['voicemail'] : null;
        $this->container['callbackNumbers'] = isset($data['callbackNumbers']) ? $data['callbackNumbers'] : null;
        $this->container['callbackUserName'] = isset($data['callbackUserName']) ? $data['callbackUserName'] : null;
        $this->container['externalCampaign'] = isset($data['externalCampaign']) ? $data['externalCampaign'] : null;
        $this->container['skipEnabled'] = isset($data['skipEnabled']) ? $data['skipEnabled'] : null;
        $this->container['timeoutSeconds'] = isset($data['timeoutSeconds']) ? $data['timeoutSeconds'] : null;
        $this->container['automatedCallbackConfigId'] = isset($data['automatedCallbackConfigId']) ? $data['automatedCallbackConfigId'] : null;
        $this->container['callbackScheduledTime'] = isset($data['callbackScheduledTime']) ? $data['callbackScheduledTime'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("endpoint", "client", "system", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnectType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("general");
        if (!in_array($this->container['flaggedReason'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'flaggedReason', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("endpoint", "client", "system", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("general");
        if (!in_array($this->container['flaggedReason'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The unique participant ID.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The display friendly name of the participant.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address The participant address.
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets startTime
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['startTime'];
    }

    /**
     * Sets startTime
     * @param \DateTime $startTime The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartTime($startTime)
    {
        $this->container['startTime'] = $startTime;

        return $this;
    }

    /**
     * Gets connectedTime
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connectedTime'];
    }

    /**
     * Sets connectedTime
     * @param \DateTime $connectedTime The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connectedTime)
    {
        $this->container['connectedTime'] = $connectedTime;

        return $this;
    }

    /**
     * Gets endTime
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['endTime'];
    }

    /**
     * Sets endTime
     * @param \DateTime $endTime The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndTime($endTime)
    {
        $this->container['endTime'] = $endTime;

        return $this;
    }

    /**
     * Gets startHoldTime
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['startHoldTime'];
    }

    /**
     * Sets startHoldTime
     * @param \DateTime $startHoldTime The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartHoldTime($startHoldTime)
    {
        $this->container['startHoldTime'] = $startHoldTime;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'none');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'none'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The participant's direction.  Values can be: 'inbound' or 'outbound'
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets disconnectType
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnectType'];
    }

    /**
     * Sets disconnectType
     * @param string $disconnectType The reason the participant was disconnected from the conversation.
     * @return $this
     */
    public function setDisconnectType($disconnectType)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam');
        if (!in_array($disconnectType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnectType', must be one of 'endpoint', 'client', 'system', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam'");
        }
        $this->container['disconnectType'] = $disconnectType;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held Value is true when the participant is on hold.
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets wrapupRequired
     * @return bool
     */
    public function getWrapupRequired()
    {
        return $this->container['wrapupRequired'];
    }

    /**
     * Sets wrapupRequired
     * @param bool $wrapupRequired Value is true when the participant requires wrap-up.
     * @return $this
     */
    public function setWrapupRequired($wrapupRequired)
    {
        $this->container['wrapupRequired'] = $wrapupRequired;

        return $this;
    }

    /**
     * Gets wrapupPrompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapupPrompt'];
    }

    /**
     * Sets wrapupPrompt
     * @param string $wrapupPrompt The wrap-up prompt indicating the type of wrap-up to be performed.
     * @return $this
     */
    public function setWrapupPrompt($wrapupPrompt)
    {
        $this->container['wrapupPrompt'] = $wrapupPrompt;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\DomainEntityRef $user The PureCloud user for this participant.
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\DomainEntityRef $queue The PureCloud queue for this participant.
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets team
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getTeam()
    {
        return $this->container['team'];
    }

    /**
     * Sets team
     * @param \PureCloudSDK\DomainEntityRef $team The PureCloud team for this participant.
     * @return $this
     */
    public function setTeam($team)
    {
        $this->container['team'] = $team;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes A list of ad-hoc attributes for the participant.
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets errorInfo
     * @return \PureCloudSDK\ErrorInfo
     */
    public function getErrorInfo()
    {
        return $this->container['errorInfo'];
    }

    /**
     * Sets errorInfo
     * @param \PureCloudSDK\ErrorInfo $errorInfo If the conversation ends in error, contains additional error details.
     * @return $this
     */
    public function setErrorInfo($errorInfo)
    {
        $this->container['errorInfo'] = $errorInfo;

        return $this;
    }

    /**
     * Gets script
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getScript()
    {
        return $this->container['script'];
    }

    /**
     * Sets script
     * @param \PureCloudSDK\DomainEntityRef $script The Engage script that should be used by this participant.
     * @return $this
     */
    public function setScript($script)
    {
        $this->container['script'] = $script;

        return $this;
    }

    /**
     * Gets wrapupTimeoutMs
     * @return int
     */
    public function getWrapupTimeoutMs()
    {
        return $this->container['wrapupTimeoutMs'];
    }

    /**
     * Sets wrapupTimeoutMs
     * @param int $wrapupTimeoutMs The amount of time the participant has to complete wrap-up.
     * @return $this
     */
    public function setWrapupTimeoutMs($wrapupTimeoutMs)
    {
        $this->container['wrapupTimeoutMs'] = $wrapupTimeoutMs;

        return $this;
    }

    /**
     * Gets wrapupSkipped
     * @return bool
     */
    public function getWrapupSkipped()
    {
        return $this->container['wrapupSkipped'];
    }

    /**
     * Sets wrapupSkipped
     * @param bool $wrapupSkipped Value is true when the participant has skipped wrap-up.
     * @return $this
     */
    public function setWrapupSkipped($wrapupSkipped)
    {
        $this->container['wrapupSkipped'] = $wrapupSkipped;

        return $this;
    }

    /**
     * Gets alertingTimeoutMs
     * @return int
     */
    public function getAlertingTimeoutMs()
    {
        return $this->container['alertingTimeoutMs'];
    }

    /**
     * Sets alertingTimeoutMs
     * @param int $alertingTimeoutMs Specifies how long the agent has to answer an interaction before being marked as not responding.
     * @return $this
     */
    public function setAlertingTimeoutMs($alertingTimeoutMs)
    {
        $this->container['alertingTimeoutMs'] = $alertingTimeoutMs;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider The source provider for the communication.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets externalContact
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getExternalContact()
    {
        return $this->container['externalContact'];
    }

    /**
     * Sets externalContact
     * @param \PureCloudSDK\DomainEntityRef $externalContact If this participant represents an external contact, then this will be the reference for the external contact.
     * @return $this
     */
    public function setExternalContact($externalContact)
    {
        $this->container['externalContact'] = $externalContact;

        return $this;
    }

    /**
     * Gets externalOrganization
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getExternalOrganization()
    {
        return $this->container['externalOrganization'];
    }

    /**
     * Sets externalOrganization
     * @param \PureCloudSDK\DomainEntityRef $externalOrganization If this participant represents an external org, then this will be the reference for the external org.
     * @return $this
     */
    public function setExternalOrganization($externalOrganization)
    {
        $this->container['externalOrganization'] = $externalOrganization;

        return $this;
    }

    /**
     * Gets wrapup
     * @return \PureCloudSDK\Wrapup
     */
    public function getWrapup()
    {
        return $this->container['wrapup'];
    }

    /**
     * Sets wrapup
     * @param \PureCloudSDK\Wrapup $wrapup Wrapup for this participant, if it has been applied.
     * @return $this
     */
    public function setWrapup($wrapup)
    {
        $this->container['wrapup'] = $wrapup;

        return $this;
    }

    /**
     * Gets peer
     * @return string
     */
    public function getPeer()
    {
        return $this->container['peer'];
    }

    /**
     * Sets peer
     * @param string $peer The peer communication corresponding to a matching leg for this communication.
     * @return $this
     */
    public function setPeer($peer)
    {
        $this->container['peer'] = $peer;

        return $this;
    }

    /**
     * Gets flaggedReason
     * @return string
     */
    public function getFlaggedReason()
    {
        return $this->container['flaggedReason'];
    }

    /**
     * Sets flaggedReason
     * @param string $flaggedReason The reason specifying why participant flagged the conversation.
     * @return $this
     */
    public function setFlaggedReason($flaggedReason)
    {
        $allowed_values = array('general');
        if (!in_array($flaggedReason, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flaggedReason', must be one of 'general'");
        }
        $this->container['flaggedReason'] = $flaggedReason;

        return $this;
    }

    /**
     * Gets journeyContext
     * @return \PureCloudSDK\JourneyContext
     */
    public function getJourneyContext()
    {
        return $this->container['journeyContext'];
    }

    /**
     * Sets journeyContext
     * @param \PureCloudSDK\JourneyContext $journeyContext Journey System data/context that is applicable to this communication.  When used for historical purposes, the context should be immutable.  When null, there is no applicable Journey System context.
     * @return $this
     */
    public function setJourneyContext($journeyContext)
    {
        $this->container['journeyContext'] = $journeyContext;

        return $this;
    }

    /**
     * Gets conversationRoutingData
     * @return \PureCloudSDK\ConversationRoutingData
     */
    public function getConversationRoutingData()
    {
        return $this->container['conversationRoutingData'];
    }

    /**
     * Sets conversationRoutingData
     * @param \PureCloudSDK\ConversationRoutingData $conversationRoutingData Information on how a communication should be routed to an agent.
     * @return $this
     */
    public function setConversationRoutingData($conversationRoutingData)
    {
        $this->container['conversationRoutingData'] = $conversationRoutingData;

        return $this;
    }

    /**
     * Gets startAcwTime
     * @return \DateTime
     */
    public function getStartAcwTime()
    {
        return $this->container['startAcwTime'];
    }

    /**
     * Sets startAcwTime
     * @param \DateTime $startAcwTime The timestamp when this participant started after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartAcwTime($startAcwTime)
    {
        $this->container['startAcwTime'] = $startAcwTime;

        return $this;
    }

    /**
     * Gets endAcwTime
     * @return \DateTime
     */
    public function getEndAcwTime()
    {
        return $this->container['endAcwTime'];
    }

    /**
     * Sets endAcwTime
     * @param \DateTime $endAcwTime The timestamp when this participant ended after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndAcwTime($endAcwTime)
    {
        $this->container['endAcwTime'] = $endAcwTime;

        return $this;
    }

    /**
     * Gets outboundPreview
     * @return \PureCloudSDK\DialerPreview
     */
    public function getOutboundPreview()
    {
        return $this->container['outboundPreview'];
    }

    /**
     * Sets outboundPreview
     * @param \PureCloudSDK\DialerPreview $outboundPreview The outbound preview associated with this callback.
     * @return $this
     */
    public function setOutboundPreview($outboundPreview)
    {
        $this->container['outboundPreview'] = $outboundPreview;

        return $this;
    }

    /**
     * Gets voicemail
     * @return \PureCloudSDK\Voicemail
     */
    public function getVoicemail()
    {
        return $this->container['voicemail'];
    }

    /**
     * Sets voicemail
     * @param \PureCloudSDK\Voicemail $voicemail The voicemail associated with this callback.
     * @return $this
     */
    public function setVoicemail($voicemail)
    {
        $this->container['voicemail'] = $voicemail;

        return $this;
    }

    /**
     * Gets callbackNumbers
     * @return string[]
     */
    public function getCallbackNumbers()
    {
        return $this->container['callbackNumbers'];
    }

    /**
     * Sets callbackNumbers
     * @param string[] $callbackNumbers The list of phone number to use for this callback.
     * @return $this
     */
    public function setCallbackNumbers($callbackNumbers)
    {
        $this->container['callbackNumbers'] = $callbackNumbers;

        return $this;
    }

    /**
     * Gets callbackUserName
     * @return string
     */
    public function getCallbackUserName()
    {
        return $this->container['callbackUserName'];
    }

    /**
     * Sets callbackUserName
     * @param string $callbackUserName The name of the callback target.
     * @return $this
     */
    public function setCallbackUserName($callbackUserName)
    {
        $this->container['callbackUserName'] = $callbackUserName;

        return $this;
    }

    /**
     * Gets externalCampaign
     * @return bool
     */
    public function getExternalCampaign()
    {
        return $this->container['externalCampaign'];
    }

    /**
     * Sets externalCampaign
     * @param bool $externalCampaign True if the call for the callback uses external dialing.
     * @return $this
     */
    public function setExternalCampaign($externalCampaign)
    {
        $this->container['externalCampaign'] = $externalCampaign;

        return $this;
    }

    /**
     * Gets skipEnabled
     * @return bool
     */
    public function getSkipEnabled()
    {
        return $this->container['skipEnabled'];
    }

    /**
     * Sets skipEnabled
     * @param bool $skipEnabled If true, the callback can be skipped.
     * @return $this
     */
    public function setSkipEnabled($skipEnabled)
    {
        $this->container['skipEnabled'] = $skipEnabled;

        return $this;
    }

    /**
     * Gets timeoutSeconds
     * @return int
     */
    public function getTimeoutSeconds()
    {
        return $this->container['timeoutSeconds'];
    }

    /**
     * Sets timeoutSeconds
     * @param int $timeoutSeconds Duration in seconds before the callback will be auto-dialed.
     * @return $this
     */
    public function setTimeoutSeconds($timeoutSeconds)
    {
        $this->container['timeoutSeconds'] = $timeoutSeconds;

        return $this;
    }

    /**
     * Gets automatedCallbackConfigId
     * @return string
     */
    public function getAutomatedCallbackConfigId()
    {
        return $this->container['automatedCallbackConfigId'];
    }

    /**
     * Sets automatedCallbackConfigId
     * @param string $automatedCallbackConfigId The id of the config for automatically placing the callback (and handling the disposition). If absent, the callback will not be placed automatically but routed to an agent as per normal.
     * @return $this
     */
    public function setAutomatedCallbackConfigId($automatedCallbackConfigId)
    {
        $this->container['automatedCallbackConfigId'] = $automatedCallbackConfigId;

        return $this;
    }

    /**
     * Gets callbackScheduledTime
     * @return \DateTime
     */
    public function getCallbackScheduledTime()
    {
        return $this->container['callbackScheduledTime'];
    }

    /**
     * Sets callbackScheduledTime
     * @param \DateTime $callbackScheduledTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallbackScheduledTime($callbackScheduledTime)
    {
        $this->container['callbackScheduledTime'] = $callbackScheduledTime;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
