<?php

/**
 * ConversationAssociation
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ConversationAssociation Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationAssociation implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationAssociation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'externalContactId' => 'string',
        'conversationId' => 'string',
        'communicationId' => 'string',
        'mediaType' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'externalContactId' => 'externalContactId',
        'conversationId' => 'conversationId',
        'communicationId' => 'communicationId',
        'mediaType' => 'mediaType'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'externalContactId' => 'setExternalContactId',
        'conversationId' => 'setConversationId',
        'communicationId' => 'setCommunicationId',
        'mediaType' => 'setMediaType'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'externalContactId' => 'getExternalContactId',
        'conversationId' => 'getConversationId',
        'communicationId' => 'getCommunicationId',
        'mediaType' => 'getMediaType'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const MEDIA_TYPE_CALL = 'CALL';
    public const MEDIA_TYPE_CALLBACK = 'CALLBACK';
    public const MEDIA_TYPE_CHAT = 'CHAT';
    public const MEDIA_TYPE_COBROWSE = 'COBROWSE';
    public const MEDIA_TYPE_EMAIL = 'EMAIL';
    public const MEDIA_TYPE_MESSAGE = 'MESSAGE';
    public const MEDIA_TYPE_SOCIAL_EXPRESSION = 'SOCIAL_EXPRESSION';
    public const MEDIA_TYPE_VIDEO = 'VIDEO';
    public const MEDIA_TYPE_SCREENSHARE = 'SCREENSHARE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_CALL,
            self::MEDIA_TYPE_CALLBACK,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_COBROWSE,
            self::MEDIA_TYPE_EMAIL,
            self::MEDIA_TYPE_MESSAGE,
            self::MEDIA_TYPE_SOCIAL_EXPRESSION,
            self::MEDIA_TYPE_VIDEO,
            self::MEDIA_TYPE_SCREENSHARE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['externalContactId'] = isset($data['externalContactId']) ? $data['externalContactId'] : null;
        $this->container['conversationId'] = isset($data['conversationId']) ? $data['conversationId'] : null;
        $this->container['communicationId'] = isset($data['communicationId']) ? $data['communicationId'] : null;
        $this->container['mediaType'] = isset($data['mediaType']) ? $data['mediaType'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['conversationId'] === null) {
            $invalid_properties[] = "'conversationId' can't be null";
        }
        if ($this->container['communicationId'] === null) {
            $invalid_properties[] = "'communicationId' can't be null";
        }
        if ($this->container['mediaType'] === null) {
            $invalid_properties[] = "'mediaType' can't be null";
        }
        $allowed_values = array("CALL", "CALLBACK", "CHAT", "COBROWSE", "EMAIL", "MESSAGE", "SOCIAL_EXPRESSION", "VIDEO", "SCREENSHARE");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mediaType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['conversationId'] === null) {
            return false;
        }
        if ($this->container['communicationId'] === null) {
            return false;
        }
        if ($this->container['mediaType'] === null) {
            return false;
        }
        $allowed_values = array("CALL", "CALLBACK", "CHAT", "COBROWSE", "EMAIL", "MESSAGE", "SOCIAL_EXPRESSION", "VIDEO", "SCREENSHARE");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets externalContactId
     * @return string
     */
    public function getExternalContactId()
    {
        return $this->container['externalContactId'];
    }

    /**
     * Sets externalContactId
     * @param string $externalContactId An external contact ID.  If not supplied, implies the conversation should be disassociated with any external contact.
     * @return $this
     */
    public function setExternalContactId($externalContactId)
    {
        $this->container['externalContactId'] = $externalContactId;

        return $this;
    }

    /**
     * Gets conversationId
     * @return string
     */
    public function getConversationId()
    {
        return $this->container['conversationId'];
    }

    /**
     * Sets conversationId
     * @param string $conversationId Conversation ID
     * @return $this
     */
    public function setConversationId($conversationId)
    {
        $this->container['conversationId'] = $conversationId;

        return $this;
    }

    /**
     * Gets communicationId
     * @return string
     */
    public function getCommunicationId()
    {
        return $this->container['communicationId'];
    }

    /**
     * Sets communicationId
     * @param string $communicationId Communication ID
     * @return $this
     */
    public function setCommunicationId($communicationId)
    {
        $this->container['communicationId'] = $communicationId;

        return $this;
    }

    /**
     * Gets mediaType
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['mediaType'];
    }

    /**
     * Sets mediaType
     * @param string $mediaType Media type
     * @return $this
     */
    public function setMediaType($mediaType)
    {
        $allowed_values = array('CALL', 'CALLBACK', 'CHAT', 'COBROWSE', 'EMAIL', 'MESSAGE', 'SOCIAL_EXPRESSION', 'VIDEO', 'SCREENSHARE');
        if (!in_array($mediaType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaType', must be one of 'CALL', 'CALLBACK', 'CHAT', 'COBROWSE', 'EMAIL', 'MESSAGE', 'SOCIAL_EXPRESSION', 'VIDEO', 'SCREENSHARE'");
        }
        $this->container['mediaType'] = $mediaType;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
