<?php

/**
 * ConversationProperties
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ConversationProperties Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationProperties implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationProperties';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'isWaiting' => 'bool',
        'isActive' => 'bool',
        'isAcd' => 'bool',
        'isPreferred' => 'bool',
        'isScreenshare' => 'bool',
        'isCobrowse' => 'bool',
        'isVoicemail' => 'bool',
        'isFlagged' => 'bool',
        'isMonitored' => 'bool',
        'filterWrapUpNotes' => 'bool',
        'matchAll' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'isWaiting' => 'isWaiting',
        'isActive' => 'isActive',
        'isAcd' => 'isAcd',
        'isPreferred' => 'isPreferred',
        'isScreenshare' => 'isScreenshare',
        'isCobrowse' => 'isCobrowse',
        'isVoicemail' => 'isVoicemail',
        'isFlagged' => 'isFlagged',
        'isMonitored' => 'isMonitored',
        'filterWrapUpNotes' => 'filterWrapUpNotes',
        'matchAll' => 'matchAll'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'isWaiting' => 'setIsWaiting',
        'isActive' => 'setIsActive',
        'isAcd' => 'setIsAcd',
        'isPreferred' => 'setIsPreferred',
        'isScreenshare' => 'setIsScreenshare',
        'isCobrowse' => 'setIsCobrowse',
        'isVoicemail' => 'setIsVoicemail',
        'isFlagged' => 'setIsFlagged',
        'isMonitored' => 'setIsMonitored',
        'filterWrapUpNotes' => 'setFilterWrapUpNotes',
        'matchAll' => 'setMatchAll'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'isWaiting' => 'getIsWaiting',
        'isActive' => 'getIsActive',
        'isAcd' => 'getIsAcd',
        'isPreferred' => 'getIsPreferred',
        'isScreenshare' => 'getIsScreenshare',
        'isCobrowse' => 'getIsCobrowse',
        'isVoicemail' => 'getIsVoicemail',
        'isFlagged' => 'getIsFlagged',
        'isMonitored' => 'getIsMonitored',
        'filterWrapUpNotes' => 'getFilterWrapUpNotes',
        'matchAll' => 'getMatchAll'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['isWaiting'] = isset($data['isWaiting']) ? $data['isWaiting'] : null;
        $this->container['isActive'] = isset($data['isActive']) ? $data['isActive'] : null;
        $this->container['isAcd'] = isset($data['isAcd']) ? $data['isAcd'] : null;
        $this->container['isPreferred'] = isset($data['isPreferred']) ? $data['isPreferred'] : null;
        $this->container['isScreenshare'] = isset($data['isScreenshare']) ? $data['isScreenshare'] : null;
        $this->container['isCobrowse'] = isset($data['isCobrowse']) ? $data['isCobrowse'] : null;
        $this->container['isVoicemail'] = isset($data['isVoicemail']) ? $data['isVoicemail'] : null;
        $this->container['isFlagged'] = isset($data['isFlagged']) ? $data['isFlagged'] : null;
        $this->container['isMonitored'] = isset($data['isMonitored']) ? $data['isMonitored'] : null;
        $this->container['filterWrapUpNotes'] = isset($data['filterWrapUpNotes']) ? $data['filterWrapUpNotes'] : null;
        $this->container['matchAll'] = isset($data['matchAll']) ? $data['matchAll'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets isWaiting
     * @return bool
     */
    public function getIsWaiting()
    {
        return $this->container['isWaiting'];
    }

    /**
     * Sets isWaiting
     * @param bool $isWaiting Indicates filtering for waiting
     * @return $this
     */
    public function setIsWaiting($isWaiting)
    {
        $this->container['isWaiting'] = $isWaiting;

        return $this;
    }

    /**
     * Gets isActive
     * @return bool
     */
    public function getIsActive()
    {
        return $this->container['isActive'];
    }

    /**
     * Sets isActive
     * @param bool $isActive Indicates filtering for active
     * @return $this
     */
    public function setIsActive($isActive)
    {
        $this->container['isActive'] = $isActive;

        return $this;
    }

    /**
     * Gets isAcd
     * @return bool
     */
    public function getIsAcd()
    {
        return $this->container['isAcd'];
    }

    /**
     * Sets isAcd
     * @param bool $isAcd Indicates filtering for Acd
     * @return $this
     */
    public function setIsAcd($isAcd)
    {
        $this->container['isAcd'] = $isAcd;

        return $this;
    }

    /**
     * Gets isPreferred
     * @return bool
     */
    public function getIsPreferred()
    {
        return $this->container['isPreferred'];
    }

    /**
     * Sets isPreferred
     * @param bool $isPreferred Indicates filtering for Preferred Agent Routing
     * @return $this
     */
    public function setIsPreferred($isPreferred)
    {
        $this->container['isPreferred'] = $isPreferred;

        return $this;
    }

    /**
     * Gets isScreenshare
     * @return bool
     */
    public function getIsScreenshare()
    {
        return $this->container['isScreenshare'];
    }

    /**
     * Sets isScreenshare
     * @param bool $isScreenshare Indicates filtering for screenshare
     * @return $this
     */
    public function setIsScreenshare($isScreenshare)
    {
        $this->container['isScreenshare'] = $isScreenshare;

        return $this;
    }

    /**
     * Gets isCobrowse
     * @return bool
     */
    public function getIsCobrowse()
    {
        return $this->container['isCobrowse'];
    }

    /**
     * Sets isCobrowse
     * @param bool $isCobrowse Indicates filtering for Cobrowse
     * @return $this
     */
    public function setIsCobrowse($isCobrowse)
    {
        $this->container['isCobrowse'] = $isCobrowse;

        return $this;
    }

    /**
     * Gets isVoicemail
     * @return bool
     */
    public function getIsVoicemail()
    {
        return $this->container['isVoicemail'];
    }

    /**
     * Sets isVoicemail
     * @param bool $isVoicemail Indicates filtering for Voice mail
     * @return $this
     */
    public function setIsVoicemail($isVoicemail)
    {
        $this->container['isVoicemail'] = $isVoicemail;

        return $this;
    }

    /**
     * Gets isFlagged
     * @return bool
     */
    public function getIsFlagged()
    {
        return $this->container['isFlagged'];
    }

    /**
     * Sets isFlagged
     * @param bool $isFlagged Indicates filtering for flagged
     * @return $this
     */
    public function setIsFlagged($isFlagged)
    {
        $this->container['isFlagged'] = $isFlagged;

        return $this;
    }

    /**
     * Gets isMonitored
     * @return bool
     */
    public function getIsMonitored()
    {
        return $this->container['isMonitored'];
    }

    /**
     * Sets isMonitored
     * @param bool $isMonitored Indicates filtering for monitored
     * @return $this
     */
    public function setIsMonitored($isMonitored)
    {
        $this->container['isMonitored'] = $isMonitored;

        return $this;
    }

    /**
     * Gets filterWrapUpNotes
     * @return bool
     */
    public function getFilterWrapUpNotes()
    {
        return $this->container['filterWrapUpNotes'];
    }

    /**
     * Sets filterWrapUpNotes
     * @param bool $filterWrapUpNotes Indicates filtering for WrapUpNotes
     * @return $this
     */
    public function setFilterWrapUpNotes($filterWrapUpNotes)
    {
        $this->container['filterWrapUpNotes'] = $filterWrapUpNotes;

        return $this;
    }

    /**
     * Gets matchAll
     * @return bool
     */
    public function getMatchAll()
    {
        return $this->container['matchAll'];
    }

    /**
     * Sets matchAll
     * @param bool $matchAll Indicates comparison operation, TRUE indicates filters will use AND logic, FALSE indicates OR logic
     * @return $this
     */
    public function setMatchAll($matchAll)
    {
        $this->container['matchAll'] = $matchAll;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
