<?php

/**
 * LexBotAlias
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * LexBotAlias Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class LexBotAlias implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'LexBotAlias';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'bot' => '\PureCloudSDK\LexBot',
        'botVersion' => 'string',
        'status' => 'string',
        'failureReason' => 'string',
        'language' => 'string',
        'intents' => '\PureCloudSDK\LexIntent[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'bot' => 'bot',
        'botVersion' => 'botVersion',
        'status' => 'status',
        'failureReason' => 'failureReason',
        'language' => 'language',
        'intents' => 'intents',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'bot' => 'setBot',
        'botVersion' => 'setBotVersion',
        'status' => 'setStatus',
        'failureReason' => 'setFailureReason',
        'language' => 'setLanguage',
        'intents' => 'setIntents',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'bot' => 'getBot',
        'botVersion' => 'getBotVersion',
        'status' => 'getStatus',
        'failureReason' => 'getFailureReason',
        'language' => 'getLanguage',
        'intents' => 'getIntents',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_BUILDING = 'BUILDING';
    public const STATUS_READY = 'READY';
    public const STATUS_FAILED = 'FAILED';
    public const STATUS_NOT_BUILT = 'NOT_BUILT';
    public const LANGUAGE_US = 'en-US';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_BUILDING,
            self::STATUS_READY,
            self::STATUS_FAILED,
            self::STATUS_NOT_BUILT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getLanguageAllowableValues()
    {
        return [
            self::LANGUAGE_US,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['bot'] = isset($data['bot']) ? $data['bot'] : null;
        $this->container['botVersion'] = isset($data['botVersion']) ? $data['botVersion'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['failureReason'] = isset($data['failureReason']) ? $data['failureReason'] : null;
        $this->container['language'] = isset($data['language']) ? $data['language'] : null;
        $this->container['intents'] = isset($data['intents']) ? $data['intents'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['status'] === null) {
            $invalid_properties[] = "'status' can't be null";
        }
        $allowed_values = array("BUILDING", "READY", "FAILED", "NOT_BUILT");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        $allowed_values = array("en-US");
        if (!in_array($this->container['language'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'language', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['status'] === null) {
            return false;
        }
        $allowed_values = array("BUILDING", "READY", "FAILED", "NOT_BUILT");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("en-US");
        if (!in_array($this->container['language'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets bot
     * @return \PureCloudSDK\LexBot
     */
    public function getBot()
    {
        return $this->container['bot'];
    }

    /**
     * Sets bot
     * @param \PureCloudSDK\LexBot $bot The Lex bot this is an alias for
     * @return $this
     */
    public function setBot($bot)
    {
        $this->container['bot'] = $bot;

        return $this;
    }

    /**
     * Gets botVersion
     * @return string
     */
    public function getBotVersion()
    {
        return $this->container['botVersion'];
    }

    /**
     * Sets botVersion
     * @param string $botVersion The version of the Lex bot this alias points at
     * @return $this
     */
    public function setBotVersion($botVersion)
    {
        $this->container['botVersion'] = $botVersion;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of the Lex bot alias
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('BUILDING', 'READY', 'FAILED', 'NOT_BUILT');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'BUILDING', 'READY', 'FAILED', 'NOT_BUILT'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets failureReason
     * @return string
     */
    public function getFailureReason()
    {
        return $this->container['failureReason'];
    }

    /**
     * Sets failureReason
     * @param string $failureReason If the status is FAILED, Amazon Lex explains why it failed to build the bot
     * @return $this
     */
    public function setFailureReason($failureReason)
    {
        $this->container['failureReason'] = $failureReason;

        return $this;
    }

    /**
     * Gets language
     * @return string
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     * @param string $language The target language of the Lex bot
     * @return $this
     */
    public function setLanguage($language)
    {
        $allowed_values = array('en-US');
        if (!in_array($language, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'language', must be one of 'en-US'");
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets intents
     * @return \PureCloudSDK\LexIntent[]
     */
    public function getIntents()
    {
        return $this->container['intents'];
    }

    /**
     * Sets intents
     * @param \PureCloudSDK\LexIntent[] $intents An array of Intents associated with this bot alias
     * @return $this
     */
    public function setIntents($intents)
    {
        $this->container['intents'] = $intents;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
