<?php
/**
 * ConversationNotificationCalls
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ConversationNotificationCalls Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationNotificationCalls implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationNotification_calls';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'state' => 'string',
        'recording' => 'bool',
        'recordingState' => 'string',
        'muted' => 'bool',
        'confined' => 'bool',
        'held' => 'bool',
        'errorInfo' => '\PureCloudSDK\ConversationNotificationErrorInfo',
        'disconnectType' => 'string',
        'startHoldTime' => '\DateTime',
        'direction' => 'string',
        'documentId' => 'string',
        'self' => '\PureCloudSDK\ConversationNotificationSelf',
        'other' => '\PureCloudSDK\ConversationNotificationAddress',
        'provider' => 'string',
        'connectedTime' => '\DateTime',
        'disconnectedTime' => '\DateTime',
        'disconnectReasons' => '\PureCloudSDK\ConversationNotificationDisconnectReasons[]',
        'faxStatus' => '\PureCloudSDK\ConversationNotificationFaxStatus',
        'additionalProperties' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'state' => 'state',
        'recording' => 'recording',
        'recordingState' => 'recordingState',
        'muted' => 'muted',
        'confined' => 'confined',
        'held' => 'held',
        'errorInfo' => 'errorInfo',
        'disconnectType' => 'disconnectType',
        'startHoldTime' => 'startHoldTime',
        'direction' => 'direction',
        'documentId' => 'documentId',
        'self' => 'self',
        'other' => 'other',
        'provider' => 'provider',
        'connectedTime' => 'connectedTime',
        'disconnectedTime' => 'disconnectedTime',
        'disconnectReasons' => 'disconnectReasons',
        'faxStatus' => 'faxStatus',
        'additionalProperties' => 'additionalProperties'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'state' => 'setState',
        'recording' => 'setRecording',
        'recordingState' => 'setRecordingState',
        'muted' => 'setMuted',
        'confined' => 'setConfined',
        'held' => 'setHeld',
        'errorInfo' => 'setErrorInfo',
        'disconnectType' => 'setDisconnectType',
        'startHoldTime' => 'setStartHoldTime',
        'direction' => 'setDirection',
        'documentId' => 'setDocumentId',
        'self' => 'setSelf',
        'other' => 'setOther',
        'provider' => 'setProvider',
        'connectedTime' => 'setConnectedTime',
        'disconnectedTime' => 'setDisconnectedTime',
        'disconnectReasons' => 'setDisconnectReasons',
        'faxStatus' => 'setFaxStatus',
        'additionalProperties' => 'setAdditionalProperties'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'state' => 'getState',
        'recording' => 'getRecording',
        'recordingState' => 'getRecordingState',
        'muted' => 'getMuted',
        'confined' => 'getConfined',
        'held' => 'getHeld',
        'errorInfo' => 'getErrorInfo',
        'disconnectType' => 'getDisconnectType',
        'startHoldTime' => 'getStartHoldTime',
        'direction' => 'getDirection',
        'documentId' => 'getDocumentId',
        'self' => 'getSelf',
        'other' => 'getOther',
        'provider' => 'getProvider',
        'connectedTime' => 'getConnectedTime',
        'disconnectedTime' => 'getDisconnectedTime',
        'disconnectReasons' => 'getDisconnectReasons',
        'faxStatus' => 'getFaxStatus',
        'additionalProperties' => 'getAdditionalProperties'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'alerting';
    const STATE_DIALING = 'dialing';
    const STATE_CONTACTING = 'contacting';
    const STATE_OFFERING = 'offering';
    const STATE_CONNECTED = 'connected';
    const STATE_DISCONNECTED = 'disconnected';
    const STATE_TERMINATED = 'terminated';
    const STATE_UPLOADING = 'uploading';
    const STATE_CONVERTING = 'converting';
    const STATE_TRANSMITTING = 'transmitting';
    const STATE_NONE = 'NONE';
    const RECORDING_STATE_NONE = 'NONE';
    const RECORDING_STATE_ACTIVE = 'ACTIVE';
    const RECORDING_STATE_PAUSED = 'PAUSED';
    const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    const DISCONNECT_TYPE_CLIENT = 'client';
    const DISCONNECT_TYPE_SYSTEM = 'system';
    const DISCONNECT_TYPE_TIMEOUT = 'timeout';
    const DISCONNECT_TYPE_TRANSFER = 'transfer';
    const DISCONNECT_TYPE_TRANSFER_CONFERENCE = 'transfer_conference';
    const DISCONNECT_TYPE_TRANSFER_CONSULT = 'transfer_consult';
    const DISCONNECT_TYPE_TRANSFER_FORWARD = 'transfer_forward';
    const DISCONNECT_TYPE_TRANSFER_NOANSWER = 'transfer_noanswer';
    const DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE = 'transfer_notavailable';
    const DISCONNECT_TYPE_TRANSPORT_FAILURE = 'transport_failure';
    const DISCONNECT_TYPE_ERROR = 'error';
    const DISCONNECT_TYPE_PEER = 'peer';
    const DISCONNECT_TYPE_OTHER = 'other';
    const DISCONNECT_TYPE_SPAM = 'spam';
    const DIRECTION_OUTBOUND = 'outbound';
    const DIRECTION_INBOUND = 'inbound';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_UPLOADING,
            self::STATE_CONVERTING,
            self::STATE_TRANSMITTING,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRecordingStateAllowableValues()
    {
        return [
            self::RECORDING_STATE_NONE,
            self::RECORDING_STATE_ACTIVE,
            self::RECORDING_STATE_PAUSED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TIMEOUT,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFER_CONFERENCE,
            self::DISCONNECT_TYPE_TRANSFER_CONSULT,
            self::DISCONNECT_TYPE_TRANSFER_FORWARD,
            self::DISCONNECT_TYPE_TRANSFER_NOANSWER,
            self::DISCONNECT_TYPE_TRANSFER_NOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORT_FAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_OUTBOUND,
            self::DIRECTION_INBOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['recording'] = isset($data['recording']) ? $data['recording'] : null;
        $this->container['recordingState'] = isset($data['recordingState']) ? $data['recordingState'] : null;
        $this->container['muted'] = isset($data['muted']) ? $data['muted'] : null;
        $this->container['confined'] = isset($data['confined']) ? $data['confined'] : null;
        $this->container['held'] = isset($data['held']) ? $data['held'] : null;
        $this->container['errorInfo'] = isset($data['errorInfo']) ? $data['errorInfo'] : null;
        $this->container['disconnectType'] = isset($data['disconnectType']) ? $data['disconnectType'] : null;
        $this->container['startHoldTime'] = isset($data['startHoldTime']) ? $data['startHoldTime'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['documentId'] = isset($data['documentId']) ? $data['documentId'] : null;
        $this->container['self'] = isset($data['self']) ? $data['self'] : null;
        $this->container['other'] = isset($data['other']) ? $data['other'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['connectedTime'] = isset($data['connectedTime']) ? $data['connectedTime'] : null;
        $this->container['disconnectedTime'] = isset($data['disconnectedTime']) ? $data['disconnectedTime'] : null;
        $this->container['disconnectReasons'] = isset($data['disconnectReasons']) ? $data['disconnectReasons'] : null;
        $this->container['faxStatus'] = isset($data['faxStatus']) ? $data['faxStatus'] : null;
        $this->container['additionalProperties'] = isset($data['additionalProperties']) ? $data['additionalProperties'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "uploading", "converting", "transmitting", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("NONE", "ACTIVE", "PAUSED");
        if (!in_array($this->container['recordingState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'recordingState', must be one of #{allowed_values}.";
        }

        $allowed_values = array("endpoint", "client", "system", "timeout", "transfer", "transfer_conference", "transfer_consult", "transfer_forward", "transfer_noanswer", "transfer_notavailable", "transport_failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnectType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("outbound", "inbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "uploading", "converting", "transmitting", "NONE");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("NONE", "ACTIVE", "PAUSED");
        if (!in_array($this->container['recordingState'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("endpoint", "client", "system", "timeout", "transfer", "transfer_conference", "transfer_consult", "transfer_forward", "transfer_noanswer", "transfer_notavailable", "transport_failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("outbound", "inbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'uploading', 'converting', 'transmitting', 'NONE');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'uploading', 'converting', 'transmitting', 'NONE'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets recording
     * @return bool
     */
    public function getRecording()
    {
        return $this->container['recording'];
    }

    /**
     * Sets recording
     * @param bool $recording
     * @return $this
     */
    public function setRecording($recording)
    {
        $this->container['recording'] = $recording;

        return $this;
    }

    /**
     * Gets recordingState
     * @return string
     */
    public function getRecordingState()
    {
        return $this->container['recordingState'];
    }

    /**
     * Sets recordingState
     * @param string $recordingState
     * @return $this
     */
    public function setRecordingState($recordingState)
    {
        $allowed_values = array('NONE', 'ACTIVE', 'PAUSED');
        if (!in_array($recordingState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'recordingState', must be one of 'NONE', 'ACTIVE', 'PAUSED'");
        }
        $this->container['recordingState'] = $recordingState;

        return $this;
    }

    /**
     * Gets muted
     * @return bool
     */
    public function getMuted()
    {
        return $this->container['muted'];
    }

    /**
     * Sets muted
     * @param bool $muted
     * @return $this
     */
    public function setMuted($muted)
    {
        $this->container['muted'] = $muted;

        return $this;
    }

    /**
     * Gets confined
     * @return bool
     */
    public function getConfined()
    {
        return $this->container['confined'];
    }

    /**
     * Sets confined
     * @param bool $confined
     * @return $this
     */
    public function setConfined($confined)
    {
        $this->container['confined'] = $confined;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets errorInfo
     * @return \PureCloudSDK\ConversationNotificationErrorInfo
     */
    public function getErrorInfo()
    {
        return $this->container['errorInfo'];
    }

    /**
     * Sets errorInfo
     * @param \PureCloudSDK\ConversationNotificationErrorInfo $errorInfo
     * @return $this
     */
    public function setErrorInfo($errorInfo)
    {
        $this->container['errorInfo'] = $errorInfo;

        return $this;
    }

    /**
     * Gets disconnectType
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnectType'];
    }

    /**
     * Sets disconnectType
     * @param string $disconnectType
     * @return $this
     */
    public function setDisconnectType($disconnectType)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'timeout', 'transfer', 'transfer_conference', 'transfer_consult', 'transfer_forward', 'transfer_noanswer', 'transfer_notavailable', 'transport_failure', 'error', 'peer', 'other', 'spam');
        if (!in_array($disconnectType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnectType', must be one of 'endpoint', 'client', 'system', 'timeout', 'transfer', 'transfer_conference', 'transfer_consult', 'transfer_forward', 'transfer_noanswer', 'transfer_notavailable', 'transport_failure', 'error', 'peer', 'other', 'spam'");
        }
        $this->container['disconnectType'] = $disconnectType;

        return $this;
    }

    /**
     * Gets startHoldTime
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['startHoldTime'];
    }

    /**
     * Sets startHoldTime
     * @param \DateTime $startHoldTime
     * @return $this
     */
    public function setStartHoldTime($startHoldTime)
    {
        $this->container['startHoldTime'] = $startHoldTime;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('outbound', 'inbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'outbound', 'inbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets documentId
     * @return string
     */
    public function getDocumentId()
    {
        return $this->container['documentId'];
    }

    /**
     * Sets documentId
     * @param string $documentId
     * @return $this
     */
    public function setDocumentId($documentId)
    {
        $this->container['documentId'] = $documentId;

        return $this;
    }

    /**
     * Gets self
     * @return \PureCloudSDK\ConversationNotificationSelf
     */
    public function getSelf()
    {
        return $this->container['self'];
    }

    /**
     * Sets self
     * @param \PureCloudSDK\ConversationNotificationSelf $self
     * @return $this
     */
    public function setSelf($self)
    {
        $this->container['self'] = $self;

        return $this;
    }

    /**
     * Gets other
     * @return \PureCloudSDK\ConversationNotificationAddress
     */
    public function getOther()
    {
        return $this->container['other'];
    }

    /**
     * Sets other
     * @param \PureCloudSDK\ConversationNotificationAddress $other
     * @return $this
     */
    public function setOther($other)
    {
        $this->container['other'] = $other;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets connectedTime
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connectedTime'];
    }

    /**
     * Sets connectedTime
     * @param \DateTime $connectedTime
     * @return $this
     */
    public function setConnectedTime($connectedTime)
    {
        $this->container['connectedTime'] = $connectedTime;

        return $this;
    }

    /**
     * Gets disconnectedTime
     * @return \DateTime
     */
    public function getDisconnectedTime()
    {
        return $this->container['disconnectedTime'];
    }

    /**
     * Sets disconnectedTime
     * @param \DateTime $disconnectedTime
     * @return $this
     */
    public function setDisconnectedTime($disconnectedTime)
    {
        $this->container['disconnectedTime'] = $disconnectedTime;

        return $this;
    }

    /**
     * Gets disconnectReasons
     * @return \PureCloudSDK\ConversationNotificationDisconnectReasons[]
     */
    public function getDisconnectReasons()
    {
        return $this->container['disconnectReasons'];
    }

    /**
     * Sets disconnectReasons
     * @param \PureCloudSDK\ConversationNotificationDisconnectReasons[] $disconnectReasons
     * @return $this
     */
    public function setDisconnectReasons($disconnectReasons)
    {
        $this->container['disconnectReasons'] = $disconnectReasons;

        return $this;
    }

    /**
     * Gets faxStatus
     * @return \PureCloudSDK\ConversationNotificationFaxStatus
     */
    public function getFaxStatus()
    {
        return $this->container['faxStatus'];
    }

    /**
     * Sets faxStatus
     * @param \PureCloudSDK\ConversationNotificationFaxStatus $faxStatus
     * @return $this
     */
    public function setFaxStatus($faxStatus)
    {
        $this->container['faxStatus'] = $faxStatus;

        return $this;
    }

    /**
     * Gets additionalProperties
     * @return object
     */
    public function getAdditionalProperties()
    {
        return $this->container['additionalProperties'];
    }

    /**
     * Sets additionalProperties
     * @param object $additionalProperties
     * @return $this
     */
    public function setAdditionalProperties($additionalProperties)
    {
        $this->container['additionalProperties'] = $additionalProperties;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


