# PureCloudSDK\ContentManagementApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteDocumentsDocumentId**](ContentManagementApi.md#deleteDocumentsDocumentId) | **DELETE** /api/v2/contentmanagement/documents/{documentId} | Delete a document.
[**deleteSharesShareId**](ContentManagementApi.md#deleteSharesShareId) | **DELETE** /api/v2/contentmanagement/shares/{shareId} | Deletes an existing share.
[**deleteStatusStatusId**](ContentManagementApi.md#deleteStatusStatusId) | **DELETE** /api/v2/contentmanagement/status/{statusId} | Cancel the command for this status
[**deleteWorkspacesWorkspaceId**](ContentManagementApi.md#deleteWorkspacesWorkspaceId) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId} | Delete a workspace
[**deleteWorkspacesWorkspaceIdMembersMemberId**](ContentManagementApi.md#deleteWorkspacesWorkspaceIdMembersMemberId) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Delete a member from a workspace
[**deleteWorkspacesWorkspaceIdTagvaluesTagId**](ContentManagementApi.md#deleteWorkspacesWorkspaceIdTagvaluesTagId) | **DELETE** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Delete workspace tag
[**getDocuments**](ContentManagementApi.md#getDocuments) | **GET** /api/v2/contentmanagement/documents | Get a list of documents.
[**getDocumentsDocumentId**](ContentManagementApi.md#getDocumentsDocumentId) | **GET** /api/v2/contentmanagement/documents/{documentId} | Get a document.
[**getDocumentsDocumentIdAudits**](ContentManagementApi.md#getDocumentsDocumentIdAudits) | **GET** /api/v2/contentmanagement/documents/{documentId}/audits | Get a list of audits for a document.
[**getDocumentsDocumentIdContent**](ContentManagementApi.md#getDocumentsDocumentIdContent) | **GET** /api/v2/contentmanagement/documents/{documentId}/content | Download a document.
[**getQuery**](ContentManagementApi.md#getQuery) | **GET** /api/v2/contentmanagement/query | Query content
[**getSecurityprofiles**](ContentManagementApi.md#getSecurityprofiles) | **GET** /api/v2/contentmanagement/securityprofiles | Get a List of Security Profiles
[**getSecurityprofilesSecurityprofileId**](ContentManagementApi.md#getSecurityprofilesSecurityprofileId) | **GET** /api/v2/contentmanagement/securityprofiles/{securityProfileId} | Get a Security Profile
[**getSharedSharedId**](ContentManagementApi.md#getSharedSharedId) | **GET** /api/v2/contentmanagement/shared/{sharedId} | Get shared documents. Securely download a shared document.
[**getShares**](ContentManagementApi.md#getShares) | **GET** /api/v2/contentmanagement/shares | Gets a list of shares.  You must specify at least one filter (e.g. entityId).
[**getSharesShareId**](ContentManagementApi.md#getSharesShareId) | **GET** /api/v2/contentmanagement/shares/{shareId} | Retrieve details about an existing share.
[**getStatus**](ContentManagementApi.md#getStatus) | **GET** /api/v2/contentmanagement/status | Get a list of statuses for pending operations
[**getStatusStatusId**](ContentManagementApi.md#getStatusStatusId) | **GET** /api/v2/contentmanagement/status/{statusId} | Get a status.
[**getUsage**](ContentManagementApi.md#getUsage) | **GET** /api/v2/contentmanagement/usage | Get usage details.
[**getWorkspaces**](ContentManagementApi.md#getWorkspaces) | **GET** /api/v2/contentmanagement/workspaces | Get a list of workspaces.
[**getWorkspacesWorkspaceId**](ContentManagementApi.md#getWorkspacesWorkspaceId) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId} | Get a workspace.
[**getWorkspacesWorkspaceIdMembers**](ContentManagementApi.md#getWorkspacesWorkspaceIdMembers) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members | Get a list workspace members
[**getWorkspacesWorkspaceIdMembersMemberId**](ContentManagementApi.md#getWorkspacesWorkspaceIdMembersMemberId) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Get a workspace member
[**getWorkspacesWorkspaceIdTagvalues**](ContentManagementApi.md#getWorkspacesWorkspaceIdTagvalues) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Get a list of workspace tags
[**getWorkspacesWorkspaceIdTagvaluesTagId**](ContentManagementApi.md#getWorkspacesWorkspaceIdTagvaluesTagId) | **GET** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Get a workspace tag
[**postAuditquery**](ContentManagementApi.md#postAuditquery) | **POST** /api/v2/contentmanagement/auditquery | Query audits
[**postDocuments**](ContentManagementApi.md#postDocuments) | **POST** /api/v2/contentmanagement/documents | Add a document.
[**postDocumentsDocumentId**](ContentManagementApi.md#postDocumentsDocumentId) | **POST** /api/v2/contentmanagement/documents/{documentId} | Update a document.
[**postDocumentsDocumentIdContent**](ContentManagementApi.md#postDocumentsDocumentIdContent) | **POST** /api/v2/contentmanagement/documents/{documentId}/content | Replace the contents of a document.
[**postQuery**](ContentManagementApi.md#postQuery) | **POST** /api/v2/contentmanagement/query | Query content
[**postShares**](ContentManagementApi.md#postShares) | **POST** /api/v2/contentmanagement/shares | Creates a new share or updates an existing share if the entity has already been shared
[**postWorkspaces**](ContentManagementApi.md#postWorkspaces) | **POST** /api/v2/contentmanagement/workspaces | Create a group workspace
[**postWorkspacesWorkspaceIdTagvalues**](ContentManagementApi.md#postWorkspacesWorkspaceIdTagvalues) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues | Create a workspace tag
[**postWorkspacesWorkspaceIdTagvaluesQuery**](ContentManagementApi.md#postWorkspacesWorkspaceIdTagvaluesQuery) | **POST** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/query | Perform a prefix query on tags in the workspace
[**putWorkspacesWorkspaceId**](ContentManagementApi.md#putWorkspacesWorkspaceId) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId} | Update a workspace
[**putWorkspacesWorkspaceIdMembersMemberId**](ContentManagementApi.md#putWorkspacesWorkspaceIdMembersMemberId) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId} | Add a member to a workspace
[**putWorkspacesWorkspaceIdTagvaluesTagId**](ContentManagementApi.md#putWorkspacesWorkspaceIdTagvaluesTagId) | **PUT** /api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId} | Update a workspace tag. Will update all documents with the new tag value.


# **deleteDocumentsDocumentId**
> deleteDocumentsDocumentId($documentId, $override)

Delete a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$override = true; // bool | Override any lock on the document

try {
    $api_instance->deleteDocumentsDocumentId($documentId, $override);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **override** | **bool**| Override any lock on the document | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteSharesShareId**
> deleteSharesShareId($shareId)

Deletes an existing share.

This revokes sharing rights specified in the share record

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$shareId = "shareId_example"; // string | Share ID

try {
    $api_instance->deleteSharesShareId($shareId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteSharesShareId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **shareId** | **string**| Share ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteStatusStatusId**
> deleteStatusStatusId($statusId)

Cancel the command for this status



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$statusId = "statusId_example"; // string | Status ID

try {
    $api_instance->deleteStatusStatusId($statusId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteStatusStatusId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **statusId** | **string**| Status ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteWorkspacesWorkspaceId**
> deleteWorkspacesWorkspaceId($workspaceId, $moveChildrenToWorkspaceId)

Delete a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$moveChildrenToWorkspaceId = "moveChildrenToWorkspaceId_example"; // string | New location for objects in deleted workspace.

try {
    $api_instance->deleteWorkspacesWorkspaceId($workspaceId, $moveChildrenToWorkspaceId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteWorkspacesWorkspaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **moveChildrenToWorkspaceId** | **string**| New location for objects in deleted workspace. | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteWorkspacesWorkspaceIdMembersMemberId**
> deleteWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId)

Delete a member from a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$memberId = "memberId_example"; // string | Member ID

try {
    $api_instance->deleteWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteWorkspacesWorkspaceIdMembersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **memberId** | **string**| Member ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteWorkspacesWorkspaceIdTagvaluesTagId**
> deleteWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId)

Delete workspace tag

Delete a tag from a workspace. Will remove this tag from all documents.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$tagId = "tagId_example"; // string | Tag ID

try {
    $api_instance->deleteWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->deleteWorkspacesWorkspaceIdTagvaluesTagId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **tagId** | **string**| Tag ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocuments**
> \PureCloudSDK\DocumentEntityListing getDocuments($workspaceId, $name, $expand, $pageSize, $pageNumber, $sortBy, $sortOrder)

Get a list of documents.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$name = "name_example"; // string | Name
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "sortBy_example"; // string | name or dateCreated
$sortOrder = "ascending"; // string | ascending or descending

try {
    $result = $api_instance->getDocuments($workspaceId, $name, $expand, $pageSize, $pageNumber, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getDocuments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **name** | **string**| Name | [optional]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| name or dateCreated | [optional]
 **sortOrder** | **string**| ascending or descending | [optional] [default to ascending]

### Return type

[**\PureCloudSDK\DocumentEntityListing**](../Model/DocumentEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocumentsDocumentId**
> \PureCloudSDK\Document getDocumentsDocumentId($documentId, $expand)

Get a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getDocumentsDocumentId($documentId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\Document**](../Model/Document.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocumentsDocumentIdAudits**
> \PureCloudSDK\DocumentAuditEntityListing getDocumentsDocumentIdAudits($documentId, $pageSize, $pageNumber, $transactionFilter, $level, $sortBy, $sortOrder)

Get a list of audits for a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$transactionFilter = "transactionFilter_example"; // string | Transaction filter
$level = "user"; // string | level
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "ascending"; // string | Sort order

try {
    $result = $api_instance->getDocumentsDocumentIdAudits($documentId, $pageSize, $pageNumber, $transactionFilter, $level, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getDocumentsDocumentIdAudits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **transactionFilter** | **string**| Transaction filter | [optional]
 **level** | **string**| level | [optional] [default to user]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to ascending]

### Return type

[**\PureCloudSDK\DocumentAuditEntityListing**](../Model/DocumentAuditEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDocumentsDocumentIdContent**
> \PureCloudSDK\DownloadResponse getDocumentsDocumentIdContent($documentId, $disposition, $contentType)

Download a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$disposition = "disposition_example"; // string | Request how the content will be downloaded: a file attachment or inline. Default is attachment.
$contentType = "contentType_example"; // string | The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav

try {
    $result = $api_instance->getDocumentsDocumentIdContent($documentId, $disposition, $contentType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getDocumentsDocumentIdContent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **disposition** | **string**| Request how the content will be downloaded: a file attachment or inline. Default is attachment. | [optional]
 **contentType** | **string**| The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav | [optional]

### Return type

[**\PureCloudSDK\DownloadResponse**](../Model/DownloadResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getQuery**
> \PureCloudSDK\QueryResults getQuery($queryPhrase, $pageSize, $pageNumber, $sortBy, $sortOrder, $expand)

Query content



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$queryPhrase = "queryPhrase_example"; // string | Phrase tokens are ANDed together over all searchable fields
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "name"; // string | name or dateCreated
$sortOrder = "ascending"; // string | ascending or descending
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getQuery($queryPhrase, $pageSize, $pageNumber, $sortBy, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queryPhrase** | **string**| Phrase tokens are ANDed together over all searchable fields |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| name or dateCreated | [optional] [default to name]
 **sortOrder** | **string**| ascending or descending | [optional] [default to ascending]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\QueryResults**](../Model/QueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSecurityprofiles**
> \PureCloudSDK\SecurityProfileEntityListing getSecurityprofiles()

Get a List of Security Profiles



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();

try {
    $result = $api_instance->getSecurityprofiles();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getSecurityprofiles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\SecurityProfileEntityListing**](../Model/SecurityProfileEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSecurityprofilesSecurityprofileId**
> \PureCloudSDK\SecurityProfile getSecurityprofilesSecurityprofileId($securityProfileId)

Get a Security Profile



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$securityProfileId = "securityProfileId_example"; // string | Security Profile Id

try {
    $result = $api_instance->getSecurityprofilesSecurityprofileId($securityProfileId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getSecurityprofilesSecurityprofileId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **securityProfileId** | **string**| Security Profile Id |

### Return type

[**\PureCloudSDK\SecurityProfile**](../Model/SecurityProfile.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSharedSharedId**
> getSharedSharedId($sharedId, $redirect, $disposition, $contentType, $expand)

Get shared documents. Securely download a shared document.

This method requires the download sharing URI obtained in the get document response (downloadSharingUri). Documents may be shared between users in the same workspace. Documents may also be shared between any user by creating a content management share.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$sharedId = "sharedId_example"; // string | Shared ID
$redirect = true; // bool | Turn on or off redirect
$disposition = "attachment"; // string | Request how the share content will be downloaded: attached as a file or inline. Default is attachment.
$contentType = "contentType_example"; // string | The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav
$expand = "expand_example"; // string | Expand some document fields

try {
    $api_instance->getSharedSharedId($sharedId, $redirect, $disposition, $contentType, $expand);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getSharedSharedId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sharedId** | **string**| Shared ID |
 **redirect** | **bool**| Turn on or off redirect | [optional] [default to true]
 **disposition** | **string**| Request how the share content will be downloaded: attached as a file or inline. Default is attachment. | [optional] [default to attachment]
 **contentType** | **string**| The requested format for the specified document. If supported, the document will be returned in that format. Example contentType&#x3D;audio/wav | [optional]
 **expand** | **string**| Expand some document fields | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getShares**
> \PureCloudSDK\ShareEntityListing getShares($entityId, $expand, $pageSize, $pageNumber)

Gets a list of shares.  You must specify at least one filter (e.g. entityId).

Failing to specify a filter will return 400.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$entityId = "entityId_example"; // string | Filters the shares returned to only the entity specified by the value of this parameter.
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getShares($entityId, $expand, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getShares: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **entityId** | **string**| Filters the shares returned to only the entity specified by the value of this parameter. | [optional]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\ShareEntityListing**](../Model/ShareEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSharesShareId**
> \PureCloudSDK\Share getSharesShareId($shareId, $expand)

Retrieve details about an existing share.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$shareId = "shareId_example"; // string | Share ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getSharesShareId($shareId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getSharesShareId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **shareId** | **string**| Share ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\Share**](../Model/Share.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStatus**
> \PureCloudSDK\CommandStatusEntityListing getStatus($pageSize, $pageNumber)

Get a list of statuses for pending operations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getStatus($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getStatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\CommandStatusEntityListing**](../Model/CommandStatusEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStatusStatusId**
> \PureCloudSDK\CommandStatus getStatusStatusId($statusId)

Get a status.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$statusId = "statusId_example"; // string | Status ID

try {
    $result = $api_instance->getStatusStatusId($statusId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getStatusStatusId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **statusId** | **string**| Status ID |

### Return type

[**\PureCloudSDK\CommandStatus**](../Model/CommandStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsage**
> \PureCloudSDK\Usage getUsage()

Get usage details.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();

try {
    $result = $api_instance->getUsage();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getUsage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\Usage**](../Model/Usage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspaces**
> \PureCloudSDK\WorkspaceEntityListing getWorkspaces($pageSize, $pageNumber, $access, $expand)

Get a list of workspaces.

Specifying 'content' access will return all workspaces the user has document access to, while 'admin' access will return all group workspaces the user has administrative rights to.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$access = array("access_example"); // string[] | Requested access level.
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspaces($pageSize, $pageNumber, $access, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **access** | [**string[]**](../Model/string.md)| Requested access level. | [optional]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\WorkspaceEntityListing**](../Model/WorkspaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceId**
> \PureCloudSDK\Workspace getWorkspacesWorkspaceId($workspaceId, $expand)

Get a workspace.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceId($workspaceId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\Workspace**](../Model/Workspace.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceIdMembers**
> \PureCloudSDK\WorkspaceMemberEntityListing getWorkspacesWorkspaceIdMembers($workspaceId, $pageSize, $pageNumber, $expand)

Get a list workspace members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceIdMembers($workspaceId, $pageSize, $pageNumber, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceIdMembers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\WorkspaceMemberEntityListing**](../Model/WorkspaceMemberEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceIdMembersMemberId**
> \PureCloudSDK\WorkspaceMember getWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId, $expand)

Get a workspace member



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$memberId = "memberId_example"; // string | Member ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceIdMembersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **memberId** | **string**| Member ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\WorkspaceMember**](../Model/WorkspaceMember.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceIdTagvalues**
> \PureCloudSDK\TagValueEntityListing getWorkspacesWorkspaceIdTagvalues($workspaceId, $value, $pageSize, $pageNumber, $expand)

Get a list of workspace tags



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$value = "value_example"; // string | filter the list of tags returned
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceIdTagvalues($workspaceId, $value, $pageSize, $pageNumber, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceIdTagvalues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **value** | **string**| filter the list of tags returned | [optional]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\TagValueEntityListing**](../Model/TagValueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWorkspacesWorkspaceIdTagvaluesTagId**
> \PureCloudSDK\TagValue getWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId, $expand)

Get a workspace tag



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$tagId = "tagId_example"; // string | Tag ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->getWorkspacesWorkspaceIdTagvaluesTagId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **tagId** | **string**| Tag ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\TagValue**](../Model/TagValue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAuditquery**
> \PureCloudSDK\QueryResults postAuditquery($body)

Query audits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\ContentQueryRequest(); // \PureCloudSDK\ContentQueryRequest | Allows for a filtered query returning facet information

try {
    $result = $api_instance->postAuditquery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postAuditquery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ContentQueryRequest**](../Model/\PureCloudSDK\ContentQueryRequest.md)| Allows for a filtered query returning facet information |

### Return type

[**\PureCloudSDK\QueryResults**](../Model/QueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDocuments**
> \PureCloudSDK\Document postDocuments($body, $copySource, $moveSource, $override)

Add a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\DocumentUpload(); // \PureCloudSDK\DocumentUpload | Document
$copySource = "copySource_example"; // string | Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source.
$moveSource = "moveSource_example"; // string | Move a document to a new workspace. Provide a document ID as the move source.
$override = true; // bool | Override any lock on the source document

try {
    $result = $api_instance->postDocuments($body, $copySource, $moveSource, $override);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postDocuments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DocumentUpload**](../Model/\PureCloudSDK\DocumentUpload.md)| Document |
 **copySource** | **string**| Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source. | [optional]
 **moveSource** | **string**| Move a document to a new workspace. Provide a document ID as the move source. | [optional]
 **override** | **bool**| Override any lock on the source document | [optional]

### Return type

[**\PureCloudSDK\Document**](../Model/Document.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDocumentsDocumentId**
> \PureCloudSDK\Document postDocumentsDocumentId($documentId, $body, $expand, $override)

Update a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$body = new \PureCloudSDK\DocumentUpdate(); // \PureCloudSDK\DocumentUpdate | Document
$expand = "expand_example"; // string | Expand some document fields
$override = true; // bool | Override any lock on the document

try {
    $result = $api_instance->postDocumentsDocumentId($documentId, $body, $expand, $override);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **body** | [**\PureCloudSDK\DocumentUpdate**](../Model/\PureCloudSDK\DocumentUpdate.md)| Document |
 **expand** | **string**| Expand some document fields | [optional]
 **override** | **bool**| Override any lock on the document | [optional]

### Return type

[**\PureCloudSDK\Document**](../Model/Document.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDocumentsDocumentIdContent**
> \PureCloudSDK\ReplaceResponse postDocumentsDocumentIdContent($documentId, $body, $override)

Replace the contents of a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$documentId = "documentId_example"; // string | Document ID
$body = new \PureCloudSDK\ReplaceRequest(); // \PureCloudSDK\ReplaceRequest | Replace Request
$override = true; // bool | Override any lock on the document

try {
    $result = $api_instance->postDocumentsDocumentIdContent($documentId, $body, $override);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postDocumentsDocumentIdContent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **body** | [**\PureCloudSDK\ReplaceRequest**](../Model/\PureCloudSDK\ReplaceRequest.md)| Replace Request |
 **override** | **bool**| Override any lock on the document | [optional]

### Return type

[**\PureCloudSDK\ReplaceResponse**](../Model/ReplaceResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postQuery**
> \PureCloudSDK\QueryResults postQuery($body, $expand)

Query content



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\QueryRequest(); // \PureCloudSDK\QueryRequest | Allows for a filtered query returning facet information
$expand = "expand_example"; // string | Expand some document fields

try {
    $result = $api_instance->postQuery($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\QueryRequest**](../Model/\PureCloudSDK\QueryRequest.md)| Allows for a filtered query returning facet information |
 **expand** | **string**| Expand some document fields | [optional]

### Return type

[**\PureCloudSDK\QueryResults**](../Model/QueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postShares**
> \PureCloudSDK\CreateShareResponse postShares($body)

Creates a new share or updates an existing share if the entity has already been shared



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\CreateShareRequest(); // \PureCloudSDK\CreateShareRequest | CreateShareRequest - entity id and type and a single member or list of members are required

try {
    $result = $api_instance->postShares($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postShares: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateShareRequest**](../Model/\PureCloudSDK\CreateShareRequest.md)| CreateShareRequest - entity id and type and a single member or list of members are required |

### Return type

[**\PureCloudSDK\CreateShareResponse**](../Model/CreateShareResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postWorkspaces**
> \PureCloudSDK\Workspace postWorkspaces($body)

Create a group workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$body = new \PureCloudSDK\WorkspaceCreate(); // \PureCloudSDK\WorkspaceCreate | Workspace

try {
    $result = $api_instance->postWorkspaces($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postWorkspaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\WorkspaceCreate**](../Model/\PureCloudSDK\WorkspaceCreate.md)| Workspace |

### Return type

[**\PureCloudSDK\Workspace**](../Model/Workspace.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postWorkspacesWorkspaceIdTagvalues**
> \PureCloudSDK\TagValue postWorkspacesWorkspaceIdTagvalues($workspaceId, $body)

Create a workspace tag



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$body = new \PureCloudSDK\TagValue(); // \PureCloudSDK\TagValue | tag

try {
    $result = $api_instance->postWorkspacesWorkspaceIdTagvalues($workspaceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postWorkspacesWorkspaceIdTagvalues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **body** | [**\PureCloudSDK\TagValue**](../Model/\PureCloudSDK\TagValue.md)| tag |

### Return type

[**\PureCloudSDK\TagValue**](../Model/TagValue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postWorkspacesWorkspaceIdTagvaluesQuery**
> \PureCloudSDK\TagValueEntityListing postWorkspacesWorkspaceIdTagvaluesQuery($workspaceId, $body, $expand)

Perform a prefix query on tags in the workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$body = new \PureCloudSDK\TagQueryRequest(); // \PureCloudSDK\TagQueryRequest | query
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->postWorkspacesWorkspaceIdTagvaluesQuery($workspaceId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->postWorkspacesWorkspaceIdTagvaluesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **body** | [**\PureCloudSDK\TagQueryRequest**](../Model/\PureCloudSDK\TagQueryRequest.md)| query |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\TagValueEntityListing**](../Model/TagValueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putWorkspacesWorkspaceId**
> \PureCloudSDK\Workspace putWorkspacesWorkspaceId($workspaceId, $body)

Update a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$body = new \PureCloudSDK\Workspace(); // \PureCloudSDK\Workspace | Workspace

try {
    $result = $api_instance->putWorkspacesWorkspaceId($workspaceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->putWorkspacesWorkspaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **body** | [**\PureCloudSDK\Workspace**](../Model/\PureCloudSDK\Workspace.md)| Workspace |

### Return type

[**\PureCloudSDK\Workspace**](../Model/Workspace.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putWorkspacesWorkspaceIdMembersMemberId**
> \PureCloudSDK\WorkspaceMember putWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId, $body)

Add a member to a workspace



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$memberId = "memberId_example"; // string | Member ID
$body = new \PureCloudSDK\WorkspaceMember(); // \PureCloudSDK\WorkspaceMember | Workspace Member

try {
    $result = $api_instance->putWorkspacesWorkspaceIdMembersMemberId($workspaceId, $memberId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->putWorkspacesWorkspaceIdMembersMemberId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **memberId** | **string**| Member ID |
 **body** | [**\PureCloudSDK\WorkspaceMember**](../Model/\PureCloudSDK\WorkspaceMember.md)| Workspace Member |

### Return type

[**\PureCloudSDK\WorkspaceMember**](../Model/WorkspaceMember.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putWorkspacesWorkspaceIdTagvaluesTagId**
> \PureCloudSDK\TagValue putWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId, $body)

Update a workspace tag. Will update all documents with the new tag value.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ContentManagementApi();
$workspaceId = "workspaceId_example"; // string | Workspace ID
$tagId = "tagId_example"; // string | Tag ID
$body = new \PureCloudSDK\TagValue(); // \PureCloudSDK\TagValue | Workspace

try {
    $result = $api_instance->putWorkspacesWorkspaceIdTagvaluesTagId($workspaceId, $tagId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ContentManagementApi->putWorkspacesWorkspaceIdTagvaluesTagId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **workspaceId** | **string**| Workspace ID |
 **tagId** | **string**| Tag ID |
 **body** | [**\PureCloudSDK\TagValue**](../Model/\PureCloudSDK\TagValue.md)| Workspace |

### Return type

[**\PureCloudSDK\TagValue**](../Model/TagValue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

