# PureCloudSDK\QualityApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteCalibrationsCalibrationId**](QualityApi.md#deleteCalibrationsCalibrationId) | **DELETE** /api/v2/quality/calibrations/{calibrationId} | Delete a calibration by id.
[**deleteConversationsConversationIdEvaluationsEvaluationId**](QualityApi.md#deleteConversationsConversationIdEvaluationsEvaluationId) | **DELETE** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Delete an evaluation
[**deleteFormsFormId**](QualityApi.md#deleteFormsFormId) | **DELETE** /api/v2/quality/forms/{formId} | Delete an evaluation form.
[**deleteKeywordsets**](QualityApi.md#deleteKeywordsets) | **DELETE** /api/v2/quality/keywordsets | Delete keyword sets
[**deleteKeywordsetsKeywordsetId**](QualityApi.md#deleteKeywordsetsKeywordsetId) | **DELETE** /api/v2/quality/keywordsets/{keywordSetId} | Delete a keywordSet by id.
[**getAgentsActivity**](QualityApi.md#getAgentsActivity) | **GET** /api/v2/quality/agents/activity | Gets a list of Agent Activities
[**getCalibrations**](QualityApi.md#getCalibrations) | **GET** /api/v2/quality/calibrations | Get the list of calibrations
[**getCalibrationsCalibrationId**](QualityApi.md#getCalibrationsCalibrationId) | **GET** /api/v2/quality/calibrations/{calibrationId} | Get a calibration by id.
[**getConversationsConversationIdAudits**](QualityApi.md#getConversationsConversationIdAudits) | **GET** /api/v2/quality/conversations/{conversationId}/audits | Get audits for conversation or recording
[**getConversationsConversationIdEvaluationsEvaluationId**](QualityApi.md#getConversationsConversationIdEvaluationsEvaluationId) | **GET** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Get an evaluation
[**getEvaluationsQuery**](QualityApi.md#getEvaluationsQuery) | **GET** /api/v2/quality/evaluations/query | Queries Evaluations and returns a paged list
[**getEvaluatorsActivity**](QualityApi.md#getEvaluatorsActivity) | **GET** /api/v2/quality/evaluators/activity | Get an evaluator activity
[**getForms**](QualityApi.md#getForms) | **GET** /api/v2/quality/forms | Get the list of evaluation forms
[**getFormsFormId**](QualityApi.md#getFormsFormId) | **GET** /api/v2/quality/forms/{formId} | Get an evaluation form
[**getFormsFormIdVersions**](QualityApi.md#getFormsFormIdVersions) | **GET** /api/v2/quality/forms/{formId}/versions | Gets all the revisions for a specific evaluation.
[**getKeywordsets**](QualityApi.md#getKeywordsets) | **GET** /api/v2/quality/keywordsets | Get the list of keyword sets
[**getKeywordsetsKeywordsetId**](QualityApi.md#getKeywordsetsKeywordsetId) | **GET** /api/v2/quality/keywordsets/{keywordSetId} | Get a keywordSet by id.
[**getPublishedforms**](QualityApi.md#getPublishedforms) | **GET** /api/v2/quality/publishedforms | Get the published evaluation forms.
[**getPublishedformsFormId**](QualityApi.md#getPublishedformsFormId) | **GET** /api/v2/quality/publishedforms/{formId} | Get the published evaluation forms.
[**postCalibrations**](QualityApi.md#postCalibrations) | **POST** /api/v2/quality/calibrations | Create a calibration
[**postConversationsConversationIdEvaluations**](QualityApi.md#postConversationsConversationIdEvaluations) | **POST** /api/v2/quality/conversations/{conversationId}/evaluations | Create an evaluation
[**postEvaluationsAggregatesQuery**](QualityApi.md#postEvaluationsAggregatesQuery) | **POST** /api/v2/analytics/evaluations/aggregates/query | Query for evaluation aggregates
[**postEvaluationsScoring**](QualityApi.md#postEvaluationsScoring) | **POST** /api/v2/quality/evaluations/scoring | Score evaluation
[**postForms**](QualityApi.md#postForms) | **POST** /api/v2/quality/forms | Create an evaluation form.
[**postKeywordsets**](QualityApi.md#postKeywordsets) | **POST** /api/v2/quality/keywordsets | Create a Keyword Set
[**postPublishedforms**](QualityApi.md#postPublishedforms) | **POST** /api/v2/quality/publishedforms | Publish an evaluation form.
[**postSpotability**](QualityApi.md#postSpotability) | **POST** /api/v2/quality/spotability | Retrieve the spotability statistic
[**putCalibrationsCalibrationId**](QualityApi.md#putCalibrationsCalibrationId) | **PUT** /api/v2/quality/calibrations/{calibrationId} | Update a calibration to the specified calibration via PUT.  Editable fields include: evaluators, expertEvaluator, and scoringIndex
[**putConversationsConversationIdEvaluationsEvaluationId**](QualityApi.md#putConversationsConversationIdEvaluationsEvaluationId) | **PUT** /api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId} | Update an evaluation
[**putFormsFormId**](QualityApi.md#putFormsFormId) | **PUT** /api/v2/quality/forms/{formId} | Update an evaluation form.
[**putKeywordsetsKeywordsetId**](QualityApi.md#putKeywordsetsKeywordsetId) | **PUT** /api/v2/quality/keywordsets/{keywordSetId} | Update a keywordSet to the specified keywordSet via PUT.


# **deleteCalibrationsCalibrationId**
> \PureCloudSDK\Calibration deleteCalibrationsCalibrationId($calibrationId, $calibratorId)

Delete a calibration by id.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$calibrationId = "calibrationId_example"; // string | Calibration ID
$calibratorId = "calibratorId_example"; // string | calibratorId

try {
    $result = $api_instance->deleteCalibrationsCalibrationId($calibrationId, $calibratorId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteCalibrationsCalibrationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **calibrationId** | **string**| Calibration ID |
 **calibratorId** | **string**| calibratorId |

### Return type

[**\PureCloudSDK\Calibration**](../Model/Calibration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteConversationsConversationIdEvaluationsEvaluationId**
> \PureCloudSDK\Evaluation deleteConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $expand)

Delete an evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | conversationId
$evaluationId = "evaluationId_example"; // string | evaluationId
$expand = "expand_example"; // string | evaluatorId

try {
    $result = $api_instance->deleteConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteConversationsConversationIdEvaluationsEvaluationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **evaluationId** | **string**| evaluationId |
 **expand** | **string**| evaluatorId | [optional]

### Return type

[**\PureCloudSDK\Evaluation**](../Model/Evaluation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteFormsFormId**
> string deleteFormsFormId($formId)

Delete an evaluation form.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID

try {
    $result = $api_instance->deleteFormsFormId($formId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteFormsFormId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteKeywordsets**
> string deleteKeywordsets($ids)

Delete keyword sets

Bulk delete of keyword sets; this will only delete the keyword sets that match the ids specified in the query param.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$ids = "ids_example"; // string | A comma-delimited list of valid KeywordSet ids

try {
    $result = $api_instance->deleteKeywordsets($ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteKeywordsets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ids** | **string**| A comma-delimited list of valid KeywordSet ids |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteKeywordsetsKeywordsetId**
> deleteKeywordsetsKeywordsetId($keywordSetId)

Delete a keywordSet by id.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$keywordSetId = "keywordSetId_example"; // string | KeywordSet ID

try {
    $api_instance->deleteKeywordsetsKeywordsetId($keywordSetId);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->deleteKeywordsetsKeywordsetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **keywordSetId** | **string**| KeywordSet ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAgentsActivity**
> \PureCloudSDK\AgentActivityEntityListing getAgentsActivity($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $startTime, $endTime, $agentUserId, $evaluatorUserId, $name, $group)

Gets a list of Agent Activities

Including the number of evaluations and average evaluation score

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$startTime = new \DateTime(); // \DateTime | Start time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$endTime = new \DateTime(); // \DateTime | End time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$agentUserId = NULL; // object[] | user id of agent requested
$evaluatorUserId = "evaluatorUserId_example"; // string | user id of the evaluator
$name = "name_example"; // string | name
$group = "group_example"; // string | group id

try {
    $result = $api_instance->getAgentsActivity($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $startTime, $endTime, $agentUserId, $evaluatorUserId, $name, $group);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getAgentsActivity: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **startTime** | **\DateTime**| Start time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **endTime** | **\DateTime**| End time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **agentUserId** | [**object[]**](../Model/object.md)| user id of agent requested | [optional]
 **evaluatorUserId** | **string**| user id of the evaluator | [optional]
 **name** | **string**| name | [optional]
 **group** | **string**| group id | [optional]

### Return type

[**\PureCloudSDK\AgentActivityEntityListing**](../Model/AgentActivityEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCalibrations**
> \PureCloudSDK\CalibrationEntityListing getCalibrations($calibratorId, $pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $conversationId, $startTime, $endTime)

Get the list of calibrations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$calibratorId = "calibratorId_example"; // string | user id of calibrator
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$conversationId = "conversationId_example"; // string | conversation id
$startTime = new \DateTime(); // \DateTime | Beginning of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$endTime = new \DateTime(); // \DateTime | end of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

try {
    $result = $api_instance->getCalibrations($calibratorId, $pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $conversationId, $startTime, $endTime);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getCalibrations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **calibratorId** | **string**| user id of calibrator |
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **conversationId** | **string**| conversation id | [optional]
 **startTime** | **\DateTime**| Beginning of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **endTime** | **\DateTime**| end of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]

### Return type

[**\PureCloudSDK\CalibrationEntityListing**](../Model/CalibrationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCalibrationsCalibrationId**
> \PureCloudSDK\Calibration getCalibrationsCalibrationId($calibrationId, $calibratorId)

Get a calibration by id.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$calibrationId = "calibrationId_example"; // string | Calibration ID
$calibratorId = "calibratorId_example"; // string | calibratorId

try {
    $result = $api_instance->getCalibrationsCalibrationId($calibrationId, $calibratorId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getCalibrationsCalibrationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **calibrationId** | **string**| Calibration ID |
 **calibratorId** | **string**| calibratorId |

### Return type

[**\PureCloudSDK\Calibration**](../Model/Calibration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdAudits**
> \PureCloudSDK\QualityAuditPage getConversationsConversationIdAudits($conversationId, $pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $recordingId, $entityType)

Get audits for conversation or recording



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | Conversation ID
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$recordingId = "recordingId_example"; // string | id of the recording
$entityType = "recording"; // string | entity type options: Recording, Calibration, Evaluation, Annotation

try {
    $result = $api_instance->getConversationsConversationIdAudits($conversationId, $pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $recordingId, $entityType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getConversationsConversationIdAudits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **recordingId** | **string**| id of the recording | [optional]
 **entityType** | **string**| entity type options: Recording, Calibration, Evaluation, Annotation | [optional] [default to recording]

### Return type

[**\PureCloudSDK\QualityAuditPage**](../Model/QualityAuditPage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdEvaluationsEvaluationId**
> \PureCloudSDK\Evaluation getConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $expand)

Get an evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | conversationId
$evaluationId = "evaluationId_example"; // string | evaluationId
$expand = "expand_example"; // string | agent, evaluator, evaluationForm

try {
    $result = $api_instance->getConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getConversationsConversationIdEvaluationsEvaluationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **evaluationId** | **string**| evaluationId |
 **expand** | **string**| agent, evaluator, evaluationForm | [optional]

### Return type

[**\PureCloudSDK\Evaluation**](../Model/Evaluation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEvaluationsQuery**
> \PureCloudSDK\EvaluationEntityListing getEvaluationsQuery($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $conversationId, $agentUserId, $evaluatorUserId, $queueId, $startTime, $endTime, $evaluationState, $isReleased, $agentHasRead, $expandAnswerTotalScores, $maximum)

Queries Evaluations and returns a paged list

Query params must include one of conversationId, evaluatorUserId, or agentUserId

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$conversationId = "conversationId_example"; // string | conversationId specified
$agentUserId = "agentUserId_example"; // string | user id of the agent
$evaluatorUserId = "evaluatorUserId_example"; // string | evaluator user id
$queueId = "queueId_example"; // string | queue id
$startTime = "startTime_example"; // string | start time of the evaluation query
$endTime = "endTime_example"; // string | end time of the evaluation query
$evaluationState = NULL; // object[] | evaluation state options: Pending, InProgress, Finished
$isReleased = true; // bool | the evaluation has been released
$agentHasRead = true; // bool | agent has the evaluation
$expandAnswerTotalScores = true; // bool | get the total scores for evaluations
$maximum = 56; // int | maximum

try {
    $result = $api_instance->getEvaluationsQuery($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $conversationId, $agentUserId, $evaluatorUserId, $queueId, $startTime, $endTime, $evaluationState, $isReleased, $agentHasRead, $expandAnswerTotalScores, $maximum);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getEvaluationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **conversationId** | **string**| conversationId specified | [optional]
 **agentUserId** | **string**| user id of the agent | [optional]
 **evaluatorUserId** | **string**| evaluator user id | [optional]
 **queueId** | **string**| queue id | [optional]
 **startTime** | **string**| start time of the evaluation query | [optional]
 **endTime** | **string**| end time of the evaluation query | [optional]
 **evaluationState** | [**object[]**](../Model/object.md)| evaluation state options: Pending, InProgress, Finished | [optional]
 **isReleased** | **bool**| the evaluation has been released | [optional]
 **agentHasRead** | **bool**| agent has the evaluation | [optional]
 **expandAnswerTotalScores** | **bool**| get the total scores for evaluations | [optional]
 **maximum** | **int**| maximum | [optional]

### Return type

[**\PureCloudSDK\EvaluationEntityListing**](../Model/EvaluationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEvaluatorsActivity**
> \PureCloudSDK\EvaluatorActivityEntityListing getEvaluatorsActivity($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $startTime, $endTime, $name, $permission, $group)

Get an evaluator activity



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$startTime = new \DateTime(); // \DateTime | The start time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$endTime = new \DateTime(); // \DateTime | The end time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
$name = "name_example"; // string | Evaluator name
$permission = NULL; // object[] | permission strings
$group = "group_example"; // string | group id

try {
    $result = $api_instance->getEvaluatorsActivity($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $startTime, $endTime, $name, $permission, $group);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getEvaluatorsActivity: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **startTime** | **\DateTime**| The start time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **endTime** | **\DateTime**| The end time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional]
 **name** | **string**| Evaluator name | [optional]
 **permission** | [**object[]**](../Model/object.md)| permission strings | [optional]
 **group** | **string**| group id | [optional]

### Return type

[**\PureCloudSDK\EvaluatorActivityEntityListing**](../Model/EvaluatorActivityEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getForms**
> \PureCloudSDK\EvaluationFormEntityListing getForms($pageSize, $pageNumber, $sortBy, $nextPage, $previousPage, $expand, $name)

Get the list of evaluation forms



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$expand = "expand_example"; // string | Expand
$name = "name_example"; // string | Name

try {
    $result = $api_instance->getForms($pageSize, $pageNumber, $sortBy, $nextPage, $previousPage, $expand, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getForms: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **expand** | **string**| Expand | [optional]
 **name** | **string**| Name | [optional]

### Return type

[**\PureCloudSDK\EvaluationFormEntityListing**](../Model/EvaluationFormEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFormsFormId**
> \PureCloudSDK\EvaluationForm getFormsFormId($formId)

Get an evaluation form



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID

try {
    $result = $api_instance->getFormsFormId($formId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getFormsFormId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFormsFormIdVersions**
> \PureCloudSDK\EvaluationFormEntityListing getFormsFormIdVersions($formId, $pageSize, $pageNumber)

Gets all the revisions for a specific evaluation.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getFormsFormIdVersions($formId, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getFormsFormIdVersions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\EvaluationFormEntityListing**](../Model/EvaluationFormEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getKeywordsets**
> \PureCloudSDK\KeywordSetEntityListing getKeywordsets($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $name)

Get the list of keyword sets



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$name = "name_example"; // string | the keyword set name - used for filtering results in searches.

try {
    $result = $api_instance->getKeywordsets($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getKeywordsets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **name** | **string**| the keyword set name - used for filtering results in searches. | [optional]

### Return type

[**\PureCloudSDK\KeywordSetEntityListing**](../Model/KeywordSetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getKeywordsetsKeywordsetId**
> \PureCloudSDK\KeywordSet getKeywordsetsKeywordsetId($keywordSetId)

Get a keywordSet by id.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$keywordSetId = "keywordSetId_example"; // string | KeywordSet ID

try {
    $result = $api_instance->getKeywordsetsKeywordsetId($keywordSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getKeywordsetsKeywordsetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **keywordSetId** | **string**| KeywordSet ID |

### Return type

[**\PureCloudSDK\KeywordSet**](../Model/KeywordSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPublishedforms**
> \PureCloudSDK\EvaluationFormEntityListing getPublishedforms($pageSize, $pageNumber, $name)

Get the published evaluation forms.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name

try {
    $result = $api_instance->getPublishedforms($pageSize, $pageNumber, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getPublishedforms: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]

### Return type

[**\PureCloudSDK\EvaluationFormEntityListing**](../Model/EvaluationFormEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPublishedformsFormId**
> \PureCloudSDK\EvaluationForm getPublishedformsFormId($formId)

Get the published evaluation forms.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID

try {
    $result = $api_instance->getPublishedformsFormId($formId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->getPublishedformsFormId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCalibrations**
> \PureCloudSDK\Calibration postCalibrations($body, $expand)

Create a calibration



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\CalibrationCreate(); // \PureCloudSDK\CalibrationCreate | calibration
$expand = "expand_example"; // string | calibratorId

try {
    $result = $api_instance->postCalibrations($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postCalibrations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CalibrationCreate**](../Model/\PureCloudSDK\CalibrationCreate.md)| calibration |
 **expand** | **string**| calibratorId | [optional]

### Return type

[**\PureCloudSDK\Calibration**](../Model/Calibration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsConversationIdEvaluations**
> \PureCloudSDK\Evaluation postConversationsConversationIdEvaluations($conversationId, $body, $expand)

Create an evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\Evaluation(); // \PureCloudSDK\Evaluation | evaluation
$expand = "expand_example"; // string | evaluatorId

try {
    $result = $api_instance->postConversationsConversationIdEvaluations($conversationId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postConversationsConversationIdEvaluations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\Evaluation**](../Model/\PureCloudSDK\Evaluation.md)| evaluation |
 **expand** | **string**| evaluatorId | [optional]

### Return type

[**\PureCloudSDK\Evaluation**](../Model/Evaluation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postEvaluationsAggregatesQuery**
> \PureCloudSDK\AggregateQueryResponse postEvaluationsAggregatesQuery($body)

Query for evaluation aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postEvaluationsAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postEvaluationsAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\AggregateQueryResponse**](../Model/AggregateQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postEvaluationsScoring**
> \PureCloudSDK\EvaluationScoringSet postEvaluationsScoring($body)

Score evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\EvaluationFormAndScoringSet(); // \PureCloudSDK\EvaluationFormAndScoringSet | evaluationAndScoringSet

try {
    $result = $api_instance->postEvaluationsScoring($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postEvaluationsScoring: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EvaluationFormAndScoringSet**](../Model/\PureCloudSDK\EvaluationFormAndScoringSet.md)| evaluationAndScoringSet |

### Return type

[**\PureCloudSDK\EvaluationScoringSet**](../Model/EvaluationScoringSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postForms**
> \PureCloudSDK\EvaluationForm postForms($body)

Create an evaluation form.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\EvaluationForm(); // \PureCloudSDK\EvaluationForm | Evaluation form

try {
    $result = $api_instance->postForms($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postForms: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EvaluationForm**](../Model/\PureCloudSDK\EvaluationForm.md)| Evaluation form |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postKeywordsets**
> \PureCloudSDK\KeywordSet postKeywordsets($body, $expand)

Create a Keyword Set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\KeywordSet(); // \PureCloudSDK\KeywordSet | keywordSet
$expand = "expand_example"; // string | queueId

try {
    $result = $api_instance->postKeywordsets($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postKeywordsets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\KeywordSet**](../Model/\PureCloudSDK\KeywordSet.md)| keywordSet |
 **expand** | **string**| queueId | [optional]

### Return type

[**\PureCloudSDK\KeywordSet**](../Model/KeywordSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postPublishedforms**
> \PureCloudSDK\EvaluationForm postPublishedforms($body)

Publish an evaluation form.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\EvaluationForm(); // \PureCloudSDK\EvaluationForm | Evaluation form

try {
    $result = $api_instance->postPublishedforms($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postPublishedforms: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EvaluationForm**](../Model/\PureCloudSDK\EvaluationForm.md)| Evaluation form |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSpotability**
> \PureCloudSDK\KeywordSet postSpotability($body)

Retrieve the spotability statistic



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$body = new \PureCloudSDK\KeywordSet(); // \PureCloudSDK\KeywordSet | Keyword Set

try {
    $result = $api_instance->postSpotability($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->postSpotability: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\KeywordSet**](../Model/\PureCloudSDK\KeywordSet.md)| Keyword Set | [optional]

### Return type

[**\PureCloudSDK\KeywordSet**](../Model/KeywordSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putCalibrationsCalibrationId**
> \PureCloudSDK\Calibration putCalibrationsCalibrationId($calibrationId, $body)

Update a calibration to the specified calibration via PUT.  Editable fields include: evaluators, expertEvaluator, and scoringIndex



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$calibrationId = "calibrationId_example"; // string | Calibration ID
$body = new \PureCloudSDK\Calibration(); // \PureCloudSDK\Calibration | Calibration

try {
    $result = $api_instance->putCalibrationsCalibrationId($calibrationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->putCalibrationsCalibrationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **calibrationId** | **string**| Calibration ID |
 **body** | [**\PureCloudSDK\Calibration**](../Model/\PureCloudSDK\Calibration.md)| Calibration |

### Return type

[**\PureCloudSDK\Calibration**](../Model/Calibration.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putConversationsConversationIdEvaluationsEvaluationId**
> \PureCloudSDK\Evaluation putConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $body, $expand)

Update an evaluation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$conversationId = "conversationId_example"; // string | conversationId
$evaluationId = "evaluationId_example"; // string | evaluationId
$body = new \PureCloudSDK\Evaluation(); // \PureCloudSDK\Evaluation | evaluation
$expand = "expand_example"; // string | evaluatorId

try {
    $result = $api_instance->putConversationsConversationIdEvaluationsEvaluationId($conversationId, $evaluationId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->putConversationsConversationIdEvaluationsEvaluationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **evaluationId** | **string**| evaluationId |
 **body** | [**\PureCloudSDK\Evaluation**](../Model/\PureCloudSDK\Evaluation.md)| evaluation |
 **expand** | **string**| evaluatorId | [optional]

### Return type

[**\PureCloudSDK\Evaluation**](../Model/Evaluation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putFormsFormId**
> \PureCloudSDK\EvaluationForm putFormsFormId($formId, $body)

Update an evaluation form.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$formId = "formId_example"; // string | Form ID
$body = new \PureCloudSDK\EvaluationForm(); // \PureCloudSDK\EvaluationForm | Evaluation form

try {
    $result = $api_instance->putFormsFormId($formId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->putFormsFormId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **formId** | **string**| Form ID |
 **body** | [**\PureCloudSDK\EvaluationForm**](../Model/\PureCloudSDK\EvaluationForm.md)| Evaluation form |

### Return type

[**\PureCloudSDK\EvaluationForm**](../Model/EvaluationForm.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putKeywordsetsKeywordsetId**
> \PureCloudSDK\KeywordSet putKeywordsetsKeywordsetId($keywordSetId, $body)

Update a keywordSet to the specified keywordSet via PUT.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\QualityApi();
$keywordSetId = "keywordSetId_example"; // string | KeywordSet ID
$body = new \PureCloudSDK\KeywordSet(); // \PureCloudSDK\KeywordSet | keywordSet

try {
    $result = $api_instance->putKeywordsetsKeywordsetId($keywordSetId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QualityApi->putKeywordsetsKeywordsetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **keywordSetId** | **string**| KeywordSet ID |
 **body** | [**\PureCloudSDK\KeywordSet**](../Model/\PureCloudSDK\KeywordSet.md)| keywordSet |

### Return type

[**\PureCloudSDK\KeywordSet**](../Model/KeywordSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

