# PureCloudSDK\ResponseManagementApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteLibrariesLibraryId**](ResponseManagementApi.md#deleteLibrariesLibraryId) | **DELETE** /api/v2/responsemanagement/libraries/{libraryId} | Delete an existing response library.
[**deleteResponsesResponseId**](ResponseManagementApi.md#deleteResponsesResponseId) | **DELETE** /api/v2/responsemanagement/responses/{responseId} | Delete an existing response.
[**getLibraries**](ResponseManagementApi.md#getLibraries) | **GET** /api/v2/responsemanagement/libraries | Gets a list of existing response libraries.
[**getLibrariesLibraryId**](ResponseManagementApi.md#getLibrariesLibraryId) | **GET** /api/v2/responsemanagement/libraries/{libraryId} | Get details about an existing response library.
[**getResponses**](ResponseManagementApi.md#getResponses) | **GET** /api/v2/responsemanagement/responses | Gets a list of existing responses.
[**getResponsesResponseId**](ResponseManagementApi.md#getResponsesResponseId) | **GET** /api/v2/responsemanagement/responses/{responseId} | Get details about an existing response.
[**postLibraries**](ResponseManagementApi.md#postLibraries) | **POST** /api/v2/responsemanagement/libraries | Create a response library.
[**postResponses**](ResponseManagementApi.md#postResponses) | **POST** /api/v2/responsemanagement/responses | Create a response.
[**postResponsesQuery**](ResponseManagementApi.md#postResponsesQuery) | **POST** /api/v2/responsemanagement/responses/query | Query responses
[**putLibrariesLibraryId**](ResponseManagementApi.md#putLibrariesLibraryId) | **PUT** /api/v2/responsemanagement/libraries/{libraryId} | Update an existing response library.
[**putResponsesResponseId**](ResponseManagementApi.md#putResponsesResponseId) | **PUT** /api/v2/responsemanagement/responses/{responseId} | Update an existing response.


# **deleteLibrariesLibraryId**
> deleteLibrariesLibraryId($libraryId)

Delete an existing response library.

This will remove any responses associated with the library.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$libraryId = "libraryId_example"; // string | Library ID

try {
    $api_instance->deleteLibrariesLibraryId($libraryId);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->deleteLibrariesLibraryId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **libraryId** | **string**| Library ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteResponsesResponseId**
> deleteResponsesResponseId($responseId)

Delete an existing response.

This will remove the response from any libraries associated with it.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$responseId = "responseId_example"; // string | Response ID

try {
    $api_instance->deleteResponsesResponseId($responseId);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->deleteResponsesResponseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **responseId** | **string**| Response ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLibraries**
> \PureCloudSDK\LibraryEntityListing getLibraries($pageNumber, $pageSize)

Gets a list of existing response libraries.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getLibraries($pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getLibraries: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\LibraryEntityListing**](../Model/LibraryEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLibrariesLibraryId**
> \PureCloudSDK\Library getLibrariesLibraryId($libraryId)

Get details about an existing response library.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$libraryId = "libraryId_example"; // string | Library ID

try {
    $result = $api_instance->getLibrariesLibraryId($libraryId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getLibrariesLibraryId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **libraryId** | **string**| Library ID |

### Return type

[**\PureCloudSDK\Library**](../Model/Library.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getResponses**
> \PureCloudSDK\ResponseEntityListing getResponses($libraryId, $pageNumber, $pageSize)

Gets a list of existing responses.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$libraryId = "libraryId_example"; // string | Library ID
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getResponses($libraryId, $pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getResponses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **libraryId** | **string**| Library ID |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\ResponseEntityListing**](../Model/ResponseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getResponsesResponseId**
> \PureCloudSDK\Response getResponsesResponseId($responseId)

Get details about an existing response.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$responseId = "responseId_example"; // string | Response ID

try {
    $result = $api_instance->getResponsesResponseId($responseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->getResponsesResponseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **responseId** | **string**| Response ID |

### Return type

[**\PureCloudSDK\Response**](../Model/Response.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postLibraries**
> \PureCloudSDK\Library postLibraries($body)

Create a response library.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$body = new \PureCloudSDK\Library(); // \PureCloudSDK\Library | Library

try {
    $result = $api_instance->postLibraries($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->postLibraries: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Library**](../Model/\PureCloudSDK\Library.md)| Library |

### Return type

[**\PureCloudSDK\Library**](../Model/Library.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postResponses**
> \PureCloudSDK\Response postResponses($body)

Create a response.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$body = new \PureCloudSDK\Response(); // \PureCloudSDK\Response | Response

try {
    $result = $api_instance->postResponses($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->postResponses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Response**](../Model/\PureCloudSDK\Response.md)| Response |

### Return type

[**\PureCloudSDK\Response**](../Model/Response.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postResponsesQuery**
> \PureCloudSDK\ResponseQueryResults postResponsesQuery($body)

Query responses



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$body = new \PureCloudSDK\ResponseQueryRequest(); // \PureCloudSDK\ResponseQueryRequest | Response

try {
    $result = $api_instance->postResponsesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->postResponsesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ResponseQueryRequest**](../Model/\PureCloudSDK\ResponseQueryRequest.md)| Response |

### Return type

[**\PureCloudSDK\ResponseQueryResults**](../Model/ResponseQueryResults.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putLibrariesLibraryId**
> \PureCloudSDK\Library putLibrariesLibraryId($libraryId, $body)

Update an existing response library.

Fields that can be updated: name. The most recent version is required for updates.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$libraryId = "libraryId_example"; // string | Library ID
$body = new \PureCloudSDK\Library(); // \PureCloudSDK\Library | Library

try {
    $result = $api_instance->putLibrariesLibraryId($libraryId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->putLibrariesLibraryId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **libraryId** | **string**| Library ID |
 **body** | [**\PureCloudSDK\Library**](../Model/\PureCloudSDK\Library.md)| Library |

### Return type

[**\PureCloudSDK\Library**](../Model/Library.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putResponsesResponseId**
> \PureCloudSDK\Response putResponsesResponseId($responseId, $body)

Update an existing response.

Fields that can be updated: name, libraries, and texts. The most recent version is required for updates.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ResponseManagementApi();
$responseId = "responseId_example"; // string | Response ID
$body = new \PureCloudSDK\Response(); // \PureCloudSDK\Response | Response

try {
    $result = $api_instance->putResponsesResponseId($responseId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ResponseManagementApi->putResponsesResponseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **responseId** | **string**| Response ID |
 **body** | [**\PureCloudSDK\Response**](../Model/\PureCloudSDK\Response.md)| Response |

### Return type

[**\PureCloudSDK\Response**](../Model/Response.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

