# PureCloudSDK\TelephonyProvidersEdgeApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteProvidersEdgesCertificateauthoritiesCertificateId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesCertificateauthoritiesCertificateId) | **DELETE** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Delete a certificate authority.
[**deleteProvidersEdgesDidpoolsDidpoolId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesDidpoolsDidpoolId) | **DELETE** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Delete a DID Pool by ID.
[**deleteProvidersEdgesEdgeId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEdgeId) | **DELETE** /api/v2/telephony/providers/edges/{edgeId} | Delete a edge.
[**deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Delete an edge logical interface
[**deleteProvidersEdgesEdgeIdSoftwareupdate**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEdgeIdSoftwareupdate) | **DELETE** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Cancels any in-progress update for this edge.
[**deleteProvidersEdgesEdgegroupsEdgegroupId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEdgegroupsEdgegroupId) | **DELETE** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Delete an edge group.
[**deleteProvidersEdgesEndpointsEndpointId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesEndpointsEndpointId) | **DELETE** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Delete endpoint
[**deleteProvidersEdgesExtensionpoolsExtensionpoolId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesExtensionpoolsExtensionpoolId) | **DELETE** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Delete an extension pool by ID
[**deleteProvidersEdgesOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesOutboundroutesOutboundrouteId) | **DELETE** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Delete Outbound Route
[**deleteProvidersEdgesPhonebasesettingsPhonebaseId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesPhonebasesettingsPhonebaseId) | **DELETE** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Delete a Phone Base Settings by ID
[**deleteProvidersEdgesPhonesPhoneId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesPhonesPhoneId) | **DELETE** /api/v2/telephony/providers/edges/phones/{phoneId} | Delete a Phone by ID
[**deleteProvidersEdgesSitesSiteId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesSitesSiteId) | **DELETE** /api/v2/telephony/providers/edges/sites/{siteId} | Delete a Site by ID
[**deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](TelephonyProvidersEdgeApi.md#deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId) | **DELETE** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Delete a Trunk Base Settings object by ID
[**getProvidersEdges**](TelephonyProvidersEdgeApi.md#getProvidersEdges) | **GET** /api/v2/telephony/providers/edges | Get the list of edges.
[**getProvidersEdgesAvailablelanguages**](TelephonyProvidersEdgeApi.md#getProvidersEdgesAvailablelanguages) | **GET** /api/v2/telephony/providers/edges/availablelanguages | Get the list of available languages.
[**getProvidersEdgesCertificateauthorities**](TelephonyProvidersEdgeApi.md#getProvidersEdgesCertificateauthorities) | **GET** /api/v2/telephony/providers/edges/certificateauthorities | Get the list of certificate authorities.
[**getProvidersEdgesCertificateauthoritiesCertificateId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesCertificateauthoritiesCertificateId) | **GET** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Get a certificate authority.
[**getProvidersEdgesDidpools**](TelephonyProvidersEdgeApi.md#getProvidersEdgesDidpools) | **GET** /api/v2/telephony/providers/edges/didpools | Get a listing of DID Pools
[**getProvidersEdgesDidpoolsDidpoolId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesDidpoolsDidpoolId) | **GET** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Get a DID Pool by ID.
[**getProvidersEdgesDids**](TelephonyProvidersEdgeApi.md#getProvidersEdgesDids) | **GET** /api/v2/telephony/providers/edges/dids | Get a listing of DIDs
[**getProvidersEdgesDidsDidId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesDidsDidId) | **GET** /api/v2/telephony/providers/edges/dids/{didId} | Get a DID by ID.
[**getProvidersEdgesEdgeId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeId) | **GET** /api/v2/telephony/providers/edges/{edgeId} | Get edge.
[**getProvidersEdgesEdgeIdLines**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLines) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines | Get the list of lines.
[**getProvidersEdgesEdgeIdLinesLineId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLinesLineId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Get line
[**getProvidersEdgesEdgeIdLogicalinterfaces**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLogicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Get edge logical interfaces.
[**getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Get an edge logical interface
[**getProvidersEdgesEdgeIdLogsJobsJobId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdLogsJobsJobId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId} | Get an Edge logs job.
[**getProvidersEdgesEdgeIdPhysicalinterfaces**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdPhysicalinterfaces) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces | Retrieve a list of all configured physical interfaces from a specific edge.
[**getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId) | **GET** /api/v2/telephony/providers/edges/{edgeId}/physicalinterfaces/{interfaceId} | Get edge physical interface.
[**getProvidersEdgesEdgeIdSetuppackage**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdSetuppackage) | **GET** /api/v2/telephony/providers/edges/{edgeId}/setuppackage | Get the setup package for a locally deployed edge device. This is needed to complete the setup process for the virtual edge.
[**getProvidersEdgesEdgeIdSoftwareupdate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdSoftwareupdate) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Gets software update status information about any edge.
[**getProvidersEdgesEdgeIdSoftwareversions**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeIdSoftwareversions) | **GET** /api/v2/telephony/providers/edges/{edgeId}/softwareversions | Gets all the available software versions for this edge.
[**getProvidersEdgesEdgegroups**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgegroups) | **GET** /api/v2/telephony/providers/edges/edgegroups | Get the list of edge groups.
[**getProvidersEdgesEdgegroupsEdgegroupId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgegroupsEdgegroupId) | **GET** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Get edge group.
[**getProvidersEdgesEdgeversionreport**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEdgeversionreport) | **GET** /api/v2/telephony/providers/edges/edgeversionreport | Get the edge version report.
[**getProvidersEdgesEndpoints**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEndpoints) | **GET** /api/v2/telephony/providers/edges/endpoints | Get endpoints
[**getProvidersEdgesEndpointsEndpointId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesEndpointsEndpointId) | **GET** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Get endpoint
[**getProvidersEdgesExtensionpools**](TelephonyProvidersEdgeApi.md#getProvidersEdgesExtensionpools) | **GET** /api/v2/telephony/providers/edges/extensionpools | Get a listing of extension pools
[**getProvidersEdgesExtensionpoolsExtensionpoolId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesExtensionpoolsExtensionpoolId) | **GET** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Get an extension pool by ID
[**getProvidersEdgesExtensions**](TelephonyProvidersEdgeApi.md#getProvidersEdgesExtensions) | **GET** /api/v2/telephony/providers/edges/extensions | Get a listing of extensions
[**getProvidersEdgesExtensionsExtensionId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesExtensionsExtensionId) | **GET** /api/v2/telephony/providers/edges/extensions/{extensionId} | Get an extension by ID.
[**getProvidersEdgesLinebasesettings**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLinebasesettings) | **GET** /api/v2/telephony/providers/edges/linebasesettings | Get a listing of line base settings objects
[**getProvidersEdgesLinebasesettingsLinebaseId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLinebasesettingsLinebaseId) | **GET** /api/v2/telephony/providers/edges/linebasesettings/{lineBaseId} | Get a line base settings object by ID
[**getProvidersEdgesLines**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLines) | **GET** /api/v2/telephony/providers/edges/lines | Get a list of Lines
[**getProvidersEdgesLinesLineId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLinesLineId) | **GET** /api/v2/telephony/providers/edges/lines/{lineId} | Get a Line by ID
[**getProvidersEdgesLinesTemplate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesLinesTemplate) | **GET** /api/v2/telephony/providers/edges/lines/template | Get a Line instance template based on a Line Base Settings object. This object can then be modified and saved as a new Line instance
[**getProvidersEdgesOutboundroutes**](TelephonyProvidersEdgeApi.md#getProvidersEdgesOutboundroutes) | **GET** /api/v2/telephony/providers/edges/outboundroutes | Get outbound routes
[**getProvidersEdgesOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesOutboundroutesOutboundrouteId) | **GET** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Get outbound route
[**getProvidersEdgesPhonebasesettings**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonebasesettings) | **GET** /api/v2/telephony/providers/edges/phonebasesettings | Get a list of Phone Base Settings objects
[**getProvidersEdgesPhonebasesettingsAvailablemetabases**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonebasesettingsAvailablemetabases) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/availablemetabases | Get a list of available makes and models to create a new Phone Base Settings
[**getProvidersEdgesPhonebasesettingsPhonebaseId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonebasesettingsPhonebaseId) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Get a Phone Base Settings object by ID
[**getProvidersEdgesPhonebasesettingsTemplate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonebasesettingsTemplate) | **GET** /api/v2/telephony/providers/edges/phonebasesettings/template | Get a Phone Base Settings instance template from a given make and model. This object can then be modified and saved as a new Phone Base Settings instance
[**getProvidersEdgesPhones**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhones) | **GET** /api/v2/telephony/providers/edges/phones | Get a list of Phone Instances
[**getProvidersEdgesPhonesPhoneId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonesPhoneId) | **GET** /api/v2/telephony/providers/edges/phones/{phoneId} | Get a Phone by ID
[**getProvidersEdgesPhonesTemplate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesPhonesTemplate) | **GET** /api/v2/telephony/providers/edges/phones/template | Get a Phone instance template based on a Phone Base Settings object. This object can then be modified and saved as a new Phone instance
[**getProvidersEdgesSites**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSites) | **GET** /api/v2/telephony/providers/edges/sites | Get the list of Sites.
[**getProvidersEdgesSitesSiteId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSitesSiteId) | **GET** /api/v2/telephony/providers/edges/sites/{siteId} | Get a Site by ID.
[**getProvidersEdgesSitesSiteIdNumberplans**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSitesSiteIdNumberplans) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Get the list of Number Plans for this Site.
[**getProvidersEdgesSitesSiteIdNumberplansClassifications**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSitesSiteIdNumberplansClassifications) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/classifications | Get a list of Classifications for this Site
[**getProvidersEdgesSitesSiteIdNumberplansNumberplanId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesSitesSiteIdNumberplansNumberplanId) | **GET** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans/{numberPlanId} | Get a Number Plan by ID.
[**getProvidersEdgesTimezones**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTimezones) | **GET** /api/v2/telephony/providers/edges/timezones | Get a list of Edge-compatible time zones
[**getProvidersEdgesTrunkbasesettings**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkbasesettings) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings | Get Trunk Base Settings listing
[**getProvidersEdgesTrunkbasesettingsAvailablemetabases**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkbasesettingsAvailablemetabases) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/availablemetabases | Get a list of available makes and models to create a new Trunk Base Settings
[**getProvidersEdgesTrunkbasesettingsTemplate**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkbasesettingsTemplate) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/template | Get a Trunk Base Settings instance template from a given make and model. This object can then be modified and saved as a new Trunk Base Settings instance
[**getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId) | **GET** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Get a Trunk Base Settings object by ID
[**getProvidersEdgesTrunks**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunks) | **GET** /api/v2/telephony/providers/edges/trunks | Get the list of available trunks.
[**getProvidersEdgesTrunksTrunkId**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunksTrunkId) | **GET** /api/v2/telephony/providers/edges/trunks/{trunkId} | Get a Trunk by ID
[**getProvidersEdgesTrunkswithrecording**](TelephonyProvidersEdgeApi.md#getProvidersEdgesTrunkswithrecording) | **GET** /api/v2/telephony/providers/edges/trunkswithrecording | Get Counts of trunks that have recording disabled or enabled
[**getSchemasEdgesVnext**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnext) | **GET** /api/v2/configuration/schemas/edges/vnext | Lists available schema categories
[**getSchemasEdgesVnextSchemacategory**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnextSchemacategory) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory} | List schemas of a specific category
[**getSchemasEdgesVnextSchemacategorySchematype**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnextSchemacategorySchematype) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType} | List schemas of a specific category
[**getSchemasEdgesVnextSchemacategorySchematypeSchemaId**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnextSchemacategorySchematypeSchemaId) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId} | Get a json schema
[**getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId**](TelephonyProvidersEdgeApi.md#getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId) | **GET** /api/v2/configuration/schemas/edges/vnext/{schemaCategory}/{schemaType}/{schemaId}/{extensionType}/{metadataId} | Get metadata for a schema
[**postProvidersEdges**](TelephonyProvidersEdgeApi.md#postProvidersEdges) | **POST** /api/v2/telephony/providers/edges | Create an edge.
[**postProvidersEdgesAddressvalidation**](TelephonyProvidersEdgeApi.md#postProvidersEdgesAddressvalidation) | **POST** /api/v2/telephony/providers/edges/addressvalidation | Validates a street address
[**postProvidersEdgesCertificateauthorities**](TelephonyProvidersEdgeApi.md#postProvidersEdgesCertificateauthorities) | **POST** /api/v2/telephony/providers/edges/certificateauthorities | Create a certificate authority.
[**postProvidersEdgesDidpools**](TelephonyProvidersEdgeApi.md#postProvidersEdgesDidpools) | **POST** /api/v2/telephony/providers/edges/didpools | Create a new DID pool
[**postProvidersEdgesEdgeIdLogicalinterfaces**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdLogicalinterfaces) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces | Create an edge logical interface.
[**postProvidersEdgesEdgeIdLogsJobs**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdLogsJobs) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs | Create a job to upload a list of Edge logs.
[**postProvidersEdgesEdgeIdLogsJobsJobIdUpload**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdLogsJobsJobIdUpload) | **POST** /api/v2/telephony/providers/edges/{edgeId}/logs/jobs/{jobId}/upload | Request that the specified fileIds be uploaded from the Edge.
[**postProvidersEdgesEdgeIdReboot**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdReboot) | **POST** /api/v2/telephony/providers/edges/{edgeId}/reboot | Reboot an Edge
[**postProvidersEdgesEdgeIdSoftwareupdate**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdSoftwareupdate) | **POST** /api/v2/telephony/providers/edges/{edgeId}/softwareupdate | Starts a software update for this edge.
[**postProvidersEdgesEdgeIdUnpair**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgeIdUnpair) | **POST** /api/v2/telephony/providers/edges/{edgeId}/unpair | Unpair an Edge
[**postProvidersEdgesEdgegroups**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEdgegroups) | **POST** /api/v2/telephony/providers/edges/edgegroups | Create an edge group.
[**postProvidersEdgesEndpoints**](TelephonyProvidersEdgeApi.md#postProvidersEdgesEndpoints) | **POST** /api/v2/telephony/providers/edges/endpoints | Create endpoint
[**postProvidersEdgesExtensionpools**](TelephonyProvidersEdgeApi.md#postProvidersEdgesExtensionpools) | **POST** /api/v2/telephony/providers/edges/extensionpools | Create a new extension pool
[**postProvidersEdgesOfflineconfiguration**](TelephonyProvidersEdgeApi.md#postProvidersEdgesOfflineconfiguration) | **POST** /api/v2/telephony/providers/edges/offlineconfiguration | Create a file that can be used to configure a hardware Edge&#39;s settings.
[**postProvidersEdgesOutboundroutes**](TelephonyProvidersEdgeApi.md#postProvidersEdgesOutboundroutes) | **POST** /api/v2/telephony/providers/edges/outboundroutes | Create outbound rule
[**postProvidersEdgesPhonebasesettings**](TelephonyProvidersEdgeApi.md#postProvidersEdgesPhonebasesettings) | **POST** /api/v2/telephony/providers/edges/phonebasesettings | Create a new Phone Base Settings object
[**postProvidersEdgesPhones**](TelephonyProvidersEdgeApi.md#postProvidersEdgesPhones) | **POST** /api/v2/telephony/providers/edges/phones | Create a new Phone
[**postProvidersEdgesPhonesPhoneIdReboot**](TelephonyProvidersEdgeApi.md#postProvidersEdgesPhonesPhoneIdReboot) | **POST** /api/v2/telephony/providers/edges/phones/{phoneId}/reboot | Reboot a Phone
[**postProvidersEdgesPhonesReboot**](TelephonyProvidersEdgeApi.md#postProvidersEdgesPhonesReboot) | **POST** /api/v2/telephony/providers/edges/phones/reboot | Reboot Multiple Phones
[**postProvidersEdgesSites**](TelephonyProvidersEdgeApi.md#postProvidersEdgesSites) | **POST** /api/v2/telephony/providers/edges/sites | Create a Site.
[**postProvidersEdgesSitesSiteIdRebalance**](TelephonyProvidersEdgeApi.md#postProvidersEdgesSitesSiteIdRebalance) | **POST** /api/v2/telephony/providers/edges/sites/{siteId}/rebalance | Triggers the rebalance operation.
[**postProvidersEdgesTrunkbasesettings**](TelephonyProvidersEdgeApi.md#postProvidersEdgesTrunkbasesettings) | **POST** /api/v2/telephony/providers/edges/trunkbasesettings | Create a Trunk Base Settings object
[**putProvidersEdgesCertificateauthoritiesCertificateId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesCertificateauthoritiesCertificateId) | **PUT** /api/v2/telephony/providers/edges/certificateauthorities/{certificateId} | Update a certificate authority.
[**putProvidersEdgesDidpoolsDidpoolId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesDidpoolsDidpoolId) | **PUT** /api/v2/telephony/providers/edges/didpools/{didPoolId} | Update a DID Pool by ID.
[**putProvidersEdgesDidsDidId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesDidsDidId) | **PUT** /api/v2/telephony/providers/edges/dids/{didId} | Update a DID by ID.
[**putProvidersEdgesEdgeId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEdgeId) | **PUT** /api/v2/telephony/providers/edges/{edgeId} | Update a edge.
[**putProvidersEdgesEdgeIdLinesLineId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEdgeIdLinesLineId) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/lines/{lineId} | Update a line.
[**putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId) | **PUT** /api/v2/telephony/providers/edges/{edgeId}/logicalinterfaces/{interfaceId} | Update an edge logical interface.
[**putProvidersEdgesEdgegroupsEdgegroupId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEdgegroupsEdgegroupId) | **PUT** /api/v2/telephony/providers/edges/edgegroups/{edgeGroupId} | Update an edge group.
[**putProvidersEdgesEndpointsEndpointId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesEndpointsEndpointId) | **PUT** /api/v2/telephony/providers/edges/endpoints/{endpointId} | Update endpoint
[**putProvidersEdgesExtensionpoolsExtensionpoolId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesExtensionpoolsExtensionpoolId) | **PUT** /api/v2/telephony/providers/edges/extensionpools/{extensionPoolId} | Update an extension pool by ID
[**putProvidersEdgesExtensionsExtensionId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesExtensionsExtensionId) | **PUT** /api/v2/telephony/providers/edges/extensions/{extensionId} | Update an extension by ID.
[**putProvidersEdgesOutboundroutesOutboundrouteId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesOutboundroutesOutboundrouteId) | **PUT** /api/v2/telephony/providers/edges/outboundroutes/{outboundRouteId} | Update outbound route
[**putProvidersEdgesPhonebasesettingsPhonebaseId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesPhonebasesettingsPhonebaseId) | **PUT** /api/v2/telephony/providers/edges/phonebasesettings/{phoneBaseId} | Update a Phone Base Settings by ID
[**putProvidersEdgesPhonesPhoneId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesPhonesPhoneId) | **PUT** /api/v2/telephony/providers/edges/phones/{phoneId} | Update a Phone by ID
[**putProvidersEdgesSitesSiteId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesSitesSiteId) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId} | Update a Site by ID.
[**putProvidersEdgesSitesSiteIdNumberplans**](TelephonyProvidersEdgeApi.md#putProvidersEdgesSitesSiteIdNumberplans) | **PUT** /api/v2/telephony/providers/edges/sites/{siteId}/numberplans | Update the list of Number Plans.
[**putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**](TelephonyProvidersEdgeApi.md#putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId) | **PUT** /api/v2/telephony/providers/edges/trunkbasesettings/{trunkBaseSettingsId} | Update a Trunk Base Settings object by ID


# **deleteProvidersEdgesCertificateauthoritiesCertificateId**
> string deleteProvidersEdgesCertificateauthoritiesCertificateId($certificateId)

Delete a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$certificateId = "certificateId_example"; // string | Certificate ID

try {
    $result = $api_instance->deleteProvidersEdgesCertificateauthoritiesCertificateId($certificateId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesCertificateauthoritiesCertificateId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **certificateId** | **string**| Certificate ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesDidpoolsDidpoolId**
> string deleteProvidersEdgesDidpoolsDidpoolId($didPoolId)

Delete a DID Pool by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didPoolId = "didPoolId_example"; // string | DID pool ID

try {
    $result = $api_instance->deleteProvidersEdgesDidpoolsDidpoolId($didPoolId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesDidpoolsDidpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didPoolId** | **string**| DID pool ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEdgeId**
> string deleteProvidersEdgesEdgeId($edgeId)

Delete a edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->deleteProvidersEdgesEdgeId($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEdgeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**
> deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId)

Delete an edge logical interface



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$interfaceId = "interfaceId_example"; // string | Interface ID

try {
    $api_instance->deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEdgeIdLogicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **interfaceId** | **string**| Interface ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEdgeIdSoftwareupdate**
> string deleteProvidersEdgesEdgeIdSoftwareupdate($edgeId)

Cancels any in-progress update for this edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->deleteProvidersEdgesEdgeIdSoftwareupdate($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEdgeIdSoftwareupdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEdgegroupsEdgegroupId**
> string deleteProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId)

Delete an edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeGroupId = "edgeGroupId_example"; // string | Edge group ID

try {
    $result = $api_instance->deleteProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEdgegroupsEdgegroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeGroupId** | **string**| Edge group ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesEndpointsEndpointId**
> string deleteProvidersEdgesEndpointsEndpointId($endpointId)

Delete endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$endpointId = "endpointId_example"; // string | Endpoint ID

try {
    $result = $api_instance->deleteProvidersEdgesEndpointsEndpointId($endpointId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesEndpointsEndpointId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **endpointId** | **string**| Endpoint ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesExtensionpoolsExtensionpoolId**
> string deleteProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId)

Delete an extension pool by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionPoolId = "extensionPoolId_example"; // string | Extension pool ID

try {
    $result = $api_instance->deleteProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesExtensionpoolsExtensionpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionPoolId** | **string**| Extension pool ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesOutboundroutesOutboundrouteId**
> string deleteProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId)

Delete Outbound Route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$outboundRouteId = "outboundRouteId_example"; // string | Outbound route ID

try {
    $result = $api_instance->deleteProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outboundRouteId** | **string**| Outbound route ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesPhonebasesettingsPhonebaseId**
> string deleteProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId)

Delete a Phone Base Settings by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneBaseId = "phoneBaseId_example"; // string | Phone base ID

try {
    $result = $api_instance->deleteProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesPhonebasesettingsPhonebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneBaseId** | **string**| Phone base ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesPhonesPhoneId**
> string deleteProvidersEdgesPhonesPhoneId($phoneId)

Delete a Phone by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneId = "phoneId_example"; // string | Phone ID

try {
    $result = $api_instance->deleteProvidersEdgesPhonesPhoneId($phoneId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesPhonesPhoneId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneId** | **string**| Phone ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesSitesSiteId**
> string deleteProvidersEdgesSitesSiteId($siteId)

Delete a Site by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID

try {
    $result = $api_instance->deleteProvidersEdgesSitesSiteId($siteId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesSitesSiteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**
> string deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId)

Delete a Trunk Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkBaseSettingsId = "trunkBaseSettingsId_example"; // string | Trunk Base ID

try {
    $result = $api_instance->deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->deleteProvidersEdgesTrunkbasesettingsTrunkbasesettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkBaseSettingsId** | **string**| Trunk Base ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdges**
> \PureCloudSDK\EdgeEntityListing getProvidersEdges($pageSize, $pageNumber, $name, $siteId, $edgeGroupId, $sortBy)

Get the list of edges.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$siteId = "siteId_example"; // string | Filter by site.id
$edgeGroupId = "edgeGroupId_example"; // string | Filter by edgeGroup.id
$sortBy = "name"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdges($pageSize, $pageNumber, $name, $siteId, $edgeGroupId, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdges: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **siteId** | **string**| Filter by site.id | [optional]
 **edgeGroupId** | **string**| Filter by edgeGroup.id | [optional]
 **sortBy** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\EdgeEntityListing**](../Model/EdgeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesAvailablelanguages**
> \PureCloudSDK\AvailableLanguageList getProvidersEdgesAvailablelanguages()

Get the list of available languages.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();

try {
    $result = $api_instance->getProvidersEdgesAvailablelanguages();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesAvailablelanguages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\AvailableLanguageList**](../Model/AvailableLanguageList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesCertificateauthorities**
> \PureCloudSDK\CertificateAuthorityEntityListing getProvidersEdgesCertificateauthorities()

Get the list of certificate authorities.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();

try {
    $result = $api_instance->getProvidersEdgesCertificateauthorities();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesCertificateauthorities: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CertificateAuthorityEntityListing**](../Model/CertificateAuthorityEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesCertificateauthoritiesCertificateId**
> \PureCloudSDK\DomainCertificateAuthority getProvidersEdgesCertificateauthoritiesCertificateId($certificateId)

Get a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$certificateId = "certificateId_example"; // string | Certificate ID

try {
    $result = $api_instance->getProvidersEdgesCertificateauthoritiesCertificateId($certificateId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesCertificateauthoritiesCertificateId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **certificateId** | **string**| Certificate ID |

### Return type

[**\PureCloudSDK\DomainCertificateAuthority**](../Model/DomainCertificateAuthority.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesDidpools**
> \PureCloudSDK\DIDPoolEntityListing getProvidersEdgesDidpools($pageSize, $pageNumber, $sortBy)

Get a listing of DID Pools



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "number"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdgesDidpools($pageSize, $pageNumber, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesDidpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to number]

### Return type

[**\PureCloudSDK\DIDPoolEntityListing**](../Model/DIDPoolEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesDidpoolsDidpoolId**
> \PureCloudSDK\DIDPool getProvidersEdgesDidpoolsDidpoolId($didPoolId)

Get a DID Pool by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didPoolId = "didPoolId_example"; // string | DID pool ID

try {
    $result = $api_instance->getProvidersEdgesDidpoolsDidpoolId($didPoolId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesDidpoolsDidpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didPoolId** | **string**| DID pool ID |

### Return type

[**\PureCloudSDK\DIDPool**](../Model/DIDPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesDids**
> \PureCloudSDK\DIDEntityListing getProvidersEdgesDids($pageSize, $pageNumber, $sortBy, $sortOrder, $phoneNumber)

Get a listing of DIDs



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "number"; // string | Sort by
$sortOrder = "asc"; // string | Sort order
$phoneNumber = "phoneNumber_example"; // string | Filter by phoneNumber

try {
    $result = $api_instance->getProvidersEdgesDids($pageSize, $pageNumber, $sortBy, $sortOrder, $phoneNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesDids: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to number]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **phoneNumber** | **string**| Filter by phoneNumber | [optional]

### Return type

[**\PureCloudSDK\DIDEntityListing**](../Model/DIDEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesDidsDidId**
> \PureCloudSDK\DID getProvidersEdgesDidsDidId($didId)

Get a DID by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didId = "didId_example"; // string | DID ID

try {
    $result = $api_instance->getProvidersEdgesDidsDidId($didId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesDidsDidId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didId** | **string**| DID ID |

### Return type

[**\PureCloudSDK\DID**](../Model/DID.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeId**
> \PureCloudSDK\Edge getProvidersEdgesEdgeId($edgeId)

Get edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeId($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\Edge**](../Model/Edge.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLines**
> \PureCloudSDK\EdgeLineEntityListing getProvidersEdgesEdgeIdLines($edgeId, $pageSize, $pageNumber)

Get the list of lines.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLines($edgeId, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLines: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\EdgeLineEntityListing**](../Model/EdgeLineEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLinesLineId**
> \PureCloudSDK\EdgeLine getProvidersEdgesEdgeIdLinesLineId($edgeId, $lineId)

Get line



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$lineId = "lineId_example"; // string | Line ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLinesLineId($edgeId, $lineId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLinesLineId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **lineId** | **string**| Line ID |

### Return type

[**\PureCloudSDK\EdgeLine**](../Model/EdgeLine.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLogicalinterfaces**
> \PureCloudSDK\LogicalInterfaceEntityListing getProvidersEdgesEdgeIdLogicalinterfaces($edgeId, $expand)

Get edge logical interfaces.

Retrieve a list of all configured logical interfaces from a specific edge.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$expand = array("expand_example"); // string[] | Field to expand in the response

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLogicalinterfaces($edgeId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLogicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **expand** | [**string[]**](../Model/string.md)| Field to expand in the response | [optional]

### Return type

[**\PureCloudSDK\LogicalInterfaceEntityListing**](../Model/LogicalInterfaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**
> \PureCloudSDK\DomainLogicalInterface getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId, $expand)

Get an edge logical interface



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$interfaceId = "interfaceId_example"; // string | Interface ID
$expand = array("expand_example"); // string[] | Field to expand in the response

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLogicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **interfaceId** | **string**| Interface ID |
 **expand** | [**string[]**](../Model/string.md)| Field to expand in the response | [optional]

### Return type

[**\PureCloudSDK\DomainLogicalInterface**](../Model/DomainLogicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdLogsJobsJobId**
> \PureCloudSDK\EdgeLogsJob getProvidersEdgesEdgeIdLogsJobsJobId($edgeId, $jobId)

Get an Edge logs job.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$jobId = "jobId_example"; // string | Job ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdLogsJobsJobId($edgeId, $jobId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdLogsJobsJobId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **jobId** | **string**| Job ID |

### Return type

[**\PureCloudSDK\EdgeLogsJob**](../Model/EdgeLogsJob.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdPhysicalinterfaces**
> \PureCloudSDK\PhysicalInterfaceEntityListing getProvidersEdgesEdgeIdPhysicalinterfaces($edgeId)

Retrieve a list of all configured physical interfaces from a specific edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdPhysicalinterfaces($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdPhysicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\PhysicalInterfaceEntityListing**](../Model/PhysicalInterfaceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId**
> \PureCloudSDK\DomainPhysicalInterface getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId($edgeId, $interfaceId)

Get edge physical interface.

Retrieve a physical interface from a specific edge.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$interfaceId = "interfaceId_example"; // string | Interface ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId($edgeId, $interfaceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdPhysicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **interfaceId** | **string**| Interface ID |

### Return type

[**\PureCloudSDK\DomainPhysicalInterface**](../Model/DomainPhysicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdSetuppackage**
> \PureCloudSDK\VmPairingInfo getProvidersEdgesEdgeIdSetuppackage($edgeId)

Get the setup package for a locally deployed edge device. This is needed to complete the setup process for the virtual edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdSetuppackage($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdSetuppackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\VmPairingInfo**](../Model/VmPairingInfo.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdSoftwareupdate**
> \PureCloudSDK\DomainEdgeSoftwareUpdateDto getProvidersEdgesEdgeIdSoftwareupdate($edgeId)

Gets software update status information about any edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdSoftwareupdate($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdSoftwareupdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\DomainEdgeSoftwareUpdateDto**](../Model/DomainEdgeSoftwareUpdateDto.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeIdSoftwareversions**
> \PureCloudSDK\DomainEdgeSoftwareVersionDtoEntityListing getProvidersEdgesEdgeIdSoftwareversions($edgeId)

Gets all the available software versions for this edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->getProvidersEdgesEdgeIdSoftwareversions($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeIdSoftwareversions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

[**\PureCloudSDK\DomainEdgeSoftwareVersionDtoEntityListing**](../Model/DomainEdgeSoftwareVersionDtoEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgegroups**
> \PureCloudSDK\EdgeGroupEntityListing getProvidersEdgesEdgegroups($pageSize, $pageNumber, $name, $sortBy)

Get the list of edge groups.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$sortBy = "name"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdgesEdgegroups($pageSize, $pageNumber, $name, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgegroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\EdgeGroupEntityListing**](../Model/EdgeGroupEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgegroupsEdgegroupId**
> \PureCloudSDK\EdgeGroup getProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId, $expand)

Get edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeGroupId = "edgeGroupId_example"; // string | Edge group ID
$expand = array("expand_example"); // string[] | Fields to expand in the response

try {
    $result = $api_instance->getProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgegroupsEdgegroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeGroupId** | **string**| Edge group ID |
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response | [optional]

### Return type

[**\PureCloudSDK\EdgeGroup**](../Model/EdgeGroup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEdgeversionreport**
> \PureCloudSDK\EdgeVersionReport getProvidersEdgesEdgeversionreport()

Get the edge version report.

The report will not have consistent data about the edge version(s) until all edges have been reset.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();

try {
    $result = $api_instance->getProvidersEdgesEdgeversionreport();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEdgeversionreport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EdgeVersionReport**](../Model/EdgeVersionReport.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEndpoints**
> \PureCloudSDK\EndpointEntityListing getProvidersEdgesEndpoints($pageSize, $pageNumber, $name, $sortBy)

Get endpoints



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$sortBy = "name"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdgesEndpoints($pageSize, $pageNumber, $name, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEndpoints: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\EndpointEntityListing**](../Model/EndpointEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesEndpointsEndpointId**
> \PureCloudSDK\Endpoint getProvidersEdgesEndpointsEndpointId($endpointId)

Get endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$endpointId = "endpointId_example"; // string | Endpoint ID

try {
    $result = $api_instance->getProvidersEdgesEndpointsEndpointId($endpointId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesEndpointsEndpointId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **endpointId** | **string**| Endpoint ID |

### Return type

[**\PureCloudSDK\Endpoint**](../Model/Endpoint.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesExtensionpools**
> \PureCloudSDK\ExtensionPoolEntityListing getProvidersEdgesExtensionpools($pageSize, $pageNumber, $sortBy, $number)

Get a listing of extension pools



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "startNumber"; // string | Sort by
$number = "number_example"; // string | Number

try {
    $result = $api_instance->getProvidersEdgesExtensionpools($pageSize, $pageNumber, $sortBy, $number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesExtensionpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to startNumber]
 **number** | **string**| Number | [optional]

### Return type

[**\PureCloudSDK\ExtensionPoolEntityListing**](../Model/ExtensionPoolEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesExtensionpoolsExtensionpoolId**
> \PureCloudSDK\ExtensionPool getProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId)

Get an extension pool by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionPoolId = "extensionPoolId_example"; // string | Extension pool ID

try {
    $result = $api_instance->getProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesExtensionpoolsExtensionpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionPoolId** | **string**| Extension pool ID |

### Return type

[**\PureCloudSDK\ExtensionPool**](../Model/ExtensionPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesExtensions**
> \PureCloudSDK\ExtensionEntityListing getProvidersEdgesExtensions($pageSize, $pageNumber, $sortBy, $sortOrder, $number)

Get a listing of extensions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "number"; // string | Sort by
$sortOrder = "asc"; // string | Sort order
$number = "number_example"; // string | Filter by number

try {
    $result = $api_instance->getProvidersEdgesExtensions($pageSize, $pageNumber, $sortBy, $sortOrder, $number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesExtensions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to number]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **number** | **string**| Filter by number | [optional]

### Return type

[**\PureCloudSDK\ExtensionEntityListing**](../Model/ExtensionEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesExtensionsExtensionId**
> \PureCloudSDK\Extension getProvidersEdgesExtensionsExtensionId($extensionId)

Get an extension by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionId = "extensionId_example"; // string | Extension ID

try {
    $result = $api_instance->getProvidersEdgesExtensionsExtensionId($extensionId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesExtensionsExtensionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionId** | **string**| Extension ID |

### Return type

[**\PureCloudSDK\Extension**](../Model/Extension.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLinebasesettings**
> \PureCloudSDK\LineBaseEntityListing getProvidersEdgesLinebasesettings($pageNumber, $pageSize, $sortBy, $sortOrder)

Get a listing of line base settings objects



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "asc"; // string | Sort order

try {
    $result = $api_instance->getProvidersEdgesLinebasesettings($pageNumber, $pageSize, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLinebasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]

### Return type

[**\PureCloudSDK\LineBaseEntityListing**](../Model/LineBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLinebasesettingsLinebaseId**
> \PureCloudSDK\LineBase getProvidersEdgesLinebasesettingsLinebaseId($lineBaseId)

Get a line base settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$lineBaseId = "lineBaseId_example"; // string | Line base ID

try {
    $result = $api_instance->getProvidersEdgesLinebasesettingsLinebaseId($lineBaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLinebasesettingsLinebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **lineBaseId** | **string**| Line base ID |

### Return type

[**\PureCloudSDK\LineBase**](../Model/LineBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLines**
> \PureCloudSDK\LineEntityListing getProvidersEdgesLines($pageSize, $pageNumber, $name, $sortBy, $expand)

Get a list of Lines



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$sortBy = "name"; // string | Value by which to sort
$expand = array("expand_example"); // string[] | Fields to expand in the response, comma-separated

try {
    $result = $api_instance->getProvidersEdgesLines($pageSize, $pageNumber, $name, $sortBy, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLines: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response, comma-separated | [optional]

### Return type

[**\PureCloudSDK\LineEntityListing**](../Model/LineEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLinesLineId**
> \PureCloudSDK\Line getProvidersEdgesLinesLineId($lineId)

Get a Line by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$lineId = "lineId_example"; // string | Line ID

try {
    $result = $api_instance->getProvidersEdgesLinesLineId($lineId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLinesLineId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **lineId** | **string**| Line ID |

### Return type

[**\PureCloudSDK\Line**](../Model/Line.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesLinesTemplate**
> \PureCloudSDK\Line getProvidersEdgesLinesTemplate($lineBaseSettingsId)

Get a Line instance template based on a Line Base Settings object. This object can then be modified and saved as a new Line instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$lineBaseSettingsId = "lineBaseSettingsId_example"; // string | The id of a Line Base Settings object upon which to base this Line

try {
    $result = $api_instance->getProvidersEdgesLinesTemplate($lineBaseSettingsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesLinesTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **lineBaseSettingsId** | **string**| The id of a Line Base Settings object upon which to base this Line |

### Return type

[**\PureCloudSDK\Line**](../Model/Line.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesOutboundroutes**
> \PureCloudSDK\OutboundRouteEntityListing getProvidersEdgesOutboundroutes($pageSize, $pageNumber, $name, $siteId, $sortBy)

Get outbound routes



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$name = "name_example"; // string | Name
$siteId = "siteId_example"; // string | Filter by site.id
$sortBy = "name"; // string | Sort by

try {
    $result = $api_instance->getProvidersEdgesOutboundroutes($pageSize, $pageNumber, $name, $siteId, $sortBy);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesOutboundroutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **name** | **string**| Name | [optional]
 **siteId** | **string**| Filter by site.id | [optional]
 **sortBy** | **string**| Sort by | [optional] [default to name]

### Return type

[**\PureCloudSDK\OutboundRouteEntityListing**](../Model/OutboundRouteEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesOutboundroutesOutboundrouteId**
> \PureCloudSDK\OutboundRoute getProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId)

Get outbound route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$outboundRouteId = "outboundRouteId_example"; // string | Outbound route ID

try {
    $result = $api_instance->getProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outboundRouteId** | **string**| Outbound route ID |

### Return type

[**\PureCloudSDK\OutboundRoute**](../Model/OutboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonebasesettings**
> \PureCloudSDK\PhoneBaseEntityListing getProvidersEdgesPhonebasesettings($pageNumber, $pageSize, $sortBy, $sortOrder)

Get a list of Phone Base Settings objects



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "asc"; // string | Sort order

try {
    $result = $api_instance->getProvidersEdgesPhonebasesettings($pageNumber, $pageSize, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonebasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]

### Return type

[**\PureCloudSDK\PhoneBaseEntityListing**](../Model/PhoneBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonebasesettingsAvailablemetabases**
> \PureCloudSDK\PhoneMetaBaseEntityListing getProvidersEdgesPhonebasesettingsAvailablemetabases($pageSize, $pageNumber)

Get a list of available makes and models to create a new Phone Base Settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getProvidersEdgesPhonebasesettingsAvailablemetabases($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonebasesettingsAvailablemetabases: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\PhoneMetaBaseEntityListing**](../Model/PhoneMetaBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonebasesettingsPhonebaseId**
> \PureCloudSDK\PhoneBase getProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId)

Get a Phone Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneBaseId = "phoneBaseId_example"; // string | Phone base ID

try {
    $result = $api_instance->getProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonebasesettingsPhonebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneBaseId** | **string**| Phone base ID |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonebasesettingsTemplate**
> \PureCloudSDK\PhoneBase getProvidersEdgesPhonebasesettingsTemplate($phoneMetabaseId)

Get a Phone Base Settings instance template from a given make and model. This object can then be modified and saved as a new Phone Base Settings instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneMetabaseId = "phoneMetabaseId_example"; // string | The id of a metabase object upon which to base this Phone Base Settings

try {
    $result = $api_instance->getProvidersEdgesPhonebasesettingsTemplate($phoneMetabaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonebasesettingsTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneMetabaseId** | **string**| The id of a metabase object upon which to base this Phone Base Settings |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhones**
> \PureCloudSDK\PhoneEntityListing getProvidersEdgesPhones($pageNumber, $pageSize, $sortBy, $sortOrder, $siteId, $webRtcUserId, $phoneBaseSettingsId, $linesLoggedInUserId, $linesDefaultForUserId, $phoneHardwareId, $linesId, $linesName, $expand, $fields)

Get a list of Phone Instances



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "asc"; // string | Sort order
$siteId = "siteId_example"; // string | Filter by site.id
$webRtcUserId = "webRtcUserId_example"; // string | Filter by webRtcUser.id
$phoneBaseSettingsId = "phoneBaseSettingsId_example"; // string | Filter by phoneBaseSettings.id
$linesLoggedInUserId = "linesLoggedInUserId_example"; // string | Filter by lines.loggedInUser.id
$linesDefaultForUserId = "linesDefaultForUserId_example"; // string | Filter by lines.defaultForUser.id
$phoneHardwareId = "phoneHardwareId_example"; // string | Filter by phone_hardwareId
$linesId = "linesId_example"; // string | Filter by lines.id
$linesName = "linesName_example"; // string | Filter by lines.name
$expand = array("expand_example"); // string[] | Fields to expand in the response, comma-separated
$fields = array("fields_example"); // string[] | Fields and properties to get, comma-separated

try {
    $result = $api_instance->getProvidersEdgesPhones($pageNumber, $pageSize, $sortBy, $sortOrder, $siteId, $webRtcUserId, $phoneBaseSettingsId, $linesLoggedInUserId, $linesDefaultForUserId, $phoneHardwareId, $linesId, $linesName, $expand, $fields);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **siteId** | **string**| Filter by site.id | [optional]
 **webRtcUserId** | **string**| Filter by webRtcUser.id | [optional]
 **phoneBaseSettingsId** | **string**| Filter by phoneBaseSettings.id | [optional]
 **linesLoggedInUserId** | **string**| Filter by lines.loggedInUser.id | [optional]
 **linesDefaultForUserId** | **string**| Filter by lines.defaultForUser.id | [optional]
 **phoneHardwareId** | **string**| Filter by phone_hardwareId | [optional]
 **linesId** | **string**| Filter by lines.id | [optional]
 **linesName** | **string**| Filter by lines.name | [optional]
 **expand** | [**string[]**](../Model/string.md)| Fields to expand in the response, comma-separated | [optional]
 **fields** | [**string[]**](../Model/string.md)| Fields and properties to get, comma-separated | [optional]

### Return type

[**\PureCloudSDK\PhoneEntityListing**](../Model/PhoneEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonesPhoneId**
> \PureCloudSDK\Phone getProvidersEdgesPhonesPhoneId($phoneId)

Get a Phone by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneId = "phoneId_example"; // string | Phone ID

try {
    $result = $api_instance->getProvidersEdgesPhonesPhoneId($phoneId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonesPhoneId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneId** | **string**| Phone ID |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesPhonesTemplate**
> \PureCloudSDK\Phone getProvidersEdgesPhonesTemplate($phoneBaseSettingsId)

Get a Phone instance template based on a Phone Base Settings object. This object can then be modified and saved as a new Phone instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneBaseSettingsId = "phoneBaseSettingsId_example"; // string | The id of a Phone Base Settings object upon which to base this Phone

try {
    $result = $api_instance->getProvidersEdgesPhonesTemplate($phoneBaseSettingsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesPhonesTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneBaseSettingsId** | **string**| The id of a Phone Base Settings object upon which to base this Phone |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSites**
> \PureCloudSDK\SiteEntityListing getProvidersEdgesSites($pageSize, $pageNumber, $sortBy, $sortOrder, $name, $locationId)

Get the list of Sites.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "name"; // string | Sort by
$sortOrder = "asc"; // string | Sort order
$name = "name_example"; // string | Name
$locationId = "locationId_example"; // string | Location Id

try {
    $result = $api_instance->getProvidersEdgesSites($pageSize, $pageNumber, $sortBy, $sortOrder, $name, $locationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSites: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **name** | **string**| Name | [optional]
 **locationId** | **string**| Location Id | [optional]

### Return type

[**\PureCloudSDK\SiteEntityListing**](../Model/SiteEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSitesSiteId**
> \PureCloudSDK\Site getProvidersEdgesSitesSiteId($siteId)

Get a Site by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID

try {
    $result = $api_instance->getProvidersEdgesSitesSiteId($siteId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSitesSiteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |

### Return type

[**\PureCloudSDK\Site**](../Model/Site.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSitesSiteIdNumberplans**
> \PureCloudSDK\NumberPlan[] getProvidersEdgesSitesSiteIdNumberplans($siteId)

Get the list of Number Plans for this Site.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID

try {
    $result = $api_instance->getProvidersEdgesSitesSiteIdNumberplans($siteId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSitesSiteIdNumberplans: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |

### Return type

[**\PureCloudSDK\NumberPlan[]**](../Model/NumberPlan.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSitesSiteIdNumberplansClassifications**
> string[] getProvidersEdgesSitesSiteIdNumberplansClassifications($siteId, $classification)

Get a list of Classifications for this Site



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$classification = "classification_example"; // string | Classification

try {
    $result = $api_instance->getProvidersEdgesSitesSiteIdNumberplansClassifications($siteId, $classification);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSitesSiteIdNumberplansClassifications: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **classification** | **string**| Classification | [optional]

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesSitesSiteIdNumberplansNumberplanId**
> \PureCloudSDK\NumberPlan getProvidersEdgesSitesSiteIdNumberplansNumberplanId($siteId, $numberPlanId)

Get a Number Plan by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$numberPlanId = "numberPlanId_example"; // string | Number Plan ID

try {
    $result = $api_instance->getProvidersEdgesSitesSiteIdNumberplansNumberplanId($siteId, $numberPlanId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesSitesSiteIdNumberplansNumberplanId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **numberPlanId** | **string**| Number Plan ID |

### Return type

[**\PureCloudSDK\NumberPlan**](../Model/NumberPlan.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTimezones**
> \PureCloudSDK\TimeZoneEntityListing getProvidersEdgesTimezones($pageSize, $pageNumber)

Get a list of Edge-compatible time zones



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 1000; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getProvidersEdgesTimezones($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTimezones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 1000]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\TimeZoneEntityListing**](../Model/TimeZoneEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkbasesettings**
> \PureCloudSDK\TrunkBaseEntityListing getProvidersEdgesTrunkbasesettings($pageNumber, $pageSize, $sortBy, $sortOrder, $recordingEnabled)

Get Trunk Base Settings listing



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "asc"; // string | Sort order
$recordingEnabled = true; // bool | Filter trunks by recording enabled

try {
    $result = $api_instance->getProvidersEdgesTrunkbasesettings($pageNumber, $pageSize, $sortBy, $sortOrder, $recordingEnabled);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkbasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **recordingEnabled** | **bool**| Filter trunks by recording enabled | [optional]

### Return type

[**\PureCloudSDK\TrunkBaseEntityListing**](../Model/TrunkBaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkbasesettingsAvailablemetabases**
> \PureCloudSDK\TrunkMetabaseEntityListing getProvidersEdgesTrunkbasesettingsAvailablemetabases($type, $pageSize, $pageNumber)

Get a list of available makes and models to create a new Trunk Base Settings



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$type = "type_example"; // string | 
$pageSize = 25; // int | 
$pageNumber = 1; // int | 

try {
    $result = $api_instance->getProvidersEdgesTrunkbasesettingsAvailablemetabases($type, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkbasesettingsAvailablemetabases: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**|  | [optional]
 **pageSize** | **int**|  | [optional] [default to 25]
 **pageNumber** | **int**|  | [optional] [default to 1]

### Return type

[**\PureCloudSDK\TrunkMetabaseEntityListing**](../Model/TrunkMetabaseEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkbasesettingsTemplate**
> \PureCloudSDK\TrunkBase getProvidersEdgesTrunkbasesettingsTemplate($trunkMetabaseId)

Get a Trunk Base Settings instance template from a given make and model. This object can then be modified and saved as a new Trunk Base Settings instance



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkMetabaseId = "trunkMetabaseId_example"; // string | The id of a metabase object upon which to base this Trunk Base Settings

try {
    $result = $api_instance->getProvidersEdgesTrunkbasesettingsTemplate($trunkMetabaseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkbasesettingsTemplate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkMetabaseId** | **string**| The id of a metabase object upon which to base this Trunk Base Settings |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**
> \PureCloudSDK\TrunkBase getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId)

Get a Trunk Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkBaseSettingsId = "trunkBaseSettingsId_example"; // string | Trunk Base ID

try {
    $result = $api_instance->getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkbasesettingsTrunkbasesettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkBaseSettingsId** | **string**| Trunk Base ID |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunks**
> \PureCloudSDK\TrunkEntityListing getProvidersEdgesTrunks($pageNumber, $pageSize, $sortBy, $sortOrder, $edgeId, $trunkBaseId, $trunkType)

Get the list of available trunks.

Trunks are created by assigning trunk base settings to an Edge or Edge Group.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "name"; // string | Value by which to sort
$sortOrder = "asc"; // string | Sort order
$edgeId = "edgeId_example"; // string | Filter by Edge Ids
$trunkBaseId = "trunkBaseId_example"; // string | Filter by Trunk Base Ids
$trunkType = "trunkType_example"; // string | Filter by a Trunk type

try {
    $result = $api_instance->getProvidersEdgesTrunks($pageNumber, $pageSize, $sortBy, $sortOrder, $edgeId, $trunkBaseId, $trunkType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Value by which to sort | [optional] [default to name]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **edgeId** | **string**| Filter by Edge Ids | [optional]
 **trunkBaseId** | **string**| Filter by Trunk Base Ids | [optional]
 **trunkType** | **string**| Filter by a Trunk type | [optional]

### Return type

[**\PureCloudSDK\TrunkEntityListing**](../Model/TrunkEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunksTrunkId**
> \PureCloudSDK\Trunk getProvidersEdgesTrunksTrunkId($trunkId)

Get a Trunk by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkId = "trunkId_example"; // string | Trunk ID

try {
    $result = $api_instance->getProvidersEdgesTrunksTrunkId($trunkId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunksTrunkId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkId** | **string**| Trunk ID |

### Return type

[**\PureCloudSDK\Trunk**](../Model/Trunk.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProvidersEdgesTrunkswithrecording**
> \PureCloudSDK\TrunkRecordingEnabledCount getProvidersEdgesTrunkswithrecording($trunkType)

Get Counts of trunks that have recording disabled or enabled



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkType = "trunkType_example"; // string | The type of this trunk base.

try {
    $result = $api_instance->getProvidersEdgesTrunkswithrecording($trunkType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getProvidersEdgesTrunkswithrecording: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkType** | **string**| The type of this trunk base. | [optional]

### Return type

[**\PureCloudSDK\TrunkRecordingEnabledCount**](../Model/TrunkRecordingEnabledCount.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnext**
> \PureCloudSDK\SchemaCategoryEntityListing getSchemasEdgesVnext($pageSize, $pageNumber)

Lists available schema categories



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getSchemasEdgesVnext($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnext: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SchemaCategoryEntityListing**](../Model/SchemaCategoryEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnextSchemacategory**
> \PureCloudSDK\SchemaReferenceEntityListing getSchemasEdgesVnextSchemacategory($schemaCategory, $pageSize, $pageNumber)

List schemas of a specific category



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schemaCategory = "schemaCategory_example"; // string | Schema category
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getSchemasEdgesVnextSchemacategory($schemaCategory, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnextSchemacategory: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schemaCategory** | **string**| Schema category |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SchemaReferenceEntityListing**](../Model/SchemaReferenceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnextSchemacategorySchematype**
> \PureCloudSDK\SchemaReferenceEntityListing getSchemasEdgesVnextSchemacategorySchematype($schemaCategory, $schemaType, $pageSize, $pageNumber)

List schemas of a specific category



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schemaCategory = "schemaCategory_example"; // string | Schema category
$schemaType = "schemaType_example"; // string | Schema type
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getSchemasEdgesVnextSchemacategorySchematype($schemaCategory, $schemaType, $pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnextSchemacategorySchematype: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schemaCategory** | **string**| Schema category |
 **schemaType** | **string**| Schema type |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\SchemaReferenceEntityListing**](../Model/SchemaReferenceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnextSchemacategorySchematypeSchemaId**
> \PureCloudSDK\Organization getSchemasEdgesVnextSchemacategorySchematypeSchemaId($schemaCategory, $schemaType, $schemaId)

Get a json schema



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schemaCategory = "schemaCategory_example"; // string | Schema category
$schemaType = "schemaType_example"; // string | Schema type
$schemaId = "schemaId_example"; // string | Schema ID

try {
    $result = $api_instance->getSchemasEdgesVnextSchemacategorySchematypeSchemaId($schemaCategory, $schemaType, $schemaId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnextSchemacategorySchematypeSchemaId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schemaCategory** | **string**| Schema category |
 **schemaType** | **string**| Schema type |
 **schemaId** | **string**| Schema ID |

### Return type

[**\PureCloudSDK\Organization**](../Model/Organization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId**
> \PureCloudSDK\Organization getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId($schemaCategory, $schemaType, $schemaId, $extensionType, $metadataId, $type)

Get metadata for a schema



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$schemaCategory = "schemaCategory_example"; // string | Schema category
$schemaType = "schemaType_example"; // string | Schema type
$schemaId = "schemaId_example"; // string | Schema ID
$extensionType = "extensionType_example"; // string | extension
$metadataId = "metadataId_example"; // string | Metadata ID
$type = "type_example"; // string | Type

try {
    $result = $api_instance->getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId($schemaCategory, $schemaType, $schemaId, $extensionType, $metadataId, $type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->getSchemasEdgesVnextSchemacategorySchematypeSchemaIdExtensiontypeMetadataId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schemaCategory** | **string**| Schema category |
 **schemaType** | **string**| Schema type |
 **schemaId** | **string**| Schema ID |
 **extensionType** | **string**| extension |
 **metadataId** | **string**| Metadata ID |
 **type** | **string**| Type | [optional]

### Return type

[**\PureCloudSDK\Organization**](../Model/Organization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdges**
> \PureCloudSDK\Edge postProvidersEdges($body)

Create an edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Edge(); // \PureCloudSDK\Edge | Edge

try {
    $result = $api_instance->postProvidersEdges($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdges: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Edge**](../Model/\PureCloudSDK\Edge.md)| Edge |

### Return type

[**\PureCloudSDK\Edge**](../Model/Edge.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesAddressvalidation**
> \PureCloudSDK\ValidateAddressResponse postProvidersEdgesAddressvalidation($body)

Validates a street address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\ValidateAddressRequest(); // \PureCloudSDK\ValidateAddressRequest | Address

try {
    $result = $api_instance->postProvidersEdgesAddressvalidation($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesAddressvalidation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ValidateAddressRequest**](../Model/\PureCloudSDK\ValidateAddressRequest.md)| Address |

### Return type

[**\PureCloudSDK\ValidateAddressResponse**](../Model/ValidateAddressResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesCertificateauthorities**
> \PureCloudSDK\DomainCertificateAuthority postProvidersEdgesCertificateauthorities($body)

Create a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\DomainCertificateAuthority(); // \PureCloudSDK\DomainCertificateAuthority | CertificateAuthority

try {
    $result = $api_instance->postProvidersEdgesCertificateauthorities($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesCertificateauthorities: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DomainCertificateAuthority**](../Model/\PureCloudSDK\DomainCertificateAuthority.md)| CertificateAuthority |

### Return type

[**\PureCloudSDK\DomainCertificateAuthority**](../Model/DomainCertificateAuthority.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesDidpools**
> \PureCloudSDK\DIDPool postProvidersEdgesDidpools($body)

Create a new DID pool



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\DIDPool(); // \PureCloudSDK\DIDPool | DID pool

try {
    $result = $api_instance->postProvidersEdgesDidpools($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesDidpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DIDPool**](../Model/\PureCloudSDK\DIDPool.md)| DID pool |

### Return type

[**\PureCloudSDK\DIDPool**](../Model/DIDPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdLogicalinterfaces**
> \PureCloudSDK\DomainLogicalInterface postProvidersEdgesEdgeIdLogicalinterfaces($edgeId, $body)

Create an edge logical interface.

Create

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\DomainLogicalInterface(); // \PureCloudSDK\DomainLogicalInterface | Logical interface

try {
    $result = $api_instance->postProvidersEdgesEdgeIdLogicalinterfaces($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdLogicalinterfaces: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\DomainLogicalInterface**](../Model/\PureCloudSDK\DomainLogicalInterface.md)| Logical interface |

### Return type

[**\PureCloudSDK\DomainLogicalInterface**](../Model/DomainLogicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdLogsJobs**
> \PureCloudSDK\EdgeLogsJobResponse postProvidersEdgesEdgeIdLogsJobs($edgeId, $body)

Create a job to upload a list of Edge logs.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\EdgeLogsJobRequest(); // \PureCloudSDK\EdgeLogsJobRequest | EdgeLogsJobRequest

try {
    $result = $api_instance->postProvidersEdgesEdgeIdLogsJobs($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdLogsJobs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\EdgeLogsJobRequest**](../Model/\PureCloudSDK\EdgeLogsJobRequest.md)| EdgeLogsJobRequest |

### Return type

[**\PureCloudSDK\EdgeLogsJobResponse**](../Model/EdgeLogsJobResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdLogsJobsJobIdUpload**
> postProvidersEdgesEdgeIdLogsJobsJobIdUpload($edgeId, $jobId, $body)

Request that the specified fileIds be uploaded from the Edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$jobId = "jobId_example"; // string | Job ID
$body = new \PureCloudSDK\EdgeLogsJobUploadRequest(); // \PureCloudSDK\EdgeLogsJobUploadRequest | Log upload request

try {
    $api_instance->postProvidersEdgesEdgeIdLogsJobsJobIdUpload($edgeId, $jobId, $body);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdLogsJobsJobIdUpload: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **jobId** | **string**| Job ID |
 **body** | [**\PureCloudSDK\EdgeLogsJobUploadRequest**](../Model/\PureCloudSDK\EdgeLogsJobUploadRequest.md)| Log upload request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdReboot**
> string postProvidersEdgesEdgeIdReboot($edgeId)

Reboot an Edge



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID

try {
    $result = $api_instance->postProvidersEdgesEdgeIdReboot($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdReboot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdSoftwareupdate**
> \PureCloudSDK\DomainEdgeSoftwareUpdateDto postProvidersEdgesEdgeIdSoftwareupdate($edgeId, $body)

Starts a software update for this edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\DomainEdgeSoftwareUpdateDto(); // \PureCloudSDK\DomainEdgeSoftwareUpdateDto | Software update request

try {
    $result = $api_instance->postProvidersEdgesEdgeIdSoftwareupdate($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdSoftwareupdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\DomainEdgeSoftwareUpdateDto**](../Model/\PureCloudSDK\DomainEdgeSoftwareUpdateDto.md)| Software update request |

### Return type

[**\PureCloudSDK\DomainEdgeSoftwareUpdateDto**](../Model/DomainEdgeSoftwareUpdateDto.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgeIdUnpair**
> string postProvidersEdgesEdgeIdUnpair($edgeId)

Unpair an Edge



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge Id

try {
    $result = $api_instance->postProvidersEdgesEdgeIdUnpair($edgeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgeIdUnpair: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge Id |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEdgegroups**
> \PureCloudSDK\EdgeGroup postProvidersEdgesEdgegroups($body)

Create an edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\EdgeGroup(); // \PureCloudSDK\EdgeGroup | EdgeGroup

try {
    $result = $api_instance->postProvidersEdgesEdgegroups($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEdgegroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EdgeGroup**](../Model/\PureCloudSDK\EdgeGroup.md)| EdgeGroup |

### Return type

[**\PureCloudSDK\EdgeGroup**](../Model/EdgeGroup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesEndpoints**
> \PureCloudSDK\Endpoint postProvidersEdgesEndpoints($body)

Create endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Endpoint(); // \PureCloudSDK\Endpoint | EndpointTemplate

try {
    $result = $api_instance->postProvidersEdgesEndpoints($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesEndpoints: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Endpoint**](../Model/\PureCloudSDK\Endpoint.md)| EndpointTemplate |

### Return type

[**\PureCloudSDK\Endpoint**](../Model/Endpoint.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesExtensionpools**
> \PureCloudSDK\ExtensionPool postProvidersEdgesExtensionpools($body)

Create a new extension pool



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\ExtensionPool(); // \PureCloudSDK\ExtensionPool | ExtensionPool

try {
    $result = $api_instance->postProvidersEdgesExtensionpools($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesExtensionpools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ExtensionPool**](../Model/\PureCloudSDK\ExtensionPool.md)| ExtensionPool |

### Return type

[**\PureCloudSDK\ExtensionPool**](../Model/ExtensionPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesOfflineconfiguration**
> \PureCloudSDK\EdgeOfflineConfigurationResponse postProvidersEdgesOfflineconfiguration($body)

Create a file that can be used to configure a hardware Edge's settings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\EdgeOfflineConfiguration(); // \PureCloudSDK\EdgeOfflineConfiguration | EdgeOfflineConfiguration

try {
    $result = $api_instance->postProvidersEdgesOfflineconfiguration($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesOfflineconfiguration: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\EdgeOfflineConfiguration**](../Model/\PureCloudSDK\EdgeOfflineConfiguration.md)| EdgeOfflineConfiguration |

### Return type

[**\PureCloudSDK\EdgeOfflineConfigurationResponse**](../Model/EdgeOfflineConfigurationResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesOutboundroutes**
> \PureCloudSDK\OutboundRoute postProvidersEdgesOutboundroutes($body)

Create outbound rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\OutboundRoute(); // \PureCloudSDK\OutboundRoute | OutboundRoute

try {
    $result = $api_instance->postProvidersEdgesOutboundroutes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesOutboundroutes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OutboundRoute**](../Model/\PureCloudSDK\OutboundRoute.md)| OutboundRoute |

### Return type

[**\PureCloudSDK\OutboundRoute**](../Model/OutboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesPhonebasesettings**
> \PureCloudSDK\PhoneBase postProvidersEdgesPhonebasesettings($body)

Create a new Phone Base Settings object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\PhoneBase(); // \PureCloudSDK\PhoneBase | Phone base settings

try {
    $result = $api_instance->postProvidersEdgesPhonebasesettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesPhonebasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PhoneBase**](../Model/\PureCloudSDK\PhoneBase.md)| Phone base settings |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesPhones**
> \PureCloudSDK\Phone postProvidersEdgesPhones($body)

Create a new Phone



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Phone(); // \PureCloudSDK\Phone | Phone

try {
    $result = $api_instance->postProvidersEdgesPhones($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesPhones: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Phone**](../Model/\PureCloudSDK\Phone.md)| Phone |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesPhonesPhoneIdReboot**
> postProvidersEdgesPhonesPhoneIdReboot($phoneId)

Reboot a Phone



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneId = "phoneId_example"; // string | Phone Id

try {
    $api_instance->postProvidersEdgesPhonesPhoneIdReboot($phoneId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesPhonesPhoneIdReboot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneId** | **string**| Phone Id |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesPhonesReboot**
> postProvidersEdgesPhonesReboot($body)

Reboot Multiple Phones



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\PhonesReboot(); // \PureCloudSDK\PhonesReboot | Phones

try {
    $api_instance->postProvidersEdgesPhonesReboot($body);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesPhonesReboot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\PhonesReboot**](../Model/\PureCloudSDK\PhonesReboot.md)| Phones |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesSites**
> \PureCloudSDK\Site postProvidersEdgesSites($body)

Create a Site.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\Site(); // \PureCloudSDK\Site | Site

try {
    $result = $api_instance->postProvidersEdgesSites($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesSites: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Site**](../Model/\PureCloudSDK\Site.md)| Site |

### Return type

[**\PureCloudSDK\Site**](../Model/Site.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesSitesSiteIdRebalance**
> postProvidersEdgesSitesSiteIdRebalance($siteId)

Triggers the rebalance operation.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID

try {
    $api_instance->postProvidersEdgesSitesSiteIdRebalance($siteId);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesSitesSiteIdRebalance: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postProvidersEdgesTrunkbasesettings**
> \PureCloudSDK\TrunkBase postProvidersEdgesTrunkbasesettings($body)

Create a Trunk Base Settings object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$body = new \PureCloudSDK\TrunkBase(); // \PureCloudSDK\TrunkBase | Trunk base settings

try {
    $result = $api_instance->postProvidersEdgesTrunkbasesettings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->postProvidersEdgesTrunkbasesettings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\TrunkBase**](../Model/\PureCloudSDK\TrunkBase.md)| Trunk base settings |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesCertificateauthoritiesCertificateId**
> \PureCloudSDK\DomainCertificateAuthority putProvidersEdgesCertificateauthoritiesCertificateId($certificateId, $body)

Update a certificate authority.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$certificateId = "certificateId_example"; // string | Certificate ID
$body = new \PureCloudSDK\DomainCertificateAuthority(); // \PureCloudSDK\DomainCertificateAuthority | Certificate authority

try {
    $result = $api_instance->putProvidersEdgesCertificateauthoritiesCertificateId($certificateId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesCertificateauthoritiesCertificateId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **certificateId** | **string**| Certificate ID |
 **body** | [**\PureCloudSDK\DomainCertificateAuthority**](../Model/\PureCloudSDK\DomainCertificateAuthority.md)| Certificate authority |

### Return type

[**\PureCloudSDK\DomainCertificateAuthority**](../Model/DomainCertificateAuthority.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesDidpoolsDidpoolId**
> \PureCloudSDK\DIDPool putProvidersEdgesDidpoolsDidpoolId($didPoolId, $body)

Update a DID Pool by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didPoolId = "didPoolId_example"; // string | DID pool ID
$body = new \PureCloudSDK\DIDPool(); // \PureCloudSDK\DIDPool | DID pool

try {
    $result = $api_instance->putProvidersEdgesDidpoolsDidpoolId($didPoolId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesDidpoolsDidpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didPoolId** | **string**| DID pool ID |
 **body** | [**\PureCloudSDK\DIDPool**](../Model/\PureCloudSDK\DIDPool.md)| DID pool |

### Return type

[**\PureCloudSDK\DIDPool**](../Model/DIDPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesDidsDidId**
> \PureCloudSDK\DID putProvidersEdgesDidsDidId($didId, $body)

Update a DID by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$didId = "didId_example"; // string | DID ID
$body = new \PureCloudSDK\DID(); // \PureCloudSDK\DID | DID

try {
    $result = $api_instance->putProvidersEdgesDidsDidId($didId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesDidsDidId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **didId** | **string**| DID ID |
 **body** | [**\PureCloudSDK\DID**](../Model/\PureCloudSDK\DID.md)| DID |

### Return type

[**\PureCloudSDK\DID**](../Model/DID.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEdgeId**
> \PureCloudSDK\Edge putProvidersEdgesEdgeId($edgeId, $body)

Update a edge.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$body = new \PureCloudSDK\Edge(); // \PureCloudSDK\Edge | Edge

try {
    $result = $api_instance->putProvidersEdgesEdgeId($edgeId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEdgeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **body** | [**\PureCloudSDK\Edge**](../Model/\PureCloudSDK\Edge.md)| Edge |

### Return type

[**\PureCloudSDK\Edge**](../Model/Edge.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEdgeIdLinesLineId**
> \PureCloudSDK\EdgeLine putProvidersEdgesEdgeIdLinesLineId($edgeId, $lineId, $body)

Update a line.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$lineId = "lineId_example"; // string | Line ID
$body = new \PureCloudSDK\EdgeLine(); // \PureCloudSDK\EdgeLine | Line

try {
    $result = $api_instance->putProvidersEdgesEdgeIdLinesLineId($edgeId, $lineId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEdgeIdLinesLineId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **lineId** | **string**| Line ID |
 **body** | [**\PureCloudSDK\EdgeLine**](../Model/\PureCloudSDK\EdgeLine.md)| Line |

### Return type

[**\PureCloudSDK\EdgeLine**](../Model/EdgeLine.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId**
> \PureCloudSDK\DomainLogicalInterface putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId, $body)

Update an edge logical interface.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeId = "edgeId_example"; // string | Edge ID
$interfaceId = "interfaceId_example"; // string | Interface ID
$body = new \PureCloudSDK\DomainLogicalInterface(); // \PureCloudSDK\DomainLogicalInterface | Logical interface

try {
    $result = $api_instance->putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId($edgeId, $interfaceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEdgeIdLogicalinterfacesInterfaceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeId** | **string**| Edge ID |
 **interfaceId** | **string**| Interface ID |
 **body** | [**\PureCloudSDK\DomainLogicalInterface**](../Model/\PureCloudSDK\DomainLogicalInterface.md)| Logical interface |

### Return type

[**\PureCloudSDK\DomainLogicalInterface**](../Model/DomainLogicalInterface.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEdgegroupsEdgegroupId**
> \PureCloudSDK\EdgeGroup putProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId, $body)

Update an edge group.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$edgeGroupId = "edgeGroupId_example"; // string | Edge group ID
$body = new \PureCloudSDK\EdgeGroup(); // \PureCloudSDK\EdgeGroup | EdgeGroup

try {
    $result = $api_instance->putProvidersEdgesEdgegroupsEdgegroupId($edgeGroupId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEdgegroupsEdgegroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **edgeGroupId** | **string**| Edge group ID |
 **body** | [**\PureCloudSDK\EdgeGroup**](../Model/\PureCloudSDK\EdgeGroup.md)| EdgeGroup |

### Return type

[**\PureCloudSDK\EdgeGroup**](../Model/EdgeGroup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesEndpointsEndpointId**
> \PureCloudSDK\Endpoint putProvidersEdgesEndpointsEndpointId($endpointId, $body)

Update endpoint



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$endpointId = "endpointId_example"; // string | Endpoint ID
$body = new \PureCloudSDK\Endpoint(); // \PureCloudSDK\Endpoint | EndpointTemplate

try {
    $result = $api_instance->putProvidersEdgesEndpointsEndpointId($endpointId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesEndpointsEndpointId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **endpointId** | **string**| Endpoint ID |
 **body** | [**\PureCloudSDK\Endpoint**](../Model/\PureCloudSDK\Endpoint.md)| EndpointTemplate |

### Return type

[**\PureCloudSDK\Endpoint**](../Model/Endpoint.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesExtensionpoolsExtensionpoolId**
> \PureCloudSDK\ExtensionPool putProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId, $body)

Update an extension pool by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionPoolId = "extensionPoolId_example"; // string | Extension pool ID
$body = new \PureCloudSDK\ExtensionPool(); // \PureCloudSDK\ExtensionPool | ExtensionPool

try {
    $result = $api_instance->putProvidersEdgesExtensionpoolsExtensionpoolId($extensionPoolId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesExtensionpoolsExtensionpoolId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionPoolId** | **string**| Extension pool ID |
 **body** | [**\PureCloudSDK\ExtensionPool**](../Model/\PureCloudSDK\ExtensionPool.md)| ExtensionPool |

### Return type

[**\PureCloudSDK\ExtensionPool**](../Model/ExtensionPool.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesExtensionsExtensionId**
> \PureCloudSDK\Extension putProvidersEdgesExtensionsExtensionId($extensionId, $body)

Update an extension by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$extensionId = "extensionId_example"; // string | Extension ID
$body = new \PureCloudSDK\Extension(); // \PureCloudSDK\Extension | Extension

try {
    $result = $api_instance->putProvidersEdgesExtensionsExtensionId($extensionId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesExtensionsExtensionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **extensionId** | **string**| Extension ID |
 **body** | [**\PureCloudSDK\Extension**](../Model/\PureCloudSDK\Extension.md)| Extension |

### Return type

[**\PureCloudSDK\Extension**](../Model/Extension.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesOutboundroutesOutboundrouteId**
> \PureCloudSDK\OutboundRoute putProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId, $body)

Update outbound route



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$outboundRouteId = "outboundRouteId_example"; // string | Outbound route ID
$body = new \PureCloudSDK\OutboundRoute(); // \PureCloudSDK\OutboundRoute | OutboundRoute

try {
    $result = $api_instance->putProvidersEdgesOutboundroutesOutboundrouteId($outboundRouteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesOutboundroutesOutboundrouteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outboundRouteId** | **string**| Outbound route ID |
 **body** | [**\PureCloudSDK\OutboundRoute**](../Model/\PureCloudSDK\OutboundRoute.md)| OutboundRoute |

### Return type

[**\PureCloudSDK\OutboundRoute**](../Model/OutboundRoute.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesPhonebasesettingsPhonebaseId**
> \PureCloudSDK\PhoneBase putProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId, $body)

Update a Phone Base Settings by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneBaseId = "phoneBaseId_example"; // string | Phone base ID
$body = new \PureCloudSDK\PhoneBase(); // \PureCloudSDK\PhoneBase | Phone base settings

try {
    $result = $api_instance->putProvidersEdgesPhonebasesettingsPhonebaseId($phoneBaseId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesPhonebasesettingsPhonebaseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneBaseId** | **string**| Phone base ID |
 **body** | [**\PureCloudSDK\PhoneBase**](../Model/\PureCloudSDK\PhoneBase.md)| Phone base settings |

### Return type

[**\PureCloudSDK\PhoneBase**](../Model/PhoneBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesPhonesPhoneId**
> \PureCloudSDK\Phone putProvidersEdgesPhonesPhoneId($phoneId, $body)

Update a Phone by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$phoneId = "phoneId_example"; // string | Phone ID
$body = new \PureCloudSDK\Phone(); // \PureCloudSDK\Phone | Phone

try {
    $result = $api_instance->putProvidersEdgesPhonesPhoneId($phoneId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesPhonesPhoneId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **phoneId** | **string**| Phone ID |
 **body** | [**\PureCloudSDK\Phone**](../Model/\PureCloudSDK\Phone.md)| Phone |

### Return type

[**\PureCloudSDK\Phone**](../Model/Phone.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesSitesSiteId**
> \PureCloudSDK\Site putProvidersEdgesSitesSiteId($siteId, $body)

Update a Site by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$body = new \PureCloudSDK\Site(); // \PureCloudSDK\Site | Site

try {
    $result = $api_instance->putProvidersEdgesSitesSiteId($siteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesSitesSiteId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **body** | [**\PureCloudSDK\Site**](../Model/\PureCloudSDK\Site.md)| Site |

### Return type

[**\PureCloudSDK\Site**](../Model/Site.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesSitesSiteIdNumberplans**
> \PureCloudSDK\NumberPlan[] putProvidersEdgesSitesSiteIdNumberplans($siteId, $body)

Update the list of Number Plans.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$siteId = "siteId_example"; // string | Site ID
$body = array(new NumberPlan()); // \PureCloudSDK\NumberPlan[] | List of number plans

try {
    $result = $api_instance->putProvidersEdgesSitesSiteIdNumberplans($siteId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesSitesSiteIdNumberplans: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **siteId** | **string**| Site ID |
 **body** | [**\PureCloudSDK\NumberPlan[]**](../Model/NumberPlan.md)| List of number plans |

### Return type

[**\PureCloudSDK\NumberPlan[]**](../Model/NumberPlan.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId**
> \PureCloudSDK\TrunkBase putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId, $body)

Update a Trunk Base Settings object by ID



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\TelephonyProvidersEdgeApi();
$trunkBaseSettingsId = "trunkBaseSettingsId_example"; // string | Trunk Base ID
$body = new \PureCloudSDK\TrunkBase(); // \PureCloudSDK\TrunkBase | Trunk base settings

try {
    $result = $api_instance->putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId($trunkBaseSettingsId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TelephonyProvidersEdgeApi->putProvidersEdgesTrunkbasesettingsTrunkbasesettingsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **trunkBaseSettingsId** | **string**| Trunk Base ID |
 **body** | [**\PureCloudSDK\TrunkBase**](../Model/\PureCloudSDK\TrunkBase.md)| Trunk base settings |

### Return type

[**\PureCloudSDK\TrunkBase**](../Model/TrunkBase.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

