<?php

/**
 * AgentActivity
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AgentActivity Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AgentActivity implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AgentActivity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'agent' => '\PureCloudSDK\User',
        'numEvaluations' => 'int',
        'averageEvaluationScore' => 'int',
        'numCriticalEvaluations' => 'int',
        'averageCriticalScore' => 'float',
        'highestEvaluationScore' => 'float',
        'lowestEvaluationScore' => 'float',
        'highestCriticalScore' => 'float',
        'lowestCriticalScore' => 'float',
        'agentEvaluatorActivityList' => '\PureCloudSDK\AgentEvaluatorActivity[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'agent' => 'agent',
        'numEvaluations' => 'numEvaluations',
        'averageEvaluationScore' => 'averageEvaluationScore',
        'numCriticalEvaluations' => 'numCriticalEvaluations',
        'averageCriticalScore' => 'averageCriticalScore',
        'highestEvaluationScore' => 'highestEvaluationScore',
        'lowestEvaluationScore' => 'lowestEvaluationScore',
        'highestCriticalScore' => 'highestCriticalScore',
        'lowestCriticalScore' => 'lowestCriticalScore',
        'agentEvaluatorActivityList' => 'agentEvaluatorActivityList',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'agent' => 'setAgent',
        'numEvaluations' => 'setNumEvaluations',
        'averageEvaluationScore' => 'setAverageEvaluationScore',
        'numCriticalEvaluations' => 'setNumCriticalEvaluations',
        'averageCriticalScore' => 'setAverageCriticalScore',
        'highestEvaluationScore' => 'setHighestEvaluationScore',
        'lowestEvaluationScore' => 'setLowestEvaluationScore',
        'highestCriticalScore' => 'setHighestCriticalScore',
        'lowestCriticalScore' => 'setLowestCriticalScore',
        'agentEvaluatorActivityList' => 'setAgentEvaluatorActivityList',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'agent' => 'getAgent',
        'numEvaluations' => 'getNumEvaluations',
        'averageEvaluationScore' => 'getAverageEvaluationScore',
        'numCriticalEvaluations' => 'getNumCriticalEvaluations',
        'averageCriticalScore' => 'getAverageCriticalScore',
        'highestEvaluationScore' => 'getHighestEvaluationScore',
        'lowestEvaluationScore' => 'getLowestEvaluationScore',
        'highestCriticalScore' => 'getHighestCriticalScore',
        'lowestCriticalScore' => 'getLowestCriticalScore',
        'agentEvaluatorActivityList' => 'getAgentEvaluatorActivityList',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['agent'] = isset($data['agent']) ? $data['agent'] : null;
        $this->container['numEvaluations'] = isset($data['numEvaluations']) ? $data['numEvaluations'] : null;
        $this->container['averageEvaluationScore'] = isset($data['averageEvaluationScore']) ? $data['averageEvaluationScore'] : null;
        $this->container['numCriticalEvaluations'] = isset($data['numCriticalEvaluations']) ? $data['numCriticalEvaluations'] : null;
        $this->container['averageCriticalScore'] = isset($data['averageCriticalScore']) ? $data['averageCriticalScore'] : null;
        $this->container['highestEvaluationScore'] = isset($data['highestEvaluationScore']) ? $data['highestEvaluationScore'] : null;
        $this->container['lowestEvaluationScore'] = isset($data['lowestEvaluationScore']) ? $data['lowestEvaluationScore'] : null;
        $this->container['highestCriticalScore'] = isset($data['highestCriticalScore']) ? $data['highestCriticalScore'] : null;
        $this->container['lowestCriticalScore'] = isset($data['lowestCriticalScore']) ? $data['lowestCriticalScore'] : null;
        $this->container['agentEvaluatorActivityList'] = isset($data['agentEvaluatorActivityList']) ? $data['agentEvaluatorActivityList'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets agent
     * @return \PureCloudSDK\User
     */
    public function getAgent()
    {
        return $this->container['agent'];
    }

    /**
     * Sets agent
     * @param \PureCloudSDK\User $agent
     * @return $this
     */
    public function setAgent($agent)
    {
        $this->container['agent'] = $agent;

        return $this;
    }

    /**
     * Gets numEvaluations
     * @return int
     */
    public function getNumEvaluations()
    {
        return $this->container['numEvaluations'];
    }

    /**
     * Sets numEvaluations
     * @param int $numEvaluations
     * @return $this
     */
    public function setNumEvaluations($numEvaluations)
    {
        $this->container['numEvaluations'] = $numEvaluations;

        return $this;
    }

    /**
     * Gets averageEvaluationScore
     * @return int
     */
    public function getAverageEvaluationScore()
    {
        return $this->container['averageEvaluationScore'];
    }

    /**
     * Sets averageEvaluationScore
     * @param int $averageEvaluationScore
     * @return $this
     */
    public function setAverageEvaluationScore($averageEvaluationScore)
    {
        $this->container['averageEvaluationScore'] = $averageEvaluationScore;

        return $this;
    }

    /**
     * Gets numCriticalEvaluations
     * @return int
     */
    public function getNumCriticalEvaluations()
    {
        return $this->container['numCriticalEvaluations'];
    }

    /**
     * Sets numCriticalEvaluations
     * @param int $numCriticalEvaluations
     * @return $this
     */
    public function setNumCriticalEvaluations($numCriticalEvaluations)
    {
        $this->container['numCriticalEvaluations'] = $numCriticalEvaluations;

        return $this;
    }

    /**
     * Gets averageCriticalScore
     * @return float
     */
    public function getAverageCriticalScore()
    {
        return $this->container['averageCriticalScore'];
    }

    /**
     * Sets averageCriticalScore
     * @param float $averageCriticalScore
     * @return $this
     */
    public function setAverageCriticalScore($averageCriticalScore)
    {
        $this->container['averageCriticalScore'] = $averageCriticalScore;

        return $this;
    }

    /**
     * Gets highestEvaluationScore
     * @return float
     */
    public function getHighestEvaluationScore()
    {
        return $this->container['highestEvaluationScore'];
    }

    /**
     * Sets highestEvaluationScore
     * @param float $highestEvaluationScore
     * @return $this
     */
    public function setHighestEvaluationScore($highestEvaluationScore)
    {
        $this->container['highestEvaluationScore'] = $highestEvaluationScore;

        return $this;
    }

    /**
     * Gets lowestEvaluationScore
     * @return float
     */
    public function getLowestEvaluationScore()
    {
        return $this->container['lowestEvaluationScore'];
    }

    /**
     * Sets lowestEvaluationScore
     * @param float $lowestEvaluationScore
     * @return $this
     */
    public function setLowestEvaluationScore($lowestEvaluationScore)
    {
        $this->container['lowestEvaluationScore'] = $lowestEvaluationScore;

        return $this;
    }

    /**
     * Gets highestCriticalScore
     * @return float
     */
    public function getHighestCriticalScore()
    {
        return $this->container['highestCriticalScore'];
    }

    /**
     * Sets highestCriticalScore
     * @param float $highestCriticalScore
     * @return $this
     */
    public function setHighestCriticalScore($highestCriticalScore)
    {
        $this->container['highestCriticalScore'] = $highestCriticalScore;

        return $this;
    }

    /**
     * Gets lowestCriticalScore
     * @return float
     */
    public function getLowestCriticalScore()
    {
        return $this->container['lowestCriticalScore'];
    }

    /**
     * Sets lowestCriticalScore
     * @param float $lowestCriticalScore
     * @return $this
     */
    public function setLowestCriticalScore($lowestCriticalScore)
    {
        $this->container['lowestCriticalScore'] = $lowestCriticalScore;

        return $this;
    }

    /**
     * Gets agentEvaluatorActivityList
     * @return \PureCloudSDK\AgentEvaluatorActivity[]
     */
    public function getAgentEvaluatorActivityList()
    {
        return $this->container['agentEvaluatorActivityList'];
    }

    /**
     * Sets agentEvaluatorActivityList
     * @param \PureCloudSDK\AgentEvaluatorActivity[] $agentEvaluatorActivityList
     * @return $this
     */
    public function setAgentEvaluatorActivityList($agentEvaluatorActivityList)
    {
        $this->container['agentEvaluatorActivityList'] = $agentEvaluatorActivityList;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
