<?php

/**
 * CoachingNotification
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CoachingNotification Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CoachingNotification implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CoachingNotification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'markedAsRead' => 'bool',
        'actionType' => 'string',
        'relationship' => 'string',
        'dateStart' => '\DateTime',
        'lengthInMinutes' => 'int',
        'status' => 'string',
        'user' => '\PureCloudSDK\UserReference',
        'appointment' => '\PureCloudSDK\CoachingAppointmentResponse',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'markedAsRead' => 'markedAsRead',
        'actionType' => 'actionType',
        'relationship' => 'relationship',
        'dateStart' => 'dateStart',
        'lengthInMinutes' => 'lengthInMinutes',
        'status' => 'status',
        'user' => 'user',
        'appointment' => 'appointment',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'markedAsRead' => 'setMarkedAsRead',
        'actionType' => 'setActionType',
        'relationship' => 'setRelationship',
        'dateStart' => 'setDateStart',
        'lengthInMinutes' => 'setLengthInMinutes',
        'status' => 'setStatus',
        'user' => 'setUser',
        'appointment' => 'setAppointment',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'markedAsRead' => 'getMarkedAsRead',
        'actionType' => 'getActionType',
        'relationship' => 'getRelationship',
        'dateStart' => 'getDateStart',
        'lengthInMinutes' => 'getLengthInMinutes',
        'status' => 'getStatus',
        'user' => 'getUser',
        'appointment' => 'getAppointment',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const ACTION_TYPE_CREATE = 'Create';
    public const ACTION_TYPE_UPDATE = 'Update';
    public const ACTION_TYPE_DELETE = 'Delete';
    public const ACTION_TYPE_STATUS_CHANGE = 'StatusChange';
    public const RELATIONSHIP_ATTENDEE = 'Attendee';
    public const RELATIONSHIP_CREATOR = 'Creator';
    public const RELATIONSHIP_FACILITATOR = 'Facilitator';
    public const STATUS_SCHEDULED = 'Scheduled';
    public const STATUS_IN_PROGRESS = 'InProgress';
    public const STATUS_COMPLETED = 'Completed';
    public const STATUS_INVALID_SCHEDULE = 'InvalidSchedule';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionTypeAllowableValues()
    {
        return [
            self::ACTION_TYPE_CREATE,
            self::ACTION_TYPE_UPDATE,
            self::ACTION_TYPE_DELETE,
            self::ACTION_TYPE_STATUS_CHANGE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRelationshipAllowableValues()
    {
        return [
            self::RELATIONSHIP_ATTENDEE,
            self::RELATIONSHIP_CREATOR,
            self::RELATIONSHIP_FACILITATOR,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_SCHEDULED,
            self::STATUS_IN_PROGRESS,
            self::STATUS_COMPLETED,
            self::STATUS_INVALID_SCHEDULE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['markedAsRead'] = isset($data['markedAsRead']) ? $data['markedAsRead'] : null;
        $this->container['actionType'] = isset($data['actionType']) ? $data['actionType'] : null;
        $this->container['relationship'] = isset($data['relationship']) ? $data['relationship'] : null;
        $this->container['dateStart'] = isset($data['dateStart']) ? $data['dateStart'] : null;
        $this->container['lengthInMinutes'] = isset($data['lengthInMinutes']) ? $data['lengthInMinutes'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['appointment'] = isset($data['appointment']) ? $data['appointment'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Create", "Update", "Delete", "StatusChange");
        if (!in_array($this->container['actionType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'actionType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Attendee", "Creator", "Facilitator");
        if (!in_array($this->container['relationship'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'relationship', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Scheduled", "InProgress", "Completed", "InvalidSchedule");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Create", "Update", "Delete", "StatusChange");
        if (!in_array($this->container['actionType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Attendee", "Creator", "Facilitator");
        if (!in_array($this->container['relationship'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Scheduled", "InProgress", "Completed", "InvalidSchedule");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the appointment for this notification.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets markedAsRead
     * @return bool
     */
    public function getMarkedAsRead()
    {
        return $this->container['markedAsRead'];
    }

    /**
     * Sets markedAsRead
     * @param bool $markedAsRead Indicates if notification is read or unread
     * @return $this
     */
    public function setMarkedAsRead($markedAsRead)
    {
        $this->container['markedAsRead'] = $markedAsRead;

        return $this;
    }

    /**
     * Gets actionType
     * @return string
     */
    public function getActionType()
    {
        return $this->container['actionType'];
    }

    /**
     * Sets actionType
     * @param string $actionType Action causing the notification.
     * @return $this
     */
    public function setActionType($actionType)
    {
        $allowed_values = array('Create', 'Update', 'Delete', 'StatusChange');
        if (!in_array($actionType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actionType', must be one of 'Create', 'Update', 'Delete', 'StatusChange'");
        }
        $this->container['actionType'] = $actionType;

        return $this;
    }

    /**
     * Gets relationship
     * @return string
     */
    public function getRelationship()
    {
        return $this->container['relationship'];
    }

    /**
     * Sets relationship
     * @param string $relationship The relationship of this user to this notification's appointment
     * @return $this
     */
    public function setRelationship($relationship)
    {
        $allowed_values = array('Attendee', 'Creator', 'Facilitator');
        if (!in_array($relationship, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'relationship', must be one of 'Attendee', 'Creator', 'Facilitator'");
        }
        $this->container['relationship'] = $relationship;

        return $this;
    }

    /**
     * Gets dateStart
     * @return \DateTime
     */
    public function getDateStart()
    {
        return $this->container['dateStart'];
    }

    /**
     * Sets dateStart
     * @param \DateTime $dateStart The start time of the appointment relating to this notification. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateStart($dateStart)
    {
        $this->container['dateStart'] = $dateStart;

        return $this;
    }

    /**
     * Gets lengthInMinutes
     * @return int
     */
    public function getLengthInMinutes()
    {
        return $this->container['lengthInMinutes'];
    }

    /**
     * Sets lengthInMinutes
     * @param int $lengthInMinutes The duration of the appointment on this notification
     * @return $this
     */
    public function setLengthInMinutes($lengthInMinutes)
    {
        $this->container['lengthInMinutes'] = $lengthInMinutes;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of the appointment for this notification
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('Scheduled', 'InProgress', 'Completed', 'InvalidSchedule');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'Scheduled', 'InProgress', 'Completed', 'InvalidSchedule'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\UserReference
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\UserReference $user The user of this notification
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets appointment
     * @return \PureCloudSDK\CoachingAppointmentResponse
     */
    public function getAppointment()
    {
        return $this->container['appointment'];
    }

    /**
     * Sets appointment
     * @param \PureCloudSDK\CoachingAppointmentResponse $appointment The appointment
     * @return $this
     */
    public function setAppointment($appointment)
    {
        $this->container['appointment'] = $appointment;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
