<?php

/**
 * ConversationAggregationView
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ConversationAggregationView Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationAggregationView implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationAggregationView';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'target' => 'string',
        'name' => 'string',
        'function' => 'string',
        'range' => '\PureCloudSDK\AggregationRange'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'target' => 'target',
        'name' => 'name',
        'function' => 'function',
        'range' => 'range'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'target' => 'setTarget',
        'name' => 'setName',
        'function' => 'setFunction',
        'range' => 'setRange'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'target' => 'getTarget',
        'name' => 'getName',
        'function' => 'getFunction',
        'range' => 'getRange'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TARGET_N_BLIND_TRANSFERRED = 'nBlindTransferred';
    public const TARGET_N_CONNECTED = 'nConnected';
    public const TARGET_N_CONSULT = 'nConsult';
    public const TARGET_N_CONSULT_TRANSFERRED = 'nConsultTransferred';
    public const TARGET_N_ERROR = 'nError';
    public const TARGET_N_OFFERED = 'nOffered';
    public const TARGET_N_OUTBOUND = 'nOutbound';
    public const TARGET_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    public const TARGET_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    public const TARGET_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    public const TARGET_N_OVER_SLA = 'nOverSla';
    public const TARGET_N_STATE_TRANSITION_ERROR = 'nStateTransitionError';
    public const TARGET_N_TRANSFERRED = 'nTransferred';
    public const TARGET_O_EXTERNAL_MEDIA_COUNT = 'oExternalMediaCount';
    public const TARGET_O_INTERACTING = 'oInteracting';
    public const TARGET_O_MEDIA_COUNT = 'oMediaCount';
    public const TARGET_O_SERVICE_LEVEL = 'oServiceLevel';
    public const TARGET_O_SERVICE_TARGET = 'oServiceTarget';
    public const TARGET_O_WAITING = 'oWaiting';
    public const TARGET_T_ABANDON = 'tAbandon';
    public const TARGET_T_ACD = 'tAcd';
    public const TARGET_T_ACW = 'tAcw';
    public const TARGET_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    public const TARGET_T_ALERT = 'tAlert';
    public const TARGET_T_ANSWERED = 'tAnswered';
    public const TARGET_T_CONTACTING = 'tContacting';
    public const TARGET_T_DIALING = 'tDialing';
    public const TARGET_T_FLOW_OUT = 'tFlowOut';
    public const TARGET_T_HANDLE = 'tHandle';
    public const TARGET_T_HELD = 'tHeld';
    public const TARGET_T_HELD_COMPLETE = 'tHeldComplete';
    public const TARGET_T_IVR = 'tIvr';
    public const TARGET_T_MONITORING = 'tMonitoring';
    public const TARGET_T_NOT_RESPONDING = 'tNotResponding';
    public const TARGET_T_SHORT_ABANDON = 'tShortAbandon';
    public const TARGET_T_TALK = 'tTalk';
    public const TARGET_T_TALK_COMPLETE = 'tTalkComplete';
    public const TARGET_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    public const TARGET_T_VOICEMAIL = 'tVoicemail';
    public const TARGET_T_WAIT = 'tWait';
    public const MODEL_FUNCTION_RANGE_BOUND = 'rangeBound';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTargetAllowableValues()
    {
        return [
            self::TARGET_N_BLIND_TRANSFERRED,
            self::TARGET_N_CONNECTED,
            self::TARGET_N_CONSULT,
            self::TARGET_N_CONSULT_TRANSFERRED,
            self::TARGET_N_ERROR,
            self::TARGET_N_OFFERED,
            self::TARGET_N_OUTBOUND,
            self::TARGET_N_OUTBOUND_ABANDONED,
            self::TARGET_N_OUTBOUND_ATTEMPTED,
            self::TARGET_N_OUTBOUND_CONNECTED,
            self::TARGET_N_OVER_SLA,
            self::TARGET_N_STATE_TRANSITION_ERROR,
            self::TARGET_N_TRANSFERRED,
            self::TARGET_O_EXTERNAL_MEDIA_COUNT,
            self::TARGET_O_INTERACTING,
            self::TARGET_O_MEDIA_COUNT,
            self::TARGET_O_SERVICE_LEVEL,
            self::TARGET_O_SERVICE_TARGET,
            self::TARGET_O_WAITING,
            self::TARGET_T_ABANDON,
            self::TARGET_T_ACD,
            self::TARGET_T_ACW,
            self::TARGET_T_AGENT_RESPONSE_TIME,
            self::TARGET_T_ALERT,
            self::TARGET_T_ANSWERED,
            self::TARGET_T_CONTACTING,
            self::TARGET_T_DIALING,
            self::TARGET_T_FLOW_OUT,
            self::TARGET_T_HANDLE,
            self::TARGET_T_HELD,
            self::TARGET_T_HELD_COMPLETE,
            self::TARGET_T_IVR,
            self::TARGET_T_MONITORING,
            self::TARGET_T_NOT_RESPONDING,
            self::TARGET_T_SHORT_ABANDON,
            self::TARGET_T_TALK,
            self::TARGET_T_TALK_COMPLETE,
            self::TARGET_T_USER_RESPONSE_TIME,
            self::TARGET_T_VOICEMAIL,
            self::TARGET_T_WAIT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFunctionAllowableValues()
    {
        return [
            self::MODEL_FUNCTION_RANGE_BOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['target'] = isset($data['target']) ? $data['target'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['function'] = isset($data['function']) ? $data['function'] : null;
        $this->container['range'] = isset($data['range']) ? $data['range'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['target'] === null) {
            $invalid_properties[] = "'target' can't be null";
        }
        $allowed_values = array("nBlindTransferred", "nConnected", "nConsult", "nConsultTransferred", "nError", "nOffered", "nOutbound", "nOutboundAbandoned", "nOutboundAttempted", "nOutboundConnected", "nOverSla", "nStateTransitionError", "nTransferred", "oExternalMediaCount", "oInteracting", "oMediaCount", "oServiceLevel", "oServiceTarget", "oWaiting", "tAbandon", "tAcd", "tAcw", "tAgentResponseTime", "tAlert", "tAnswered", "tContacting", "tDialing", "tFlowOut", "tHandle", "tHeld", "tHeldComplete", "tIvr", "tMonitoring", "tNotResponding", "tShortAbandon", "tTalk", "tTalkComplete", "tUserResponseTime", "tVoicemail", "tWait");
        if (!in_array($this->container['target'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'target', must be one of #{allowed_values}.";
        }

        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['function'] === null) {
            $invalid_properties[] = "'function' can't be null";
        }
        $allowed_values = array("rangeBound");
        if (!in_array($this->container['function'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'function', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['target'] === null) {
            return false;
        }
        $allowed_values = array("nBlindTransferred", "nConnected", "nConsult", "nConsultTransferred", "nError", "nOffered", "nOutbound", "nOutboundAbandoned", "nOutboundAttempted", "nOutboundConnected", "nOverSla", "nStateTransitionError", "nTransferred", "oExternalMediaCount", "oInteracting", "oMediaCount", "oServiceLevel", "oServiceTarget", "oWaiting", "tAbandon", "tAcd", "tAcw", "tAgentResponseTime", "tAlert", "tAnswered", "tContacting", "tDialing", "tFlowOut", "tHandle", "tHeld", "tHeldComplete", "tIvr", "tMonitoring", "tNotResponding", "tShortAbandon", "tTalk", "tTalkComplete", "tUserResponseTime", "tVoicemail", "tWait");
        if (!in_array($this->container['target'], $allowed_values)) {
            return false;
        }
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['function'] === null) {
            return false;
        }
        $allowed_values = array("rangeBound");
        if (!in_array($this->container['function'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets target
     * @return string
     */
    public function getTarget()
    {
        return $this->container['target'];
    }

    /**
     * Sets target
     * @param string $target Target metric name
     * @return $this
     */
    public function setTarget($target)
    {
        $allowed_values = array('nBlindTransferred', 'nConnected', 'nConsult', 'nConsultTransferred', 'nError', 'nOffered', 'nOutbound', 'nOutboundAbandoned', 'nOutboundAttempted', 'nOutboundConnected', 'nOverSla', 'nStateTransitionError', 'nTransferred', 'oExternalMediaCount', 'oInteracting', 'oMediaCount', 'oServiceLevel', 'oServiceTarget', 'oWaiting', 'tAbandon', 'tAcd', 'tAcw', 'tAgentResponseTime', 'tAlert', 'tAnswered', 'tContacting', 'tDialing', 'tFlowOut', 'tHandle', 'tHeld', 'tHeldComplete', 'tIvr', 'tMonitoring', 'tNotResponding', 'tShortAbandon', 'tTalk', 'tTalkComplete', 'tUserResponseTime', 'tVoicemail', 'tWait');
        if (!in_array($target, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'target', must be one of 'nBlindTransferred', 'nConnected', 'nConsult', 'nConsultTransferred', 'nError', 'nOffered', 'nOutbound', 'nOutboundAbandoned', 'nOutboundAttempted', 'nOutboundConnected', 'nOverSla', 'nStateTransitionError', 'nTransferred', 'oExternalMediaCount', 'oInteracting', 'oMediaCount', 'oServiceLevel', 'oServiceTarget', 'oWaiting', 'tAbandon', 'tAcd', 'tAcw', 'tAgentResponseTime', 'tAlert', 'tAnswered', 'tContacting', 'tDialing', 'tFlowOut', 'tHandle', 'tHeld', 'tHeldComplete', 'tIvr', 'tMonitoring', 'tNotResponding', 'tShortAbandon', 'tTalk', 'tTalkComplete', 'tUserResponseTime', 'tVoicemail', 'tWait'");
        }
        $this->container['target'] = $target;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name A unique name for this view. Must be distinct from other views and built-in metric names.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets function
     * @return string
     */
    public function getFunction()
    {
        return $this->container['function'];
    }

    /**
     * Sets function
     * @param string $function Type of view you wish to create
     * @return $this
     */
    public function setFunction($function)
    {
        $allowed_values = array('rangeBound');
        if (!in_array($function, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'function', must be one of 'rangeBound'");
        }
        $this->container['function'] = $function;

        return $this;
    }

    /**
     * Gets range
     * @return \PureCloudSDK\AggregationRange
     */
    public function getRange()
    {
        return $this->container['range'];
    }

    /**
     * Sets range
     * @param \PureCloudSDK\AggregationRange $range Range of numbers for slicing up data
     * @return $this
     */
    public function setRange($range)
    {
        $this->container['range'] = $range;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
