<?php

/**
 * CreateShareRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CreateShareRequest Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateShareRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateShareRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'sharedEntityType' => 'string',
        'sharedEntity' => '\PureCloudSDK\SharedEntity',
        'memberType' => 'string',
        'member' => '\PureCloudSDK\SharedEntity',
        'members' => '\PureCloudSDK\CreateShareRequestMember[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'sharedEntityType' => 'sharedEntityType',
        'sharedEntity' => 'sharedEntity',
        'memberType' => 'memberType',
        'member' => 'member',
        'members' => 'members'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'sharedEntityType' => 'setSharedEntityType',
        'sharedEntity' => 'setSharedEntity',
        'memberType' => 'setMemberType',
        'member' => 'setMember',
        'members' => 'setMembers'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'sharedEntityType' => 'getSharedEntityType',
        'sharedEntity' => 'getSharedEntity',
        'memberType' => 'getMemberType',
        'member' => 'getMember',
        'members' => 'getMembers'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const SHARED_ENTITY_TYPE_DOCUMENT = 'DOCUMENT';
    public const MEMBER_TYPE_USER = 'USER';
    public const MEMBER_TYPE_GROUP = 'GROUP';
    public const MEMBER_TYPE_PUBLIC = 'PUBLIC';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSharedEntityTypeAllowableValues()
    {
        return [
            self::SHARED_ENTITY_TYPE_DOCUMENT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMemberTypeAllowableValues()
    {
        return [
            self::MEMBER_TYPE_USER,
            self::MEMBER_TYPE_GROUP,
            self::MEMBER_TYPE_PUBLIC,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['sharedEntityType'] = isset($data['sharedEntityType']) ? $data['sharedEntityType'] : null;
        $this->container['sharedEntity'] = isset($data['sharedEntity']) ? $data['sharedEntity'] : null;
        $this->container['memberType'] = isset($data['memberType']) ? $data['memberType'] : null;
        $this->container['member'] = isset($data['member']) ? $data['member'] : null;
        $this->container['members'] = isset($data['members']) ? $data['members'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['sharedEntityType'] === null) {
            $invalid_properties[] = "'sharedEntityType' can't be null";
        }
        $allowed_values = array("DOCUMENT");
        if (!in_array($this->container['sharedEntityType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'sharedEntityType', must be one of #{allowed_values}.";
        }

        if ($this->container['sharedEntity'] === null) {
            $invalid_properties[] = "'sharedEntity' can't be null";
        }
        $allowed_values = array("USER", "GROUP", "PUBLIC");
        if (!in_array($this->container['memberType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'memberType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['sharedEntityType'] === null) {
            return false;
        }
        $allowed_values = array("DOCUMENT");
        if (!in_array($this->container['sharedEntityType'], $allowed_values)) {
            return false;
        }
        if ($this->container['sharedEntity'] === null) {
            return false;
        }
        $allowed_values = array("USER", "GROUP", "PUBLIC");
        if (!in_array($this->container['memberType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets sharedEntityType
     * @return string
     */
    public function getSharedEntityType()
    {
        return $this->container['sharedEntityType'];
    }

    /**
     * Sets sharedEntityType
     * @param string $sharedEntityType The share entity type
     * @return $this
     */
    public function setSharedEntityType($sharedEntityType)
    {
        $allowed_values = array('DOCUMENT');
        if (!in_array($sharedEntityType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'sharedEntityType', must be one of 'DOCUMENT'");
        }
        $this->container['sharedEntityType'] = $sharedEntityType;

        return $this;
    }

    /**
     * Gets sharedEntity
     * @return \PureCloudSDK\SharedEntity
     */
    public function getSharedEntity()
    {
        return $this->container['sharedEntity'];
    }

    /**
     * Sets sharedEntity
     * @param \PureCloudSDK\SharedEntity $sharedEntity The entity that will be shared
     * @return $this
     */
    public function setSharedEntity($sharedEntity)
    {
        $this->container['sharedEntity'] = $sharedEntity;

        return $this;
    }

    /**
     * Gets memberType
     * @return string
     */
    public function getMemberType()
    {
        return $this->container['memberType'];
    }

    /**
     * Sets memberType
     * @param string $memberType
     * @return $this
     */
    public function setMemberType($memberType)
    {
        $allowed_values = array('USER', 'GROUP', 'PUBLIC');
        if (!in_array($memberType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'memberType', must be one of 'USER', 'GROUP', 'PUBLIC'");
        }
        $this->container['memberType'] = $memberType;

        return $this;
    }

    /**
     * Gets member
     * @return \PureCloudSDK\SharedEntity
     */
    public function getMember()
    {
        return $this->container['member'];
    }

    /**
     * Sets member
     * @param \PureCloudSDK\SharedEntity $member The member that will have access to this share. Only required if a list of members is not provided.
     * @return $this
     */
    public function setMember($member)
    {
        $this->container['member'] = $member;

        return $this;
    }

    /**
     * Gets members
     * @return \PureCloudSDK\CreateShareRequestMember[]
     */
    public function getMembers()
    {
        return $this->container['members'];
    }

    /**
     * Sets members
     * @param \PureCloudSDK\CreateShareRequestMember[] $members
     * @return $this
     */
    public function setMembers($members)
    {
        $this->container['members'] = $members;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
