<?php

/**
 * FlowAggregationQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * FlowAggregationQuery Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowAggregationQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowAggregationQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'interval' => 'string',
        'granularity' => 'string',
        'timeZone' => 'string',
        'groupBy' => 'string[]',
        'filter' => '\PureCloudSDK\FlowAggregateQueryFilter',
        'metrics' => 'string[]',
        'flattenMultivaluedDimensions' => 'bool',
        'views' => '\PureCloudSDK\FlowAggregationView[]',
        'alternateTimeDimension' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'interval' => 'interval',
        'granularity' => 'granularity',
        'timeZone' => 'timeZone',
        'groupBy' => 'groupBy',
        'filter' => 'filter',
        'metrics' => 'metrics',
        'flattenMultivaluedDimensions' => 'flattenMultivaluedDimensions',
        'views' => 'views',
        'alternateTimeDimension' => 'alternateTimeDimension'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'interval' => 'setInterval',
        'granularity' => 'setGranularity',
        'timeZone' => 'setTimeZone',
        'groupBy' => 'setGroupBy',
        'filter' => 'setFilter',
        'metrics' => 'setMetrics',
        'flattenMultivaluedDimensions' => 'setFlattenMultivaluedDimensions',
        'views' => 'setViews',
        'alternateTimeDimension' => 'setAlternateTimeDimension'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'interval' => 'getInterval',
        'granularity' => 'getGranularity',
        'timeZone' => 'getTimeZone',
        'groupBy' => 'getGroupBy',
        'filter' => 'getFilter',
        'metrics' => 'getMetrics',
        'flattenMultivaluedDimensions' => 'getFlattenMultivaluedDimensions',
        'views' => 'getViews',
        'alternateTimeDimension' => 'getAlternateTimeDimension'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const GROUP_BY_ADDRESS_FROM = 'addressFrom';
    public const GROUP_BY_ADDRESS_TO = 'addressTo';
    public const GROUP_BY_AGENT_ASSISTANT_ID = 'agentAssistantId';
    public const GROUP_BY_AGENT_RANK = 'agentRank';
    public const GROUP_BY_AGENT_SCORE = 'agentScore';
    public const GROUP_BY_ANI = 'ani';
    public const GROUP_BY_CONVERSATION_ID = 'conversationId';
    public const GROUP_BY_CONVERTED_FROM = 'convertedFrom';
    public const GROUP_BY_CONVERTED_TO = 'convertedTo';
    public const GROUP_BY_DIRECTION = 'direction';
    public const GROUP_BY_DISCONNECT_TYPE = 'disconnectType';
    public const GROUP_BY_DIVISION_ID = 'divisionId';
    public const GROUP_BY_DNIS = 'dnis';
    public const GROUP_BY_EDGE_ID = 'edgeId';
    public const GROUP_BY_ENDING_LANGUAGE = 'endingLanguage';
    public const GROUP_BY_ENTRY_REASON = 'entryReason';
    public const GROUP_BY_ENTRY_TYPE = 'entryType';
    public const GROUP_BY_EXIT_REASON = 'exitReason';
    public const GROUP_BY_EXTERNAL_CONTACT_ID = 'externalContactId';
    public const GROUP_BY_EXTERNAL_MEDIA_COUNT = 'externalMediaCount';
    public const GROUP_BY_EXTERNAL_ORGANIZATION_ID = 'externalOrganizationId';
    public const GROUP_BY_FLAGGED_REASON = 'flaggedReason';
    public const GROUP_BY_FLOW_ID = 'flowId';
    public const GROUP_BY_FLOW_MILESTONE_ID = 'flowMilestoneId';
    public const GROUP_BY_FLOW_NAME = 'flowName';
    public const GROUP_BY_FLOW_OUT_TYPE = 'flowOutType';
    public const GROUP_BY_FLOW_OUTCOME = 'flowOutcome';
    public const GROUP_BY_FLOW_OUTCOME_ID = 'flowOutcomeId';
    public const GROUP_BY_FLOW_OUTCOME_VALUE = 'flowOutcomeValue';
    public const GROUP_BY_FLOW_TYPE = 'flowType';
    public const GROUP_BY_FLOW_VERSION = 'flowVersion';
    public const GROUP_BY_GROUP_ID = 'groupId';
    public const GROUP_BY_INTERACTION_TYPE = 'interactionType';
    public const GROUP_BY_JOURNEY_ACTION_ID = 'journeyActionId';
    public const GROUP_BY_JOURNEY_ACTION_MAP_ID = 'journeyActionMapId';
    public const GROUP_BY_JOURNEY_ACTION_MAP_VERSION = 'journeyActionMapVersion';
    public const GROUP_BY_JOURNEY_CUSTOMER_ID = 'journeyCustomerId';
    public const GROUP_BY_JOURNEY_CUSTOMER_ID_TYPE = 'journeyCustomerIdType';
    public const GROUP_BY_JOURNEY_CUSTOMER_SESSION_ID = 'journeyCustomerSessionId';
    public const GROUP_BY_JOURNEY_CUSTOMER_SESSION_ID_TYPE = 'journeyCustomerSessionIdType';
    public const GROUP_BY_MEDIA_COUNT = 'mediaCount';
    public const GROUP_BY_MEDIA_TYPE = 'mediaType';
    public const GROUP_BY_MESSAGE_TYPE = 'messageType';
    public const GROUP_BY_ORIGINATING_DIRECTION = 'originatingDirection';
    public const GROUP_BY_OUTBOUND_CAMPAIGN_ID = 'outboundCampaignId';
    public const GROUP_BY_OUTBOUND_CONTACT_ID = 'outboundContactId';
    public const GROUP_BY_OUTBOUND_CONTACT_LIST_ID = 'outboundContactListId';
    public const GROUP_BY_PARTICIPANT_NAME = 'participantName';
    public const GROUP_BY_PEER_ID = 'peerId';
    public const GROUP_BY_PROPOSED_AGENT_ID = 'proposedAgentId';
    public const GROUP_BY_PROVIDER = 'provider';
    public const GROUP_BY_PURPOSE = 'purpose';
    public const GROUP_BY_QUEUE_ID = 'queueId';
    public const GROUP_BY_REMOTE = 'remote';
    public const GROUP_BY_REQUESTED_LANGUAGE_ID = 'requestedLanguageId';
    public const GROUP_BY_REQUESTED_ROUTING = 'requestedRouting';
    public const GROUP_BY_REQUESTED_ROUTING_SKILL_ID = 'requestedRoutingSkillId';
    public const GROUP_BY_ROOM_ID = 'roomId';
    public const GROUP_BY_ROUTING_PRIORITY = 'routingPriority';
    public const GROUP_BY_SCORED_AGENT_ID = 'scoredAgentId';
    public const GROUP_BY_SELECTED_AGENT_ID = 'selectedAgentId';
    public const GROUP_BY_SELECTED_AGENT_RANK = 'selectedAgentRank';
    public const GROUP_BY_SESSION_DNIS = 'sessionDnis';
    public const GROUP_BY_SESSION_ID = 'sessionId';
    public const GROUP_BY_STARTING_LANGUAGE = 'startingLanguage';
    public const GROUP_BY_STATION_ID = 'stationId';
    public const GROUP_BY_TEAM_ID = 'teamId';
    public const GROUP_BY_TRANSFER_TARGET_ADDRESS = 'transferTargetAddress';
    public const GROUP_BY_TRANSFER_TARGET_NAME = 'transferTargetName';
    public const GROUP_BY_TRANSFER_TYPE = 'transferType';
    public const GROUP_BY_USED_ROUTING = 'usedRouting';
    public const GROUP_BY_USER_ID = 'userId';
    public const GROUP_BY_WRAP_UP_CODE = 'wrapUpCode';
    public const METRICS_N_FLOW = 'nFlow';
    public const METRICS_N_FLOW_MILESTONE = 'nFlowMilestone';
    public const METRICS_N_FLOW_OUTCOME = 'nFlowOutcome';
    public const METRICS_N_FLOW_OUTCOME_FAILED = 'nFlowOutcomeFailed';
    public const METRICS_O_FLOW = 'oFlow';
    public const METRICS_O_FLOW_MILESTONE = 'oFlowMilestone';
    public const METRICS_T_FLOW = 'tFlow';
    public const METRICS_T_FLOW_DISCONNECT = 'tFlowDisconnect';
    public const METRICS_T_FLOW_EXIT = 'tFlowExit';
    public const METRICS_T_FLOW_OUTCOME = 'tFlowOutcome';
    public const ALTERNATE_TIME_DIMENSION_EVENT_TIME = 'eventTime';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getGroupByAllowableValues()
    {
        return [
            self::GROUP_BY_ADDRESS_FROM,
            self::GROUP_BY_ADDRESS_TO,
            self::GROUP_BY_AGENT_ASSISTANT_ID,
            self::GROUP_BY_AGENT_RANK,
            self::GROUP_BY_AGENT_SCORE,
            self::GROUP_BY_ANI,
            self::GROUP_BY_CONVERSATION_ID,
            self::GROUP_BY_CONVERTED_FROM,
            self::GROUP_BY_CONVERTED_TO,
            self::GROUP_BY_DIRECTION,
            self::GROUP_BY_DISCONNECT_TYPE,
            self::GROUP_BY_DIVISION_ID,
            self::GROUP_BY_DNIS,
            self::GROUP_BY_EDGE_ID,
            self::GROUP_BY_ENDING_LANGUAGE,
            self::GROUP_BY_ENTRY_REASON,
            self::GROUP_BY_ENTRY_TYPE,
            self::GROUP_BY_EXIT_REASON,
            self::GROUP_BY_EXTERNAL_CONTACT_ID,
            self::GROUP_BY_EXTERNAL_MEDIA_COUNT,
            self::GROUP_BY_EXTERNAL_ORGANIZATION_ID,
            self::GROUP_BY_FLAGGED_REASON,
            self::GROUP_BY_FLOW_ID,
            self::GROUP_BY_FLOW_MILESTONE_ID,
            self::GROUP_BY_FLOW_NAME,
            self::GROUP_BY_FLOW_OUT_TYPE,
            self::GROUP_BY_FLOW_OUTCOME,
            self::GROUP_BY_FLOW_OUTCOME_ID,
            self::GROUP_BY_FLOW_OUTCOME_VALUE,
            self::GROUP_BY_FLOW_TYPE,
            self::GROUP_BY_FLOW_VERSION,
            self::GROUP_BY_GROUP_ID,
            self::GROUP_BY_INTERACTION_TYPE,
            self::GROUP_BY_JOURNEY_ACTION_ID,
            self::GROUP_BY_JOURNEY_ACTION_MAP_ID,
            self::GROUP_BY_JOURNEY_ACTION_MAP_VERSION,
            self::GROUP_BY_JOURNEY_CUSTOMER_ID,
            self::GROUP_BY_JOURNEY_CUSTOMER_ID_TYPE,
            self::GROUP_BY_JOURNEY_CUSTOMER_SESSION_ID,
            self::GROUP_BY_JOURNEY_CUSTOMER_SESSION_ID_TYPE,
            self::GROUP_BY_MEDIA_COUNT,
            self::GROUP_BY_MEDIA_TYPE,
            self::GROUP_BY_MESSAGE_TYPE,
            self::GROUP_BY_ORIGINATING_DIRECTION,
            self::GROUP_BY_OUTBOUND_CAMPAIGN_ID,
            self::GROUP_BY_OUTBOUND_CONTACT_ID,
            self::GROUP_BY_OUTBOUND_CONTACT_LIST_ID,
            self::GROUP_BY_PARTICIPANT_NAME,
            self::GROUP_BY_PEER_ID,
            self::GROUP_BY_PROPOSED_AGENT_ID,
            self::GROUP_BY_PROVIDER,
            self::GROUP_BY_PURPOSE,
            self::GROUP_BY_QUEUE_ID,
            self::GROUP_BY_REMOTE,
            self::GROUP_BY_REQUESTED_LANGUAGE_ID,
            self::GROUP_BY_REQUESTED_ROUTING,
            self::GROUP_BY_REQUESTED_ROUTING_SKILL_ID,
            self::GROUP_BY_ROOM_ID,
            self::GROUP_BY_ROUTING_PRIORITY,
            self::GROUP_BY_SCORED_AGENT_ID,
            self::GROUP_BY_SELECTED_AGENT_ID,
            self::GROUP_BY_SELECTED_AGENT_RANK,
            self::GROUP_BY_SESSION_DNIS,
            self::GROUP_BY_SESSION_ID,
            self::GROUP_BY_STARTING_LANGUAGE,
            self::GROUP_BY_STATION_ID,
            self::GROUP_BY_TEAM_ID,
            self::GROUP_BY_TRANSFER_TARGET_ADDRESS,
            self::GROUP_BY_TRANSFER_TARGET_NAME,
            self::GROUP_BY_TRANSFER_TYPE,
            self::GROUP_BY_USED_ROUTING,
            self::GROUP_BY_USER_ID,
            self::GROUP_BY_WRAP_UP_CODE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_N_FLOW,
            self::METRICS_N_FLOW_MILESTONE,
            self::METRICS_N_FLOW_OUTCOME,
            self::METRICS_N_FLOW_OUTCOME_FAILED,
            self::METRICS_O_FLOW,
            self::METRICS_O_FLOW_MILESTONE,
            self::METRICS_T_FLOW,
            self::METRICS_T_FLOW_DISCONNECT,
            self::METRICS_T_FLOW_EXIT,
            self::METRICS_T_FLOW_OUTCOME,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlternateTimeDimensionAllowableValues()
    {
        return [
            self::ALTERNATE_TIME_DIMENSION_EVENT_TIME,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['granularity'] = isset($data['granularity']) ? $data['granularity'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['groupBy'] = isset($data['groupBy']) ? $data['groupBy'] : null;
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
        $this->container['flattenMultivaluedDimensions'] = isset($data['flattenMultivaluedDimensions']) ? $data['flattenMultivaluedDimensions'] : null;
        $this->container['views'] = isset($data['views']) ? $data['views'] : null;
        $this->container['alternateTimeDimension'] = isset($data['alternateTimeDimension']) ? $data['alternateTimeDimension'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['interval'] === null) {
            $invalid_properties[] = "'interval' can't be null";
        }
        $allowed_values = array("eventTime");
        if (!in_array($this->container['alternateTimeDimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'alternateTimeDimension', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['interval'] === null) {
            return false;
        }
        $allowed_values = array("eventTime");
        if (!in_array($this->container['alternateTimeDimension'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets granularity
     * @return string
     */
    public function getGranularity()
    {
        return $this->container['granularity'];
    }

    /**
     * Sets granularity
     * @param string $granularity Granularity aggregates metrics into subpartitions within the time interval specified. The default granularity is the same duration as the interval. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H
     * @return $this
     */
    public function setGranularity($granularity)
    {
        $this->container['granularity'] = $granularity;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets groupBy
     * @return string[]
     */
    public function getGroupBy()
    {
        return $this->container['groupBy'];
    }

    /**
     * Sets groupBy
     * @param string[] $groupBy Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.
     * @return $this
     */
    public function setGroupBy($groupBy)
    {
        $allowed_values = array('addressFrom', 'addressTo', 'agentAssistantId', 'agentRank', 'agentScore', 'ani', 'conversationId', 'convertedFrom', 'convertedTo', 'direction', 'disconnectType', 'divisionId', 'dnis', 'edgeId', 'endingLanguage', 'entryReason', 'entryType', 'exitReason', 'externalContactId', 'externalMediaCount', 'externalOrganizationId', 'flaggedReason', 'flowId', 'flowMilestoneId', 'flowName', 'flowOutType', 'flowOutcome', 'flowOutcomeId', 'flowOutcomeValue', 'flowType', 'flowVersion', 'groupId', 'interactionType', 'journeyActionId', 'journeyActionMapId', 'journeyActionMapVersion', 'journeyCustomerId', 'journeyCustomerIdType', 'journeyCustomerSessionId', 'journeyCustomerSessionIdType', 'mediaCount', 'mediaType', 'messageType', 'originatingDirection', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'participantName', 'peerId', 'proposedAgentId', 'provider', 'purpose', 'queueId', 'remote', 'requestedLanguageId', 'requestedRouting', 'requestedRoutingSkillId', 'roomId', 'routingPriority', 'scoredAgentId', 'selectedAgentId', 'selectedAgentRank', 'sessionDnis', 'sessionId', 'startingLanguage', 'stationId', 'teamId', 'transferTargetAddress', 'transferTargetName', 'transferType', 'usedRouting', 'userId', 'wrapUpCode');
        if (!in_array($groupBy, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'groupBy', must be one of 'addressFrom', 'addressTo', 'agentAssistantId', 'agentRank', 'agentScore', 'ani', 'conversationId', 'convertedFrom', 'convertedTo', 'direction', 'disconnectType', 'divisionId', 'dnis', 'edgeId', 'endingLanguage', 'entryReason', 'entryType', 'exitReason', 'externalContactId', 'externalMediaCount', 'externalOrganizationId', 'flaggedReason', 'flowId', 'flowMilestoneId', 'flowName', 'flowOutType', 'flowOutcome', 'flowOutcomeId', 'flowOutcomeValue', 'flowType', 'flowVersion', 'groupId', 'interactionType', 'journeyActionId', 'journeyActionMapId', 'journeyActionMapVersion', 'journeyCustomerId', 'journeyCustomerIdType', 'journeyCustomerSessionId', 'journeyCustomerSessionIdType', 'mediaCount', 'mediaType', 'messageType', 'originatingDirection', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'participantName', 'peerId', 'proposedAgentId', 'provider', 'purpose', 'queueId', 'remote', 'requestedLanguageId', 'requestedRouting', 'requestedRoutingSkillId', 'roomId', 'routingPriority', 'scoredAgentId', 'selectedAgentId', 'selectedAgentRank', 'sessionDnis', 'sessionId', 'startingLanguage', 'stationId', 'teamId', 'transferTargetAddress', 'transferTargetName', 'transferType', 'usedRouting', 'userId', 'wrapUpCode'");
        }
        $this->container['groupBy'] = $groupBy;

        return $this;
    }

    /**
     * Gets filter
     * @return \PureCloudSDK\FlowAggregateQueryFilter
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\FlowAggregateQueryFilter $filter Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('nFlow', 'nFlowMilestone', 'nFlowOutcome', 'nFlowOutcomeFailed', 'oFlow', 'oFlowMilestone', 'tFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlowOutcome');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'nFlow', 'nFlowMilestone', 'nFlowOutcome', 'nFlowOutcomeFailed', 'oFlow', 'oFlowMilestone', 'tFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlowOutcome'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets flattenMultivaluedDimensions
     * @return bool
     */
    public function getFlattenMultivaluedDimensions()
    {
        return $this->container['flattenMultivaluedDimensions'];
    }

    /**
     * Sets flattenMultivaluedDimensions
     * @param bool $flattenMultivaluedDimensions Flattens any multivalued dimensions used in response groups (e.g. ['a','b','c']->'a,b,c')
     * @return $this
     */
    public function setFlattenMultivaluedDimensions($flattenMultivaluedDimensions)
    {
        $this->container['flattenMultivaluedDimensions'] = $flattenMultivaluedDimensions;

        return $this;
    }

    /**
     * Gets views
     * @return \PureCloudSDK\FlowAggregationView[]
     */
    public function getViews()
    {
        return $this->container['views'];
    }

    /**
     * Sets views
     * @param \PureCloudSDK\FlowAggregationView[] $views Custom derived metric views
     * @return $this
     */
    public function setViews($views)
    {
        $this->container['views'] = $views;

        return $this;
    }

    /**
     * Gets alternateTimeDimension
     * @return string
     */
    public function getAlternateTimeDimension()
    {
        return $this->container['alternateTimeDimension'];
    }

    /**
     * Sets alternateTimeDimension
     * @param string $alternateTimeDimension Dimension to use as the alternative timestamp for data in the aggregate.  Choosing \"eventTime\" uses the actual time of the data event.
     * @return $this
     */
    public function setAlternateTimeDimension($alternateTimeDimension)
    {
        $allowed_values = array('eventTime');
        if (!in_array($alternateTimeDimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alternateTimeDimension', must be one of 'eventTime'");
        }
        $this->container['alternateTimeDimension'] = $alternateTimeDimension;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
