<?php

/**
 * Recording
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * Recording Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Recording implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Recording';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'conversationId' => 'string',
        'path' => 'string',
        'startTime' => 'string',
        'endTime' => 'string',
        'media' => 'string',
        'annotations' => '\PureCloudSDK\Annotation[]',
        'transcript' => '\PureCloudSDK\ChatMessage[]',
        'emailTranscript' => '\PureCloudSDK\RecordingEmailMessage[]',
        'messagingTranscript' => '\PureCloudSDK\RecordingMessagingMessage[]',
        'fileState' => 'string',
        'restoreExpirationTime' => '\DateTime',
        'mediaUris' => 'map[string,\PureCloudSDK\MediaResult]',
        'estimatedTranscodeTimeMs' => 'int',
        'actualTranscodeTimeMs' => 'int',
        'archiveDate' => '\DateTime',
        'archiveMedium' => 'string',
        'deleteDate' => '\DateTime',
        'exportDate' => '\DateTime',
        'exportedDate' => '\DateTime',
        'outputDurationMs' => 'int',
        'outputSizeInBytes' => 'int',
        'maxAllowedRestorationsForOrg' => 'int',
        'remainingRestorationsAllowedForOrg' => 'int',
        'sessionId' => 'string',
        'users' => '\PureCloudSDK\User[]',
        'recordingFileRole' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'conversationId' => 'conversationId',
        'path' => 'path',
        'startTime' => 'startTime',
        'endTime' => 'endTime',
        'media' => 'media',
        'annotations' => 'annotations',
        'transcript' => 'transcript',
        'emailTranscript' => 'emailTranscript',
        'messagingTranscript' => 'messagingTranscript',
        'fileState' => 'fileState',
        'restoreExpirationTime' => 'restoreExpirationTime',
        'mediaUris' => 'mediaUris',
        'estimatedTranscodeTimeMs' => 'estimatedTranscodeTimeMs',
        'actualTranscodeTimeMs' => 'actualTranscodeTimeMs',
        'archiveDate' => 'archiveDate',
        'archiveMedium' => 'archiveMedium',
        'deleteDate' => 'deleteDate',
        'exportDate' => 'exportDate',
        'exportedDate' => 'exportedDate',
        'outputDurationMs' => 'outputDurationMs',
        'outputSizeInBytes' => 'outputSizeInBytes',
        'maxAllowedRestorationsForOrg' => 'maxAllowedRestorationsForOrg',
        'remainingRestorationsAllowedForOrg' => 'remainingRestorationsAllowedForOrg',
        'sessionId' => 'sessionId',
        'users' => 'users',
        'recordingFileRole' => 'recordingFileRole',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'conversationId' => 'setConversationId',
        'path' => 'setPath',
        'startTime' => 'setStartTime',
        'endTime' => 'setEndTime',
        'media' => 'setMedia',
        'annotations' => 'setAnnotations',
        'transcript' => 'setTranscript',
        'emailTranscript' => 'setEmailTranscript',
        'messagingTranscript' => 'setMessagingTranscript',
        'fileState' => 'setFileState',
        'restoreExpirationTime' => 'setRestoreExpirationTime',
        'mediaUris' => 'setMediaUris',
        'estimatedTranscodeTimeMs' => 'setEstimatedTranscodeTimeMs',
        'actualTranscodeTimeMs' => 'setActualTranscodeTimeMs',
        'archiveDate' => 'setArchiveDate',
        'archiveMedium' => 'setArchiveMedium',
        'deleteDate' => 'setDeleteDate',
        'exportDate' => 'setExportDate',
        'exportedDate' => 'setExportedDate',
        'outputDurationMs' => 'setOutputDurationMs',
        'outputSizeInBytes' => 'setOutputSizeInBytes',
        'maxAllowedRestorationsForOrg' => 'setMaxAllowedRestorationsForOrg',
        'remainingRestorationsAllowedForOrg' => 'setRemainingRestorationsAllowedForOrg',
        'sessionId' => 'setSessionId',
        'users' => 'setUsers',
        'recordingFileRole' => 'setRecordingFileRole',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'conversationId' => 'getConversationId',
        'path' => 'getPath',
        'startTime' => 'getStartTime',
        'endTime' => 'getEndTime',
        'media' => 'getMedia',
        'annotations' => 'getAnnotations',
        'transcript' => 'getTranscript',
        'emailTranscript' => 'getEmailTranscript',
        'messagingTranscript' => 'getMessagingTranscript',
        'fileState' => 'getFileState',
        'restoreExpirationTime' => 'getRestoreExpirationTime',
        'mediaUris' => 'getMediaUris',
        'estimatedTranscodeTimeMs' => 'getEstimatedTranscodeTimeMs',
        'actualTranscodeTimeMs' => 'getActualTranscodeTimeMs',
        'archiveDate' => 'getArchiveDate',
        'archiveMedium' => 'getArchiveMedium',
        'deleteDate' => 'getDeleteDate',
        'exportDate' => 'getExportDate',
        'exportedDate' => 'getExportedDate',
        'outputDurationMs' => 'getOutputDurationMs',
        'outputSizeInBytes' => 'getOutputSizeInBytes',
        'maxAllowedRestorationsForOrg' => 'getMaxAllowedRestorationsForOrg',
        'remainingRestorationsAllowedForOrg' => 'getRemainingRestorationsAllowedForOrg',
        'sessionId' => 'getSessionId',
        'users' => 'getUsers',
        'recordingFileRole' => 'getRecordingFileRole',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const FILE_STATE_ARCHIVED = 'ARCHIVED';
    public const FILE_STATE_AVAILABLE = 'AVAILABLE';
    public const FILE_STATE_DELETED = 'DELETED';
    public const FILE_STATE_RESTORED = 'RESTORED';
    public const FILE_STATE_RESTORING = 'RESTORING';
    public const FILE_STATE_UPLOADING = 'UPLOADING';
    public const FILE_STATE_ERROR = 'ERROR';
    public const ARCHIVE_MEDIUM_CLOUDARCHIVE = 'CLOUDARCHIVE';
    public const RECORDING_FILE_ROLE_CUSTOMER_EXPERIENCE = 'CUSTOMER_EXPERIENCE';
    public const RECORDING_FILE_ROLE_ADHOC = 'ADHOC';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFileStateAllowableValues()
    {
        return [
            self::FILE_STATE_ARCHIVED,
            self::FILE_STATE_AVAILABLE,
            self::FILE_STATE_DELETED,
            self::FILE_STATE_RESTORED,
            self::FILE_STATE_RESTORING,
            self::FILE_STATE_UPLOADING,
            self::FILE_STATE_ERROR,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getArchiveMediumAllowableValues()
    {
        return [
            self::ARCHIVE_MEDIUM_CLOUDARCHIVE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRecordingFileRoleAllowableValues()
    {
        return [
            self::RECORDING_FILE_ROLE_CUSTOMER_EXPERIENCE,
            self::RECORDING_FILE_ROLE_ADHOC,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['conversationId'] = isset($data['conversationId']) ? $data['conversationId'] : null;
        $this->container['path'] = isset($data['path']) ? $data['path'] : null;
        $this->container['startTime'] = isset($data['startTime']) ? $data['startTime'] : null;
        $this->container['endTime'] = isset($data['endTime']) ? $data['endTime'] : null;
        $this->container['media'] = isset($data['media']) ? $data['media'] : null;
        $this->container['annotations'] = isset($data['annotations']) ? $data['annotations'] : null;
        $this->container['transcript'] = isset($data['transcript']) ? $data['transcript'] : null;
        $this->container['emailTranscript'] = isset($data['emailTranscript']) ? $data['emailTranscript'] : null;
        $this->container['messagingTranscript'] = isset($data['messagingTranscript']) ? $data['messagingTranscript'] : null;
        $this->container['fileState'] = isset($data['fileState']) ? $data['fileState'] : null;
        $this->container['restoreExpirationTime'] = isset($data['restoreExpirationTime']) ? $data['restoreExpirationTime'] : null;
        $this->container['mediaUris'] = isset($data['mediaUris']) ? $data['mediaUris'] : null;
        $this->container['estimatedTranscodeTimeMs'] = isset($data['estimatedTranscodeTimeMs']) ? $data['estimatedTranscodeTimeMs'] : null;
        $this->container['actualTranscodeTimeMs'] = isset($data['actualTranscodeTimeMs']) ? $data['actualTranscodeTimeMs'] : null;
        $this->container['archiveDate'] = isset($data['archiveDate']) ? $data['archiveDate'] : null;
        $this->container['archiveMedium'] = isset($data['archiveMedium']) ? $data['archiveMedium'] : null;
        $this->container['deleteDate'] = isset($data['deleteDate']) ? $data['deleteDate'] : null;
        $this->container['exportDate'] = isset($data['exportDate']) ? $data['exportDate'] : null;
        $this->container['exportedDate'] = isset($data['exportedDate']) ? $data['exportedDate'] : null;
        $this->container['outputDurationMs'] = isset($data['outputDurationMs']) ? $data['outputDurationMs'] : null;
        $this->container['outputSizeInBytes'] = isset($data['outputSizeInBytes']) ? $data['outputSizeInBytes'] : null;
        $this->container['maxAllowedRestorationsForOrg'] = isset($data['maxAllowedRestorationsForOrg']) ? $data['maxAllowedRestorationsForOrg'] : null;
        $this->container['remainingRestorationsAllowedForOrg'] = isset($data['remainingRestorationsAllowedForOrg']) ? $data['remainingRestorationsAllowedForOrg'] : null;
        $this->container['sessionId'] = isset($data['sessionId']) ? $data['sessionId'] : null;
        $this->container['users'] = isset($data['users']) ? $data['users'] : null;
        $this->container['recordingFileRole'] = isset($data['recordingFileRole']) ? $data['recordingFileRole'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ARCHIVED", "AVAILABLE", "DELETED", "RESTORED", "RESTORING", "UPLOADING", "ERROR");
        if (!in_array($this->container['fileState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'fileState', must be one of #{allowed_values}.";
        }

        $allowed_values = array("CLOUDARCHIVE");
        if (!in_array($this->container['archiveMedium'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'archiveMedium', must be one of #{allowed_values}.";
        }

        $allowed_values = array("CUSTOMER_EXPERIENCE", "ADHOC");
        if (!in_array($this->container['recordingFileRole'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'recordingFileRole', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ARCHIVED", "AVAILABLE", "DELETED", "RESTORED", "RESTORING", "UPLOADING", "ERROR");
        if (!in_array($this->container['fileState'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("CLOUDARCHIVE");
        if (!in_array($this->container['archiveMedium'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("CUSTOMER_EXPERIENCE", "ADHOC");
        if (!in_array($this->container['recordingFileRole'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets conversationId
     * @return string
     */
    public function getConversationId()
    {
        return $this->container['conversationId'];
    }

    /**
     * Sets conversationId
     * @param string $conversationId
     * @return $this
     */
    public function setConversationId($conversationId)
    {
        $this->container['conversationId'] = $conversationId;

        return $this;
    }

    /**
     * Gets path
     * @return string
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     * @param string $path
     * @return $this
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets startTime
     * @return string
     */
    public function getStartTime()
    {
        return $this->container['startTime'];
    }

    /**
     * Sets startTime
     * @param string $startTime The start time of the recording. Null when there is no playable media.
     * @return $this
     */
    public function setStartTime($startTime)
    {
        $this->container['startTime'] = $startTime;

        return $this;
    }

    /**
     * Gets endTime
     * @return string
     */
    public function getEndTime()
    {
        return $this->container['endTime'];
    }

    /**
     * Sets endTime
     * @param string $endTime The end time of the recording. Null when there is no playable media.
     * @return $this
     */
    public function setEndTime($endTime)
    {
        $this->container['endTime'] = $endTime;

        return $this;
    }

    /**
     * Gets media
     * @return string
     */
    public function getMedia()
    {
        return $this->container['media'];
    }

    /**
     * Sets media
     * @param string $media The type of media that the recording is. At the moment that could be audio, chat, or email.
     * @return $this
     */
    public function setMedia($media)
    {
        $this->container['media'] = $media;

        return $this;
    }

    /**
     * Gets annotations
     * @return \PureCloudSDK\Annotation[]
     */
    public function getAnnotations()
    {
        return $this->container['annotations'];
    }

    /**
     * Sets annotations
     * @param \PureCloudSDK\Annotation[] $annotations Annotations that belong to the recording.
     * @return $this
     */
    public function setAnnotations($annotations)
    {
        $this->container['annotations'] = $annotations;

        return $this;
    }

    /**
     * Gets transcript
     * @return \PureCloudSDK\ChatMessage[]
     */
    public function getTranscript()
    {
        return $this->container['transcript'];
    }

    /**
     * Sets transcript
     * @param \PureCloudSDK\ChatMessage[] $transcript Represents a chat transcript
     * @return $this
     */
    public function setTranscript($transcript)
    {
        $this->container['transcript'] = $transcript;

        return $this;
    }

    /**
     * Gets emailTranscript
     * @return \PureCloudSDK\RecordingEmailMessage[]
     */
    public function getEmailTranscript()
    {
        return $this->container['emailTranscript'];
    }

    /**
     * Sets emailTranscript
     * @param \PureCloudSDK\RecordingEmailMessage[] $emailTranscript Represents an email transcript
     * @return $this
     */
    public function setEmailTranscript($emailTranscript)
    {
        $this->container['emailTranscript'] = $emailTranscript;

        return $this;
    }

    /**
     * Gets messagingTranscript
     * @return \PureCloudSDK\RecordingMessagingMessage[]
     */
    public function getMessagingTranscript()
    {
        return $this->container['messagingTranscript'];
    }

    /**
     * Sets messagingTranscript
     * @param \PureCloudSDK\RecordingMessagingMessage[] $messagingTranscript Represents a messaging transcript
     * @return $this
     */
    public function setMessagingTranscript($messagingTranscript)
    {
        $this->container['messagingTranscript'] = $messagingTranscript;

        return $this;
    }

    /**
     * Gets fileState
     * @return string
     */
    public function getFileState()
    {
        return $this->container['fileState'];
    }

    /**
     * Sets fileState
     * @param string $fileState Represents the current file state for a recording. Examples: Uploading, Archived, etc
     * @return $this
     */
    public function setFileState($fileState)
    {
        $allowed_values = array('ARCHIVED', 'AVAILABLE', 'DELETED', 'RESTORED', 'RESTORING', 'UPLOADING', 'ERROR');
        if (!in_array($fileState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'fileState', must be one of 'ARCHIVED', 'AVAILABLE', 'DELETED', 'RESTORED', 'RESTORING', 'UPLOADING', 'ERROR'");
        }
        $this->container['fileState'] = $fileState;

        return $this;
    }

    /**
     * Gets restoreExpirationTime
     * @return \DateTime
     */
    public function getRestoreExpirationTime()
    {
        return $this->container['restoreExpirationTime'];
    }

    /**
     * Sets restoreExpirationTime
     * @param \DateTime $restoreExpirationTime The amount of time a restored recording will remain restored before being archived again. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setRestoreExpirationTime($restoreExpirationTime)
    {
        $this->container['restoreExpirationTime'] = $restoreExpirationTime;

        return $this;
    }

    /**
     * Gets mediaUris
     * @return map[string,\PureCloudSDK\MediaResult]
     */
    public function getMediaUris()
    {
        return $this->container['mediaUris'];
    }

    /**
     * Sets mediaUris
     * @param map[string,\PureCloudSDK\MediaResult] $mediaUris The different mediaUris for the recording. Null when there is no playable media.
     * @return $this
     */
    public function setMediaUris($mediaUris)
    {
        $this->container['mediaUris'] = $mediaUris;

        return $this;
    }

    /**
     * Gets estimatedTranscodeTimeMs
     * @return int
     */
    public function getEstimatedTranscodeTimeMs()
    {
        return $this->container['estimatedTranscodeTimeMs'];
    }

    /**
     * Sets estimatedTranscodeTimeMs
     * @param int $estimatedTranscodeTimeMs
     * @return $this
     */
    public function setEstimatedTranscodeTimeMs($estimatedTranscodeTimeMs)
    {
        $this->container['estimatedTranscodeTimeMs'] = $estimatedTranscodeTimeMs;

        return $this;
    }

    /**
     * Gets actualTranscodeTimeMs
     * @return int
     */
    public function getActualTranscodeTimeMs()
    {
        return $this->container['actualTranscodeTimeMs'];
    }

    /**
     * Sets actualTranscodeTimeMs
     * @param int $actualTranscodeTimeMs
     * @return $this
     */
    public function setActualTranscodeTimeMs($actualTranscodeTimeMs)
    {
        $this->container['actualTranscodeTimeMs'] = $actualTranscodeTimeMs;

        return $this;
    }

    /**
     * Gets archiveDate
     * @return \DateTime
     */
    public function getArchiveDate()
    {
        return $this->container['archiveDate'];
    }

    /**
     * Sets archiveDate
     * @param \DateTime $archiveDate The date the recording will be archived. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setArchiveDate($archiveDate)
    {
        $this->container['archiveDate'] = $archiveDate;

        return $this;
    }

    /**
     * Gets archiveMedium
     * @return string
     */
    public function getArchiveMedium()
    {
        return $this->container['archiveMedium'];
    }

    /**
     * Sets archiveMedium
     * @param string $archiveMedium The type of archive medium used. Example: CloudArchive
     * @return $this
     */
    public function setArchiveMedium($archiveMedium)
    {
        $allowed_values = array('CLOUDARCHIVE');
        if (!in_array($archiveMedium, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'archiveMedium', must be one of 'CLOUDARCHIVE'");
        }
        $this->container['archiveMedium'] = $archiveMedium;

        return $this;
    }

    /**
     * Gets deleteDate
     * @return \DateTime
     */
    public function getDeleteDate()
    {
        return $this->container['deleteDate'];
    }

    /**
     * Sets deleteDate
     * @param \DateTime $deleteDate The date the recording will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDeleteDate($deleteDate)
    {
        $this->container['deleteDate'] = $deleteDate;

        return $this;
    }

    /**
     * Gets exportDate
     * @return \DateTime
     */
    public function getExportDate()
    {
        return $this->container['exportDate'];
    }

    /**
     * Sets exportDate
     * @param \DateTime $exportDate The date the recording will be exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setExportDate($exportDate)
    {
        $this->container['exportDate'] = $exportDate;

        return $this;
    }

    /**
     * Gets exportedDate
     * @return \DateTime
     */
    public function getExportedDate()
    {
        return $this->container['exportedDate'];
    }

    /**
     * Sets exportedDate
     * @param \DateTime $exportedDate The date the recording was exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setExportedDate($exportedDate)
    {
        $this->container['exportedDate'] = $exportedDate;

        return $this;
    }

    /**
     * Gets outputDurationMs
     * @return int
     */
    public function getOutputDurationMs()
    {
        return $this->container['outputDurationMs'];
    }

    /**
     * Sets outputDurationMs
     * @param int $outputDurationMs Duration of transcoded media in milliseconds
     * @return $this
     */
    public function setOutputDurationMs($outputDurationMs)
    {
        $this->container['outputDurationMs'] = $outputDurationMs;

        return $this;
    }

    /**
     * Gets outputSizeInBytes
     * @return int
     */
    public function getOutputSizeInBytes()
    {
        return $this->container['outputSizeInBytes'];
    }

    /**
     * Sets outputSizeInBytes
     * @param int $outputSizeInBytes Size of transcoded media in bytes. 0 if there is no transcoded media.
     * @return $this
     */
    public function setOutputSizeInBytes($outputSizeInBytes)
    {
        $this->container['outputSizeInBytes'] = $outputSizeInBytes;

        return $this;
    }

    /**
     * Gets maxAllowedRestorationsForOrg
     * @return int
     */
    public function getMaxAllowedRestorationsForOrg()
    {
        return $this->container['maxAllowedRestorationsForOrg'];
    }

    /**
     * Sets maxAllowedRestorationsForOrg
     * @param int $maxAllowedRestorationsForOrg How many archive restorations the organization is allowed to have.
     * @return $this
     */
    public function setMaxAllowedRestorationsForOrg($maxAllowedRestorationsForOrg)
    {
        $this->container['maxAllowedRestorationsForOrg'] = $maxAllowedRestorationsForOrg;

        return $this;
    }

    /**
     * Gets remainingRestorationsAllowedForOrg
     * @return int
     */
    public function getRemainingRestorationsAllowedForOrg()
    {
        return $this->container['remainingRestorationsAllowedForOrg'];
    }

    /**
     * Sets remainingRestorationsAllowedForOrg
     * @param int $remainingRestorationsAllowedForOrg The remaining archive restorations the organization has.
     * @return $this
     */
    public function setRemainingRestorationsAllowedForOrg($remainingRestorationsAllowedForOrg)
    {
        $this->container['remainingRestorationsAllowedForOrg'] = $remainingRestorationsAllowedForOrg;

        return $this;
    }

    /**
     * Gets sessionId
     * @return string
     */
    public function getSessionId()
    {
        return $this->container['sessionId'];
    }

    /**
     * Sets sessionId
     * @param string $sessionId The session id represents an external resource id, such as email, call, chat, etc
     * @return $this
     */
    public function setSessionId($sessionId)
    {
        $this->container['sessionId'] = $sessionId;

        return $this;
    }

    /**
     * Gets users
     * @return \PureCloudSDK\User[]
     */
    public function getUsers()
    {
        return $this->container['users'];
    }

    /**
     * Sets users
     * @param \PureCloudSDK\User[] $users The users participating in the conversation
     * @return $this
     */
    public function setUsers($users)
    {
        $this->container['users'] = $users;

        return $this;
    }

    /**
     * Gets recordingFileRole
     * @return string
     */
    public function getRecordingFileRole()
    {
        return $this->container['recordingFileRole'];
    }

    /**
     * Sets recordingFileRole
     * @param string $recordingFileRole Role of the file recording. It can be either customer_experience or adhoc.
     * @return $this
     */
    public function setRecordingFileRole($recordingFileRole)
    {
        $allowed_values = array('CUSTOMER_EXPERIENCE', 'ADHOC');
        if (!in_array($recordingFileRole, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'recordingFileRole', must be one of 'CUSTOMER_EXPERIENCE', 'ADHOC'");
        }
        $this->container['recordingFileRole'] = $recordingFileRole;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
