<?php

/**
 * RoutePathRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * RoutePathRequest Class Doc Comment
 *
 * @category    Class */
 // @description Route path configuration
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RoutePathRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'RoutePathRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'queueId' => 'string',
        'mediaType' => 'string',
        'languageId' => 'string',
        'skillIds' => 'string[]',
        'sourcePlanningGroup' => '\PureCloudSDK\SourcePlanningGroupRequest'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'queueId' => 'queueId',
        'mediaType' => 'mediaType',
        'languageId' => 'languageId',
        'skillIds' => 'skillIds',
        'sourcePlanningGroup' => 'sourcePlanningGroup'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'queueId' => 'setQueueId',
        'mediaType' => 'setMediaType',
        'languageId' => 'setLanguageId',
        'skillIds' => 'setSkillIds',
        'sourcePlanningGroup' => 'setSourcePlanningGroup'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'queueId' => 'getQueueId',
        'mediaType' => 'getMediaType',
        'languageId' => 'getLanguageId',
        'skillIds' => 'getSkillIds',
        'sourcePlanningGroup' => 'getSourcePlanningGroup'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const MEDIA_TYPE_VOICE = 'Voice';
    public const MEDIA_TYPE_CHAT = 'Chat';
    public const MEDIA_TYPE_EMAIL = 'Email';
    public const MEDIA_TYPE_CALLBACK = 'Callback';
    public const MEDIA_TYPE_MESSAGE = 'Message';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_VOICE,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
            self::MEDIA_TYPE_CALLBACK,
            self::MEDIA_TYPE_MESSAGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['queueId'] = isset($data['queueId']) ? $data['queueId'] : null;
        $this->container['mediaType'] = isset($data['mediaType']) ? $data['mediaType'] : null;
        $this->container['languageId'] = isset($data['languageId']) ? $data['languageId'] : null;
        $this->container['skillIds'] = isset($data['skillIds']) ? $data['skillIds'] : null;
        $this->container['sourcePlanningGroup'] = isset($data['sourcePlanningGroup']) ? $data['sourcePlanningGroup'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['queueId'] === null) {
            $invalid_properties[] = "'queueId' can't be null";
        }
        if ($this->container['mediaType'] === null) {
            $invalid_properties[] = "'mediaType' can't be null";
        }
        $allowed_values = array("Voice", "Chat", "Email", "Callback", "Message");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mediaType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['queueId'] === null) {
            return false;
        }
        if ($this->container['mediaType'] === null) {
            return false;
        }
        $allowed_values = array("Voice", "Chat", "Email", "Callback", "Message");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets queueId
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queueId'];
    }

    /**
     * Sets queueId
     * @param string $queueId The ID of the queue to associate with the route path
     * @return $this
     */
    public function setQueueId($queueId)
    {
        $this->container['queueId'] = $queueId;

        return $this;
    }

    /**
     * Gets mediaType
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['mediaType'];
    }

    /**
     * Sets mediaType
     * @param string $mediaType The media type of the given queue to associate with the route path
     * @return $this
     */
    public function setMediaType($mediaType)
    {
        $allowed_values = array('Voice', 'Chat', 'Email', 'Callback', 'Message');
        if (!in_array($mediaType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaType', must be one of 'Voice', 'Chat', 'Email', 'Callback', 'Message'");
        }
        $this->container['mediaType'] = $mediaType;

        return $this;
    }

    /**
     * Gets languageId
     * @return string
     */
    public function getLanguageId()
    {
        return $this->container['languageId'];
    }

    /**
     * Sets languageId
     * @param string $languageId The ID of the language to associate with the route path
     * @return $this
     */
    public function setLanguageId($languageId)
    {
        $this->container['languageId'] = $languageId;

        return $this;
    }

    /**
     * Gets skillIds
     * @return string[]
     */
    public function getSkillIds()
    {
        return $this->container['skillIds'];
    }

    /**
     * Sets skillIds
     * @param string[] $skillIds The set of skill IDs to associate with the route path
     * @return $this
     */
    public function setSkillIds($skillIds)
    {
        $this->container['skillIds'] = $skillIds;

        return $this;
    }

    /**
     * Gets sourcePlanningGroup
     * @return \PureCloudSDK\SourcePlanningGroupRequest
     */
    public function getSourcePlanningGroup()
    {
        return $this->container['sourcePlanningGroup'];
    }

    /**
     * Sets sourcePlanningGroup
     * @param \PureCloudSDK\SourcePlanningGroupRequest $sourcePlanningGroup The planning group from which to copy route paths
     * @return $this
     */
    public function setSourcePlanningGroup($sourcePlanningGroup)
    {
        $this->container['sourcePlanningGroup'] = $sourcePlanningGroup;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
