<?php

/**
 * SurveyAssignment
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * SurveyAssignment Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SurveyAssignment implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SurveyAssignment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'surveyForm' => '\PureCloudSDK\PublishedSurveyFormReference',
        'flow' => '\PureCloudSDK\DomainEntityRef',
        'inviteTimeInterval' => 'string',
        'sendingUser' => 'string',
        'sendingDomain' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'surveyForm' => 'surveyForm',
        'flow' => 'flow',
        'inviteTimeInterval' => 'inviteTimeInterval',
        'sendingUser' => 'sendingUser',
        'sendingDomain' => 'sendingDomain'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'surveyForm' => 'setSurveyForm',
        'flow' => 'setFlow',
        'inviteTimeInterval' => 'setInviteTimeInterval',
        'sendingUser' => 'setSendingUser',
        'sendingDomain' => 'setSendingDomain'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'surveyForm' => 'getSurveyForm',
        'flow' => 'getFlow',
        'inviteTimeInterval' => 'getInviteTimeInterval',
        'sendingUser' => 'getSendingUser',
        'sendingDomain' => 'getSendingDomain'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['surveyForm'] = isset($data['surveyForm']) ? $data['surveyForm'] : null;
        $this->container['flow'] = isset($data['flow']) ? $data['flow'] : null;
        $this->container['inviteTimeInterval'] = isset($data['inviteTimeInterval']) ? $data['inviteTimeInterval'] : null;
        $this->container['sendingUser'] = isset($data['sendingUser']) ? $data['sendingUser'] : null;
        $this->container['sendingDomain'] = isset($data['sendingDomain']) ? $data['sendingDomain'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['sendingDomain'] === null) {
            $invalid_properties[] = "'sendingDomain' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['sendingDomain'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets surveyForm
     * @return \PureCloudSDK\PublishedSurveyFormReference
     */
    public function getSurveyForm()
    {
        return $this->container['surveyForm'];
    }

    /**
     * Sets surveyForm
     * @param \PureCloudSDK\PublishedSurveyFormReference $surveyForm The survey form used for this survey.
     * @return $this
     */
    public function setSurveyForm($surveyForm)
    {
        $this->container['surveyForm'] = $surveyForm;

        return $this;
    }

    /**
     * Gets flow
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getFlow()
    {
        return $this->container['flow'];
    }

    /**
     * Sets flow
     * @param \PureCloudSDK\DomainEntityRef $flow The URI reference to the flow associated with this survey.
     * @return $this
     */
    public function setFlow($flow)
    {
        $this->container['flow'] = $flow;

        return $this;
    }

    /**
     * Gets inviteTimeInterval
     * @return string
     */
    public function getInviteTimeInterval()
    {
        return $this->container['inviteTimeInterval'];
    }

    /**
     * Sets inviteTimeInterval
     * @param string $inviteTimeInterval An ISO 8601 repeated interval consisting of the number of repetitions, the start datetime, and the interval (e.g. R2/2018-03-01T13:00:00Z/P1M10DT2H30M). Total duration must not exceed 90 days.
     * @return $this
     */
    public function setInviteTimeInterval($inviteTimeInterval)
    {
        $this->container['inviteTimeInterval'] = $inviteTimeInterval;

        return $this;
    }

    /**
     * Gets sendingUser
     * @return string
     */
    public function getSendingUser()
    {
        return $this->container['sendingUser'];
    }

    /**
     * Sets sendingUser
     * @param string $sendingUser User together with sendingDomain used to send email, null to use no-reply
     * @return $this
     */
    public function setSendingUser($sendingUser)
    {
        $this->container['sendingUser'] = $sendingUser;

        return $this;
    }

    /**
     * Gets sendingDomain
     * @return string
     */
    public function getSendingDomain()
    {
        return $this->container['sendingDomain'];
    }

    /**
     * Sets sendingDomain
     * @param string $sendingDomain Validated email domain, required
     * @return $this
     */
    public function setSendingDomain($sendingDomain)
    {
        $this->container['sendingDomain'] = $sendingDomain;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
