<?php
/**
 * AnalyticsParticipant
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsParticipant Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsParticipant implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsParticipant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'participantId' => 'string',
        'participantName' => 'string',
        'userId' => 'string',
        'purpose' => 'string',
        'externalContactId' => 'string',
        'externalOrganizationId' => 'string',
        'sessions' => '\PureCloudSDK\AnalyticsSession[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'participantId' => 'participantId',
        'participantName' => 'participantName',
        'userId' => 'userId',
        'purpose' => 'purpose',
        'externalContactId' => 'externalContactId',
        'externalOrganizationId' => 'externalOrganizationId',
        'sessions' => 'sessions'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'participantId' => 'setParticipantId',
        'participantName' => 'setParticipantName',
        'userId' => 'setUserId',
        'purpose' => 'setPurpose',
        'externalContactId' => 'setExternalContactId',
        'externalOrganizationId' => 'setExternalOrganizationId',
        'sessions' => 'setSessions'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'participantId' => 'getParticipantId',
        'participantName' => 'getParticipantName',
        'userId' => 'getUserId',
        'purpose' => 'getPurpose',
        'externalContactId' => 'getExternalContactId',
        'externalOrganizationId' => 'getExternalOrganizationId',
        'sessions' => 'getSessions'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const PURPOSE_MANUAL = 'manual';
    const PURPOSE_DIALER = 'dialer';
    const PURPOSE_INBOUND = 'inbound';
    const PURPOSE_ACD = 'acd';
    const PURPOSE_IVR = 'ivr';
    const PURPOSE_VOICEMAIL = 'voicemail';
    const PURPOSE_OUTBOUND = 'outbound';
    const PURPOSE_AGENT = 'agent';
    const PURPOSE_USER = 'user';
    const PURPOSE_STATION = 'station';
    const PURPOSE_GROUP = 'group';
    const PURPOSE_CUSTOMER = 'customer';
    const PURPOSE_EXTERNAL = 'external';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPurposeAllowableValues()
    {
        return [
            self::PURPOSE_MANUAL,
            self::PURPOSE_DIALER,
            self::PURPOSE_INBOUND,
            self::PURPOSE_ACD,
            self::PURPOSE_IVR,
            self::PURPOSE_VOICEMAIL,
            self::PURPOSE_OUTBOUND,
            self::PURPOSE_AGENT,
            self::PURPOSE_USER,
            self::PURPOSE_STATION,
            self::PURPOSE_GROUP,
            self::PURPOSE_CUSTOMER,
            self::PURPOSE_EXTERNAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['participantId'] = isset($data['participantId']) ? $data['participantId'] : null;
        $this->container['participantName'] = isset($data['participantName']) ? $data['participantName'] : null;
        $this->container['userId'] = isset($data['userId']) ? $data['userId'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['externalContactId'] = isset($data['externalContactId']) ? $data['externalContactId'] : null;
        $this->container['externalOrganizationId'] = isset($data['externalOrganizationId']) ? $data['externalOrganizationId'] : null;
        $this->container['sessions'] = isset($data['sessions']) ? $data['sessions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("manual", "dialer", "inbound", "acd", "ivr", "voicemail", "outbound", "agent", "user", "station", "group", "customer", "external");
        if (!in_array($this->container['purpose'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'purpose', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("manual", "dialer", "inbound", "acd", "ivr", "voicemail", "outbound", "agent", "user", "station", "group", "customer", "external");
        if (!in_array($this->container['purpose'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets participantId
     * @return string
     */
    public function getParticipantId()
    {
        return $this->container['participantId'];
    }

    /**
     * Sets participantId
     * @param string $participantId
     * @return $this
     */
    public function setParticipantId($participantId)
    {
        $this->container['participantId'] = $participantId;

        return $this;
    }

    /**
     * Gets participantName
     * @return string
     */
    public function getParticipantName()
    {
        return $this->container['participantName'];
    }

    /**
     * Sets participantName
     * @param string $participantName
     * @return $this
     */
    public function setParticipantName($participantName)
    {
        $this->container['participantName'] = $participantName;

        return $this;
    }

    /**
     * Gets userId
     * @return string
     */
    public function getUserId()
    {
        return $this->container['userId'];
    }

    /**
     * Sets userId
     * @param string $userId
     * @return $this
     */
    public function setUserId($userId)
    {
        $this->container['userId'] = $userId;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $allowed_values = array('manual', 'dialer', 'inbound', 'acd', 'ivr', 'voicemail', 'outbound', 'agent', 'user', 'station', 'group', 'customer', 'external');
        if (!in_array($purpose, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'purpose', must be one of 'manual', 'dialer', 'inbound', 'acd', 'ivr', 'voicemail', 'outbound', 'agent', 'user', 'station', 'group', 'customer', 'external'");
        }
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets externalContactId
     * @return string
     */
    public function getExternalContactId()
    {
        return $this->container['externalContactId'];
    }

    /**
     * Sets externalContactId
     * @param string $externalContactId
     * @return $this
     */
    public function setExternalContactId($externalContactId)
    {
        $this->container['externalContactId'] = $externalContactId;

        return $this;
    }

    /**
     * Gets externalOrganizationId
     * @return string
     */
    public function getExternalOrganizationId()
    {
        return $this->container['externalOrganizationId'];
    }

    /**
     * Sets externalOrganizationId
     * @param string $externalOrganizationId
     * @return $this
     */
    public function setExternalOrganizationId($externalOrganizationId)
    {
        $this->container['externalOrganizationId'] = $externalOrganizationId;

        return $this;
    }

    /**
     * Gets sessions
     * @return \PureCloudSDK\AnalyticsSession[]
     */
    public function getSessions()
    {
        return $this->container['sessions'];
    }

    /**
     * Sets sessions
     * @param \PureCloudSDK\AnalyticsSession[] $sessions
     * @return $this
     */
    public function setSessions($sessions)
    {
        $this->container['sessions'] = $sessions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


