<?php
/**
 * ChatMediaPolicyConditions
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ChatMediaPolicyConditions Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ChatMediaPolicyConditions implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ChatMediaPolicyConditions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'forUsers' => '\PureCloudSDK\User[]',
        'dateRanges' => 'string[]',
        'forQueues' => '\PureCloudSDK\Queue[]',
        'wrapupCodes' => '\PureCloudSDK\WrapupCode[]',
        'timeAllowed' => '\PureCloudSDK\TimeAllowed',
        'duration' => '\PureCloudSDK\DurationCondition'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'forUsers' => 'forUsers',
        'dateRanges' => 'dateRanges',
        'forQueues' => 'forQueues',
        'wrapupCodes' => 'wrapupCodes',
        'timeAllowed' => 'timeAllowed',
        'duration' => 'duration'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'forUsers' => 'setForUsers',
        'dateRanges' => 'setDateRanges',
        'forQueues' => 'setForQueues',
        'wrapupCodes' => 'setWrapupCodes',
        'timeAllowed' => 'setTimeAllowed',
        'duration' => 'setDuration'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'forUsers' => 'getForUsers',
        'dateRanges' => 'getDateRanges',
        'forQueues' => 'getForQueues',
        'wrapupCodes' => 'getWrapupCodes',
        'timeAllowed' => 'getTimeAllowed',
        'duration' => 'getDuration'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['forUsers'] = isset($data['forUsers']) ? $data['forUsers'] : null;
        $this->container['dateRanges'] = isset($data['dateRanges']) ? $data['dateRanges'] : null;
        $this->container['forQueues'] = isset($data['forQueues']) ? $data['forQueues'] : null;
        $this->container['wrapupCodes'] = isset($data['wrapupCodes']) ? $data['wrapupCodes'] : null;
        $this->container['timeAllowed'] = isset($data['timeAllowed']) ? $data['timeAllowed'] : null;
        $this->container['duration'] = isset($data['duration']) ? $data['duration'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets forUsers
     * @return \PureCloudSDK\User[]
     */
    public function getForUsers()
    {
        return $this->container['forUsers'];
    }

    /**
     * Sets forUsers
     * @param \PureCloudSDK\User[] $forUsers
     * @return $this
     */
    public function setForUsers($forUsers)
    {
        $this->container['forUsers'] = $forUsers;

        return $this;
    }

    /**
     * Gets dateRanges
     * @return string[]
     */
    public function getDateRanges()
    {
        return $this->container['dateRanges'];
    }

    /**
     * Sets dateRanges
     * @param string[] $dateRanges
     * @return $this
     */
    public function setDateRanges($dateRanges)
    {
        $this->container['dateRanges'] = $dateRanges;

        return $this;
    }

    /**
     * Gets forQueues
     * @return \PureCloudSDK\Queue[]
     */
    public function getForQueues()
    {
        return $this->container['forQueues'];
    }

    /**
     * Sets forQueues
     * @param \PureCloudSDK\Queue[] $forQueues
     * @return $this
     */
    public function setForQueues($forQueues)
    {
        $this->container['forQueues'] = $forQueues;

        return $this;
    }

    /**
     * Gets wrapupCodes
     * @return \PureCloudSDK\WrapupCode[]
     */
    public function getWrapupCodes()
    {
        return $this->container['wrapupCodes'];
    }

    /**
     * Sets wrapupCodes
     * @param \PureCloudSDK\WrapupCode[] $wrapupCodes
     * @return $this
     */
    public function setWrapupCodes($wrapupCodes)
    {
        $this->container['wrapupCodes'] = $wrapupCodes;

        return $this;
    }

    /**
     * Gets timeAllowed
     * @return \PureCloudSDK\TimeAllowed
     */
    public function getTimeAllowed()
    {
        return $this->container['timeAllowed'];
    }

    /**
     * Sets timeAllowed
     * @param \PureCloudSDK\TimeAllowed $timeAllowed
     * @return $this
     */
    public function setTimeAllowed($timeAllowed)
    {
        $this->container['timeAllowed'] = $timeAllowed;

        return $this;
    }

    /**
     * Gets duration
     * @return \PureCloudSDK\DurationCondition
     */
    public function getDuration()
    {
        return $this->container['duration'];
    }

    /**
     * Sets duration
     * @param \PureCloudSDK\DurationCondition $duration
     * @return $this
     */
    public function setDuration($duration)
    {
        $this->container['duration'] = $duration;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


