<?php
/**
 * Conversation
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Conversation Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Conversation implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Conversation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'startTime' => '\DateTime',
        'endTime' => '\DateTime',
        'address' => 'string',
        'participants' => '\PureCloudSDK\Participant[]',
        'conversationIds' => 'string[]',
        'maxParticipants' => 'int',
        'recordingState' => 'string',
        'state' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'startTime' => 'startTime',
        'endTime' => 'endTime',
        'address' => 'address',
        'participants' => 'participants',
        'conversationIds' => 'conversationIds',
        'maxParticipants' => 'maxParticipants',
        'recordingState' => 'recordingState',
        'state' => 'state',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'startTime' => 'setStartTime',
        'endTime' => 'setEndTime',
        'address' => 'setAddress',
        'participants' => 'setParticipants',
        'conversationIds' => 'setConversationIds',
        'maxParticipants' => 'setMaxParticipants',
        'recordingState' => 'setRecordingState',
        'state' => 'setState',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'startTime' => 'getStartTime',
        'endTime' => 'getEndTime',
        'address' => 'getAddress',
        'participants' => 'getParticipants',
        'conversationIds' => 'getConversationIds',
        'maxParticipants' => 'getMaxParticipants',
        'recordingState' => 'getRecordingState',
        'state' => 'getState',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const RECORDING_STATE_ACTIVE = 'ACTIVE';
    const RECORDING_STATE_PAUSED = 'PAUSED';
    const RECORDING_STATE_NONE = 'NONE';
    const STATE_ALERTING = 'alerting';
    const STATE_DIALING = 'dialing';
    const STATE_CONTACTING = 'contacting';
    const STATE_OFFERING = 'offering';
    const STATE_CONNECTED = 'connected';
    const STATE_DISCONNECTED = 'disconnected';
    const STATE_TERMINATED = 'terminated';
    const STATE_CONVERTING = 'converting';
    const STATE_UPLOADING = 'uploading';
    const STATE_TRANSMITTING = 'transmitting';
    const STATE_NONE = 'none';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRecordingStateAllowableValues()
    {
        return [
            self::RECORDING_STATE_ACTIVE,
            self::RECORDING_STATE_PAUSED,
            self::RECORDING_STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_CONVERTING,
            self::STATE_UPLOADING,
            self::STATE_TRANSMITTING,
            self::STATE_NONE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['startTime'] = isset($data['startTime']) ? $data['startTime'] : null;
        $this->container['endTime'] = isset($data['endTime']) ? $data['endTime'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['participants'] = isset($data['participants']) ? $data['participants'] : null;
        $this->container['conversationIds'] = isset($data['conversationIds']) ? $data['conversationIds'] : null;
        $this->container['maxParticipants'] = isset($data['maxParticipants']) ? $data['maxParticipants'] : null;
        $this->container['recordingState'] = isset($data['recordingState']) ? $data['recordingState'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['startTime'] === null) {
            $invalid_properties[] = "'startTime' can't be null";
        }
        if ($this->container['participants'] === null) {
            $invalid_properties[] = "'participants' can't be null";
        }
        $allowed_values = array("ACTIVE", "PAUSED", "NONE");
        if (!in_array($this->container['recordingState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'recordingState', must be one of #{allowed_values}.";
        }

        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['startTime'] === null) {
            return false;
        }
        if ($this->container['participants'] === null) {
            return false;
        }
        $allowed_values = array("ACTIVE", "PAUSED", "NONE");
        if (!in_array($this->container['recordingState'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets startTime
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['startTime'];
    }

    /**
     * Sets startTime
     * @param \DateTime $startTime The time when the conversation started. This will be the time when the first participant joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartTime($startTime)
    {
        $this->container['startTime'] = $startTime;

        return $this;
    }

    /**
     * Gets endTime
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['endTime'];
    }

    /**
     * Sets endTime
     * @param \DateTime $endTime The time when the conversation ended. This will be the time when the last participant left the conversation, or null when the conversation is still active. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndTime($endTime)
    {
        $this->container['endTime'] = $endTime;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address The address of the conversation as seen from an external participant. For phone calls this will be the DNIS for inbound calls and the ANI for outbound calls. For other media types this will be the address of the destination participant for inbound and the address of the initiating participant for outbound.
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets participants
     * @return \PureCloudSDK\Participant[]
     */
    public function getParticipants()
    {
        return $this->container['participants'];
    }

    /**
     * Sets participants
     * @param \PureCloudSDK\Participant[] $participants The list of all participants in the conversation.
     * @return $this
     */
    public function setParticipants($participants)
    {
        $this->container['participants'] = $participants;

        return $this;
    }

    /**
     * Gets conversationIds
     * @return string[]
     */
    public function getConversationIds()
    {
        return $this->container['conversationIds'];
    }

    /**
     * Sets conversationIds
     * @param string[] $conversationIds A list of conversations to merge into this conversation to create a conference. This field is null except when being used to create a conference.
     * @return $this
     */
    public function setConversationIds($conversationIds)
    {
        $this->container['conversationIds'] = $conversationIds;

        return $this;
    }

    /**
     * Gets maxParticipants
     * @return int
     */
    public function getMaxParticipants()
    {
        return $this->container['maxParticipants'];
    }

    /**
     * Sets maxParticipants
     * @param int $maxParticipants If this is a conference conversation, then this field indicates the maximum number of participants allowed to participant in the conference.
     * @return $this
     */
    public function setMaxParticipants($maxParticipants)
    {
        $this->container['maxParticipants'] = $maxParticipants;

        return $this;
    }

    /**
     * Gets recordingState
     * @return string
     */
    public function getRecordingState()
    {
        return $this->container['recordingState'];
    }

    /**
     * Sets recordingState
     * @param string $recordingState On update, 'paused' initiates a secure pause, 'active' resumes any paused recordings; otherwise indicates state of conversation recording.
     * @return $this
     */
    public function setRecordingState($recordingState)
    {
        $allowed_values = array('ACTIVE', 'PAUSED', 'NONE');
        if (!in_array($recordingState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'recordingState', must be one of 'ACTIVE', 'PAUSED', 'NONE'");
        }
        $this->container['recordingState'] = $recordingState;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The conversation's state.  Values can be: 'disconnected'
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'none');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'none'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


