<?php
/**
 * Dependency
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Dependency Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Dependency implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Dependency';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'version' => 'string',
        'type' => 'string',
        'deleted' => 'bool',
        'updated' => 'bool',
        'stateUnknown' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'version' => 'version',
        'type' => 'type',
        'deleted' => 'deleted',
        'updated' => 'updated',
        'stateUnknown' => 'stateUnknown',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'version' => 'setVersion',
        'type' => 'setType',
        'deleted' => 'setDeleted',
        'updated' => 'setUpdated',
        'stateUnknown' => 'setStateUnknown',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'version' => 'getVersion',
        'type' => 'getType',
        'deleted' => 'getDeleted',
        'updated' => 'getUpdated',
        'stateUnknown' => 'getStateUnknown',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_ACDLANGUAGE = 'ACDLANGUAGE';
    const TYPE_ACDSKILL = 'ACDSKILL';
    const TYPE_ACDWRAPUPCODE = 'ACDWRAPUPCODE';
    const TYPE_BRIDGEACTION = 'BRIDGEACTION';
    const TYPE_COMPOSERSCRIPT = 'COMPOSERSCRIPT';
    const TYPE_CONTACTLIST = 'CONTACTLIST';
    const TYPE_DATAACTION = 'DATAACTION';
    const TYPE_GROUP = 'GROUP';
    const TYPE_INBOUNDCALLFLOW = 'INBOUNDCALLFLOW';
    const TYPE_INBOUNDEMAILFLOW = 'INBOUNDEMAILFLOW';
    const TYPE_INQUEUECALLFLOW = 'INQUEUECALLFLOW';
    const TYPE_IVRCONFIGURATION = 'IVRCONFIGURATION';
    const TYPE_LANGUAGE = 'LANGUAGE';
    const TYPE_OUTBOUNDCALLFLOW = 'OUTBOUNDCALLFLOW';
    const TYPE_QUEUE = 'QUEUE';
    const TYPE_RESPONSE = 'RESPONSE';
    const TYPE_SCHEDULE = 'SCHEDULE';
    const TYPE_SCHEDULEGROUP = 'SCHEDULEGROUP';
    const TYPE_SECUREACTION = 'SECUREACTION';
    const TYPE_SECURECALLFLOW = 'SECURECALLFLOW';
    const TYPE_SYSTEMPROMPT = 'SYSTEMPROMPT';
    const TYPE_USER = 'USER';
    const TYPE_USERPROMPT = 'USERPROMPT';
    const TYPE_VOICEXML = 'VOICEXML';
    const TYPE_WORKFLOW = 'WORKFLOW';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ACDLANGUAGE,
            self::TYPE_ACDSKILL,
            self::TYPE_ACDWRAPUPCODE,
            self::TYPE_BRIDGEACTION,
            self::TYPE_COMPOSERSCRIPT,
            self::TYPE_CONTACTLIST,
            self::TYPE_DATAACTION,
            self::TYPE_GROUP,
            self::TYPE_INBOUNDCALLFLOW,
            self::TYPE_INBOUNDEMAILFLOW,
            self::TYPE_INQUEUECALLFLOW,
            self::TYPE_IVRCONFIGURATION,
            self::TYPE_LANGUAGE,
            self::TYPE_OUTBOUNDCALLFLOW,
            self::TYPE_QUEUE,
            self::TYPE_RESPONSE,
            self::TYPE_SCHEDULE,
            self::TYPE_SCHEDULEGROUP,
            self::TYPE_SECUREACTION,
            self::TYPE_SECURECALLFLOW,
            self::TYPE_SYSTEMPROMPT,
            self::TYPE_USER,
            self::TYPE_USERPROMPT,
            self::TYPE_VOICEXML,
            self::TYPE_WORKFLOW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['deleted'] = isset($data['deleted']) ? $data['deleted'] : null;
        $this->container['updated'] = isset($data['updated']) ? $data['updated'] : null;
        $this->container['stateUnknown'] = isset($data['stateUnknown']) ? $data['stateUnknown'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ACDLANGUAGE", "ACDSKILL", "ACDWRAPUPCODE", "BRIDGEACTION", "COMPOSERSCRIPT", "CONTACTLIST", "DATAACTION", "GROUP", "INBOUNDCALLFLOW", "INBOUNDEMAILFLOW", "INQUEUECALLFLOW", "IVRCONFIGURATION", "LANGUAGE", "OUTBOUNDCALLFLOW", "QUEUE", "RESPONSE", "SCHEDULE", "SCHEDULEGROUP", "SECUREACTION", "SECURECALLFLOW", "SYSTEMPROMPT", "USER", "USERPROMPT", "VOICEXML", "WORKFLOW");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ACDLANGUAGE", "ACDSKILL", "ACDWRAPUPCODE", "BRIDGEACTION", "COMPOSERSCRIPT", "CONTACTLIST", "DATAACTION", "GROUP", "INBOUNDCALLFLOW", "INBOUNDEMAILFLOW", "INQUEUECALLFLOW", "IVRCONFIGURATION", "LANGUAGE", "OUTBOUNDCALLFLOW", "QUEUE", "RESPONSE", "SCHEDULE", "SCHEDULEGROUP", "SECUREACTION", "SECURECALLFLOW", "SYSTEMPROMPT", "USER", "USERPROMPT", "VOICEXML", "WORKFLOW");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets version
     * @return string
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param string $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('ACDLANGUAGE', 'ACDSKILL', 'ACDWRAPUPCODE', 'BRIDGEACTION', 'COMPOSERSCRIPT', 'CONTACTLIST', 'DATAACTION', 'GROUP', 'INBOUNDCALLFLOW', 'INBOUNDEMAILFLOW', 'INQUEUECALLFLOW', 'IVRCONFIGURATION', 'LANGUAGE', 'OUTBOUNDCALLFLOW', 'QUEUE', 'RESPONSE', 'SCHEDULE', 'SCHEDULEGROUP', 'SECUREACTION', 'SECURECALLFLOW', 'SYSTEMPROMPT', 'USER', 'USERPROMPT', 'VOICEXML', 'WORKFLOW');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'ACDLANGUAGE', 'ACDSKILL', 'ACDWRAPUPCODE', 'BRIDGEACTION', 'COMPOSERSCRIPT', 'CONTACTLIST', 'DATAACTION', 'GROUP', 'INBOUNDCALLFLOW', 'INBOUNDEMAILFLOW', 'INQUEUECALLFLOW', 'IVRCONFIGURATION', 'LANGUAGE', 'OUTBOUNDCALLFLOW', 'QUEUE', 'RESPONSE', 'SCHEDULE', 'SCHEDULEGROUP', 'SECUREACTION', 'SECURECALLFLOW', 'SYSTEMPROMPT', 'USER', 'USERPROMPT', 'VOICEXML', 'WORKFLOW'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets deleted
     * @return bool
     */
    public function getDeleted()
    {
        return $this->container['deleted'];
    }

    /**
     * Sets deleted
     * @param bool $deleted
     * @return $this
     */
    public function setDeleted($deleted)
    {
        $this->container['deleted'] = $deleted;

        return $this;
    }

    /**
     * Gets updated
     * @return bool
     */
    public function getUpdated()
    {
        return $this->container['updated'];
    }

    /**
     * Sets updated
     * @param bool $updated
     * @return $this
     */
    public function setUpdated($updated)
    {
        $this->container['updated'] = $updated;

        return $this;
    }

    /**
     * Gets stateUnknown
     * @return bool
     */
    public function getStateUnknown()
    {
        return $this->container['stateUnknown'];
    }

    /**
     * Sets stateUnknown
     * @param bool $stateUnknown
     * @return $this
     */
    public function setStateUnknown($stateUnknown)
    {
        $this->container['stateUnknown'] = $stateUnknown;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


