<?php
/**
 * EventMessage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * EventMessage Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EventMessage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EventMessage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'code' => 'string',
        'message' => 'string',
        'messageWithParams' => 'string',
        'messageParams' => 'map[string,object]',
        'documentationUri' => 'string',
        'resourceURIs' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'code' => 'code',
        'message' => 'message',
        'messageWithParams' => 'messageWithParams',
        'messageParams' => 'messageParams',
        'documentationUri' => 'documentationUri',
        'resourceURIs' => 'resourceURIs'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'code' => 'setCode',
        'message' => 'setMessage',
        'messageWithParams' => 'setMessageWithParams',
        'messageParams' => 'setMessageParams',
        'documentationUri' => 'setDocumentationUri',
        'resourceURIs' => 'setResourceURIs'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'code' => 'getCode',
        'message' => 'getMessage',
        'messageWithParams' => 'getMessageWithParams',
        'messageParams' => 'getMessageParams',
        'documentationUri' => 'getDocumentationUri',
        'resourceURIs' => 'getResourceURIs'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const CODE_CAMPAIGN_START_ERROR = 'CAMPAIGN_START_ERROR';
    const CODE_CAMPAIGN_RULE_START_ERROR = 'CAMPAIGN_RULE_START_ERROR';
    const CODE_CAMPAIGN_SET_DIALING_MODE_ERROR = 'CAMPAIGN_SET_DIALING_MODE_ERROR';
    const CODE_INVALID_CALLABLE_TIME_ZONE = 'INVALID_CALLABLE_TIME_ZONE';
    const CODE_CALLBACK_CREATION_INVALID_NUMBER = 'CALLBACK_CREATION_INVALID_NUMBER';
    const CODE_CALL_RULE_INVALID_CONTACT_COLUMN = 'CALL_RULE_INVALID_CONTACT_COLUMN';
    const CODE_CALL_RULE_MISMATCH_TYPE = 'CALL_RULE_MISMATCH_TYPE';
    const CODE_CALL_RULE_INVALID_OPERATOR = 'CALL_RULE_INVALID_OPERATOR';
    const CODE_CALL_RULE_NO_DNC_LISTS_CONFIGURED = 'CALL_RULE_NO_DNC_LISTS_CONFIGURED';
    const CODE_CONTACT_LIST_FILTER_EVALUATION_FAILED = 'CONTACT_LIST_FILTER_EVALUATION_FAILED';
    const CODE_INVALID_PHONE_NUMBER = 'INVALID_PHONE_NUMBER';
    const CODE_IMPORT_FAILED_TO_READ_HEADERS = 'IMPORT_FAILED_TO_READ_HEADERS';
    const CODE_IMPORT_COULD_NOT_PARSE_AN_ENTRY = 'IMPORT_COULD_NOT_PARSE_AN_ENTRY';
    const CODE_IMPORT_CONTACT_DOES_NOT_MATCH_LIST_FORMAT = 'IMPORT_CONTACT_DOES_NOT_MATCH_LIST_FORMAT';
    const CODE_IMPORT_ENTRY_DOES_NOT_ALIGN_WITH_HEADERS = 'IMPORT_ENTRY_DOES_NOT_ALIGN_WITH_HEADERS';
    const CODE_IMPORT_INVALID_CUSTOM_ID = 'IMPORT_INVALID_CUSTOM_ID';
    const CODE_IMPORT_INVALID_DATA = 'IMPORT_INVALID_DATA';
    const CODE_IMPORT_NO_COLUMNS_DEFINED = 'IMPORT_NO_COLUMNS_DEFINED';
    const CODE_IMPORT_COLUMNS_DO_NOT_EXIST_ON_LIST = 'IMPORT_COLUMNS_DO_NOT_EXIST_ON_LIST';
    const CODE_IMPORT_LIST_NO_LONGER_EXISTS = 'IMPORT_LIST_NO_LONGER_EXISTS';
    const CODE_RECYCLE_CAMPAIGN = 'RECYCLE_CAMPAIGN';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCodeAllowableValues()
    {
        return [
            self::CODE_CAMPAIGN_START_ERROR,
            self::CODE_CAMPAIGN_RULE_START_ERROR,
            self::CODE_CAMPAIGN_SET_DIALING_MODE_ERROR,
            self::CODE_INVALID_CALLABLE_TIME_ZONE,
            self::CODE_CALLBACK_CREATION_INVALID_NUMBER,
            self::CODE_CALL_RULE_INVALID_CONTACT_COLUMN,
            self::CODE_CALL_RULE_MISMATCH_TYPE,
            self::CODE_CALL_RULE_INVALID_OPERATOR,
            self::CODE_CALL_RULE_NO_DNC_LISTS_CONFIGURED,
            self::CODE_CONTACT_LIST_FILTER_EVALUATION_FAILED,
            self::CODE_INVALID_PHONE_NUMBER,
            self::CODE_IMPORT_FAILED_TO_READ_HEADERS,
            self::CODE_IMPORT_COULD_NOT_PARSE_AN_ENTRY,
            self::CODE_IMPORT_CONTACT_DOES_NOT_MATCH_LIST_FORMAT,
            self::CODE_IMPORT_ENTRY_DOES_NOT_ALIGN_WITH_HEADERS,
            self::CODE_IMPORT_INVALID_CUSTOM_ID,
            self::CODE_IMPORT_INVALID_DATA,
            self::CODE_IMPORT_NO_COLUMNS_DEFINED,
            self::CODE_IMPORT_COLUMNS_DO_NOT_EXIST_ON_LIST,
            self::CODE_IMPORT_LIST_NO_LONGER_EXISTS,
            self::CODE_RECYCLE_CAMPAIGN,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['code'] = isset($data['code']) ? $data['code'] : null;
        $this->container['message'] = isset($data['message']) ? $data['message'] : null;
        $this->container['messageWithParams'] = isset($data['messageWithParams']) ? $data['messageWithParams'] : null;
        $this->container['messageParams'] = isset($data['messageParams']) ? $data['messageParams'] : null;
        $this->container['documentationUri'] = isset($data['documentationUri']) ? $data['documentationUri'] : null;
        $this->container['resourceURIs'] = isset($data['resourceURIs']) ? $data['resourceURIs'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("CAMPAIGN_START_ERROR", "CAMPAIGN_RULE_START_ERROR", "CAMPAIGN_SET_DIALING_MODE_ERROR", "INVALID_CALLABLE_TIME_ZONE", "CALLBACK_CREATION_INVALID_NUMBER", "CALL_RULE_INVALID_CONTACT_COLUMN", "CALL_RULE_MISMATCH_TYPE", "CALL_RULE_INVALID_OPERATOR", "CALL_RULE_NO_DNC_LISTS_CONFIGURED", "CONTACT_LIST_FILTER_EVALUATION_FAILED", "INVALID_PHONE_NUMBER", "IMPORT_FAILED_TO_READ_HEADERS", "IMPORT_COULD_NOT_PARSE_AN_ENTRY", "IMPORT_CONTACT_DOES_NOT_MATCH_LIST_FORMAT", "IMPORT_ENTRY_DOES_NOT_ALIGN_WITH_HEADERS", "IMPORT_INVALID_CUSTOM_ID", "IMPORT_INVALID_DATA", "IMPORT_NO_COLUMNS_DEFINED", "IMPORT_COLUMNS_DO_NOT_EXIST_ON_LIST", "IMPORT_LIST_NO_LONGER_EXISTS", "RECYCLE_CAMPAIGN");
        if (!in_array($this->container['code'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'code', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("CAMPAIGN_START_ERROR", "CAMPAIGN_RULE_START_ERROR", "CAMPAIGN_SET_DIALING_MODE_ERROR", "INVALID_CALLABLE_TIME_ZONE", "CALLBACK_CREATION_INVALID_NUMBER", "CALL_RULE_INVALID_CONTACT_COLUMN", "CALL_RULE_MISMATCH_TYPE", "CALL_RULE_INVALID_OPERATOR", "CALL_RULE_NO_DNC_LISTS_CONFIGURED", "CONTACT_LIST_FILTER_EVALUATION_FAILED", "INVALID_PHONE_NUMBER", "IMPORT_FAILED_TO_READ_HEADERS", "IMPORT_COULD_NOT_PARSE_AN_ENTRY", "IMPORT_CONTACT_DOES_NOT_MATCH_LIST_FORMAT", "IMPORT_ENTRY_DOES_NOT_ALIGN_WITH_HEADERS", "IMPORT_INVALID_CUSTOM_ID", "IMPORT_INVALID_DATA", "IMPORT_NO_COLUMNS_DEFINED", "IMPORT_COLUMNS_DO_NOT_EXIST_ON_LIST", "IMPORT_LIST_NO_LONGER_EXISTS", "RECYCLE_CAMPAIGN");
        if (!in_array($this->container['code'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets code
     * @return string
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     * @param string $code
     * @return $this
     */
    public function setCode($code)
    {
        $allowed_values = array('CAMPAIGN_START_ERROR', 'CAMPAIGN_RULE_START_ERROR', 'CAMPAIGN_SET_DIALING_MODE_ERROR', 'INVALID_CALLABLE_TIME_ZONE', 'CALLBACK_CREATION_INVALID_NUMBER', 'CALL_RULE_INVALID_CONTACT_COLUMN', 'CALL_RULE_MISMATCH_TYPE', 'CALL_RULE_INVALID_OPERATOR', 'CALL_RULE_NO_DNC_LISTS_CONFIGURED', 'CONTACT_LIST_FILTER_EVALUATION_FAILED', 'INVALID_PHONE_NUMBER', 'IMPORT_FAILED_TO_READ_HEADERS', 'IMPORT_COULD_NOT_PARSE_AN_ENTRY', 'IMPORT_CONTACT_DOES_NOT_MATCH_LIST_FORMAT', 'IMPORT_ENTRY_DOES_NOT_ALIGN_WITH_HEADERS', 'IMPORT_INVALID_CUSTOM_ID', 'IMPORT_INVALID_DATA', 'IMPORT_NO_COLUMNS_DEFINED', 'IMPORT_COLUMNS_DO_NOT_EXIST_ON_LIST', 'IMPORT_LIST_NO_LONGER_EXISTS', 'RECYCLE_CAMPAIGN');
        if (!in_array($code, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'code', must be one of 'CAMPAIGN_START_ERROR', 'CAMPAIGN_RULE_START_ERROR', 'CAMPAIGN_SET_DIALING_MODE_ERROR', 'INVALID_CALLABLE_TIME_ZONE', 'CALLBACK_CREATION_INVALID_NUMBER', 'CALL_RULE_INVALID_CONTACT_COLUMN', 'CALL_RULE_MISMATCH_TYPE', 'CALL_RULE_INVALID_OPERATOR', 'CALL_RULE_NO_DNC_LISTS_CONFIGURED', 'CONTACT_LIST_FILTER_EVALUATION_FAILED', 'INVALID_PHONE_NUMBER', 'IMPORT_FAILED_TO_READ_HEADERS', 'IMPORT_COULD_NOT_PARSE_AN_ENTRY', 'IMPORT_CONTACT_DOES_NOT_MATCH_LIST_FORMAT', 'IMPORT_ENTRY_DOES_NOT_ALIGN_WITH_HEADERS', 'IMPORT_INVALID_CUSTOM_ID', 'IMPORT_INVALID_DATA', 'IMPORT_NO_COLUMNS_DEFINED', 'IMPORT_COLUMNS_DO_NOT_EXIST_ON_LIST', 'IMPORT_LIST_NO_LONGER_EXISTS', 'RECYCLE_CAMPAIGN'");
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets message
     * @return string
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     * @param string $message
     * @return $this
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets messageWithParams
     * @return string
     */
    public function getMessageWithParams()
    {
        return $this->container['messageWithParams'];
    }

    /**
     * Sets messageWithParams
     * @param string $messageWithParams
     * @return $this
     */
    public function setMessageWithParams($messageWithParams)
    {
        $this->container['messageWithParams'] = $messageWithParams;

        return $this;
    }

    /**
     * Gets messageParams
     * @return map[string,object]
     */
    public function getMessageParams()
    {
        return $this->container['messageParams'];
    }

    /**
     * Sets messageParams
     * @param map[string,object] $messageParams
     * @return $this
     */
    public function setMessageParams($messageParams)
    {
        $this->container['messageParams'] = $messageParams;

        return $this;
    }

    /**
     * Gets documentationUri
     * @return string
     */
    public function getDocumentationUri()
    {
        return $this->container['documentationUri'];
    }

    /**
     * Sets documentationUri
     * @param string $documentationUri
     * @return $this
     */
    public function setDocumentationUri($documentationUri)
    {
        $this->container['documentationUri'] = $documentationUri;

        return $this;
    }

    /**
     * Gets resourceURIs
     * @return string[]
     */
    public function getResourceURIs()
    {
        return $this->container['resourceURIs'];
    }

    /**
     * Sets resourceURIs
     * @param string[] $resourceURIs
     * @return $this
     */
    public function setResourceURIs($resourceURIs)
    {
        $this->container['resourceURIs'] = $resourceURIs;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


