<?php
/**
 * UpdateUser
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UpdateUser Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UpdateUser implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UpdateUser';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'chat' => '\PureCloudSDK\Chat',
        'department' => 'string',
        'email' => 'string',
        'primaryContactInfo' => '\PureCloudSDK\Contact[]',
        'addresses' => '\PureCloudSDK\Contact[]',
        'title' => 'string',
        'username' => 'string',
        'manager' => 'string',
        'images' => '\PureCloudSDK\UserImage[]',
        'version' => 'int',
        'profileSkills' => 'string[]',
        'locations' => '\PureCloudSDK\Location[]',
        'groups' => '\PureCloudSDK\Group[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'chat' => 'chat',
        'department' => 'department',
        'email' => 'email',
        'primaryContactInfo' => 'primaryContactInfo',
        'addresses' => 'addresses',
        'title' => 'title',
        'username' => 'username',
        'manager' => 'manager',
        'images' => 'images',
        'version' => 'version',
        'profileSkills' => 'profileSkills',
        'locations' => 'locations',
        'groups' => 'groups',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'chat' => 'setChat',
        'department' => 'setDepartment',
        'email' => 'setEmail',
        'primaryContactInfo' => 'setPrimaryContactInfo',
        'addresses' => 'setAddresses',
        'title' => 'setTitle',
        'username' => 'setUsername',
        'manager' => 'setManager',
        'images' => 'setImages',
        'version' => 'setVersion',
        'profileSkills' => 'setProfileSkills',
        'locations' => 'setLocations',
        'groups' => 'setGroups',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'chat' => 'getChat',
        'department' => 'getDepartment',
        'email' => 'getEmail',
        'primaryContactInfo' => 'getPrimaryContactInfo',
        'addresses' => 'getAddresses',
        'title' => 'getTitle',
        'username' => 'getUsername',
        'manager' => 'getManager',
        'images' => 'getImages',
        'version' => 'getVersion',
        'profileSkills' => 'getProfileSkills',
        'locations' => 'getLocations',
        'groups' => 'getGroups',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['chat'] = isset($data['chat']) ? $data['chat'] : null;
        $this->container['department'] = isset($data['department']) ? $data['department'] : null;
        $this->container['email'] = isset($data['email']) ? $data['email'] : null;
        $this->container['primaryContactInfo'] = isset($data['primaryContactInfo']) ? $data['primaryContactInfo'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['username'] = isset($data['username']) ? $data['username'] : null;
        $this->container['manager'] = isset($data['manager']) ? $data['manager'] : null;
        $this->container['images'] = isset($data['images']) ? $data['images'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['profileSkills'] = isset($data['profileSkills']) ? $data['profileSkills'] : null;
        $this->container['locations'] = isset($data['locations']) ? $data['locations'] : null;
        $this->container['groups'] = isset($data['groups']) ? $data['groups'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets chat
     * @return \PureCloudSDK\Chat
     */
    public function getChat()
    {
        return $this->container['chat'];
    }

    /**
     * Sets chat
     * @param \PureCloudSDK\Chat $chat
     * @return $this
     */
    public function setChat($chat)
    {
        $this->container['chat'] = $chat;

        return $this;
    }

    /**
     * Gets department
     * @return string
     */
    public function getDepartment()
    {
        return $this->container['department'];
    }

    /**
     * Sets department
     * @param string $department
     * @return $this
     */
    public function setDepartment($department)
    {
        $this->container['department'] = $department;

        return $this;
    }

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     * @param string $email
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets primaryContactInfo
     * @return \PureCloudSDK\Contact[]
     */
    public function getPrimaryContactInfo()
    {
        return $this->container['primaryContactInfo'];
    }

    /**
     * Sets primaryContactInfo
     * @param \PureCloudSDK\Contact[] $primaryContactInfo
     * @return $this
     */
    public function setPrimaryContactInfo($primaryContactInfo)
    {
        $this->container['primaryContactInfo'] = $primaryContactInfo;

        return $this;
    }

    /**
     * Gets addresses
     * @return \PureCloudSDK\Contact[]
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     * @param \PureCloudSDK\Contact[] $addresses Email addresses and phone numbers for this user
     * @return $this
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets username
     * @return string
     */
    public function getUsername()
    {
        return $this->container['username'];
    }

    /**
     * Sets username
     * @param string $username
     * @return $this
     */
    public function setUsername($username)
    {
        $this->container['username'] = $username;

        return $this;
    }

    /**
     * Gets manager
     * @return string
     */
    public function getManager()
    {
        return $this->container['manager'];
    }

    /**
     * Sets manager
     * @param string $manager
     * @return $this
     */
    public function setManager($manager)
    {
        $this->container['manager'] = $manager;

        return $this;
    }

    /**
     * Gets images
     * @return \PureCloudSDK\UserImage[]
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     * @param \PureCloudSDK\UserImage[] $images
     * @return $this
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required when updating a user, this value should be the current version of the user.  The current version can be obtained with a GET on the user before doing a PATCH.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets profileSkills
     * @return string[]
     */
    public function getProfileSkills()
    {
        return $this->container['profileSkills'];
    }

    /**
     * Sets profileSkills
     * @param string[] $profileSkills Skills possessed by the user
     * @return $this
     */
    public function setProfileSkills($profileSkills)
    {
        $this->container['profileSkills'] = $profileSkills;

        return $this;
    }

    /**
     * Gets locations
     * @return \PureCloudSDK\Location[]
     */
    public function getLocations()
    {
        return $this->container['locations'];
    }

    /**
     * Sets locations
     * @param \PureCloudSDK\Location[] $locations The user placement at each site location.
     * @return $this
     */
    public function setLocations($locations)
    {
        $this->container['locations'] = $locations;

        return $this;
    }

    /**
     * Gets groups
     * @return \PureCloudSDK\Group[]
     */
    public function getGroups()
    {
        return $this->container['groups'];
    }

    /**
     * Sets groups
     * @param \PureCloudSDK\Group[] $groups The groups the user is a member of
     * @return $this
     */
    public function setGroups($groups)
    {
        $this->container['groups'] = $groups;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


