<?php
/**
 * UserScheduleActivity
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * UserScheduleActivity Class Doc Comment
 *
 * @category    Class */
 // @description Represents a single activity in a user&#39;s shift
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserScheduleActivity implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserScheduleActivity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'activityCodeId' => 'string',
        'startDate' => '\DateTime',
        'lengthInMinutes' => 'int',
        'description' => 'string',
        'countsAsPaidTime' => 'bool',
        'isDstFallback' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'activityCodeId' => 'activityCodeId',
        'startDate' => 'startDate',
        'lengthInMinutes' => 'lengthInMinutes',
        'description' => 'description',
        'countsAsPaidTime' => 'countsAsPaidTime',
        'isDstFallback' => 'isDstFallback'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'activityCodeId' => 'setActivityCodeId',
        'startDate' => 'setStartDate',
        'lengthInMinutes' => 'setLengthInMinutes',
        'description' => 'setDescription',
        'countsAsPaidTime' => 'setCountsAsPaidTime',
        'isDstFallback' => 'setIsDstFallback'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'activityCodeId' => 'getActivityCodeId',
        'startDate' => 'getStartDate',
        'lengthInMinutes' => 'getLengthInMinutes',
        'description' => 'getDescription',
        'countsAsPaidTime' => 'getCountsAsPaidTime',
        'isDstFallback' => 'getIsDstFallback'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['activityCodeId'] = isset($data['activityCodeId']) ? $data['activityCodeId'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['lengthInMinutes'] = isset($data['lengthInMinutes']) ? $data['lengthInMinutes'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['countsAsPaidTime'] = isset($data['countsAsPaidTime']) ? $data['countsAsPaidTime'] : null;
        $this->container['isDstFallback'] = isset($data['isDstFallback']) ? $data['isDstFallback'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets activityCodeId
     * @return string
     */
    public function getActivityCodeId()
    {
        return $this->container['activityCodeId'];
    }

    /**
     * Sets activityCodeId
     * @param string $activityCodeId The id for the activity code.  Look up a map of activity codes with the activities route
     * @return $this
     */
    public function setActivityCodeId($activityCodeId)
    {
        $this->container['activityCodeId'] = $activityCodeId;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate Start time in UTC for this activity, in ISO-8601 format
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets lengthInMinutes
     * @return int
     */
    public function getLengthInMinutes()
    {
        return $this->container['lengthInMinutes'];
    }

    /**
     * Sets lengthInMinutes
     * @param int $lengthInMinutes Length in minutes for this activity
     * @return $this
     */
    public function setLengthInMinutes($lengthInMinutes)
    {
        $this->container['lengthInMinutes'] = $lengthInMinutes;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description Description for this activity
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets countsAsPaidTime
     * @return bool
     */
    public function getCountsAsPaidTime()
    {
        return $this->container['countsAsPaidTime'];
    }

    /**
     * Sets countsAsPaidTime
     * @param bool $countsAsPaidTime Whether this activity is paid
     * @return $this
     */
    public function setCountsAsPaidTime($countsAsPaidTime)
    {
        $this->container['countsAsPaidTime'] = $countsAsPaidTime;

        return $this;
    }

    /**
     * Gets isDstFallback
     * @return bool
     */
    public function getIsDstFallback()
    {
        return $this->container['isDstFallback'];
    }

    /**
     * Sets isDstFallback
     * @param bool $isDstFallback Whether this activity spans a DST fallback
     * @return $this
     */
    public function setIsDstFallback($isDstFallback)
    {
        $this->container['isDstFallback'] = $isDstFallback;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


