# PureCloudSDK\AlertingApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAlertingHeartbeatAlertsAlertId**](AlertingApi.md#deleteAlertingHeartbeatAlertsAlertId) | **DELETE** /api/v2/alerting/heartbeat/alerts/{alertId} | Delete a heart beat alert
[**deleteAlertingHeartbeatRulesRuleId**](AlertingApi.md#deleteAlertingHeartbeatRulesRuleId) | **DELETE** /api/v2/alerting/heartbeat/rules/{ruleId} | Delete a heart beat rule.
[**deleteAlertingInteractionstatsAlertsAlertId**](AlertingApi.md#deleteAlertingInteractionstatsAlertsAlertId) | **DELETE** /api/v2/alerting/interactionstats/alerts/{alertId} | Delete an interaction stats alert
[**deleteAlertingInteractionstatsRulesRuleId**](AlertingApi.md#deleteAlertingInteractionstatsRulesRuleId) | **DELETE** /api/v2/alerting/interactionstats/rules/{ruleId} | Delete an interaction stats rule.
[**deleteAlertingRoutingstatusAlertsAlertId**](AlertingApi.md#deleteAlertingRoutingstatusAlertsAlertId) | **DELETE** /api/v2/alerting/routingstatus/alerts/{alertId} | Delete a routing status alert
[**deleteAlertingRoutingstatusRulesRuleId**](AlertingApi.md#deleteAlertingRoutingstatusRulesRuleId) | **DELETE** /api/v2/alerting/routingstatus/rules/{ruleId} | Delete a routing status rule.
[**deleteAlertingUserpresenceAlertsAlertId**](AlertingApi.md#deleteAlertingUserpresenceAlertsAlertId) | **DELETE** /api/v2/alerting/userpresence/alerts/{alertId} | Delete a user presence alert
[**deleteAlertingUserpresenceRulesRuleId**](AlertingApi.md#deleteAlertingUserpresenceRulesRuleId) | **DELETE** /api/v2/alerting/userpresence/rules/{ruleId} | Delete a user presence rule.
[**getAlertingHeartbeatAlerts**](AlertingApi.md#getAlertingHeartbeatAlerts) | **GET** /api/v2/alerting/heartbeat/alerts | Get heart beat alert list.
[**getAlertingHeartbeatAlertsAlertId**](AlertingApi.md#getAlertingHeartbeatAlertsAlertId) | **GET** /api/v2/alerting/heartbeat/alerts/{alertId} | Get a heart beat alert
[**getAlertingHeartbeatRules**](AlertingApi.md#getAlertingHeartbeatRules) | **GET** /api/v2/alerting/heartbeat/rules | Get a heart beat rule list.
[**getAlertingHeartbeatRulesRuleId**](AlertingApi.md#getAlertingHeartbeatRulesRuleId) | **GET** /api/v2/alerting/heartbeat/rules/{ruleId} | Get a heart beat rule.
[**getAlertingInteractionstatsAlerts**](AlertingApi.md#getAlertingInteractionstatsAlerts) | **GET** /api/v2/alerting/interactionstats/alerts | Get interaction stats alert list.
[**getAlertingInteractionstatsAlertsAlertId**](AlertingApi.md#getAlertingInteractionstatsAlertsAlertId) | **GET** /api/v2/alerting/interactionstats/alerts/{alertId} | Get an interaction stats alert
[**getAlertingInteractionstatsAlertsUnread**](AlertingApi.md#getAlertingInteractionstatsAlertsUnread) | **GET** /api/v2/alerting/interactionstats/alerts/unread | Gets user unread count of interaction stats alerts.
[**getAlertingInteractionstatsRules**](AlertingApi.md#getAlertingInteractionstatsRules) | **GET** /api/v2/alerting/interactionstats/rules | Get an interaction stats rule list.
[**getAlertingInteractionstatsRulesRuleId**](AlertingApi.md#getAlertingInteractionstatsRulesRuleId) | **GET** /api/v2/alerting/interactionstats/rules/{ruleId} | Get an interaction stats rule.
[**getAlertingRoutingstatusAlerts**](AlertingApi.md#getAlertingRoutingstatusAlerts) | **GET** /api/v2/alerting/routingstatus/alerts | Get routing status alert list.
[**getAlertingRoutingstatusAlertsAlertId**](AlertingApi.md#getAlertingRoutingstatusAlertsAlertId) | **GET** /api/v2/alerting/routingstatus/alerts/{alertId} | Get a routing status alert
[**getAlertingRoutingstatusRules**](AlertingApi.md#getAlertingRoutingstatusRules) | **GET** /api/v2/alerting/routingstatus/rules | Get a routing status rule list.
[**getAlertingRoutingstatusRulesRuleId**](AlertingApi.md#getAlertingRoutingstatusRulesRuleId) | **GET** /api/v2/alerting/routingstatus/rules/{ruleId} | Get a routing status rule.
[**getAlertingUserpresenceAlerts**](AlertingApi.md#getAlertingUserpresenceAlerts) | **GET** /api/v2/alerting/userpresence/alerts | Get user presence alert list.
[**getAlertingUserpresenceAlertsAlertId**](AlertingApi.md#getAlertingUserpresenceAlertsAlertId) | **GET** /api/v2/alerting/userpresence/alerts/{alertId} | Get a user presence alert
[**getAlertingUserpresenceRules**](AlertingApi.md#getAlertingUserpresenceRules) | **GET** /api/v2/alerting/userpresence/rules | Get a user presence rule list.
[**getAlertingUserpresenceRulesRuleId**](AlertingApi.md#getAlertingUserpresenceRulesRuleId) | **GET** /api/v2/alerting/userpresence/rules/{ruleId} | Get a user presence rule.
[**postAlertingHeartbeatRules**](AlertingApi.md#postAlertingHeartbeatRules) | **POST** /api/v2/alerting/heartbeat/rules | Create a heart beat rule.
[**postAlertingInteractionstatsRules**](AlertingApi.md#postAlertingInteractionstatsRules) | **POST** /api/v2/alerting/interactionstats/rules | Create an interaction stats rule.
[**postAlertingRoutingstatusRules**](AlertingApi.md#postAlertingRoutingstatusRules) | **POST** /api/v2/alerting/routingstatus/rules | Create a routing status rule.
[**postAlertingUserpresenceRules**](AlertingApi.md#postAlertingUserpresenceRules) | **POST** /api/v2/alerting/userpresence/rules | Create a user presence rule.
[**putAlertingHeartbeatRulesRuleId**](AlertingApi.md#putAlertingHeartbeatRulesRuleId) | **PUT** /api/v2/alerting/heartbeat/rules/{ruleId} | Update a heart beat rule
[**putAlertingInteractionstatsAlertsAlertId**](AlertingApi.md#putAlertingInteractionstatsAlertsAlertId) | **PUT** /api/v2/alerting/interactionstats/alerts/{alertId} | Update an interaction stats alert read status
[**putAlertingInteractionstatsRulesRuleId**](AlertingApi.md#putAlertingInteractionstatsRulesRuleId) | **PUT** /api/v2/alerting/interactionstats/rules/{ruleId} | Update an interaction stats rule
[**putAlertingRoutingstatusRulesRuleId**](AlertingApi.md#putAlertingRoutingstatusRulesRuleId) | **PUT** /api/v2/alerting/routingstatus/rules/{ruleId} | Update a routing status rule
[**putAlertingUserpresenceRulesRuleId**](AlertingApi.md#putAlertingUserpresenceRulesRuleId) | **PUT** /api/v2/alerting/userpresence/rules/{ruleId} | Update a user presence rule


# **deleteAlertingHeartbeatAlertsAlertId**
> deleteAlertingHeartbeatAlertsAlertId($alertId)

Delete a heart beat alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteAlertingHeartbeatAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingHeartbeatAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingHeartbeatRulesRuleId**
> deleteAlertingHeartbeatRulesRuleId($ruleId)

Delete a heart beat rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $api_instance->deleteAlertingHeartbeatRulesRuleId($ruleId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingHeartbeatRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingInteractionstatsAlertsAlertId**
> deleteAlertingInteractionstatsAlertsAlertId($alertId)

Delete an interaction stats alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteAlertingInteractionstatsAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingInteractionstatsAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingInteractionstatsRulesRuleId**
> deleteAlertingInteractionstatsRulesRuleId($ruleId)

Delete an interaction stats rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $api_instance->deleteAlertingInteractionstatsRulesRuleId($ruleId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingInteractionstatsRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingRoutingstatusAlertsAlertId**
> deleteAlertingRoutingstatusAlertsAlertId($alertId)

Delete a routing status alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteAlertingRoutingstatusAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingRoutingstatusAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingRoutingstatusRulesRuleId**
> deleteAlertingRoutingstatusRulesRuleId($ruleId)

Delete a routing status rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $api_instance->deleteAlertingRoutingstatusRulesRuleId($ruleId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingRoutingstatusRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingUserpresenceAlertsAlertId**
> deleteAlertingUserpresenceAlertsAlertId($alertId)

Delete a user presence alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteAlertingUserpresenceAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingUserpresenceAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAlertingUserpresenceRulesRuleId**
> deleteAlertingUserpresenceRulesRuleId($ruleId)

Delete a user presence rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $api_instance->deleteAlertingUserpresenceRulesRuleId($ruleId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteAlertingUserpresenceRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingHeartbeatAlerts**
> \PureCloudSDK\HeartBeatAlertContainer getAlertingHeartbeatAlerts($expand)

Get heart beat alert list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingHeartbeatAlerts($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingHeartbeatAlerts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\HeartBeatAlertContainer**](../Model/HeartBeatAlertContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingHeartbeatAlertsAlertId**
> \PureCloudSDK\HeartBeatAlert getAlertingHeartbeatAlertsAlertId($alertId, $expand)

Get a heart beat alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingHeartbeatAlertsAlertId($alertId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingHeartbeatAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\HeartBeatAlert**](../Model/HeartBeatAlert.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingHeartbeatRules**
> \PureCloudSDK\HeartBeatRuleContainer getAlertingHeartbeatRules($expand)

Get a heart beat rule list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingHeartbeatRules($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingHeartbeatRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\HeartBeatRuleContainer**](../Model/HeartBeatRuleContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingHeartbeatRulesRuleId**
> \PureCloudSDK\HeartBeatRule getAlertingHeartbeatRulesRuleId($ruleId, $expand)

Get a heart beat rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingHeartbeatRulesRuleId($ruleId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingHeartbeatRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\HeartBeatRule**](../Model/HeartBeatRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsAlerts**
> \PureCloudSDK\InteractionStatsAlertContainer getAlertingInteractionstatsAlerts($expand)

Get interaction stats alert list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingInteractionstatsAlerts($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsAlerts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\InteractionStatsAlertContainer**](../Model/InteractionStatsAlertContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsAlertsAlertId**
> \PureCloudSDK\InteractionStatsAlert getAlertingInteractionstatsAlertsAlertId($alertId, $expand)

Get an interaction stats alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingInteractionstatsAlertsAlertId($alertId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\InteractionStatsAlert**](../Model/InteractionStatsAlert.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsAlertsUnread**
> \PureCloudSDK\UnreadMetric getAlertingInteractionstatsAlertsUnread()

Gets user unread count of interaction stats alerts.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getAlertingInteractionstatsAlertsUnread();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsAlertsUnread: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\UnreadMetric**](../Model/UnreadMetric.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsRules**
> \PureCloudSDK\InteractionStatsRuleContainer getAlertingInteractionstatsRules($expand)

Get an interaction stats rule list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingInteractionstatsRules($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\InteractionStatsRuleContainer**](../Model/InteractionStatsRuleContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingInteractionstatsRulesRuleId**
> \PureCloudSDK\InteractionStatsRule getAlertingInteractionstatsRulesRuleId($ruleId, $expand)

Get an interaction stats rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingInteractionstatsRulesRuleId($ruleId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingInteractionstatsRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\InteractionStatsRule**](../Model/InteractionStatsRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingRoutingstatusAlerts**
> \PureCloudSDK\RoutingStatusAlertContainer getAlertingRoutingstatusAlerts($expand)

Get routing status alert list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingRoutingstatusAlerts($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingRoutingstatusAlerts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\RoutingStatusAlertContainer**](../Model/RoutingStatusAlertContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingRoutingstatusAlertsAlertId**
> \PureCloudSDK\RoutingStatusAlert getAlertingRoutingstatusAlertsAlertId($alertId, $expand)

Get a routing status alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingRoutingstatusAlertsAlertId($alertId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingRoutingstatusAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\RoutingStatusAlert**](../Model/RoutingStatusAlert.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingRoutingstatusRules**
> \PureCloudSDK\RoutingStatusRuleContainer getAlertingRoutingstatusRules($expand)

Get a routing status rule list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingRoutingstatusRules($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingRoutingstatusRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\RoutingStatusRuleContainer**](../Model/RoutingStatusRuleContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingRoutingstatusRulesRuleId**
> \PureCloudSDK\RoutingStatusRule getAlertingRoutingstatusRulesRuleId($ruleId, $expand)

Get a routing status rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingRoutingstatusRulesRuleId($ruleId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingRoutingstatusRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\RoutingStatusRule**](../Model/RoutingStatusRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingUserpresenceAlerts**
> \PureCloudSDK\UserPresenceAlertContainer getAlertingUserpresenceAlerts($expand)

Get user presence alert list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingUserpresenceAlerts($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingUserpresenceAlerts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UserPresenceAlertContainer**](../Model/UserPresenceAlertContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingUserpresenceAlertsAlertId**
> \PureCloudSDK\UserPresenceAlert getAlertingUserpresenceAlertsAlertId($alertId, $expand)

Get a user presence alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingUserpresenceAlertsAlertId($alertId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingUserpresenceAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UserPresenceAlert**](../Model/UserPresenceAlert.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingUserpresenceRules**
> \PureCloudSDK\UserPresenceRuleContainer getAlertingUserpresenceRules($expand)

Get a user presence rule list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingUserpresenceRules($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingUserpresenceRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UserPresenceRuleContainer**](../Model/UserPresenceRuleContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAlertingUserpresenceRulesRuleId**
> \PureCloudSDK\UserPresenceRule getAlertingUserpresenceRulesRuleId($ruleId, $expand)

Get a user presence rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getAlertingUserpresenceRulesRuleId($ruleId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getAlertingUserpresenceRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UserPresenceRule**](../Model/UserPresenceRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAlertingHeartbeatRules**
> \PureCloudSDK\HeartBeatRule postAlertingHeartbeatRules($body, $expand)

Create a heart beat rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$body = new \PureCloudSDK\HeartBeatRule(); // \PureCloudSDK\HeartBeatRule | HeartBeatRule
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->postAlertingHeartbeatRules($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->postAlertingHeartbeatRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\HeartBeatRule**](../Model/\PureCloudSDK\HeartBeatRule.md)| HeartBeatRule |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\HeartBeatRule**](../Model/HeartBeatRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAlertingInteractionstatsRules**
> \PureCloudSDK\InteractionStatsRule postAlertingInteractionstatsRules($body, $expand)

Create an interaction stats rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$body = new \PureCloudSDK\InteractionStatsRule(); // \PureCloudSDK\InteractionStatsRule | AlertingRule
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->postAlertingInteractionstatsRules($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->postAlertingInteractionstatsRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\InteractionStatsRule**](../Model/\PureCloudSDK\InteractionStatsRule.md)| AlertingRule |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\InteractionStatsRule**](../Model/InteractionStatsRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAlertingRoutingstatusRules**
> \PureCloudSDK\RoutingStatusRule postAlertingRoutingstatusRules($body, $expand)

Create a routing status rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$body = new \PureCloudSDK\RoutingStatusRule(); // \PureCloudSDK\RoutingStatusRule | RoutingStatusRule
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->postAlertingRoutingstatusRules($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->postAlertingRoutingstatusRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\RoutingStatusRule**](../Model/\PureCloudSDK\RoutingStatusRule.md)| RoutingStatusRule |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\RoutingStatusRule**](../Model/RoutingStatusRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAlertingUserpresenceRules**
> \PureCloudSDK\UserPresenceRule postAlertingUserpresenceRules($body, $expand)

Create a user presence rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$body = new \PureCloudSDK\UserPresenceRule(); // \PureCloudSDK\UserPresenceRule | UserPresenceRule
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->postAlertingUserpresenceRules($body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->postAlertingUserpresenceRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\UserPresenceRule**](../Model/\PureCloudSDK\UserPresenceRule.md)| UserPresenceRule |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UserPresenceRule**](../Model/UserPresenceRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAlertingHeartbeatRulesRuleId**
> \PureCloudSDK\HeartBeatRule putAlertingHeartbeatRulesRuleId($ruleId, $body, $expand)

Update a heart beat rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$body = new \PureCloudSDK\HeartBeatRule(); // \PureCloudSDK\HeartBeatRule | HeartBeatRule
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->putAlertingHeartbeatRulesRuleId($ruleId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putAlertingHeartbeatRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **body** | [**\PureCloudSDK\HeartBeatRule**](../Model/\PureCloudSDK\HeartBeatRule.md)| HeartBeatRule |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\HeartBeatRule**](../Model/HeartBeatRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAlertingInteractionstatsAlertsAlertId**
> \PureCloudSDK\UnreadStatus putAlertingInteractionstatsAlertsAlertId($alertId, $body, $expand)

Update an interaction stats alert read status



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID
$body = new \PureCloudSDK\UnreadStatus(); // \PureCloudSDK\UnreadStatus | InteractionStatsAlert
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->putAlertingInteractionstatsAlertsAlertId($alertId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putAlertingInteractionstatsAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |
 **body** | [**\PureCloudSDK\UnreadStatus**](../Model/\PureCloudSDK\UnreadStatus.md)| InteractionStatsAlert |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UnreadStatus**](../Model/UnreadStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAlertingInteractionstatsRulesRuleId**
> \PureCloudSDK\InteractionStatsRule putAlertingInteractionstatsRulesRuleId($ruleId, $body, $expand)

Update an interaction stats rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$body = new \PureCloudSDK\InteractionStatsRule(); // \PureCloudSDK\InteractionStatsRule | AlertingRule
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->putAlertingInteractionstatsRulesRuleId($ruleId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putAlertingInteractionstatsRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **body** | [**\PureCloudSDK\InteractionStatsRule**](../Model/\PureCloudSDK\InteractionStatsRule.md)| AlertingRule |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\InteractionStatsRule**](../Model/InteractionStatsRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAlertingRoutingstatusRulesRuleId**
> \PureCloudSDK\RoutingStatusRule putAlertingRoutingstatusRulesRuleId($ruleId, $body, $expand)

Update a routing status rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$body = new \PureCloudSDK\RoutingStatusRule(); // \PureCloudSDK\RoutingStatusRule | RoutingStatusRule
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->putAlertingRoutingstatusRulesRuleId($ruleId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putAlertingRoutingstatusRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **body** | [**\PureCloudSDK\RoutingStatusRule**](../Model/\PureCloudSDK\RoutingStatusRule.md)| RoutingStatusRule |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\RoutingStatusRule**](../Model/RoutingStatusRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAlertingUserpresenceRulesRuleId**
> \PureCloudSDK\UserPresenceRule putAlertingUserpresenceRulesRuleId($ruleId, $body, $expand)

Update a user presence rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$body = new \PureCloudSDK\UserPresenceRule(); // \PureCloudSDK\UserPresenceRule | UserPresenceRule
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->putAlertingUserpresenceRulesRuleId($ruleId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putAlertingUserpresenceRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **body** | [**\PureCloudSDK\UserPresenceRule**](../Model/\PureCloudSDK\UserPresenceRule.md)| UserPresenceRule |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UserPresenceRule**](../Model/UserPresenceRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

