# PureCloudSDK\UsersApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteUsersUserId**](UsersApi.md#deleteUsersUserId) | **DELETE** /api/v2/users/{userId} | Delete user
[**deleteUsersUserIdRoles**](UsersApi.md#deleteUsersUserIdRoles) | **DELETE** /api/v2/users/{userId}/roles | Removes all the roles from the user.
[**deleteUsersUserIdRoutingskillsSkillId**](UsersApi.md#deleteUsersUserIdRoutingskillsSkillId) | **DELETE** /api/v2/users/{userId}/routingskills/{skillId} | Remove routing skill from user
[**deleteUsersUserIdStationAssociatedstation**](UsersApi.md#deleteUsersUserIdStationAssociatedstation) | **DELETE** /api/v2/users/{userId}/station/associatedstation | Clear associated station
[**deleteUsersUserIdStationDefaultstation**](UsersApi.md#deleteUsersUserIdStationDefaultstation) | **DELETE** /api/v2/users/{userId}/station/defaultstation | Clear default station
[**getFieldconfig**](UsersApi.md#getFieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
[**getUsers**](UsersApi.md#getUsers) | **GET** /api/v2/users | Get the list of available users.
[**getUsersMe**](UsersApi.md#getUsersMe) | **GET** /api/v2/users/me | Get current user details.
[**getUsersSearch**](UsersApi.md#getUsersSearch) | **GET** /api/v2/users/search | Search users using the q64 value returned from a previous search
[**getUsersUserId**](UsersApi.md#getUsersUserId) | **GET** /api/v2/users/{userId} | Get user.
[**getUsersUserIdAdjacents**](UsersApi.md#getUsersUserIdAdjacents) | **GET** /api/v2/users/{userId}/adjacents | Get adjacents
[**getUsersUserIdCallforwarding**](UsersApi.md#getUsersUserIdCallforwarding) | **GET** /api/v2/users/{userId}/callforwarding | Get a user&#39;s CallForwarding
[**getUsersUserIdDirectreports**](UsersApi.md#getUsersUserIdDirectreports) | **GET** /api/v2/users/{userId}/directreports | Get direct reports
[**getUsersUserIdFavorites**](UsersApi.md#getUsersUserIdFavorites) | **GET** /api/v2/users/{userId}/favorites | Get favorites
[**getUsersUserIdGeolocationsClientId**](UsersApi.md#getUsersUserIdGeolocationsClientId) | **GET** /api/v2/users/{userId}/geolocations/{clientId} | Get a user&#39;s Geolocation
[**getUsersUserIdOutofoffice**](UsersApi.md#getUsersUserIdOutofoffice) | **GET** /api/v2/users/{userId}/outofoffice | Get a OutOfOffice
[**getUsersUserIdProfileskills**](UsersApi.md#getUsersUserIdProfileskills) | **GET** /api/v2/users/{userId}/profileskills | List profile skills for a user
[**getUsersUserIdQueues**](UsersApi.md#getUsersUserIdQueues) | **GET** /api/v2/users/{userId}/queues | Get queues for user
[**getUsersUserIdRoles**](UsersApi.md#getUsersUserIdRoles) | **GET** /api/v2/users/{userId}/roles | Returns a listing of roles and permissions for a user.
[**getUsersUserIdRoutingskills**](UsersApi.md#getUsersUserIdRoutingskills) | **GET** /api/v2/users/{userId}/routingskills | List routing skills for user
[**getUsersUserIdRoutingstatus**](UsersApi.md#getUsersUserIdRoutingstatus) | **GET** /api/v2/users/{userId}/routingstatus | Fetch the routing status of a user
[**getUsersUserIdStation**](UsersApi.md#getUsersUserIdStation) | **GET** /api/v2/users/{userId}/station | Get station information for user
[**getUsersUserIdSuperiors**](UsersApi.md#getUsersUserIdSuperiors) | **GET** /api/v2/users/{userId}/superiors | Get superiors
[**patchUsersUserId**](UsersApi.md#patchUsersUserId) | **PATCH** /api/v2/users/{userId} | Update user
[**patchUsersUserIdCallforwarding**](UsersApi.md#patchUsersUserIdCallforwarding) | **PATCH** /api/v2/users/{userId}/callforwarding | Patch a user&#39;s CallForwarding
[**patchUsersUserIdGeolocationsClientId**](UsersApi.md#patchUsersUserIdGeolocationsClientId) | **PATCH** /api/v2/users/{userId}/geolocations/{clientId} | Patch a user&#39;s Geolocation
[**patchUsersUserIdQueues**](UsersApi.md#patchUsersUserIdQueues) | **PATCH** /api/v2/users/{userId}/queues | Join or unjoin a set of queues for a user
[**patchUsersUserIdQueuesQueueId**](UsersApi.md#patchUsersUserIdQueuesQueueId) | **PATCH** /api/v2/users/{userId}/queues/{queueId} | Join or unjoin a queue for a user
[**postAnalyticsUsersAggregatesQuery**](UsersApi.md#postAnalyticsUsersAggregatesQuery) | **POST** /api/v2/analytics/users/aggregates/query | Query for user aggregates
[**postAnalyticsUsersDetailsQuery**](UsersApi.md#postAnalyticsUsersDetailsQuery) | **POST** /api/v2/analytics/users/details/query | Query for user details
[**postAnalyticsUsersObservationsQuery**](UsersApi.md#postAnalyticsUsersObservationsQuery) | **POST** /api/v2/analytics/users/observations/query | Query for user observations
[**postUsers**](UsersApi.md#postUsers) | **POST** /api/v2/users | Create user
[**postUsersSearch**](UsersApi.md#postUsersSearch) | **POST** /api/v2/users/search | Search users
[**postUsersUserIdRoutingskills**](UsersApi.md#postUsersUserIdRoutingskills) | **POST** /api/v2/users/{userId}/routingskills | Add routing skill to user
[**putUsersUserIdCallforwarding**](UsersApi.md#putUsersUserIdCallforwarding) | **PUT** /api/v2/users/{userId}/callforwarding | Update a user&#39;s CallForwarding
[**putUsersUserIdOutofoffice**](UsersApi.md#putUsersUserIdOutofoffice) | **PUT** /api/v2/users/{userId}/outofoffice | Update an OutOfOffice
[**putUsersUserIdProfileskills**](UsersApi.md#putUsersUserIdProfileskills) | **PUT** /api/v2/users/{userId}/profileskills | Update profile skills for a user
[**putUsersUserIdRoles**](UsersApi.md#putUsersUserIdRoles) | **PUT** /api/v2/users/{userId}/roles | Sets the user&#39;s roles
[**putUsersUserIdRoutingskillsSkillId**](UsersApi.md#putUsersUserIdRoutingskillsSkillId) | **PUT** /api/v2/users/{userId}/routingskills/{skillId} | Update routing skill proficiency or state.
[**putUsersUserIdRoutingstatus**](UsersApi.md#putUsersUserIdRoutingstatus) | **PUT** /api/v2/users/{userId}/routingstatus | Update the routing status of a user
[**putUsersUserIdStationAssociatedstationStationId**](UsersApi.md#putUsersUserIdStationAssociatedstationStationId) | **PUT** /api/v2/users/{userId}/station/associatedstation/{stationId} | Set associated station
[**putUsersUserIdStationDefaultstationStationId**](UsersApi.md#putUsersUserIdStationDefaultstationStationId) | **PUT** /api/v2/users/{userId}/station/defaultstation/{stationId} | Set default station


# **deleteUsersUserId**
> \PureCloudSDK\ModelEmpty deleteUsersUserId($userId)

Delete user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->deleteUsersUserId($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUsersUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\ModelEmpty**](../Model/ModelEmpty.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUsersUserIdRoles**
> deleteUsersUserIdRoles($userId)

Removes all the roles from the user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $api_instance->deleteUsersUserIdRoles($userId);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUsersUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUsersUserIdRoutingskillsSkillId**
> deleteUsersUserIdRoutingskillsSkillId($userId, $skillId)

Remove routing skill from user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$skillId = "skillId_example"; // string | skillId

try {
    $api_instance->deleteUsersUserIdRoutingskillsSkillId($userId, $skillId);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUsersUserIdRoutingskillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **skillId** | **string**| skillId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUsersUserIdStationAssociatedstation**
> deleteUsersUserIdStationAssociatedstation($userId)

Clear associated station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $api_instance->deleteUsersUserIdStationAssociatedstation($userId);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUsersUserIdStationAssociatedstation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUsersUserIdStationDefaultstation**
> deleteUsersUserIdStationDefaultstation($userId)

Clear default station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $api_instance->deleteUsersUserIdStationDefaultstation($userId);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->deleteUsersUserIdStationDefaultstation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFieldconfig**
> \PureCloudSDK\FieldConfig getFieldconfig($type)

Fetch field config for an entity type



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$type = "type_example"; // string | Field type

try {
    $result = $api_instance->getFieldconfig($type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getFieldconfig: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**| Field type |

### Return type

[**\PureCloudSDK\FieldConfig**](../Model/FieldConfig.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsers**
> \PureCloudSDK\UserEntityListing getUsers($pageSize, $pageNumber, $id, $sortOrder, $expand)

Get the list of available users.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$id = array("id_example"); // string[] | id
$sortOrder = "ASC"; // string | Ascending or descending sort order
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getUsers($pageSize, $pageNumber, $id, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **id** | [**string[]**](../Model/string.md)| id | [optional]
 **sortOrder** | **string**| Ascending or descending sort order | [optional] [default to ASC]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UserEntityListing**](../Model/UserEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersMe**
> \PureCloudSDK\UserMe getUsersMe($expand)

Get current user details.

This request is not valid when using the Client Credentials OAuth grant.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getUsersMe($expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersMe: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\UserMe**](../Model/UserMe.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersSearch**
> \PureCloudSDK\UsersSearchResponse getUsersSearch($q64, $expand)

Search users using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getUsersSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\UsersSearchResponse**](../Model/UsersSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserId**
> \PureCloudSDK\User getUsersUserId($userId, $expand)

Get user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getUsersUserId($userId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\User**](../Model/User.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdAdjacents**
> \PureCloudSDK\Adjacents getUsersUserIdAdjacents($userId, $expand)

Get adjacents



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getUsersUserIdAdjacents($userId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdAdjacents: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\Adjacents**](../Model/Adjacents.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdCallforwarding**
> \PureCloudSDK\CallForwarding getUsersUserIdCallforwarding($userId)

Get a user's CallForwarding



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getUsersUserIdCallforwarding($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdCallforwarding: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\CallForwarding**](../Model/CallForwarding.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdDirectreports**
> \PureCloudSDK\User[] getUsersUserIdDirectreports($userId, $expand)

Get direct reports



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getUsersUserIdDirectreports($userId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdDirectreports: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\User[]**](../Model/User.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdFavorites**
> \PureCloudSDK\UserEntityListing getUsersUserIdFavorites($userId, $pageSize, $pageNumber, $sortOrder, $expand)

Get favorites



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "ASC"; // string | Sort order
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getUsersUserIdFavorites($userId, $pageSize, $pageNumber, $sortOrder, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdFavorites: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Sort order | [optional] [default to ASC]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\UserEntityListing**](../Model/UserEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdGeolocationsClientId**
> \PureCloudSDK\Geolocation getUsersUserIdGeolocationsClientId($userId, $clientId)

Get a user's Geolocation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | user Id
$clientId = "clientId_example"; // string | client Id

try {
    $result = $api_instance->getUsersUserIdGeolocationsClientId($userId, $clientId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdGeolocationsClientId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| user Id |
 **clientId** | **string**| client Id |

### Return type

[**\PureCloudSDK\Geolocation**](../Model/Geolocation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdOutofoffice**
> \PureCloudSDK\OutOfOffice getUsersUserIdOutofoffice($userId)

Get a OutOfOffice



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getUsersUserIdOutofoffice($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdOutofoffice: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\OutOfOffice**](../Model/OutOfOffice.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdProfileskills**
> string[] getUsersUserIdProfileskills($userId)

List profile skills for a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getUsersUserIdProfileskills($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdProfileskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdQueues**
> \PureCloudSDK\UserQueueEntityListing getUsersUserIdQueues($userId, $pageSize, $pageNumber, $joined)

Get queues for user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$joined = true; // bool | Is joined to the queue

try {
    $result = $api_instance->getUsersUserIdQueues($userId, $pageSize, $pageNumber, $joined);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdQueues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **joined** | **bool**| Is joined to the queue | [optional] [default to true]

### Return type

[**\PureCloudSDK\UserQueueEntityListing**](../Model/UserQueueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdRoles**
> \PureCloudSDK\UserAuthorization getUsersUserIdRoles($userId)

Returns a listing of roles and permissions for a user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getUsersUserIdRoles($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\UserAuthorization**](../Model/UserAuthorization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdRoutingskills**
> \PureCloudSDK\UserSkillEntityListing getUsersUserIdRoutingskills($userId, $pageSize, $pageNumber, $sortOrder)

List routing skills for user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "ASC"; // string | Ascending or descending sort order

try {
    $result = $api_instance->getUsersUserIdRoutingskills($userId, $pageSize, $pageNumber, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdRoutingskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Ascending or descending sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\UserSkillEntityListing**](../Model/UserSkillEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdRoutingstatus**
> \PureCloudSDK\RoutingStatus getUsersUserIdRoutingstatus($userId)

Fetch the routing status of a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getUsersUserIdRoutingstatus($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdRoutingstatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\RoutingStatus**](../Model/RoutingStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdStation**
> \PureCloudSDK\UserStations getUsersUserIdStation($userId)

Get station information for user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getUsersUserIdStation($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdStation: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\UserStations**](../Model/UserStations.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersUserIdSuperiors**
> \PureCloudSDK\User[] getUsersUserIdSuperiors($userId, $expand)

Get superiors



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand

try {
    $result = $api_instance->getUsersUserIdSuperiors($userId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->getUsersUserIdSuperiors: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]

### Return type

[**\PureCloudSDK\User[]**](../Model/User.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUsersUserId**
> \PureCloudSDK\User patchUsersUserId($userId, $body)

Update user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\UpdateUser(); // \PureCloudSDK\UpdateUser | User

try {
    $result = $api_instance->patchUsersUserId($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUsersUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\UpdateUser**](../Model/\PureCloudSDK\UpdateUser.md)| User |

### Return type

[**\PureCloudSDK\User**](../Model/User.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUsersUserIdCallforwarding**
> \PureCloudSDK\CallForwarding patchUsersUserIdCallforwarding($userId, $body)

Patch a user's CallForwarding



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\CallForwarding(); // \PureCloudSDK\CallForwarding | Call forwarding

try {
    $result = $api_instance->patchUsersUserIdCallforwarding($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUsersUserIdCallforwarding: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\CallForwarding**](../Model/\PureCloudSDK\CallForwarding.md)| Call forwarding |

### Return type

[**\PureCloudSDK\CallForwarding**](../Model/CallForwarding.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUsersUserIdGeolocationsClientId**
> \PureCloudSDK\Geolocation patchUsersUserIdGeolocationsClientId($userId, $clientId, $body)

Patch a user's Geolocation

The geolocation object can be patched one of three ways. Option 1: Set the 'primary' property to true. This will set the client as the user's primary geolocation source.  Option 2: Provide the 'latitude' and 'longitude' values.  This will enqueue an asynchronous update of the 'city', 'region', and 'country', generating a notification. A subsequent GET operation will include the new values for 'city', 'region' and 'country'.  Option 3:  Provide the 'city', 'region', 'country' values.  Option 1 can be combined with Option 2 or Option 3.  For example, update the client as primary and provide latitude and longitude values.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | user Id
$clientId = "clientId_example"; // string | client Id
$body = new \PureCloudSDK\Geolocation(); // \PureCloudSDK\Geolocation | Geolocation

try {
    $result = $api_instance->patchUsersUserIdGeolocationsClientId($userId, $clientId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUsersUserIdGeolocationsClientId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| user Id |
 **clientId** | **string**| client Id |
 **body** | [**\PureCloudSDK\Geolocation**](../Model/\PureCloudSDK\Geolocation.md)| Geolocation |

### Return type

[**\PureCloudSDK\Geolocation**](../Model/Geolocation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUsersUserIdQueues**
> \PureCloudSDK\UserQueueEntityListing patchUsersUserIdQueues($userId, $body)

Join or unjoin a set of queues for a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$body = array(new UserQueue()); // \PureCloudSDK\UserQueue[] | User Queues

try {
    $result = $api_instance->patchUsersUserIdQueues($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUsersUserIdQueues: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\UserQueue[]**](../Model/UserQueue.md)| User Queues |

### Return type

[**\PureCloudSDK\UserQueueEntityListing**](../Model/UserQueueEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchUsersUserIdQueuesQueueId**
> \PureCloudSDK\UserQueue patchUsersUserIdQueuesQueueId($queueId, $userId, $body)

Join or unjoin a queue for a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$queueId = "queueId_example"; // string | Queue ID
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\UserQueue(); // \PureCloudSDK\UserQueue | Queue Member

try {
    $result = $api_instance->patchUsersUserIdQueuesQueueId($queueId, $userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->patchUsersUserIdQueuesQueueId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **queueId** | **string**| Queue ID |
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\UserQueue**](../Model/\PureCloudSDK\UserQueue.md)| Queue Member |

### Return type

[**\PureCloudSDK\UserQueue**](../Model/UserQueue.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsUsersAggregatesQuery**
> \PureCloudSDK\PresenceQueryResponse postAnalyticsUsersAggregatesQuery($body)

Query for user aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postAnalyticsUsersAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postAnalyticsUsersAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\PresenceQueryResponse**](../Model/PresenceQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsUsersDetailsQuery**
> \PureCloudSDK\AnalyticsUserDetailsQueryResponse postAnalyticsUsersDetailsQuery($body)

Query for user details



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$body = new \PureCloudSDK\UserDetailsQuery(); // \PureCloudSDK\UserDetailsQuery | query

try {
    $result = $api_instance->postAnalyticsUsersDetailsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postAnalyticsUsersDetailsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\UserDetailsQuery**](../Model/\PureCloudSDK\UserDetailsQuery.md)| query |

### Return type

[**\PureCloudSDK\AnalyticsUserDetailsQueryResponse**](../Model/AnalyticsUserDetailsQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAnalyticsUsersObservationsQuery**
> \PureCloudSDK\ObservationQueryResponse postAnalyticsUsersObservationsQuery($body)

Query for user observations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$body = new \PureCloudSDK\ObservationQuery(); // \PureCloudSDK\ObservationQuery | query

try {
    $result = $api_instance->postAnalyticsUsersObservationsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postAnalyticsUsersObservationsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ObservationQuery**](../Model/\PureCloudSDK\ObservationQuery.md)| query |

### Return type

[**\PureCloudSDK\ObservationQueryResponse**](../Model/ObservationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsers**
> \PureCloudSDK\User postUsers($body)

Create user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$body = new \PureCloudSDK\CreateUser(); // \PureCloudSDK\CreateUser | User

try {
    $result = $api_instance->postUsers($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateUser**](../Model/\PureCloudSDK\CreateUser.md)| User |

### Return type

[**\PureCloudSDK\User**](../Model/User.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsersSearch**
> \PureCloudSDK\UsersSearchResponse postUsersSearch($body)

Search users



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$body = new \PureCloudSDK\UserSearchRequest(); // \PureCloudSDK\UserSearchRequest | Search request options

try {
    $result = $api_instance->postUsersSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postUsersSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\UserSearchRequest**](../Model/\PureCloudSDK\UserSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\UsersSearchResponse**](../Model/UsersSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsersUserIdRoutingskills**
> \PureCloudSDK\UserRoutingSkill postUsersUserIdRoutingskills($userId, $body)

Add routing skill to user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\UserRoutingSkillPost(); // \PureCloudSDK\UserRoutingSkillPost | Skill

try {
    $result = $api_instance->postUsersUserIdRoutingskills($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->postUsersUserIdRoutingskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\UserRoutingSkillPost**](../Model/\PureCloudSDK\UserRoutingSkillPost.md)| Skill |

### Return type

[**\PureCloudSDK\UserRoutingSkill**](../Model/UserRoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdCallforwarding**
> \PureCloudSDK\CallForwarding putUsersUserIdCallforwarding($userId, $body)

Update a user's CallForwarding



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\CallForwarding(); // \PureCloudSDK\CallForwarding | Call forwarding

try {
    $result = $api_instance->putUsersUserIdCallforwarding($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUsersUserIdCallforwarding: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\CallForwarding**](../Model/\PureCloudSDK\CallForwarding.md)| Call forwarding |

### Return type

[**\PureCloudSDK\CallForwarding**](../Model/CallForwarding.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdOutofoffice**
> \PureCloudSDK\OutOfOffice putUsersUserIdOutofoffice($userId, $body)

Update an OutOfOffice



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\OutOfOffice(); // \PureCloudSDK\OutOfOffice | The updated UserPresence

try {
    $result = $api_instance->putUsersUserIdOutofoffice($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUsersUserIdOutofoffice: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\OutOfOffice**](../Model/\PureCloudSDK\OutOfOffice.md)| The updated UserPresence |

### Return type

[**\PureCloudSDK\OutOfOffice**](../Model/OutOfOffice.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdProfileskills**
> string[] putUsersUserIdProfileskills($userId, $body)

Update profile skills for a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$body = array(new string[]()); // string[] | Skills

try {
    $result = $api_instance->putUsersUserIdProfileskills($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUsersUserIdProfileskills: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | **string[]**| Skills | [optional]

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdRoles**
> \PureCloudSDK\UserAuthorization putUsersUserIdRoles($userId, $body)

Sets the user's roles



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$body = array(new string[]()); // string[] | List of roles

try {
    $result = $api_instance->putUsersUserIdRoles($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUsersUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | **string[]**| List of roles |

### Return type

[**\PureCloudSDK\UserAuthorization**](../Model/UserAuthorization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdRoutingskillsSkillId**
> \PureCloudSDK\UserRoutingSkill putUsersUserIdRoutingskillsSkillId($userId, $skillId, $body)

Update routing skill proficiency or state.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$skillId = "skillId_example"; // string | skillId
$body = new \PureCloudSDK\UserRoutingSkill(); // \PureCloudSDK\UserRoutingSkill | Skill

try {
    $result = $api_instance->putUsersUserIdRoutingskillsSkillId($userId, $skillId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUsersUserIdRoutingskillsSkillId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **skillId** | **string**| skillId |
 **body** | [**\PureCloudSDK\UserRoutingSkill**](../Model/\PureCloudSDK\UserRoutingSkill.md)| Skill |

### Return type

[**\PureCloudSDK\UserRoutingSkill**](../Model/UserRoutingSkill.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdRoutingstatus**
> \PureCloudSDK\RoutingStatus putUsersUserIdRoutingstatus($userId, $body)

Update the routing status of a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$body = new \PureCloudSDK\RoutingStatus(); // \PureCloudSDK\RoutingStatus | Routing Status

try {
    $result = $api_instance->putUsersUserIdRoutingstatus($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUsersUserIdRoutingstatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | [**\PureCloudSDK\RoutingStatus**](../Model/\PureCloudSDK\RoutingStatus.md)| Routing Status |

### Return type

[**\PureCloudSDK\RoutingStatus**](../Model/RoutingStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdStationAssociatedstationStationId**
> putUsersUserIdStationAssociatedstationStationId($userId, $stationId)

Set associated station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$stationId = "stationId_example"; // string | stationId

try {
    $api_instance->putUsersUserIdStationAssociatedstationStationId($userId, $stationId);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUsersUserIdStationAssociatedstationStationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **stationId** | **string**| stationId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUsersUserIdStationDefaultstationStationId**
> putUsersUserIdStationDefaultstationStationId($userId, $stationId)

Set default station



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UsersApi();
$userId = "userId_example"; // string | User ID
$stationId = "stationId_example"; // string | stationId

try {
    $api_instance->putUsersUserIdStationDefaultstationStationId($userId, $stationId);
} catch (Exception $e) {
    echo 'Exception when calling UsersApi->putUsersUserIdStationDefaultstationStationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **stationId** | **string**| stationId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

