<?php

/**
 * ArchitectApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use PureCloudSDK\Configuration;
use PureCloudSDK\ApiClient;
use PureCloudSDK\ApiException;
use PureCloudSDK\ObjectSerializer;

/**
 * ArchitectApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ArchitectApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.ie');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return ArchitectApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteArchitectEmergencygroup
     *
     * Deletes a emergency group by ID
     *
     * @param string $emergencyGroupId Emergency group ID (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectEmergencygroup($emergencyGroupId)
    {
        list($response) = $this->deleteArchitectEmergencygroupWithHttpInfo($emergencyGroupId);
        return $response;
    }

    /**
     * Operation deleteArchitectEmergencygroupWithHttpInfo
     *
     * Deletes a emergency group by ID
     *
     * @param string $emergencyGroupId Emergency group ID (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectEmergencygroupWithHttpInfo($emergencyGroupId)
    {
        // verify the required parameter 'emergencyGroupId' is set
        if ($emergencyGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emergencyGroupId when calling deleteArchitectEmergencygroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/emergencygroups/{emergencyGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emergencyGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "emergencyGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emergencyGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/emergencygroups/{emergencyGroupId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectIvr
     *
     * Delete an IVR Config.
     *
     * @param string $ivrId IVR id (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectIvr($ivrId)
    {
        list($response) = $this->deleteArchitectIvrWithHttpInfo($ivrId);
        return $response;
    }

    /**
     * Operation deleteArchitectIvrWithHttpInfo
     *
     * Delete an IVR Config.
     *
     * @param string $ivrId IVR id (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectIvrWithHttpInfo($ivrId)
    {
        // verify the required parameter 'ivrId' is set
        if ($ivrId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ivrId when calling deleteArchitectIvr');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/ivrs/{ivrId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($ivrId !== null) {
            $resourcePath = str_replace(
                "{" . "ivrId" . "}",
                $this->apiClient->getSerializer()->toPathValue($ivrId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/ivrs/{ivrId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectPrompt
     *
     * Delete specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @param bool $allResources Whether or not to delete all the prompt resources (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPrompt($promptId, $allResources = null)
    {
        list($response) = $this->deleteArchitectPromptWithHttpInfo($promptId, $allResources);
        return $response;
    }

    /**
     * Operation deleteArchitectPromptWithHttpInfo
     *
     * Delete specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @param bool $allResources Whether or not to delete all the prompt resources (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptWithHttpInfo($promptId, $allResources = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling deleteArchitectPrompt');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($allResources !== null) {
            $queryParams['allResources'] = $this->apiClient->getSerializer()->toQueryValue($allResources);
        }
        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/prompts/{promptId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectPromptResource
     *
     * Delete specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptResource($promptId, $languageCode)
    {
        list($response) = $this->deleteArchitectPromptResourceWithHttpInfo($promptId, $languageCode);
        return $response;
    }

    /**
     * Operation deleteArchitectPromptResourceWithHttpInfo
     *
     * Delete specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptResourceWithHttpInfo($promptId, $languageCode)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling deleteArchitectPromptResource');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling deleteArchitectPromptResource');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectPromptResourceAudio
     *
     * Delete specified user prompt resource audio
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptResourceAudio($promptId, $languageCode)
    {
        list($response) = $this->deleteArchitectPromptResourceAudioWithHttpInfo($promptId, $languageCode);
        return $response;
    }

    /**
     * Operation deleteArchitectPromptResourceAudioWithHttpInfo
     *
     * Delete specified user prompt resource audio
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptResourceAudioWithHttpInfo($promptId, $languageCode)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling deleteArchitectPromptResourceAudio');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling deleteArchitectPromptResourceAudio');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}/audio";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/prompts/{promptId}/resources/{languageCode}/audio'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectPrompts
     *
     * Batch-delete a list of prompts
     *
     * @param string[] $id List of Prompt IDs (required)
     * @return \PureCloudSDK\Operation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPrompts($id)
    {
        list($response) = $this->deleteArchitectPromptsWithHttpInfo($id);
        return $response;
    }

    /**
     * Operation deleteArchitectPromptsWithHttpInfo
     *
     * Batch-delete a list of prompts
     *
     * @param string[] $id List of Prompt IDs (required)
     * @return Array of \PureCloudSDK\Operation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptsWithHttpInfo($id)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling deleteArchitectPrompts');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($id)) {
            $id = $this->apiClient->getSerializer()->serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Operation',
                '/api/v2/architect/prompts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Operation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Operation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectSchedule
     *
     * Delete a schedule by id
     *
     * @param string $scheduleId Schedule ID (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectSchedule($scheduleId)
    {
        list($response) = $this->deleteArchitectScheduleWithHttpInfo($scheduleId);
        return $response;
    }

    /**
     * Operation deleteArchitectScheduleWithHttpInfo
     *
     * Delete a schedule by id
     *
     * @param string $scheduleId Schedule ID (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectScheduleWithHttpInfo($scheduleId)
    {
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling deleteArchitectSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/schedules/{scheduleId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectSchedulegroup
     *
     * Deletes a schedule group by ID
     *
     * @param string $scheduleGroupId Schedule group ID (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectSchedulegroup($scheduleGroupId)
    {
        list($response) = $this->deleteArchitectSchedulegroupWithHttpInfo($scheduleGroupId);
        return $response;
    }

    /**
     * Operation deleteArchitectSchedulegroupWithHttpInfo
     *
     * Deletes a schedule group by ID
     *
     * @param string $scheduleGroupId Schedule group ID (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectSchedulegroupWithHttpInfo($scheduleGroupId)
    {
        // verify the required parameter 'scheduleGroupId' is set
        if ($scheduleGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleGroupId when calling deleteArchitectSchedulegroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/schedulegroups/{scheduleGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($scheduleGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/schedulegroups/{scheduleGroupId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectSystempromptResource
     *
     * Delete a system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectSystempromptResource($promptId, $languageCode)
    {
        list($response) = $this->deleteArchitectSystempromptResourceWithHttpInfo($promptId, $languageCode);
        return $response;
    }

    /**
     * Operation deleteArchitectSystempromptResourceWithHttpInfo
     *
     * Delete a system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectSystempromptResourceWithHttpInfo($promptId, $languageCode)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling deleteArchitectSystempromptResource');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling deleteArchitectSystempromptResource');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteFlow
     *
     * Delete flow
     *
     * @param string $flowId Flow ID (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlow($flowId)
    {
        list($response) = $this->deleteFlowWithHttpInfo($flowId);
        return $response;
    }

    /**
     * Operation deleteFlowWithHttpInfo
     *
     * Delete flow
     *
     * @param string $flowId Flow ID (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlowWithHttpInfo($flowId)
    {
        // verify the required parameter 'flowId' is set
        if ($flowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowId when calling deleteFlow');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/{flowId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($flowId !== null) {
            $resourcePath = str_replace(
                "{" . "flowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/flows/{flowId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteFlows
     *
     * Batch-delete a list of flows
     *
     * @param string[] $id List of Flow IDs (required)
     * @return \PureCloudSDK\Operation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlows($id)
    {
        list($response) = $this->deleteFlowsWithHttpInfo($id);
        return $response;
    }

    /**
     * Operation deleteFlowsWithHttpInfo
     *
     * Batch-delete a list of flows
     *
     * @param string[] $id List of Flow IDs (required)
     * @return Array of \PureCloudSDK\Operation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlowsWithHttpInfo($id)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling deleteFlows');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($id)) {
            $id = $this->apiClient->getSerializer()->serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Operation',
                '/api/v2/flows'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Operation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Operation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteFlowsDatatable
     *
     * deletes a specific datatable by id
     *
     * @param string $datatableId id of datatable (required)
     * @param bool $force force delete, even if in use (optional, default to false)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlowsDatatable($datatableId, $force = null)
    {
        list($response) = $this->deleteFlowsDatatableWithHttpInfo($datatableId, $force);
        return $response;
    }

    /**
     * Operation deleteFlowsDatatableWithHttpInfo
     *
     * deletes a specific datatable by id
     *
     * @param string $datatableId id of datatable (required)
     * @param bool $force force delete, even if in use (optional, default to false)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlowsDatatableWithHttpInfo($datatableId, $force = null)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling deleteFlowsDatatable');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($force !== null) {
            $queryParams['force'] = $this->apiClient->getSerializer()->toQueryValue($force);
        }
        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/flows/datatables/{datatableId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteFlowsDatatableRow
     *
     * Delete a row entry
     *
     * @param string $datatableId id of datatable (required)
     * @param string $rowId the key for the row (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlowsDatatableRow($datatableId, $rowId)
    {
        list($response) = $this->deleteFlowsDatatableRowWithHttpInfo($datatableId, $rowId);
        return $response;
    }

    /**
     * Operation deleteFlowsDatatableRowWithHttpInfo
     *
     * Delete a row entry
     *
     * @param string $datatableId id of datatable (required)
     * @param string $rowId the key for the row (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlowsDatatableRowWithHttpInfo($datatableId, $rowId)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling deleteFlowsDatatableRow');
        }
        // verify the required parameter 'rowId' is set
        if ($rowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $rowId when calling deleteFlowsDatatableRow');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/rows/{rowId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // path params
        if ($rowId !== null) {
            $resourcePath = str_replace(
                "{" . "rowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($rowId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/flows/datatables/{datatableId}/rows/{rowId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteFlowsMilestone
     *
     * Delete a flow milestone.
     *
     * @param string $milestoneId flow milestone ID (required)
     * @return \PureCloudSDK\ModelEmpty
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlowsMilestone($milestoneId)
    {
        list($response) = $this->deleteFlowsMilestoneWithHttpInfo($milestoneId);
        return $response;
    }

    /**
     * Operation deleteFlowsMilestoneWithHttpInfo
     *
     * Delete a flow milestone.
     *
     * @param string $milestoneId flow milestone ID (required)
     * @return Array of \PureCloudSDK\ModelEmpty, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteFlowsMilestoneWithHttpInfo($milestoneId)
    {
        // verify the required parameter 'milestoneId' is set
        if ($milestoneId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $milestoneId when calling deleteFlowsMilestone');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/milestones/{milestoneId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($milestoneId !== null) {
            $resourcePath = str_replace(
                "{" . "milestoneId" . "}",
                $this->apiClient->getSerializer()->toPathValue($milestoneId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ModelEmpty',
                '/api/v2/flows/milestones/{milestoneId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ModelEmpty', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ModelEmpty', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectDependencytracking
     *
     * Get Dependency Tracking objects that have a given display name
     *
     * @param string $name Object name to search for (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string[] $objectType Object type(s) to search for (optional)
     * @param bool $consumedResources Include resources each result item consumes (optional)
     * @param bool $consumingResources Include resources that consume each result item (optional)
     * @param string[] $consumedResourceType Types of consumed resources to return, if consumed resources are requested (optional)
     * @param string[] $consumingResourceType Types of consuming resources to return, if consuming resources are requested (optional)
     * @return \PureCloudSDK\DependencyObjectEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytracking($name, $pageNumber = null, $pageSize = null, $objectType = null, $consumedResources = null, $consumingResources = null, $consumedResourceType = null, $consumingResourceType = null)
    {
        list($response) = $this->getArchitectDependencytrackingWithHttpInfo($name, $pageNumber, $pageSize, $objectType, $consumedResources, $consumingResources, $consumedResourceType, $consumingResourceType);
        return $response;
    }

    /**
     * Operation getArchitectDependencytrackingWithHttpInfo
     *
     * Get Dependency Tracking objects that have a given display name
     *
     * @param string $name Object name to search for (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string[] $objectType Object type(s) to search for (optional)
     * @param bool $consumedResources Include resources each result item consumes (optional)
     * @param bool $consumingResources Include resources that consume each result item (optional)
     * @param string[] $consumedResourceType Types of consumed resources to return, if consumed resources are requested (optional)
     * @param string[] $consumingResourceType Types of consuming resources to return, if consuming resources are requested (optional)
     * @return Array of \PureCloudSDK\DependencyObjectEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingWithHttpInfo($name, $pageNumber = null, $pageSize = null, $objectType = null, $consumedResources = null, $consumingResources = null, $consumedResourceType = null, $consumingResourceType = null)
    {
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling getArchitectDependencytracking');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if (is_array($objectType)) {
            $objectType = $this->apiClient->getSerializer()->serializeCollection($objectType, 'multi', true);
        }
        if ($objectType !== null) {
            $queryParams['objectType'] = $this->apiClient->getSerializer()->toQueryValue($objectType);
        }
        // query params
        if ($consumedResources !== null) {
            $queryParams['consumedResources'] = $this->apiClient->getSerializer()->toQueryValue($consumedResources);
        }
        // query params
        if ($consumingResources !== null) {
            $queryParams['consumingResources'] = $this->apiClient->getSerializer()->toQueryValue($consumingResources);
        }
        // query params
        if (is_array($consumedResourceType)) {
            $consumedResourceType = $this->apiClient->getSerializer()->serializeCollection($consumedResourceType, 'multi', true);
        }
        if ($consumedResourceType !== null) {
            $queryParams['consumedResourceType'] = $this->apiClient->getSerializer()->toQueryValue($consumedResourceType);
        }
        // query params
        if (is_array($consumingResourceType)) {
            $consumingResourceType = $this->apiClient->getSerializer()->serializeCollection($consumingResourceType, 'multi', true);
        }
        if ($consumingResourceType !== null) {
            $queryParams['consumingResourceType'] = $this->apiClient->getSerializer()->toQueryValue($consumingResourceType);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DependencyObjectEntityListing',
                '/api/v2/architect/dependencytracking'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DependencyObjectEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DependencyObjectEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectDependencytrackingBuild
     *
     * Get Dependency Tracking build status for an organization
     *
     * @return \PureCloudSDK\DependencyStatus
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingBuild()
    {
        list($response) = $this->getArchitectDependencytrackingBuildWithHttpInfo();
        return $response;
    }

    /**
     * Operation getArchitectDependencytrackingBuildWithHttpInfo
     *
     * Get Dependency Tracking build status for an organization
     *
     * @return Array of \PureCloudSDK\DependencyStatus, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingBuildWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking/build";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DependencyStatus',
                '/api/v2/architect/dependencytracking/build'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DependencyStatus', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DependencyStatus', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectDependencytrackingConsumedresources
     *
     * Get resources that are consumed by a given Dependency Tracking object
     *
     * @param string $id Consuming object ID (required)
     * @param string $version Consuming object version (required)
     * @param string $objectType Consuming object type.  Only versioned types are allowed here. (required)
     * @param string[] $resourceType Types of consumed resources to show (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return \PureCloudSDK\ConsumedResourcesEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingConsumedresources($id, $version, $objectType, $resourceType = null, $pageNumber = null, $pageSize = null)
    {
        list($response) = $this->getArchitectDependencytrackingConsumedresourcesWithHttpInfo($id, $version, $objectType, $resourceType, $pageNumber, $pageSize);
        return $response;
    }

    /**
     * Operation getArchitectDependencytrackingConsumedresourcesWithHttpInfo
     *
     * Get resources that are consumed by a given Dependency Tracking object
     *
     * @param string $id Consuming object ID (required)
     * @param string $version Consuming object version (required)
     * @param string $objectType Consuming object type.  Only versioned types are allowed here. (required)
     * @param string[] $resourceType Types of consumed resources to show (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return Array of \PureCloudSDK\ConsumedResourcesEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingConsumedresourcesWithHttpInfo($id, $version, $objectType, $resourceType = null, $pageNumber = null, $pageSize = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling getArchitectDependencytrackingConsumedresources');
        }
        // verify the required parameter 'version' is set
        if ($version === null) {
            throw new \InvalidArgumentException('Missing the required parameter $version when calling getArchitectDependencytrackingConsumedresources');
        }
        // verify the required parameter 'objectType' is set
        if ($objectType === null) {
            throw new \InvalidArgumentException('Missing the required parameter $objectType when calling getArchitectDependencytrackingConsumedresources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking/consumedresources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // query params
        if ($version !== null) {
            $queryParams['version'] = $this->apiClient->getSerializer()->toQueryValue($version);
        }
        // query params
        if ($objectType !== null) {
            $queryParams['objectType'] = $this->apiClient->getSerializer()->toQueryValue($objectType);
        }
        // query params
        if (is_array($resourceType)) {
            $resourceType = $this->apiClient->getSerializer()->serializeCollection($resourceType, 'multi', true);
        }
        if ($resourceType !== null) {
            $queryParams['resourceType'] = $this->apiClient->getSerializer()->toQueryValue($resourceType);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ConsumedResourcesEntityListing',
                '/api/v2/architect/dependencytracking/consumedresources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ConsumedResourcesEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ConsumedResourcesEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectDependencytrackingConsumingresources
     *
     * Get resources that consume a given Dependency Tracking object
     *
     * @param string $id Consumed object ID (required)
     * @param string $objectType Consumed object type (required)
     * @param string[] $resourceType Types of consuming resources to show.  Only versioned types are allowed here. (optional)
     * @param string $version Object version (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $flowFilter Show only checkedIn or published flows (optional)
     * @return \PureCloudSDK\ConsumingResourcesEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingConsumingresources($id, $objectType, $resourceType = null, $version = null, $pageNumber = null, $pageSize = null, $flowFilter = null)
    {
        list($response) = $this->getArchitectDependencytrackingConsumingresourcesWithHttpInfo($id, $objectType, $resourceType, $version, $pageNumber, $pageSize, $flowFilter);
        return $response;
    }

    /**
     * Operation getArchitectDependencytrackingConsumingresourcesWithHttpInfo
     *
     * Get resources that consume a given Dependency Tracking object
     *
     * @param string $id Consumed object ID (required)
     * @param string $objectType Consumed object type (required)
     * @param string[] $resourceType Types of consuming resources to show.  Only versioned types are allowed here. (optional)
     * @param string $version Object version (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $flowFilter Show only checkedIn or published flows (optional)
     * @return Array of \PureCloudSDK\ConsumingResourcesEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingConsumingresourcesWithHttpInfo($id, $objectType, $resourceType = null, $version = null, $pageNumber = null, $pageSize = null, $flowFilter = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling getArchitectDependencytrackingConsumingresources');
        }
        // verify the required parameter 'objectType' is set
        if ($objectType === null) {
            throw new \InvalidArgumentException('Missing the required parameter $objectType when calling getArchitectDependencytrackingConsumingresources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking/consumingresources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // query params
        if ($objectType !== null) {
            $queryParams['objectType'] = $this->apiClient->getSerializer()->toQueryValue($objectType);
        }
        // query params
        if (is_array($resourceType)) {
            $resourceType = $this->apiClient->getSerializer()->serializeCollection($resourceType, 'multi', true);
        }
        if ($resourceType !== null) {
            $queryParams['resourceType'] = $this->apiClient->getSerializer()->toQueryValue($resourceType);
        }
        // query params
        if ($version !== null) {
            $queryParams['version'] = $this->apiClient->getSerializer()->toQueryValue($version);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($flowFilter !== null) {
            $queryParams['flowFilter'] = $this->apiClient->getSerializer()->toQueryValue($flowFilter);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ConsumingResourcesEntityListing',
                '/api/v2/architect/dependencytracking/consumingresources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ConsumingResourcesEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ConsumingResourcesEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectDependencytrackingDeletedresourceconsumers
     *
     * Get Dependency Tracking objects that consume deleted resources
     *
     * @param string $name Name to search for (optional)
     * @param string[] $objectType Object type(s) to search for (optional)
     * @param string $flowFilter Show only checkedIn or published flows (optional)
     * @param bool $consumedResources Return consumed resources? (optional, default to false)
     * @param string[] $consumedResourceType Resource type(s) to return (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return \PureCloudSDK\DependencyObjectEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingDeletedresourceconsumers($name = null, $objectType = null, $flowFilter = null, $consumedResources = null, $consumedResourceType = null, $pageNumber = null, $pageSize = null)
    {
        list($response) = $this->getArchitectDependencytrackingDeletedresourceconsumersWithHttpInfo($name, $objectType, $flowFilter, $consumedResources, $consumedResourceType, $pageNumber, $pageSize);
        return $response;
    }

    /**
     * Operation getArchitectDependencytrackingDeletedresourceconsumersWithHttpInfo
     *
     * Get Dependency Tracking objects that consume deleted resources
     *
     * @param string $name Name to search for (optional)
     * @param string[] $objectType Object type(s) to search for (optional)
     * @param string $flowFilter Show only checkedIn or published flows (optional)
     * @param bool $consumedResources Return consumed resources? (optional, default to false)
     * @param string[] $consumedResourceType Resource type(s) to return (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return Array of \PureCloudSDK\DependencyObjectEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingDeletedresourceconsumersWithHttpInfo($name = null, $objectType = null, $flowFilter = null, $consumedResources = null, $consumedResourceType = null, $pageNumber = null, $pageSize = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking/deletedresourceconsumers";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if (is_array($objectType)) {
            $objectType = $this->apiClient->getSerializer()->serializeCollection($objectType, 'multi', true);
        }
        if ($objectType !== null) {
            $queryParams['objectType'] = $this->apiClient->getSerializer()->toQueryValue($objectType);
        }
        // query params
        if ($flowFilter !== null) {
            $queryParams['flowFilter'] = $this->apiClient->getSerializer()->toQueryValue($flowFilter);
        }
        // query params
        if ($consumedResources !== null) {
            $queryParams['consumedResources'] = $this->apiClient->getSerializer()->toQueryValue($consumedResources);
        }
        // query params
        if (is_array($consumedResourceType)) {
            $consumedResourceType = $this->apiClient->getSerializer()->serializeCollection($consumedResourceType, 'multi', true);
        }
        if ($consumedResourceType !== null) {
            $queryParams['consumedResourceType'] = $this->apiClient->getSerializer()->toQueryValue($consumedResourceType);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DependencyObjectEntityListing',
                '/api/v2/architect/dependencytracking/deletedresourceconsumers'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DependencyObjectEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DependencyObjectEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectDependencytrackingObject
     *
     * Get a Dependency Tracking object
     *
     * @param string $id Object ID (required)
     * @param string $version Object version (optional)
     * @param string $objectType Object type (optional)
     * @param bool $consumedResources Include resources this item consumes (optional)
     * @param bool $consumingResources Include resources that consume this item (optional)
     * @param string[] $consumedResourceType Types of consumed resources to return, if consumed resources are requested (optional)
     * @param string[] $consumingResourceType Types of consuming resources to return, if consuming resources are requested (optional)
     * @param bool $consumedResourceRequest Indicate that this is going to look up a consumed resource object (optional)
     * @return \PureCloudSDK\DependencyObject
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingObject($id, $version = null, $objectType = null, $consumedResources = null, $consumingResources = null, $consumedResourceType = null, $consumingResourceType = null, $consumedResourceRequest = null)
    {
        list($response) = $this->getArchitectDependencytrackingObjectWithHttpInfo($id, $version, $objectType, $consumedResources, $consumingResources, $consumedResourceType, $consumingResourceType, $consumedResourceRequest);
        return $response;
    }

    /**
     * Operation getArchitectDependencytrackingObjectWithHttpInfo
     *
     * Get a Dependency Tracking object
     *
     * @param string $id Object ID (required)
     * @param string $version Object version (optional)
     * @param string $objectType Object type (optional)
     * @param bool $consumedResources Include resources this item consumes (optional)
     * @param bool $consumingResources Include resources that consume this item (optional)
     * @param string[] $consumedResourceType Types of consumed resources to return, if consumed resources are requested (optional)
     * @param string[] $consumingResourceType Types of consuming resources to return, if consuming resources are requested (optional)
     * @param bool $consumedResourceRequest Indicate that this is going to look up a consumed resource object (optional)
     * @return Array of \PureCloudSDK\DependencyObject, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingObjectWithHttpInfo($id, $version = null, $objectType = null, $consumedResources = null, $consumingResources = null, $consumedResourceType = null, $consumingResourceType = null, $consumedResourceRequest = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling getArchitectDependencytrackingObject');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking/object";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // query params
        if ($version !== null) {
            $queryParams['version'] = $this->apiClient->getSerializer()->toQueryValue($version);
        }
        // query params
        if ($objectType !== null) {
            $queryParams['objectType'] = $this->apiClient->getSerializer()->toQueryValue($objectType);
        }
        // query params
        if ($consumedResources !== null) {
            $queryParams['consumedResources'] = $this->apiClient->getSerializer()->toQueryValue($consumedResources);
        }
        // query params
        if ($consumingResources !== null) {
            $queryParams['consumingResources'] = $this->apiClient->getSerializer()->toQueryValue($consumingResources);
        }
        // query params
        if (is_array($consumedResourceType)) {
            $consumedResourceType = $this->apiClient->getSerializer()->serializeCollection($consumedResourceType, 'multi', true);
        }
        if ($consumedResourceType !== null) {
            $queryParams['consumedResourceType'] = $this->apiClient->getSerializer()->toQueryValue($consumedResourceType);
        }
        // query params
        if (is_array($consumingResourceType)) {
            $consumingResourceType = $this->apiClient->getSerializer()->serializeCollection($consumingResourceType, 'multi', true);
        }
        if ($consumingResourceType !== null) {
            $queryParams['consumingResourceType'] = $this->apiClient->getSerializer()->toQueryValue($consumingResourceType);
        }
        // query params
        if ($consumedResourceRequest !== null) {
            $queryParams['consumedResourceRequest'] = $this->apiClient->getSerializer()->toQueryValue($consumedResourceRequest);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DependencyObject',
                '/api/v2/architect/dependencytracking/object'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DependencyObject', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DependencyObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectDependencytrackingType
     *
     * Get a Dependency Tracking type.
     *
     * @param string $typeId Type ID (required)
     * @return \PureCloudSDK\DependencyType
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingType($typeId)
    {
        list($response) = $this->getArchitectDependencytrackingTypeWithHttpInfo($typeId);
        return $response;
    }

    /**
     * Operation getArchitectDependencytrackingTypeWithHttpInfo
     *
     * Get a Dependency Tracking type.
     *
     * @param string $typeId Type ID (required)
     * @return Array of \PureCloudSDK\DependencyType, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingTypeWithHttpInfo($typeId)
    {
        // verify the required parameter 'typeId' is set
        if ($typeId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $typeId when calling getArchitectDependencytrackingType');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking/types/{typeId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($typeId !== null) {
            $resourcePath = str_replace(
                "{" . "typeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($typeId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DependencyType',
                '/api/v2/architect/dependencytracking/types/{typeId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DependencyType', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DependencyType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectDependencytrackingTypes
     *
     * Get Dependency Tracking types.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return \PureCloudSDK\DependencyTypeEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingTypes($pageNumber = null, $pageSize = null)
    {
        list($response) = $this->getArchitectDependencytrackingTypesWithHttpInfo($pageNumber, $pageSize);
        return $response;
    }

    /**
     * Operation getArchitectDependencytrackingTypesWithHttpInfo
     *
     * Get Dependency Tracking types.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return Array of \PureCloudSDK\DependencyTypeEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingTypesWithHttpInfo($pageNumber = null, $pageSize = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking/types";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DependencyTypeEntityListing',
                '/api/v2/architect/dependencytracking/types'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DependencyTypeEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DependencyTypeEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectDependencytrackingUpdatedresourceconsumers
     *
     * Get Dependency Tracking objects that depend on updated resources
     *
     * @param string $name Name to search for (optional)
     * @param string[] $objectType Object type(s) to search for (optional)
     * @param bool $consumedResources Return consumed resources? (optional, default to false)
     * @param string[] $consumedResourceType Resource type(s) to return (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return \PureCloudSDK\DependencyObjectEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingUpdatedresourceconsumers($name = null, $objectType = null, $consumedResources = null, $consumedResourceType = null, $pageNumber = null, $pageSize = null)
    {
        list($response) = $this->getArchitectDependencytrackingUpdatedresourceconsumersWithHttpInfo($name, $objectType, $consumedResources, $consumedResourceType, $pageNumber, $pageSize);
        return $response;
    }

    /**
     * Operation getArchitectDependencytrackingUpdatedresourceconsumersWithHttpInfo
     *
     * Get Dependency Tracking objects that depend on updated resources
     *
     * @param string $name Name to search for (optional)
     * @param string[] $objectType Object type(s) to search for (optional)
     * @param bool $consumedResources Return consumed resources? (optional, default to false)
     * @param string[] $consumedResourceType Resource type(s) to return (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return Array of \PureCloudSDK\DependencyObjectEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectDependencytrackingUpdatedresourceconsumersWithHttpInfo($name = null, $objectType = null, $consumedResources = null, $consumedResourceType = null, $pageNumber = null, $pageSize = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking/updatedresourceconsumers";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if (is_array($objectType)) {
            $objectType = $this->apiClient->getSerializer()->serializeCollection($objectType, 'multi', true);
        }
        if ($objectType !== null) {
            $queryParams['objectType'] = $this->apiClient->getSerializer()->toQueryValue($objectType);
        }
        // query params
        if ($consumedResources !== null) {
            $queryParams['consumedResources'] = $this->apiClient->getSerializer()->toQueryValue($consumedResources);
        }
        // query params
        if (is_array($consumedResourceType)) {
            $consumedResourceType = $this->apiClient->getSerializer()->serializeCollection($consumedResourceType, 'multi', true);
        }
        if ($consumedResourceType !== null) {
            $queryParams['consumedResourceType'] = $this->apiClient->getSerializer()->toQueryValue($consumedResourceType);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DependencyObjectEntityListing',
                '/api/v2/architect/dependencytracking/updatedresourceconsumers'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DependencyObjectEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DependencyObjectEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectEmergencygroup
     *
     * Gets a emergency group by ID
     *
     * @param string $emergencyGroupId Emergency group ID (required)
     * @return \PureCloudSDK\EmergencyGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectEmergencygroup($emergencyGroupId)
    {
        list($response) = $this->getArchitectEmergencygroupWithHttpInfo($emergencyGroupId);
        return $response;
    }

    /**
     * Operation getArchitectEmergencygroupWithHttpInfo
     *
     * Gets a emergency group by ID
     *
     * @param string $emergencyGroupId Emergency group ID (required)
     * @return Array of \PureCloudSDK\EmergencyGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectEmergencygroupWithHttpInfo($emergencyGroupId)
    {
        // verify the required parameter 'emergencyGroupId' is set
        if ($emergencyGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emergencyGroupId when calling getArchitectEmergencygroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/emergencygroups/{emergencyGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emergencyGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "emergencyGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emergencyGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmergencyGroup',
                '/api/v2/architect/emergencygroups/{emergencyGroupId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmergencyGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmergencyGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectEmergencygroups
     *
     * Get a list of emergency groups.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $sortOrder Sort order (optional, default to ASC)
     * @param string $name Name of the Emergency Group to filter by. (optional)
     * @return \PureCloudSDK\EmergencyGroupListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectEmergencygroups($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null)
    {
        list($response) = $this->getArchitectEmergencygroupsWithHttpInfo($pageNumber, $pageSize, $sortBy, $sortOrder, $name);
        return $response;
    }

    /**
     * Operation getArchitectEmergencygroupsWithHttpInfo
     *
     * Get a list of emergency groups.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $sortOrder Sort order (optional, default to ASC)
     * @param string $name Name of the Emergency Group to filter by. (optional)
     * @return Array of \PureCloudSDK\EmergencyGroupListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectEmergencygroupsWithHttpInfo($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/emergencygroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmergencyGroupListing',
                '/api/v2/architect/emergencygroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmergencyGroupListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmergencyGroupListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectIvr
     *
     * Get an IVR config.
     *
     * @param string $ivrId IVR id (required)
     * @return \PureCloudSDK\IVR
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectIvr($ivrId)
    {
        list($response) = $this->getArchitectIvrWithHttpInfo($ivrId);
        return $response;
    }

    /**
     * Operation getArchitectIvrWithHttpInfo
     *
     * Get an IVR config.
     *
     * @param string $ivrId IVR id (required)
     * @return Array of \PureCloudSDK\IVR, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectIvrWithHttpInfo($ivrId)
    {
        // verify the required parameter 'ivrId' is set
        if ($ivrId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ivrId when calling getArchitectIvr');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/ivrs/{ivrId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($ivrId !== null) {
            $resourcePath = str_replace(
                "{" . "ivrId" . "}",
                $this->apiClient->getSerializer()->toPathValue($ivrId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\IVR',
                '/api/v2/architect/ivrs/{ivrId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\IVR', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\IVR', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectIvrs
     *
     * Get IVR configs.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $sortOrder Sort order (optional, default to ASC)
     * @param string $name Name of the IVR to filter by. (optional)
     * @return \PureCloudSDK\IVREntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectIvrs($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null)
    {
        list($response) = $this->getArchitectIvrsWithHttpInfo($pageNumber, $pageSize, $sortBy, $sortOrder, $name);
        return $response;
    }

    /**
     * Operation getArchitectIvrsWithHttpInfo
     *
     * Get IVR configs.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $sortOrder Sort order (optional, default to ASC)
     * @param string $name Name of the IVR to filter by. (optional)
     * @return Array of \PureCloudSDK\IVREntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectIvrsWithHttpInfo($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/ivrs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\IVREntityListing',
                '/api/v2/architect/ivrs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\IVREntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\IVREntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectPrompt
     *
     * Get specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @return \PureCloudSDK\Prompt
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPrompt($promptId)
    {
        list($response) = $this->getArchitectPromptWithHttpInfo($promptId);
        return $response;
    }

    /**
     * Operation getArchitectPromptWithHttpInfo
     *
     * Get specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @return Array of \PureCloudSDK\Prompt, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptWithHttpInfo($promptId)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectPrompt');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Prompt',
                '/api/v2/architect/prompts/{promptId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Prompt', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Prompt', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectPromptHistoryHistoryId
     *
     * Get generated prompt history
     *
     * @param string $promptId Prompt ID (required)
     * @param string $historyId History request ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortOrder Sort order (optional, default to desc)
     * @param string $sortBy Sort by (optional, default to timestamp)
     * @param string[] $action Flow actions to include (omit to include all) (optional)
     * @return \PureCloudSDK\HistoryListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptHistoryHistoryId($promptId, $historyId, $pageNumber = null, $pageSize = null, $sortOrder = null, $sortBy = null, $action = null)
    {
        list($response) = $this->getArchitectPromptHistoryHistoryIdWithHttpInfo($promptId, $historyId, $pageNumber, $pageSize, $sortOrder, $sortBy, $action);
        return $response;
    }

    /**
     * Operation getArchitectPromptHistoryHistoryIdWithHttpInfo
     *
     * Get generated prompt history
     *
     * @param string $promptId Prompt ID (required)
     * @param string $historyId History request ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortOrder Sort order (optional, default to desc)
     * @param string $sortBy Sort by (optional, default to timestamp)
     * @param string[] $action Flow actions to include (omit to include all) (optional)
     * @return Array of \PureCloudSDK\HistoryListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptHistoryHistoryIdWithHttpInfo($promptId, $historyId, $pageNumber = null, $pageSize = null, $sortOrder = null, $sortBy = null, $action = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectPromptHistoryHistoryId');
        }
        // verify the required parameter 'historyId' is set
        if ($historyId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $historyId when calling getArchitectPromptHistoryHistoryId');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/history/{historyId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if (is_array($action)) {
            $action = $this->apiClient->getSerializer()->serializeCollection($action, 'multi', true);
        }
        if ($action !== null) {
            $queryParams['action'] = $this->apiClient->getSerializer()->toQueryValue($action);
        }
        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($historyId !== null) {
            $resourcePath = str_replace(
                "{" . "historyId" . "}",
                $this->apiClient->getSerializer()->toPathValue($historyId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\HistoryListing',
                '/api/v2/architect/prompts/{promptId}/history/{historyId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\HistoryListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\HistoryListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectPromptResource
     *
     * Get specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return \PureCloudSDK\PromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptResource($promptId, $languageCode)
    {
        list($response) = $this->getArchitectPromptResourceWithHttpInfo($promptId, $languageCode);
        return $response;
    }

    /**
     * Operation getArchitectPromptResourceWithHttpInfo
     *
     * Get specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return Array of \PureCloudSDK\PromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptResourceWithHttpInfo($promptId, $languageCode)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectPromptResource');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getArchitectPromptResource');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptAsset',
                '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectPromptResources
     *
     * Get a pageable list of user prompt resources
     *
     * @param string $promptId Prompt ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return \PureCloudSDK\PromptAssetEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptResources($promptId, $pageNumber = null, $pageSize = null)
    {
        list($response) = $this->getArchitectPromptResourcesWithHttpInfo($promptId, $pageNumber, $pageSize);
        return $response;
    }

    /**
     * Operation getArchitectPromptResourcesWithHttpInfo
     *
     * Get a pageable list of user prompt resources
     *
     * @param string $promptId Prompt ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return Array of \PureCloudSDK\PromptAssetEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptResourcesWithHttpInfo($promptId, $pageNumber = null, $pageSize = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectPromptResources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptAssetEntityListing',
                '/api/v2/architect/prompts/{promptId}/resources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptAssetEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptAssetEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectPrompts
     *
     * Get a pageable list of user prompts
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string[] $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @return \PureCloudSDK\PromptEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPrompts($pageNumber = null, $pageSize = null, $name = null, $description = null, $nameOrDescription = null, $sortBy = null, $sortOrder = null)
    {
        list($response) = $this->getArchitectPromptsWithHttpInfo($pageNumber, $pageSize, $name, $description, $nameOrDescription, $sortBy, $sortOrder);
        return $response;
    }

    /**
     * Operation getArchitectPromptsWithHttpInfo
     *
     * Get a pageable list of user prompts
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string[] $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @return Array of \PureCloudSDK\PromptEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptsWithHttpInfo($pageNumber = null, $pageSize = null, $name = null, $description = null, $nameOrDescription = null, $sortBy = null, $sortOrder = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if (is_array($name)) {
            $name = $this->apiClient->getSerializer()->serializeCollection($name, 'multi', true);
        }
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($description !== null) {
            $queryParams['description'] = $this->apiClient->getSerializer()->toQueryValue($description);
        }
        // query params
        if ($nameOrDescription !== null) {
            $queryParams['nameOrDescription'] = $this->apiClient->getSerializer()->toQueryValue($nameOrDescription);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptEntityListing',
                '/api/v2/architect/prompts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSchedule
     *
     * Get a schedule by ID
     *
     * @param string $scheduleId Schedule ID (required)
     * @return \PureCloudSDK\Schedule
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSchedule($scheduleId)
    {
        list($response) = $this->getArchitectScheduleWithHttpInfo($scheduleId);
        return $response;
    }

    /**
     * Operation getArchitectScheduleWithHttpInfo
     *
     * Get a schedule by ID
     *
     * @param string $scheduleId Schedule ID (required)
     * @return Array of \PureCloudSDK\Schedule, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectScheduleWithHttpInfo($scheduleId)
    {
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling getArchitectSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Schedule',
                '/api/v2/architect/schedules/{scheduleId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Schedule', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Schedule', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSchedulegroup
     *
     * Gets a schedule group by ID
     *
     * @param string $scheduleGroupId Schedule group ID (required)
     * @return \PureCloudSDK\ScheduleGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSchedulegroup($scheduleGroupId)
    {
        list($response) = $this->getArchitectSchedulegroupWithHttpInfo($scheduleGroupId);
        return $response;
    }

    /**
     * Operation getArchitectSchedulegroupWithHttpInfo
     *
     * Gets a schedule group by ID
     *
     * @param string $scheduleGroupId Schedule group ID (required)
     * @return Array of \PureCloudSDK\ScheduleGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSchedulegroupWithHttpInfo($scheduleGroupId)
    {
        // verify the required parameter 'scheduleGroupId' is set
        if ($scheduleGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleGroupId when calling getArchitectSchedulegroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/schedulegroups/{scheduleGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($scheduleGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ScheduleGroup',
                '/api/v2/architect/schedulegroups/{scheduleGroupId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ScheduleGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ScheduleGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSchedulegroups
     *
     * Get a list of schedule groups.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $sortOrder Sort order (optional, default to ASC)
     * @param string $name Name of the Schedule Group to filter by. (optional)
     * @param string $scheduleIds A comma-delimited list of Schedule IDs to filter by. (optional)
     * @return \PureCloudSDK\ScheduleGroupEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSchedulegroups($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null, $scheduleIds = null)
    {
        list($response) = $this->getArchitectSchedulegroupsWithHttpInfo($pageNumber, $pageSize, $sortBy, $sortOrder, $name, $scheduleIds);
        return $response;
    }

    /**
     * Operation getArchitectSchedulegroupsWithHttpInfo
     *
     * Get a list of schedule groups.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $sortOrder Sort order (optional, default to ASC)
     * @param string $name Name of the Schedule Group to filter by. (optional)
     * @param string $scheduleIds A comma-delimited list of Schedule IDs to filter by. (optional)
     * @return Array of \PureCloudSDK\ScheduleGroupEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSchedulegroupsWithHttpInfo($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null, $scheduleIds = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/schedulegroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($scheduleIds !== null) {
            $queryParams['scheduleIds'] = $this->apiClient->getSerializer()->toQueryValue($scheduleIds);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ScheduleGroupEntityListing',
                '/api/v2/architect/schedulegroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ScheduleGroupEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ScheduleGroupEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSchedules
     *
     * Get a list of schedules.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $sortOrder Sort order (optional, default to ASC)
     * @param string $name Name of the Schedule to filter by. (optional)
     * @return \PureCloudSDK\ScheduleEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSchedules($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null)
    {
        list($response) = $this->getArchitectSchedulesWithHttpInfo($pageNumber, $pageSize, $sortBy, $sortOrder, $name);
        return $response;
    }

    /**
     * Operation getArchitectSchedulesWithHttpInfo
     *
     * Get a list of schedules.
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $sortOrder Sort order (optional, default to ASC)
     * @param string $name Name of the Schedule to filter by. (optional)
     * @return Array of \PureCloudSDK\ScheduleEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSchedulesWithHttpInfo($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ScheduleEntityListing',
                '/api/v2/architect/schedules'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ScheduleEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ScheduleEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSystemprompt
     *
     * Get a system prompt
     *
     * @param string $promptId promptId (required)
     * @return \PureCloudSDK\SystemPrompt
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystemprompt($promptId)
    {
        list($response) = $this->getArchitectSystempromptWithHttpInfo($promptId);
        return $response;
    }

    /**
     * Operation getArchitectSystempromptWithHttpInfo
     *
     * Get a system prompt
     *
     * @param string $promptId promptId (required)
     * @return Array of \PureCloudSDK\SystemPrompt, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptWithHttpInfo($promptId)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectSystemprompt');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPrompt',
                '/api/v2/architect/systemprompts/{promptId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPrompt', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPrompt', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSystempromptHistoryHistoryId
     *
     * Get generated prompt history
     *
     * @param string $promptId promptId (required)
     * @param string $historyId History request ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortOrder Sort order (optional, default to desc)
     * @param string $sortBy Sort by (optional, default to timestamp)
     * @param string[] $action Flow actions to include (omit to include all) (optional)
     * @return \PureCloudSDK\HistoryListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptHistoryHistoryId($promptId, $historyId, $pageNumber = null, $pageSize = null, $sortOrder = null, $sortBy = null, $action = null)
    {
        list($response) = $this->getArchitectSystempromptHistoryHistoryIdWithHttpInfo($promptId, $historyId, $pageNumber, $pageSize, $sortOrder, $sortBy, $action);
        return $response;
    }

    /**
     * Operation getArchitectSystempromptHistoryHistoryIdWithHttpInfo
     *
     * Get generated prompt history
     *
     * @param string $promptId promptId (required)
     * @param string $historyId History request ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortOrder Sort order (optional, default to desc)
     * @param string $sortBy Sort by (optional, default to timestamp)
     * @param string[] $action Flow actions to include (omit to include all) (optional)
     * @return Array of \PureCloudSDK\HistoryListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptHistoryHistoryIdWithHttpInfo($promptId, $historyId, $pageNumber = null, $pageSize = null, $sortOrder = null, $sortBy = null, $action = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectSystempromptHistoryHistoryId');
        }
        // verify the required parameter 'historyId' is set
        if ($historyId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $historyId when calling getArchitectSystempromptHistoryHistoryId');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/history/{historyId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if (is_array($action)) {
            $action = $this->apiClient->getSerializer()->serializeCollection($action, 'multi', true);
        }
        if ($action !== null) {
            $queryParams['action'] = $this->apiClient->getSerializer()->toQueryValue($action);
        }
        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($historyId !== null) {
            $resourcePath = str_replace(
                "{" . "historyId" . "}",
                $this->apiClient->getSerializer()->toPathValue($historyId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\HistoryListing',
                '/api/v2/architect/systemprompts/{promptId}/history/{historyId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\HistoryListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\HistoryListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSystempromptResource
     *
     * Get a system prompt resource.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return \PureCloudSDK\SystemPromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptResource($promptId, $languageCode)
    {
        list($response) = $this->getArchitectSystempromptResourceWithHttpInfo($promptId, $languageCode);
        return $response;
    }

    /**
     * Operation getArchitectSystempromptResourceWithHttpInfo
     *
     * Get a system prompt resource.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return Array of \PureCloudSDK\SystemPromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptResourceWithHttpInfo($promptId, $languageCode)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectSystempromptResource');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getArchitectSystempromptResource');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptAsset',
                '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSystempromptResources
     *
     * Get system prompt resources.
     *
     * @param string $promptId Prompt ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @return \PureCloudSDK\SystemPromptAssetEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptResources($promptId, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null)
    {
        list($response) = $this->getArchitectSystempromptResourcesWithHttpInfo($promptId, $pageNumber, $pageSize, $sortBy, $sortOrder);
        return $response;
    }

    /**
     * Operation getArchitectSystempromptResourcesWithHttpInfo
     *
     * Get system prompt resources.
     *
     * @param string $promptId Prompt ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @return Array of \PureCloudSDK\SystemPromptAssetEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptResourcesWithHttpInfo($promptId, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectSystempromptResources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptAssetEntityListing',
                '/api/v2/architect/systemprompts/{promptId}/resources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptAssetEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptAssetEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSystemprompts
     *
     * Get System Prompts
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return \PureCloudSDK\SystemPromptEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystemprompts($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null, $description = null, $nameOrDescription = null)
    {
        list($response) = $this->getArchitectSystempromptsWithHttpInfo($pageNumber, $pageSize, $sortBy, $sortOrder, $name, $description, $nameOrDescription);
        return $response;
    }

    /**
     * Operation getArchitectSystempromptsWithHttpInfo
     *
     * Get System Prompts
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return Array of \PureCloudSDK\SystemPromptEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptsWithHttpInfo($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null, $description = null, $nameOrDescription = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($description !== null) {
            $queryParams['description'] = $this->apiClient->getSerializer()->toQueryValue($description);
        }
        // query params
        if ($nameOrDescription !== null) {
            $queryParams['nameOrDescription'] = $this->apiClient->getSerializer()->toQueryValue($nameOrDescription);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptEntityListing',
                '/api/v2/architect/systemprompts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlow
     *
     * Get flow
     *
     * @param string $flowId Flow ID (required)
     * @param bool $deleted Include deleted flows (optional, default to false)
     * @return \PureCloudSDK\Flow
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlow($flowId, $deleted = null)
    {
        list($response) = $this->getFlowWithHttpInfo($flowId, $deleted);
        return $response;
    }

    /**
     * Operation getFlowWithHttpInfo
     *
     * Get flow
     *
     * @param string $flowId Flow ID (required)
     * @param bool $deleted Include deleted flows (optional, default to false)
     * @return Array of \PureCloudSDK\Flow, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowWithHttpInfo($flowId, $deleted = null)
    {
        // verify the required parameter 'flowId' is set
        if ($flowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowId when calling getFlow');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/{flowId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = $this->apiClient->getSerializer()->toQueryValue($deleted);
        }
        // path params
        if ($flowId !== null) {
            $resourcePath = str_replace(
                "{" . "flowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Flow',
                '/api/v2/flows/{flowId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Flow', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Flow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowHistoryHistoryId
     *
     * Get generated flow history
     *
     * @param string $flowId Flow ID (required)
     * @param string $historyId History request ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortOrder Sort order (optional, default to desc)
     * @param string $sortBy Sort by (optional, default to timestamp)
     * @param string[] $action Flow actions to include (omit to include all) (optional)
     * @return \PureCloudSDK\HistoryListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowHistoryHistoryId($flowId, $historyId, $pageNumber = null, $pageSize = null, $sortOrder = null, $sortBy = null, $action = null)
    {
        list($response) = $this->getFlowHistoryHistoryIdWithHttpInfo($flowId, $historyId, $pageNumber, $pageSize, $sortOrder, $sortBy, $action);
        return $response;
    }

    /**
     * Operation getFlowHistoryHistoryIdWithHttpInfo
     *
     * Get generated flow history
     *
     * @param string $flowId Flow ID (required)
     * @param string $historyId History request ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortOrder Sort order (optional, default to desc)
     * @param string $sortBy Sort by (optional, default to timestamp)
     * @param string[] $action Flow actions to include (omit to include all) (optional)
     * @return Array of \PureCloudSDK\HistoryListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowHistoryHistoryIdWithHttpInfo($flowId, $historyId, $pageNumber = null, $pageSize = null, $sortOrder = null, $sortBy = null, $action = null)
    {
        // verify the required parameter 'flowId' is set
        if ($flowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowId when calling getFlowHistoryHistoryId');
        }
        // verify the required parameter 'historyId' is set
        if ($historyId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $historyId when calling getFlowHistoryHistoryId');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/{flowId}/history/{historyId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if (is_array($action)) {
            $action = $this->apiClient->getSerializer()->serializeCollection($action, 'multi', true);
        }
        if ($action !== null) {
            $queryParams['action'] = $this->apiClient->getSerializer()->toQueryValue($action);
        }
        // path params
        if ($flowId !== null) {
            $resourcePath = str_replace(
                "{" . "flowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowId),
                $resourcePath
            );
        }
        // path params
        if ($historyId !== null) {
            $resourcePath = str_replace(
                "{" . "historyId" . "}",
                $this->apiClient->getSerializer()->toPathValue($historyId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\HistoryListing',
                '/api/v2/flows/{flowId}/history/{historyId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\HistoryListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\HistoryListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowLatestconfiguration
     *
     * Get the latest configuration for flow
     *
     * @param string $flowId Flow ID (required)
     * @param bool $deleted Include deleted flows (optional, default to false)
     * @return object
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowLatestconfiguration($flowId, $deleted = null)
    {
        list($response) = $this->getFlowLatestconfigurationWithHttpInfo($flowId, $deleted);
        return $response;
    }

    /**
     * Operation getFlowLatestconfigurationWithHttpInfo
     *
     * Get the latest configuration for flow
     *
     * @param string $flowId Flow ID (required)
     * @param bool $deleted Include deleted flows (optional, default to false)
     * @return Array of object, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowLatestconfigurationWithHttpInfo($flowId, $deleted = null)
    {
        // verify the required parameter 'flowId' is set
        if ($flowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowId when calling getFlowLatestconfiguration');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/{flowId}/latestconfiguration";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = $this->apiClient->getSerializer()->toQueryValue($deleted);
        }
        // path params
        if ($flowId !== null) {
            $resourcePath = str_replace(
                "{" . "flowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                'object',
                '/api/v2/flows/{flowId}/latestconfiguration'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'object', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowVersion
     *
     * Get flow version
     *
     * @param string $flowId Flow ID (required)
     * @param string $versionId Version ID (required)
     * @param string $deleted Include deleted flows (optional)
     * @return \PureCloudSDK\FlowVersion
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowVersion($flowId, $versionId, $deleted = null)
    {
        list($response) = $this->getFlowVersionWithHttpInfo($flowId, $versionId, $deleted);
        return $response;
    }

    /**
     * Operation getFlowVersionWithHttpInfo
     *
     * Get flow version
     *
     * @param string $flowId Flow ID (required)
     * @param string $versionId Version ID (required)
     * @param string $deleted Include deleted flows (optional)
     * @return Array of \PureCloudSDK\FlowVersion, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowVersionWithHttpInfo($flowId, $versionId, $deleted = null)
    {
        // verify the required parameter 'flowId' is set
        if ($flowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowId when calling getFlowVersion');
        }
        // verify the required parameter 'versionId' is set
        if ($versionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $versionId when calling getFlowVersion');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/{flowId}/versions/{versionId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = $this->apiClient->getSerializer()->toQueryValue($deleted);
        }
        // path params
        if ($flowId !== null) {
            $resourcePath = str_replace(
                "{" . "flowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowId),
                $resourcePath
            );
        }
        // path params
        if ($versionId !== null) {
            $resourcePath = str_replace(
                "{" . "versionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($versionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowVersion',
                '/api/v2/flows/{flowId}/versions/{versionId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowVersion', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowVersion', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowVersionConfiguration
     *
     * Create flow version configuration
     *
     * @param string $flowId Flow ID (required)
     * @param string $versionId Version ID (required)
     * @param string $deleted Include deleted flows (optional)
     * @return object
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowVersionConfiguration($flowId, $versionId, $deleted = null)
    {
        list($response) = $this->getFlowVersionConfigurationWithHttpInfo($flowId, $versionId, $deleted);
        return $response;
    }

    /**
     * Operation getFlowVersionConfigurationWithHttpInfo
     *
     * Create flow version configuration
     *
     * @param string $flowId Flow ID (required)
     * @param string $versionId Version ID (required)
     * @param string $deleted Include deleted flows (optional)
     * @return Array of object, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowVersionConfigurationWithHttpInfo($flowId, $versionId, $deleted = null)
    {
        // verify the required parameter 'flowId' is set
        if ($flowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowId when calling getFlowVersionConfiguration');
        }
        // verify the required parameter 'versionId' is set
        if ($versionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $versionId when calling getFlowVersionConfiguration');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/{flowId}/versions/{versionId}/configuration";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = $this->apiClient->getSerializer()->toQueryValue($deleted);
        }
        // path params
        if ($flowId !== null) {
            $resourcePath = str_replace(
                "{" . "flowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowId),
                $resourcePath
            );
        }
        // path params
        if ($versionId !== null) {
            $resourcePath = str_replace(
                "{" . "versionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($versionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                'object',
                '/api/v2/flows/{flowId}/versions/{versionId}/configuration'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'object', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowVersions
     *
     * Get flow version list
     *
     * @param string $flowId Flow ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param bool $deleted Include deleted flows (optional)
     * @return \PureCloudSDK\FlowVersionEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowVersions($flowId, $pageNumber = null, $pageSize = null, $deleted = null)
    {
        list($response) = $this->getFlowVersionsWithHttpInfo($flowId, $pageNumber, $pageSize, $deleted);
        return $response;
    }

    /**
     * Operation getFlowVersionsWithHttpInfo
     *
     * Get flow version list
     *
     * @param string $flowId Flow ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param bool $deleted Include deleted flows (optional)
     * @return Array of \PureCloudSDK\FlowVersionEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowVersionsWithHttpInfo($flowId, $pageNumber = null, $pageSize = null, $deleted = null)
    {
        // verify the required parameter 'flowId' is set
        if ($flowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowId when calling getFlowVersions');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/{flowId}/versions";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = $this->apiClient->getSerializer()->toQueryValue($deleted);
        }
        // path params
        if ($flowId !== null) {
            $resourcePath = str_replace(
                "{" . "flowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowVersionEntityListing',
                '/api/v2/flows/{flowId}/versions'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowVersionEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowVersionEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlows
     *
     * Get a pageable list of flows, filtered by query parameters
     *
     * @param string[] $type Type (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @param string $publishVersionId Publish version ID (optional)
     * @param string $editableBy Editable by (optional)
     * @param string $lockedBy Locked by (optional)
     * @param string $lockedByClientId Locked by client ID (optional)
     * @param string $secure Secure (optional)
     * @param bool $deleted Include deleted (optional, default to false)
     * @param bool $includeSchemas Include variable schemas (optional, default to false)
     * @param string $publishedAfter Published after (optional)
     * @param string $publishedBefore Published before (optional)
     * @param string[] $divisionId division ID(s) (optional)
     * @return \PureCloudSDK\FlowEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlows($type = null, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $description = null, $nameOrDescription = null, $publishVersionId = null, $editableBy = null, $lockedBy = null, $lockedByClientId = null, $secure = null, $deleted = null, $includeSchemas = null, $publishedAfter = null, $publishedBefore = null, $divisionId = null)
    {
        list($response) = $this->getFlowsWithHttpInfo($type, $pageNumber, $pageSize, $sortBy, $sortOrder, $id, $name, $description, $nameOrDescription, $publishVersionId, $editableBy, $lockedBy, $lockedByClientId, $secure, $deleted, $includeSchemas, $publishedAfter, $publishedBefore, $divisionId);
        return $response;
    }

    /**
     * Operation getFlowsWithHttpInfo
     *
     * Get a pageable list of flows, filtered by query parameters
     *
     * @param string[] $type Type (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @param string $publishVersionId Publish version ID (optional)
     * @param string $editableBy Editable by (optional)
     * @param string $lockedBy Locked by (optional)
     * @param string $lockedByClientId Locked by client ID (optional)
     * @param string $secure Secure (optional)
     * @param bool $deleted Include deleted (optional, default to false)
     * @param bool $includeSchemas Include variable schemas (optional, default to false)
     * @param string $publishedAfter Published after (optional)
     * @param string $publishedBefore Published before (optional)
     * @param string[] $divisionId division ID(s) (optional)
     * @return Array of \PureCloudSDK\FlowEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsWithHttpInfo($type = null, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $description = null, $nameOrDescription = null, $publishVersionId = null, $editableBy = null, $lockedBy = null, $lockedByClientId = null, $secure = null, $deleted = null, $includeSchemas = null, $publishedAfter = null, $publishedBefore = null, $divisionId = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/flows";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($type)) {
            $type = $this->apiClient->getSerializer()->serializeCollection($type, 'multi', true);
        }
        if ($type !== null) {
            $queryParams['type'] = $this->apiClient->getSerializer()->toQueryValue($type);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if (is_array($id)) {
            $id = $this->apiClient->getSerializer()->serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($description !== null) {
            $queryParams['description'] = $this->apiClient->getSerializer()->toQueryValue($description);
        }
        // query params
        if ($nameOrDescription !== null) {
            $queryParams['nameOrDescription'] = $this->apiClient->getSerializer()->toQueryValue($nameOrDescription);
        }
        // query params
        if ($publishVersionId !== null) {
            $queryParams['publishVersionId'] = $this->apiClient->getSerializer()->toQueryValue($publishVersionId);
        }
        // query params
        if ($editableBy !== null) {
            $queryParams['editableBy'] = $this->apiClient->getSerializer()->toQueryValue($editableBy);
        }
        // query params
        if ($lockedBy !== null) {
            $queryParams['lockedBy'] = $this->apiClient->getSerializer()->toQueryValue($lockedBy);
        }
        // query params
        if ($lockedByClientId !== null) {
            $queryParams['lockedByClientId'] = $this->apiClient->getSerializer()->toQueryValue($lockedByClientId);
        }
        // query params
        if ($secure !== null) {
            $queryParams['secure'] = $this->apiClient->getSerializer()->toQueryValue($secure);
        }
        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = $this->apiClient->getSerializer()->toQueryValue($deleted);
        }
        // query params
        if ($includeSchemas !== null) {
            $queryParams['includeSchemas'] = $this->apiClient->getSerializer()->toQueryValue($includeSchemas);
        }
        // query params
        if ($publishedAfter !== null) {
            $queryParams['publishedAfter'] = $this->apiClient->getSerializer()->toQueryValue($publishedAfter);
        }
        // query params
        if ($publishedBefore !== null) {
            $queryParams['publishedBefore'] = $this->apiClient->getSerializer()->toQueryValue($publishedBefore);
        }
        // query params
        if (is_array($divisionId)) {
            $divisionId = $this->apiClient->getSerializer()->serializeCollection($divisionId, 'multi', true);
        }
        if ($divisionId !== null) {
            $queryParams['divisionId'] = $this->apiClient->getSerializer()->toQueryValue($divisionId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowEntityListing',
                '/api/v2/flows'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsDatatable
     *
     * Returns a specific datatable by id
     *
     * @param string $datatableId id of datatable (required)
     * @param string $expand Expand instructions for the result (optional)
     * @return \PureCloudSDK\DataTable
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatable($datatableId, $expand = null)
    {
        list($response) = $this->getFlowsDatatableWithHttpInfo($datatableId, $expand);
        return $response;
    }

    /**
     * Operation getFlowsDatatableWithHttpInfo
     *
     * Returns a specific datatable by id
     *
     * @param string $datatableId id of datatable (required)
     * @param string $expand Expand instructions for the result (optional)
     * @return Array of \PureCloudSDK\DataTable, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableWithHttpInfo($datatableId, $expand = null)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling getFlowsDatatable');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DataTable',
                '/api/v2/flows/datatables/{datatableId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DataTable', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTable', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsDatatableExportJob
     *
     * Returns the state information about an export job
     *
     * @param string $datatableId id of datatable (required)
     * @param string $exportJobId id of export job (required)
     * @return \PureCloudSDK\DataTableExportJob
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableExportJob($datatableId, $exportJobId)
    {
        list($response) = $this->getFlowsDatatableExportJobWithHttpInfo($datatableId, $exportJobId);
        return $response;
    }

    /**
     * Operation getFlowsDatatableExportJobWithHttpInfo
     *
     * Returns the state information about an export job
     *
     * @param string $datatableId id of datatable (required)
     * @param string $exportJobId id of export job (required)
     * @return Array of \PureCloudSDK\DataTableExportJob, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableExportJobWithHttpInfo($datatableId, $exportJobId)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling getFlowsDatatableExportJob');
        }
        // verify the required parameter 'exportJobId' is set
        if ($exportJobId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $exportJobId when calling getFlowsDatatableExportJob');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/export/jobs/{exportJobId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // path params
        if ($exportJobId !== null) {
            $resourcePath = str_replace(
                "{" . "exportJobId" . "}",
                $this->apiClient->getSerializer()->toPathValue($exportJobId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DataTableExportJob',
                '/api/v2/flows/datatables/{datatableId}/export/jobs/{exportJobId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DataTableExportJob', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTableExportJob', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTableExportJob', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsDatatableImportJob
     *
     * Returns the state information about an import job
     *
     * @param string $datatableId id of datatable (required)
     * @param string $importJobId id of import job (required)
     * @return \PureCloudSDK\DataTableImportJob
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableImportJob($datatableId, $importJobId)
    {
        list($response) = $this->getFlowsDatatableImportJobWithHttpInfo($datatableId, $importJobId);
        return $response;
    }

    /**
     * Operation getFlowsDatatableImportJobWithHttpInfo
     *
     * Returns the state information about an import job
     *
     * @param string $datatableId id of datatable (required)
     * @param string $importJobId id of import job (required)
     * @return Array of \PureCloudSDK\DataTableImportJob, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableImportJobWithHttpInfo($datatableId, $importJobId)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling getFlowsDatatableImportJob');
        }
        // verify the required parameter 'importJobId' is set
        if ($importJobId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $importJobId when calling getFlowsDatatableImportJob');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/import/jobs/{importJobId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // path params
        if ($importJobId !== null) {
            $resourcePath = str_replace(
                "{" . "importJobId" . "}",
                $this->apiClient->getSerializer()->toPathValue($importJobId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DataTableImportJob',
                '/api/v2/flows/datatables/{datatableId}/import/jobs/{importJobId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DataTableImportJob', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTableImportJob', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTableImportJob', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsDatatableImportJobs
     *
     * Get all recent import jobs
     *
     * @param string $datatableId id of datatable (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return \PureCloudSDK\EntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableImportJobs($datatableId, $pageNumber = null, $pageSize = null)
    {
        list($response) = $this->getFlowsDatatableImportJobsWithHttpInfo($datatableId, $pageNumber, $pageSize);
        return $response;
    }

    /**
     * Operation getFlowsDatatableImportJobsWithHttpInfo
     *
     * Get all recent import jobs
     *
     * @param string $datatableId id of datatable (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return Array of \PureCloudSDK\EntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableImportJobsWithHttpInfo($datatableId, $pageNumber = null, $pageSize = null)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling getFlowsDatatableImportJobs');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/import/jobs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EntityListing',
                '/api/v2/flows/datatables/{datatableId}/import/jobs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsDatatableRow
     *
     * Returns a specific row for the datatable
     *
     * @param string $datatableId id of datatable (required)
     * @param string $rowId The key for the row (required)
     * @param bool $showbrief if true returns just the key field for the row (optional, default to true)
     * @return map[string,object]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableRow($datatableId, $rowId, $showbrief = null)
    {
        list($response) = $this->getFlowsDatatableRowWithHttpInfo($datatableId, $rowId, $showbrief);
        return $response;
    }

    /**
     * Operation getFlowsDatatableRowWithHttpInfo
     *
     * Returns a specific row for the datatable
     *
     * @param string $datatableId id of datatable (required)
     * @param string $rowId The key for the row (required)
     * @param bool $showbrief if true returns just the key field for the row (optional, default to true)
     * @return Array of map[string,object], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableRowWithHttpInfo($datatableId, $rowId, $showbrief = null)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling getFlowsDatatableRow');
        }
        // verify the required parameter 'rowId' is set
        if ($rowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $rowId when calling getFlowsDatatableRow');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/rows/{rowId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($showbrief !== null) {
            $queryParams['showbrief'] = $this->apiClient->getSerializer()->toQueryValue($showbrief);
        }
        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // path params
        if ($rowId !== null) {
            $resourcePath = str_replace(
                "{" . "rowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($rowId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                'map[string,object]',
                '/api/v2/flows/datatables/{datatableId}/rows/{rowId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'map[string,object]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'map[string,object]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsDatatableRows
     *
     * Returns the rows for the datatable with the given id
     *
     * @param string $datatableId id of datatable (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param bool $showbrief If true returns just the key value of the row (optional, default to true)
     * @return \PureCloudSDK\DataTableRowEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableRows($datatableId, $pageNumber = null, $pageSize = null, $showbrief = null)
    {
        list($response) = $this->getFlowsDatatableRowsWithHttpInfo($datatableId, $pageNumber, $pageSize, $showbrief);
        return $response;
    }

    /**
     * Operation getFlowsDatatableRowsWithHttpInfo
     *
     * Returns the rows for the datatable with the given id
     *
     * @param string $datatableId id of datatable (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param bool $showbrief If true returns just the key value of the row (optional, default to true)
     * @return Array of \PureCloudSDK\DataTableRowEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatableRowsWithHttpInfo($datatableId, $pageNumber = null, $pageSize = null, $showbrief = null)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling getFlowsDatatableRows');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/rows";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($showbrief !== null) {
            $queryParams['showbrief'] = $this->apiClient->getSerializer()->toQueryValue($showbrief);
        }
        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DataTableRowEntityListing',
                '/api/v2/flows/datatables/{datatableId}/rows'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DataTableRowEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTableRowEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsDatatables
     *
     * Retrieve a list of datatables for the org
     *
     * @param string $expand Expand instructions for the result (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to ascending)
     * @return \PureCloudSDK\DataTablesDomainEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatables($expand = null, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null)
    {
        list($response) = $this->getFlowsDatatablesWithHttpInfo($expand, $pageNumber, $pageSize, $sortBy, $sortOrder);
        return $response;
    }

    /**
     * Operation getFlowsDatatablesWithHttpInfo
     *
     * Retrieve a list of datatables for the org
     *
     * @param string $expand Expand instructions for the result (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to ascending)
     * @return Array of \PureCloudSDK\DataTablesDomainEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDatatablesWithHttpInfo($expand = null, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DataTablesDomainEntityListing',
                '/api/v2/flows/datatables'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DataTablesDomainEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTablesDomainEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsDivisionviews
     *
     * Get a pageable list of basic flow information objects filterable by query parameters.
     *
     * @param string[] $type Type (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $publishVersionId Publish version ID (optional)
     * @param string $publishedAfter Published after (optional)
     * @param string $publishedBefore Published before (optional)
     * @param string[] $divisionId division ID(s) (optional)
     * @param bool $includeSchemas Include variable schemas (optional, default to false)
     * @return \PureCloudSDK\FlowDivisionViewEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDivisionviews($type = null, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $publishVersionId = null, $publishedAfter = null, $publishedBefore = null, $divisionId = null, $includeSchemas = null)
    {
        list($response) = $this->getFlowsDivisionviewsWithHttpInfo($type, $pageNumber, $pageSize, $sortBy, $sortOrder, $id, $name, $publishVersionId, $publishedAfter, $publishedBefore, $divisionId, $includeSchemas);
        return $response;
    }

    /**
     * Operation getFlowsDivisionviewsWithHttpInfo
     *
     * Get a pageable list of basic flow information objects filterable by query parameters.
     *
     * @param string[] $type Type (optional)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $publishVersionId Publish version ID (optional)
     * @param string $publishedAfter Published after (optional)
     * @param string $publishedBefore Published before (optional)
     * @param string[] $divisionId division ID(s) (optional)
     * @param bool $includeSchemas Include variable schemas (optional, default to false)
     * @return Array of \PureCloudSDK\FlowDivisionViewEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsDivisionviewsWithHttpInfo($type = null, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $publishVersionId = null, $publishedAfter = null, $publishedBefore = null, $divisionId = null, $includeSchemas = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/flows/divisionviews";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($type)) {
            $type = $this->apiClient->getSerializer()->serializeCollection($type, 'multi', true);
        }
        if ($type !== null) {
            $queryParams['type'] = $this->apiClient->getSerializer()->toQueryValue($type);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if (is_array($id)) {
            $id = $this->apiClient->getSerializer()->serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($publishVersionId !== null) {
            $queryParams['publishVersionId'] = $this->apiClient->getSerializer()->toQueryValue($publishVersionId);
        }
        // query params
        if ($publishedAfter !== null) {
            $queryParams['publishedAfter'] = $this->apiClient->getSerializer()->toQueryValue($publishedAfter);
        }
        // query params
        if ($publishedBefore !== null) {
            $queryParams['publishedBefore'] = $this->apiClient->getSerializer()->toQueryValue($publishedBefore);
        }
        // query params
        if (is_array($divisionId)) {
            $divisionId = $this->apiClient->getSerializer()->serializeCollection($divisionId, 'multi', true);
        }
        if ($divisionId !== null) {
            $queryParams['divisionId'] = $this->apiClient->getSerializer()->toQueryValue($divisionId);
        }
        // query params
        if ($includeSchemas !== null) {
            $queryParams['includeSchemas'] = $this->apiClient->getSerializer()->toQueryValue($includeSchemas);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowDivisionViewEntityListing',
                '/api/v2/flows/divisionviews'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowDivisionViewEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowDivisionViewEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 501:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsExecution
     *
     * Get a flow execution's details. Flow execution details are available for several days after the flow is started.
     *
     * @param string $flowExecutionId flow execution ID (required)
     * @return \PureCloudSDK\FlowRuntimeExecution
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsExecution($flowExecutionId)
    {
        list($response) = $this->getFlowsExecutionWithHttpInfo($flowExecutionId);
        return $response;
    }

    /**
     * Operation getFlowsExecutionWithHttpInfo
     *
     * Get a flow execution's details. Flow execution details are available for several days after the flow is started.
     *
     * @param string $flowExecutionId flow execution ID (required)
     * @return Array of \PureCloudSDK\FlowRuntimeExecution, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsExecutionWithHttpInfo($flowExecutionId)
    {
        // verify the required parameter 'flowExecutionId' is set
        if ($flowExecutionId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowExecutionId when calling getFlowsExecution');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/executions/{flowExecutionId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($flowExecutionId !== null) {
            $resourcePath = str_replace(
                "{" . "flowExecutionId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowExecutionId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowRuntimeExecution',
                '/api/v2/flows/executions/{flowExecutionId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowRuntimeExecution', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowRuntimeExecution', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsMilestone
     *
     * Get a flow milestone
     *
     * @param string $milestoneId flow milestone ID (required)
     * @return \PureCloudSDK\FlowMilestone
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsMilestone($milestoneId)
    {
        list($response) = $this->getFlowsMilestoneWithHttpInfo($milestoneId);
        return $response;
    }

    /**
     * Operation getFlowsMilestoneWithHttpInfo
     *
     * Get a flow milestone
     *
     * @param string $milestoneId flow milestone ID (required)
     * @return Array of \PureCloudSDK\FlowMilestone, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsMilestoneWithHttpInfo($milestoneId)
    {
        // verify the required parameter 'milestoneId' is set
        if ($milestoneId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $milestoneId when calling getFlowsMilestone');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/milestones/{milestoneId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($milestoneId !== null) {
            $resourcePath = str_replace(
                "{" . "milestoneId" . "}",
                $this->apiClient->getSerializer()->toPathValue($milestoneId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowMilestone',
                '/api/v2/flows/milestones/{milestoneId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowMilestone', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowMilestone', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsMilestones
     *
     * Get a pageable list of flow milestones, filtered by query parameters
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return \PureCloudSDK\FlowMilestoneListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsMilestones($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $description = null, $nameOrDescription = null)
    {
        list($response) = $this->getFlowsMilestonesWithHttpInfo($pageNumber, $pageSize, $sortBy, $sortOrder, $id, $name, $description, $nameOrDescription);
        return $response;
    }

    /**
     * Operation getFlowsMilestonesWithHttpInfo
     *
     * Get a pageable list of flow milestones, filtered by query parameters
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return Array of \PureCloudSDK\FlowMilestoneListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsMilestonesWithHttpInfo($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $description = null, $nameOrDescription = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/flows/milestones";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if (is_array($id)) {
            $id = $this->apiClient->getSerializer()->serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($description !== null) {
            $queryParams['description'] = $this->apiClient->getSerializer()->toQueryValue($description);
        }
        // query params
        if ($nameOrDescription !== null) {
            $queryParams['nameOrDescription'] = $this->apiClient->getSerializer()->toQueryValue($nameOrDescription);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowMilestoneListing',
                '/api/v2/flows/milestones'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowMilestoneListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowMilestoneListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsOutcome
     *
     * Get a flow outcome
     *
     * @param string $flowOutcomeId flow outcome ID (required)
     * @return \PureCloudSDK\FlowOutcome
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsOutcome($flowOutcomeId)
    {
        list($response) = $this->getFlowsOutcomeWithHttpInfo($flowOutcomeId);
        return $response;
    }

    /**
     * Operation getFlowsOutcomeWithHttpInfo
     *
     * Get a flow outcome
     *
     * @param string $flowOutcomeId flow outcome ID (required)
     * @return Array of \PureCloudSDK\FlowOutcome, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsOutcomeWithHttpInfo($flowOutcomeId)
    {
        // verify the required parameter 'flowOutcomeId' is set
        if ($flowOutcomeId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowOutcomeId when calling getFlowsOutcome');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/outcomes/{flowOutcomeId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($flowOutcomeId !== null) {
            $resourcePath = str_replace(
                "{" . "flowOutcomeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowOutcomeId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowOutcome',
                '/api/v2/flows/outcomes/{flowOutcomeId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowOutcome', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowOutcome', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlowsOutcomes
     *
     * Get a pageable list of flow outcomes, filtered by query parameters
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return \PureCloudSDK\FlowOutcomeListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsOutcomes($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $description = null, $nameOrDescription = null)
    {
        list($response) = $this->getFlowsOutcomesWithHttpInfo($pageNumber, $pageSize, $sortBy, $sortOrder, $id, $name, $description, $nameOrDescription);
        return $response;
    }

    /**
     * Operation getFlowsOutcomesWithHttpInfo
     *
     * Get a pageable list of flow outcomes, filtered by query parameters
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return Array of \PureCloudSDK\FlowOutcomeListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsOutcomesWithHttpInfo($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $description = null, $nameOrDescription = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/flows/outcomes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if (is_array($id)) {
            $id = $this->apiClient->getSerializer()->serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($description !== null) {
            $queryParams['description'] = $this->apiClient->getSerializer()->toQueryValue($description);
        }
        // query params
        if ($nameOrDescription !== null) {
            $queryParams['nameOrDescription'] = $this->apiClient->getSerializer()->toQueryValue($nameOrDescription);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowOutcomeListing',
                '/api/v2/flows/outcomes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowOutcomeListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowOutcomeListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectDependencytrackingBuild
     *
     * Rebuild Dependency Tracking data for an organization
     *
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectDependencytrackingBuild()
    {
        list($response) = $this->postArchitectDependencytrackingBuildWithHttpInfo();
        return $response;
    }

    /**
     * Operation postArchitectDependencytrackingBuildWithHttpInfo
     *
     * Rebuild Dependency Tracking data for an organization
     *
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectDependencytrackingBuildWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/dependencytracking/build";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/dependencytracking/build'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectEmergencygroups
     *
     * Creates a new emergency group
     *
     * @param \PureCloudSDK\EmergencyGroup $body  (required)
     * @return \PureCloudSDK\EmergencyGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectEmergencygroups($body)
    {
        list($response) = $this->postArchitectEmergencygroupsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postArchitectEmergencygroupsWithHttpInfo
     *
     * Creates a new emergency group
     *
     * @param \PureCloudSDK\EmergencyGroup $body  (required)
     * @return Array of \PureCloudSDK\EmergencyGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectEmergencygroupsWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postArchitectEmergencygroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/emergencygroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmergencyGroup',
                '/api/v2/architect/emergencygroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmergencyGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmergencyGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectIvrs
     *
     * Create IVR config.
     *
     * @param \PureCloudSDK\IVR $body  (required)
     * @return \PureCloudSDK\IVR
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectIvrs($body)
    {
        list($response) = $this->postArchitectIvrsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postArchitectIvrsWithHttpInfo
     *
     * Create IVR config.
     *
     * @param \PureCloudSDK\IVR $body  (required)
     * @return Array of \PureCloudSDK\IVR, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectIvrsWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postArchitectIvrs');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/ivrs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\IVR',
                '/api/v2/architect/ivrs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\IVR', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\IVR', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectPromptHistory
     *
     * Generate prompt history
     *
     * @param string $promptId Prompt ID (required)
     * @return \PureCloudSDK\Operation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPromptHistory($promptId)
    {
        list($response) = $this->postArchitectPromptHistoryWithHttpInfo($promptId);
        return $response;
    }

    /**
     * Operation postArchitectPromptHistoryWithHttpInfo
     *
     * Generate prompt history
     *
     * @param string $promptId Prompt ID (required)
     * @return Array of \PureCloudSDK\Operation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPromptHistoryWithHttpInfo($promptId)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling postArchitectPromptHistory');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/history";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Operation',
                '/api/v2/architect/prompts/{promptId}/history'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Operation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Operation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectPromptResources
     *
     * Create a new user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\PromptAssetCreate $body  (required)
     * @return \PureCloudSDK\PromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPromptResources($promptId, $body)
    {
        list($response) = $this->postArchitectPromptResourcesWithHttpInfo($promptId, $body);
        return $response;
    }

    /**
     * Operation postArchitectPromptResourcesWithHttpInfo
     *
     * Create a new user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\PromptAssetCreate $body  (required)
     * @return Array of \PureCloudSDK\PromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPromptResourcesWithHttpInfo($promptId, $body)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling postArchitectPromptResources');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postArchitectPromptResources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptAsset',
                '/api/v2/architect/prompts/{promptId}/resources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectPrompts
     *
     * Create a new user prompt
     *
     * @param \PureCloudSDK\Prompt $body  (required)
     * @return \PureCloudSDK\Prompt
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPrompts($body)
    {
        list($response) = $this->postArchitectPromptsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postArchitectPromptsWithHttpInfo
     *
     * Create a new user prompt
     *
     * @param \PureCloudSDK\Prompt $body  (required)
     * @return Array of \PureCloudSDK\Prompt, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPromptsWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postArchitectPrompts');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Prompt',
                '/api/v2/architect/prompts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Prompt', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Prompt', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectSchedulegroups
     *
     * Creates a new schedule group
     *
     * @param \PureCloudSDK\ScheduleGroup $body  (required)
     * @return \PureCloudSDK\ScheduleGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSchedulegroups($body)
    {
        list($response) = $this->postArchitectSchedulegroupsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postArchitectSchedulegroupsWithHttpInfo
     *
     * Creates a new schedule group
     *
     * @param \PureCloudSDK\ScheduleGroup $body  (required)
     * @return Array of \PureCloudSDK\ScheduleGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSchedulegroupsWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postArchitectSchedulegroups');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/schedulegroups";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ScheduleGroup',
                '/api/v2/architect/schedulegroups'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ScheduleGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ScheduleGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectSchedules
     *
     * Create a new schedule.
     *
     * @param \PureCloudSDK\Schedule $body  (required)
     * @return \PureCloudSDK\Schedule
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSchedules($body)
    {
        list($response) = $this->postArchitectSchedulesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postArchitectSchedulesWithHttpInfo
     *
     * Create a new schedule.
     *
     * @param \PureCloudSDK\Schedule $body  (required)
     * @return Array of \PureCloudSDK\Schedule, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSchedulesWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postArchitectSchedules');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/schedules";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Schedule',
                '/api/v2/architect/schedules'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Schedule', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Schedule', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectSystempromptHistory
     *
     * Generate system prompt history
     *
     * @param string $promptId promptId (required)
     * @return \PureCloudSDK\Operation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSystempromptHistory($promptId)
    {
        list($response) = $this->postArchitectSystempromptHistoryWithHttpInfo($promptId);
        return $response;
    }

    /**
     * Operation postArchitectSystempromptHistoryWithHttpInfo
     *
     * Generate system prompt history
     *
     * @param string $promptId promptId (required)
     * @return Array of \PureCloudSDK\Operation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSystempromptHistoryWithHttpInfo($promptId)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling postArchitectSystempromptHistory');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/history";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Operation',
                '/api/v2/architect/systemprompts/{promptId}/history'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Operation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Operation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectSystempromptResources
     *
     * Create system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\SystemPromptAsset $body  (required)
     * @return \PureCloudSDK\SystemPromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSystempromptResources($promptId, $body)
    {
        list($response) = $this->postArchitectSystempromptResourcesWithHttpInfo($promptId, $body);
        return $response;
    }

    /**
     * Operation postArchitectSystempromptResourcesWithHttpInfo
     *
     * Create system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\SystemPromptAsset $body  (required)
     * @return Array of \PureCloudSDK\SystemPromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSystempromptResourcesWithHttpInfo($promptId, $body)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling postArchitectSystempromptResources');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postArchitectSystempromptResources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptAsset',
                '/api/v2/architect/systemprompts/{promptId}/resources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowVersions
     *
     * Create flow version
     *
     * @param string $flowId Flow ID (required)
     * @param object $body  (required)
     * @return \PureCloudSDK\FlowVersion
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowVersions($flowId, $body)
    {
        list($response) = $this->postFlowVersionsWithHttpInfo($flowId, $body);
        return $response;
    }

    /**
     * Operation postFlowVersionsWithHttpInfo
     *
     * Create flow version
     *
     * @param string $flowId Flow ID (required)
     * @param object $body  (required)
     * @return Array of \PureCloudSDK\FlowVersion, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowVersionsWithHttpInfo($flowId, $body)
    {
        // verify the required parameter 'flowId' is set
        if ($flowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowId when calling postFlowVersions');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postFlowVersions');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/{flowId}/versions";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($flowId !== null) {
            $resourcePath = str_replace(
                "{" . "flowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowVersion',
                '/api/v2/flows/{flowId}/versions'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowVersion', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowVersion', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlows
     *
     * Create flow
     *
     * @param \PureCloudSDK\Flow $body  (required)
     * @return \PureCloudSDK\Flow
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlows($body)
    {
        list($response) = $this->postFlowsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postFlowsWithHttpInfo
     *
     * Create flow
     *
     * @param \PureCloudSDK\Flow $body  (required)
     * @return Array of \PureCloudSDK\Flow, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postFlows');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Flow',
                '/api/v2/flows'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Flow', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Flow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsActionsCheckin
     *
     * Check-in flow
     *
     * @param string $flow Flow ID (required)
     * @return \PureCloudSDK\Operation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsCheckin($flow)
    {
        list($response) = $this->postFlowsActionsCheckinWithHttpInfo($flow);
        return $response;
    }

    /**
     * Operation postFlowsActionsCheckinWithHttpInfo
     *
     * Check-in flow
     *
     * @param string $flow Flow ID (required)
     * @return Array of \PureCloudSDK\Operation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsCheckinWithHttpInfo($flow)
    {
        // verify the required parameter 'flow' is set
        if ($flow === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flow when calling postFlowsActionsCheckin');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/actions/checkin";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($flow !== null) {
            $queryParams['flow'] = $this->apiClient->getSerializer()->toQueryValue($flow);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Operation',
                '/api/v2/flows/actions/checkin'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Operation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Operation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsActionsCheckout
     *
     * Check-out flow
     *
     * @param string $flow Flow ID (required)
     * @return \PureCloudSDK\Flow
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsCheckout($flow)
    {
        list($response) = $this->postFlowsActionsCheckoutWithHttpInfo($flow);
        return $response;
    }

    /**
     * Operation postFlowsActionsCheckoutWithHttpInfo
     *
     * Check-out flow
     *
     * @param string $flow Flow ID (required)
     * @return Array of \PureCloudSDK\Flow, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsCheckoutWithHttpInfo($flow)
    {
        // verify the required parameter 'flow' is set
        if ($flow === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flow when calling postFlowsActionsCheckout');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/actions/checkout";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($flow !== null) {
            $queryParams['flow'] = $this->apiClient->getSerializer()->toQueryValue($flow);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Flow',
                '/api/v2/flows/actions/checkout'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Flow', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Flow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsActionsDeactivate
     *
     * Deactivate flow
     *
     * @param string $flow Flow ID (required)
     * @return \PureCloudSDK\Flow
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsDeactivate($flow)
    {
        list($response) = $this->postFlowsActionsDeactivateWithHttpInfo($flow);
        return $response;
    }

    /**
     * Operation postFlowsActionsDeactivateWithHttpInfo
     *
     * Deactivate flow
     *
     * @param string $flow Flow ID (required)
     * @return Array of \PureCloudSDK\Flow, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsDeactivateWithHttpInfo($flow)
    {
        // verify the required parameter 'flow' is set
        if ($flow === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flow when calling postFlowsActionsDeactivate');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/actions/deactivate";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($flow !== null) {
            $queryParams['flow'] = $this->apiClient->getSerializer()->toQueryValue($flow);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Flow',
                '/api/v2/flows/actions/deactivate'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Flow', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Flow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsActionsPublish
     *
     * Publish flow
     *
     * @param string $flow Flow ID (required)
     * @param string $version version (optional)
     * @return \PureCloudSDK\Operation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsPublish($flow, $version = null)
    {
        list($response) = $this->postFlowsActionsPublishWithHttpInfo($flow, $version);
        return $response;
    }

    /**
     * Operation postFlowsActionsPublishWithHttpInfo
     *
     * Publish flow
     *
     * @param string $flow Flow ID (required)
     * @param string $version version (optional)
     * @return Array of \PureCloudSDK\Operation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsPublishWithHttpInfo($flow, $version = null)
    {
        // verify the required parameter 'flow' is set
        if ($flow === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flow when calling postFlowsActionsPublish');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/actions/publish";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($flow !== null) {
            $queryParams['flow'] = $this->apiClient->getSerializer()->toQueryValue($flow);
        }
        // query params
        if ($version !== null) {
            $queryParams['version'] = $this->apiClient->getSerializer()->toQueryValue($version);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Operation',
                '/api/v2/flows/actions/publish'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Operation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Operation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsActionsRevert
     *
     * Revert flow
     *
     * @param string $flow Flow ID (required)
     * @return \PureCloudSDK\Flow
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsRevert($flow)
    {
        list($response) = $this->postFlowsActionsRevertWithHttpInfo($flow);
        return $response;
    }

    /**
     * Operation postFlowsActionsRevertWithHttpInfo
     *
     * Revert flow
     *
     * @param string $flow Flow ID (required)
     * @return Array of \PureCloudSDK\Flow, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsRevertWithHttpInfo($flow)
    {
        // verify the required parameter 'flow' is set
        if ($flow === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flow when calling postFlowsActionsRevert');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/actions/revert";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($flow !== null) {
            $queryParams['flow'] = $this->apiClient->getSerializer()->toQueryValue($flow);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Flow',
                '/api/v2/flows/actions/revert'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Flow', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Flow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsActionsUnlock
     *
     * Unlock flow
     *
     * @param string $flow Flow ID (required)
     * @return \PureCloudSDK\Flow
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsUnlock($flow)
    {
        list($response) = $this->postFlowsActionsUnlockWithHttpInfo($flow);
        return $response;
    }

    /**
     * Operation postFlowsActionsUnlockWithHttpInfo
     *
     * Unlock flow
     *
     * @param string $flow Flow ID (required)
     * @return Array of \PureCloudSDK\Flow, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsActionsUnlockWithHttpInfo($flow)
    {
        // verify the required parameter 'flow' is set
        if ($flow === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flow when calling postFlowsActionsUnlock');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/actions/unlock";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($flow !== null) {
            $queryParams['flow'] = $this->apiClient->getSerializer()->toQueryValue($flow);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Flow',
                '/api/v2/flows/actions/unlock'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Flow', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Flow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsDatatableExportJobs
     *
     * Begin an export process for exporting all rows from a datatable
     *
     * @param string $datatableId id of datatable (required)
     * @return \PureCloudSDK\DataTableExportJob
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsDatatableExportJobs($datatableId)
    {
        list($response) = $this->postFlowsDatatableExportJobsWithHttpInfo($datatableId);
        return $response;
    }

    /**
     * Operation postFlowsDatatableExportJobsWithHttpInfo
     *
     * Begin an export process for exporting all rows from a datatable
     *
     * @param string $datatableId id of datatable (required)
     * @return Array of \PureCloudSDK\DataTableExportJob, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsDatatableExportJobsWithHttpInfo($datatableId)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling postFlowsDatatableExportJobs');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/export/jobs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DataTableExportJob',
                '/api/v2/flows/datatables/{datatableId}/export/jobs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DataTableExportJob', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTableExportJob', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTableExportJob', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsDatatableImportJobs
     *
     * Begin an import process for importing rows into a datatable
     *
     * @param string $datatableId id of datatable (required)
     * @param \PureCloudSDK\DataTableImportJob $body import job information (required)
     * @return \PureCloudSDK\DataTableImportJob
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsDatatableImportJobs($datatableId, $body)
    {
        list($response) = $this->postFlowsDatatableImportJobsWithHttpInfo($datatableId, $body);
        return $response;
    }

    /**
     * Operation postFlowsDatatableImportJobsWithHttpInfo
     *
     * Begin an import process for importing rows into a datatable
     *
     * @param string $datatableId id of datatable (required)
     * @param \PureCloudSDK\DataTableImportJob $body import job information (required)
     * @return Array of \PureCloudSDK\DataTableImportJob, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsDatatableImportJobsWithHttpInfo($datatableId, $body)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling postFlowsDatatableImportJobs');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postFlowsDatatableImportJobs');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/import/jobs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DataTableImportJob',
                '/api/v2/flows/datatables/{datatableId}/import/jobs'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DataTableImportJob', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTableImportJob', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTableImportJob', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsDatatableRows
     *
     * Create a new row entry for the datatable.
     *
     * @param string $datatableId id of datatable (required)
     * @param object $dataTableRow  (required)
     * @return map[string,object]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsDatatableRows($datatableId, $dataTableRow)
    {
        list($response) = $this->postFlowsDatatableRowsWithHttpInfo($datatableId, $dataTableRow);
        return $response;
    }

    /**
     * Operation postFlowsDatatableRowsWithHttpInfo
     *
     * Create a new row entry for the datatable.
     *
     * @param string $datatableId id of datatable (required)
     * @param object $dataTableRow  (required)
     * @return Array of map[string,object], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsDatatableRowsWithHttpInfo($datatableId, $dataTableRow)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling postFlowsDatatableRows');
        }
        // verify the required parameter 'dataTableRow' is set
        if ($dataTableRow === null) {
            throw new \InvalidArgumentException('Missing the required parameter $dataTableRow when calling postFlowsDatatableRows');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/rows";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($dataTableRow)) {
            $_tempBody = $dataTableRow;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                'map[string,object]',
                '/api/v2/flows/datatables/{datatableId}/rows'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'map[string,object]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'map[string,object]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsDatatables
     *
     * Create a new datatable with the specified json-schema definition
     *
     * @param \PureCloudSDK\DataTable $body datatable json-schema (required)
     * @return \PureCloudSDK\DataTable
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsDatatables($body)
    {
        list($response) = $this->postFlowsDatatablesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postFlowsDatatablesWithHttpInfo
     *
     * Create a new datatable with the specified json-schema definition
     *
     * @param \PureCloudSDK\DataTable $body datatable json-schema (required)
     * @return Array of \PureCloudSDK\DataTable, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsDatatablesWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postFlowsDatatables');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DataTable',
                '/api/v2/flows/datatables'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DataTable', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTable', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsExecutions
     *
     * Launch an instance of a flow definition, for flow types that support it such as the 'workflow' type.
     *
     * @param \PureCloudSDK\FlowExecutionLaunchRequest $flowLaunchRequest  (required)
     * @return \PureCloudSDK\FlowExecutionLaunchResponse
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsExecutions($flowLaunchRequest)
    {
        list($response) = $this->postFlowsExecutionsWithHttpInfo($flowLaunchRequest);
        return $response;
    }

    /**
     * Operation postFlowsExecutionsWithHttpInfo
     *
     * Launch an instance of a flow definition, for flow types that support it such as the 'workflow' type.
     *
     * @param \PureCloudSDK\FlowExecutionLaunchRequest $flowLaunchRequest  (required)
     * @return Array of \PureCloudSDK\FlowExecutionLaunchResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsExecutionsWithHttpInfo($flowLaunchRequest)
    {
        // verify the required parameter 'flowLaunchRequest' is set
        if ($flowLaunchRequest === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowLaunchRequest when calling postFlowsExecutions');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/executions";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($flowLaunchRequest)) {
            $_tempBody = $flowLaunchRequest;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowExecutionLaunchResponse',
                '/api/v2/flows/executions'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowExecutionLaunchResponse', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowExecutionLaunchResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsMilestones
     *
     * Create a flow milestone
     *
     * @param \PureCloudSDK\FlowMilestone $body  (optional)
     * @return \PureCloudSDK\FlowMilestone
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsMilestones($body = null)
    {
        list($response) = $this->postFlowsMilestonesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postFlowsMilestonesWithHttpInfo
     *
     * Create a flow milestone
     *
     * @param \PureCloudSDK\FlowMilestone $body  (optional)
     * @return Array of \PureCloudSDK\FlowMilestone, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsMilestonesWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/flows/milestones";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowMilestone',
                '/api/v2/flows/milestones'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowMilestone', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowMilestone', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postFlowsOutcomes
     *
     * Create a flow outcome
     *
     * @param \PureCloudSDK\FlowOutcome $body  (optional)
     * @return \PureCloudSDK\FlowOutcome
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsOutcomes($body = null)
    {
        list($response) = $this->postFlowsOutcomesWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postFlowsOutcomesWithHttpInfo
     *
     * Create a flow outcome
     *
     * @param \PureCloudSDK\FlowOutcome $body  (optional)
     * @return Array of \PureCloudSDK\FlowOutcome, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postFlowsOutcomesWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/flows/outcomes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowOutcome',
                '/api/v2/flows/outcomes'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowOutcome', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowOutcome', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectEmergencygroup
     *
     * Updates a emergency group by ID
     *
     * @param string $emergencyGroupId Emergency group ID (required)
     * @param \PureCloudSDK\EmergencyGroup $body  (required)
     * @return \PureCloudSDK\EmergencyGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectEmergencygroup($emergencyGroupId, $body)
    {
        list($response) = $this->putArchitectEmergencygroupWithHttpInfo($emergencyGroupId, $body);
        return $response;
    }

    /**
     * Operation putArchitectEmergencygroupWithHttpInfo
     *
     * Updates a emergency group by ID
     *
     * @param string $emergencyGroupId Emergency group ID (required)
     * @param \PureCloudSDK\EmergencyGroup $body  (required)
     * @return Array of \PureCloudSDK\EmergencyGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectEmergencygroupWithHttpInfo($emergencyGroupId, $body)
    {
        // verify the required parameter 'emergencyGroupId' is set
        if ($emergencyGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $emergencyGroupId when calling putArchitectEmergencygroup');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putArchitectEmergencygroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/emergencygroups/{emergencyGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($emergencyGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "emergencyGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($emergencyGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\EmergencyGroup',
                '/api/v2/architect/emergencygroups/{emergencyGroupId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\EmergencyGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\EmergencyGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectIvr
     *
     * Update an IVR Config.
     *
     * @param string $ivrId IVR id (required)
     * @param \PureCloudSDK\IVR $body  (required)
     * @return \PureCloudSDK\IVR
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectIvr($ivrId, $body)
    {
        list($response) = $this->putArchitectIvrWithHttpInfo($ivrId, $body);
        return $response;
    }

    /**
     * Operation putArchitectIvrWithHttpInfo
     *
     * Update an IVR Config.
     *
     * @param string $ivrId IVR id (required)
     * @param \PureCloudSDK\IVR $body  (required)
     * @return Array of \PureCloudSDK\IVR, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectIvrWithHttpInfo($ivrId, $body)
    {
        // verify the required parameter 'ivrId' is set
        if ($ivrId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $ivrId when calling putArchitectIvr');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putArchitectIvr');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/ivrs/{ivrId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($ivrId !== null) {
            $resourcePath = str_replace(
                "{" . "ivrId" . "}",
                $this->apiClient->getSerializer()->toPathValue($ivrId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\IVR',
                '/api/v2/architect/ivrs/{ivrId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\IVR', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\IVR', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectPrompt
     *
     * Update specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\Prompt $body  (required)
     * @return \PureCloudSDK\Prompt
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectPrompt($promptId, $body)
    {
        list($response) = $this->putArchitectPromptWithHttpInfo($promptId, $body);
        return $response;
    }

    /**
     * Operation putArchitectPromptWithHttpInfo
     *
     * Update specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\Prompt $body  (required)
     * @return Array of \PureCloudSDK\Prompt, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectPromptWithHttpInfo($promptId, $body)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling putArchitectPrompt');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putArchitectPrompt');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Prompt',
                '/api/v2/architect/prompts/{promptId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Prompt', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Prompt', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectPromptResource
     *
     * Update specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @param \PureCloudSDK\PromptAsset $body  (required)
     * @return \PureCloudSDK\PromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectPromptResource($promptId, $languageCode, $body)
    {
        list($response) = $this->putArchitectPromptResourceWithHttpInfo($promptId, $languageCode, $body);
        return $response;
    }

    /**
     * Operation putArchitectPromptResourceWithHttpInfo
     *
     * Update specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @param \PureCloudSDK\PromptAsset $body  (required)
     * @return Array of \PureCloudSDK\PromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectPromptResourceWithHttpInfo($promptId, $languageCode, $body)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling putArchitectPromptResource');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling putArchitectPromptResource');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putArchitectPromptResource');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptAsset',
                '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectSchedule
     *
     * Update schedule by ID
     *
     * @param string $scheduleId Schedule ID (required)
     * @param \PureCloudSDK\Schedule $body  (required)
     * @return \PureCloudSDK\Schedule
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectSchedule($scheduleId, $body)
    {
        list($response) = $this->putArchitectScheduleWithHttpInfo($scheduleId, $body);
        return $response;
    }

    /**
     * Operation putArchitectScheduleWithHttpInfo
     *
     * Update schedule by ID
     *
     * @param string $scheduleId Schedule ID (required)
     * @param \PureCloudSDK\Schedule $body  (required)
     * @return Array of \PureCloudSDK\Schedule, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectScheduleWithHttpInfo($scheduleId, $body)
    {
        // verify the required parameter 'scheduleId' is set
        if ($scheduleId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleId when calling putArchitectSchedule');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putArchitectSchedule');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/schedules/{scheduleId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($scheduleId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Schedule',
                '/api/v2/architect/schedules/{scheduleId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Schedule', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Schedule', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectSchedulegroup
     *
     * Updates a schedule group by ID
     *
     * @param string $scheduleGroupId Schedule group ID (required)
     * @param \PureCloudSDK\ScheduleGroup $body  (required)
     * @return \PureCloudSDK\ScheduleGroup
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectSchedulegroup($scheduleGroupId, $body)
    {
        list($response) = $this->putArchitectSchedulegroupWithHttpInfo($scheduleGroupId, $body);
        return $response;
    }

    /**
     * Operation putArchitectSchedulegroupWithHttpInfo
     *
     * Updates a schedule group by ID
     *
     * @param string $scheduleGroupId Schedule group ID (required)
     * @param \PureCloudSDK\ScheduleGroup $body  (required)
     * @return Array of \PureCloudSDK\ScheduleGroup, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectSchedulegroupWithHttpInfo($scheduleGroupId, $body)
    {
        // verify the required parameter 'scheduleGroupId' is set
        if ($scheduleGroupId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $scheduleGroupId when calling putArchitectSchedulegroup');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putArchitectSchedulegroup');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/schedulegroups/{scheduleGroupId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($scheduleGroupId !== null) {
            $resourcePath = str_replace(
                "{" . "scheduleGroupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($scheduleGroupId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\ScheduleGroup',
                '/api/v2/architect/schedulegroups/{scheduleGroupId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\ScheduleGroup', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ScheduleGroup', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectSystempromptResource
     *
     * Updates a system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @param \PureCloudSDK\SystemPromptAsset $body  (required)
     * @return \PureCloudSDK\SystemPromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectSystempromptResource($promptId, $languageCode, $body)
    {
        list($response) = $this->putArchitectSystempromptResourceWithHttpInfo($promptId, $languageCode, $body);
        return $response;
    }

    /**
     * Operation putArchitectSystempromptResourceWithHttpInfo
     *
     * Updates a system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @param \PureCloudSDK\SystemPromptAsset $body  (required)
     * @return Array of \PureCloudSDK\SystemPromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectSystempromptResourceWithHttpInfo($promptId, $languageCode, $body)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling putArchitectSystempromptResource');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling putArchitectSystempromptResource');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putArchitectSystempromptResource');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptAsset',
                '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putFlow
     *
     * Update flow
     *
     * @param string $flowId Flow ID (required)
     * @param \PureCloudSDK\Flow $body  (required)
     * @return \PureCloudSDK\Flow
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlow($flowId, $body)
    {
        list($response) = $this->putFlowWithHttpInfo($flowId, $body);
        return $response;
    }

    /**
     * Operation putFlowWithHttpInfo
     *
     * Update flow
     *
     * @param string $flowId Flow ID (required)
     * @param \PureCloudSDK\Flow $body  (required)
     * @return Array of \PureCloudSDK\Flow, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlowWithHttpInfo($flowId, $body)
    {
        // verify the required parameter 'flowId' is set
        if ($flowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowId when calling putFlow');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putFlow');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/{flowId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($flowId !== null) {
            $resourcePath = str_replace(
                "{" . "flowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Flow',
                '/api/v2/flows/{flowId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Flow', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Flow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 410:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putFlowsDatatable
     *
     * Updates a specific datatable by id
     *
     * @param string $datatableId id of datatable (required)
     * @param string $expand Expand instructions for the result (optional)
     * @param \PureCloudSDK\DataTable $body datatable json-schema (optional)
     * @return \PureCloudSDK\DataTable
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlowsDatatable($datatableId, $expand = null, $body = null)
    {
        list($response) = $this->putFlowsDatatableWithHttpInfo($datatableId, $expand, $body);
        return $response;
    }

    /**
     * Operation putFlowsDatatableWithHttpInfo
     *
     * Updates a specific datatable by id
     *
     * @param string $datatableId id of datatable (required)
     * @param string $expand Expand instructions for the result (optional)
     * @param \PureCloudSDK\DataTable $body datatable json-schema (optional)
     * @return Array of \PureCloudSDK\DataTable, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlowsDatatableWithHttpInfo($datatableId, $expand = null, $body = null)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling putFlowsDatatable');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($expand !== null) {
            $queryParams['expand'] = $this->apiClient->getSerializer()->toQueryValue($expand);
        }
        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\DataTable',
                '/api/v2/flows/datatables/{datatableId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\DataTable', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\DataTable', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putFlowsDatatableRow
     *
     * Update a row entry
     *
     * @param string $datatableId id of datatable (required)
     * @param string $rowId the key for the row (required)
     * @param object $body datatable row (optional)
     * @return map[string,object]
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlowsDatatableRow($datatableId, $rowId, $body = null)
    {
        list($response) = $this->putFlowsDatatableRowWithHttpInfo($datatableId, $rowId, $body);
        return $response;
    }

    /**
     * Operation putFlowsDatatableRowWithHttpInfo
     *
     * Update a row entry
     *
     * @param string $datatableId id of datatable (required)
     * @param string $rowId the key for the row (required)
     * @param object $body datatable row (optional)
     * @return Array of map[string,object], HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlowsDatatableRowWithHttpInfo($datatableId, $rowId, $body = null)
    {
        // verify the required parameter 'datatableId' is set
        if ($datatableId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $datatableId when calling putFlowsDatatableRow');
        }
        // verify the required parameter 'rowId' is set
        if ($rowId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $rowId when calling putFlowsDatatableRow');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/datatables/{datatableId}/rows/{rowId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($datatableId !== null) {
            $resourcePath = str_replace(
                "{" . "datatableId" . "}",
                $this->apiClient->getSerializer()->toPathValue($datatableId),
                $resourcePath
            );
        }
        // path params
        if ($rowId !== null) {
            $resourcePath = str_replace(
                "{" . "rowId" . "}",
                $this->apiClient->getSerializer()->toPathValue($rowId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                'map[string,object]',
                '/api/v2/flows/datatables/{datatableId}/rows/{rowId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'map[string,object]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'map[string,object]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putFlowsMilestone
     *
     * Updates a flow milestone
     *
     * @param string $milestoneId flow milestone ID (required)
     * @param \PureCloudSDK\FlowMilestone $body  (optional)
     * @return \PureCloudSDK\FlowMilestone
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlowsMilestone($milestoneId, $body = null)
    {
        list($response) = $this->putFlowsMilestoneWithHttpInfo($milestoneId, $body);
        return $response;
    }

    /**
     * Operation putFlowsMilestoneWithHttpInfo
     *
     * Updates a flow milestone
     *
     * @param string $milestoneId flow milestone ID (required)
     * @param \PureCloudSDK\FlowMilestone $body  (optional)
     * @return Array of \PureCloudSDK\FlowMilestone, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlowsMilestoneWithHttpInfo($milestoneId, $body = null)
    {
        // verify the required parameter 'milestoneId' is set
        if ($milestoneId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $milestoneId when calling putFlowsMilestone');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/milestones/{milestoneId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($milestoneId !== null) {
            $resourcePath = str_replace(
                "{" . "milestoneId" . "}",
                $this->apiClient->getSerializer()->toPathValue($milestoneId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowMilestone',
                '/api/v2/flows/milestones/{milestoneId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowMilestone', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowMilestone', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putFlowsOutcome
     *
     * Updates a flow outcome
     *
     * @param string $flowOutcomeId flow outcome ID (required)
     * @param \PureCloudSDK\FlowOutcome $body  (optional)
     * @return \PureCloudSDK\Operation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlowsOutcome($flowOutcomeId, $body = null)
    {
        list($response) = $this->putFlowsOutcomeWithHttpInfo($flowOutcomeId, $body);
        return $response;
    }

    /**
     * Operation putFlowsOutcomeWithHttpInfo
     *
     * Updates a flow outcome
     *
     * @param string $flowOutcomeId flow outcome ID (required)
     * @param \PureCloudSDK\FlowOutcome $body  (optional)
     * @return Array of \PureCloudSDK\Operation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putFlowsOutcomeWithHttpInfo($flowOutcomeId, $body = null)
    {
        // verify the required parameter 'flowOutcomeId' is set
        if ($flowOutcomeId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $flowOutcomeId when calling putFlowsOutcome');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows/outcomes/{flowOutcomeId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($flowOutcomeId !== null) {
            $resourcePath = str_replace(
                "{" . "flowOutcomeId" . "}",
                $this->apiClient->getSerializer()->toPathValue($flowOutcomeId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Operation',
                '/api/v2/flows/outcomes/{flowOutcomeId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Operation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Operation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 405:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 413:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
