<?php

/**
 * AuditQueryExecutionStatusResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AuditQueryExecutionStatusResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AuditQueryExecutionStatusResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AuditQueryExecutionStatusResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'state' => 'string',
        'startDate' => '\DateTime',
        'interval' => 'string',
        'serviceName' => 'string',
        'filters' => '\PureCloudSDK\AuditQueryFilter[]',
        'sort' => '\PureCloudSDK\AuditQuerySort[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'state' => 'state',
        'startDate' => 'startDate',
        'interval' => 'interval',
        'serviceName' => 'serviceName',
        'filters' => 'filters',
        'sort' => 'sort'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'state' => 'setState',
        'startDate' => 'setStartDate',
        'interval' => 'setInterval',
        'serviceName' => 'setServiceName',
        'filters' => 'setFilters',
        'sort' => 'setSort'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'state' => 'getState',
        'startDate' => 'getStartDate',
        'interval' => 'getInterval',
        'serviceName' => 'getServiceName',
        'filters' => 'getFilters',
        'sort' => 'getSort'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_QUEUED = 'Queued';
    public const STATE_RUNNING = 'Running';
    public const STATE_SUCCEEDED = 'Succeeded';
    public const STATE_FAILED = 'Failed';
    public const STATE_CANCELLED = 'Cancelled';
    public const SERVICE_NAME_CONTACT_CENTER = 'ContactCenter';
    public const SERVICE_NAME_CONTENT_MANAGEMENT = 'ContentManagement';
    public const SERVICE_NAME_PEOPLE_PERMISSIONS = 'PeoplePermissions';
    public const SERVICE_NAME_QUALITY = 'Quality';
    public const SERVICE_NAME_LANGUAGE_UNDERSTANDING = 'LanguageUnderstanding';
    public const SERVICE_NAME_TOPICS_DEFINITIONS = 'TopicsDefinitions';
    public const SERVICE_NAME_PREDICTIVE_ENGAGEMENT = 'PredictiveEngagement';
    public const SERVICE_NAME_WORKFORCE_MANAGEMENT = 'WorkforceManagement';
    public const SERVICE_NAME_TRIGGERS = 'Triggers';
    public const SERVICE_NAME_RESPONSE_MANAGEMENT = 'ResponseManagement';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_QUEUED,
            self::STATE_RUNNING,
            self::STATE_SUCCEEDED,
            self::STATE_FAILED,
            self::STATE_CANCELLED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getServiceNameAllowableValues()
    {
        return [
            self::SERVICE_NAME_CONTACT_CENTER,
            self::SERVICE_NAME_CONTENT_MANAGEMENT,
            self::SERVICE_NAME_PEOPLE_PERMISSIONS,
            self::SERVICE_NAME_QUALITY,
            self::SERVICE_NAME_LANGUAGE_UNDERSTANDING,
            self::SERVICE_NAME_TOPICS_DEFINITIONS,
            self::SERVICE_NAME_PREDICTIVE_ENGAGEMENT,
            self::SERVICE_NAME_WORKFORCE_MANAGEMENT,
            self::SERVICE_NAME_TRIGGERS,
            self::SERVICE_NAME_RESPONSE_MANAGEMENT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['serviceName'] = isset($data['serviceName']) ? $data['serviceName'] : null;
        $this->container['filters'] = isset($data['filters']) ? $data['filters'] : null;
        $this->container['sort'] = isset($data['sort']) ? $data['sort'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Queued", "Running", "Succeeded", "Failed", "Cancelled");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ContactCenter", "ContentManagement", "PeoplePermissions", "Quality", "LanguageUnderstanding", "TopicsDefinitions", "PredictiveEngagement", "WorkforceManagement", "Triggers", "ResponseManagement");
        if (!in_array($this->container['serviceName'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'serviceName', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Queued", "Running", "Succeeded", "Failed", "Cancelled");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ContactCenter", "ContentManagement", "PeoplePermissions", "Quality", "LanguageUnderstanding", "TopicsDefinitions", "PredictiveEngagement", "WorkforceManagement", "Triggers", "ResponseManagement");
        if (!in_array($this->container['serviceName'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id Id of the audit query execution request.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state Status of the audit query execution request.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('Queued', 'Running', 'Succeeded', 'Failed', 'Cancelled');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'Queued', 'Running', 'Succeeded', 'Failed', 'Cancelled'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate Start date and time of the audit query execution. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Interval for the audit query. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets serviceName
     * @return string
     */
    public function getServiceName()
    {
        return $this->container['serviceName'];
    }

    /**
     * Sets serviceName
     * @param string $serviceName Service name for the audit query.
     * @return $this
     */
    public function setServiceName($serviceName)
    {
        $allowed_values = array('ContactCenter', 'ContentManagement', 'PeoplePermissions', 'Quality', 'LanguageUnderstanding', 'TopicsDefinitions', 'PredictiveEngagement', 'WorkforceManagement', 'Triggers', 'ResponseManagement');
        if (!in_array($serviceName, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'serviceName', must be one of 'ContactCenter', 'ContentManagement', 'PeoplePermissions', 'Quality', 'LanguageUnderstanding', 'TopicsDefinitions', 'PredictiveEngagement', 'WorkforceManagement', 'Triggers', 'ResponseManagement'");
        }
        $this->container['serviceName'] = $serviceName;

        return $this;
    }

    /**
     * Gets filters
     * @return \PureCloudSDK\AuditQueryFilter[]
     */
    public function getFilters()
    {
        return $this->container['filters'];
    }

    /**
     * Sets filters
     * @param \PureCloudSDK\AuditQueryFilter[] $filters Filters for the audit query.
     * @return $this
     */
    public function setFilters($filters)
    {
        $this->container['filters'] = $filters;

        return $this;
    }

    /**
     * Gets sort
     * @return \PureCloudSDK\AuditQuerySort[]
     */
    public function getSort()
    {
        return $this->container['sort'];
    }

    /**
     * Sets sort
     * @param \PureCloudSDK\AuditQuerySort[] $sort Sort parameter for the audit query.
     * @return $this
     */
    public function setSort($sort)
    {
        $this->container['sort'] = $sort;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
