<?php

/**
 * BuIntradayDataGroup
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * BuIntradayDataGroup Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BuIntradayDataGroup implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BuIntradayDataGroup';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'mediaType' => 'string',
        'forecastDataSummary' => '\PureCloudSDK\BuIntradayForecastData',
        'forecastDataPerInterval' => '\PureCloudSDK\BuIntradayForecastData[]',
        'scheduleDataSummary' => '\PureCloudSDK\BuIntradayScheduleData',
        'scheduleDataPerInterval' => '\PureCloudSDK\BuIntradayScheduleData[]',
        'performancePredictionDataSummary' => '\PureCloudSDK\IntradayPerformancePredictionData',
        'performancePredictionDataPerInterval' => '\PureCloudSDK\IntradayPerformancePredictionData[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'mediaType' => 'mediaType',
        'forecastDataSummary' => 'forecastDataSummary',
        'forecastDataPerInterval' => 'forecastDataPerInterval',
        'scheduleDataSummary' => 'scheduleDataSummary',
        'scheduleDataPerInterval' => 'scheduleDataPerInterval',
        'performancePredictionDataSummary' => 'performancePredictionDataSummary',
        'performancePredictionDataPerInterval' => 'performancePredictionDataPerInterval'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'mediaType' => 'setMediaType',
        'forecastDataSummary' => 'setForecastDataSummary',
        'forecastDataPerInterval' => 'setForecastDataPerInterval',
        'scheduleDataSummary' => 'setScheduleDataSummary',
        'scheduleDataPerInterval' => 'setScheduleDataPerInterval',
        'performancePredictionDataSummary' => 'setPerformancePredictionDataSummary',
        'performancePredictionDataPerInterval' => 'setPerformancePredictionDataPerInterval'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'mediaType' => 'getMediaType',
        'forecastDataSummary' => 'getForecastDataSummary',
        'forecastDataPerInterval' => 'getForecastDataPerInterval',
        'scheduleDataSummary' => 'getScheduleDataSummary',
        'scheduleDataPerInterval' => 'getScheduleDataPerInterval',
        'performancePredictionDataSummary' => 'getPerformancePredictionDataSummary',
        'performancePredictionDataPerInterval' => 'getPerformancePredictionDataPerInterval'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const MEDIA_TYPE_VOICE = 'Voice';
    public const MEDIA_TYPE_CHAT = 'Chat';
    public const MEDIA_TYPE_EMAIL = 'Email';
    public const MEDIA_TYPE_CALLBACK = 'Callback';
    public const MEDIA_TYPE_MESSAGE = 'Message';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_VOICE,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
            self::MEDIA_TYPE_CALLBACK,
            self::MEDIA_TYPE_MESSAGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['mediaType'] = isset($data['mediaType']) ? $data['mediaType'] : null;
        $this->container['forecastDataSummary'] = isset($data['forecastDataSummary']) ? $data['forecastDataSummary'] : null;
        $this->container['forecastDataPerInterval'] = isset($data['forecastDataPerInterval']) ? $data['forecastDataPerInterval'] : null;
        $this->container['scheduleDataSummary'] = isset($data['scheduleDataSummary']) ? $data['scheduleDataSummary'] : null;
        $this->container['scheduleDataPerInterval'] = isset($data['scheduleDataPerInterval']) ? $data['scheduleDataPerInterval'] : null;
        $this->container['performancePredictionDataSummary'] = isset($data['performancePredictionDataSummary']) ? $data['performancePredictionDataSummary'] : null;
        $this->container['performancePredictionDataPerInterval'] = isset($data['performancePredictionDataPerInterval']) ? $data['performancePredictionDataPerInterval'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Voice", "Chat", "Email", "Callback", "Message");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mediaType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Voice", "Chat", "Email", "Callback", "Message");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets mediaType
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['mediaType'];
    }

    /**
     * Sets mediaType
     * @param string $mediaType The media type associated with this intraday group
     * @return $this
     */
    public function setMediaType($mediaType)
    {
        $allowed_values = array('Voice', 'Chat', 'Email', 'Callback', 'Message');
        if (!in_array($mediaType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaType', must be one of 'Voice', 'Chat', 'Email', 'Callback', 'Message'");
        }
        $this->container['mediaType'] = $mediaType;

        return $this;
    }

    /**
     * Gets forecastDataSummary
     * @return \PureCloudSDK\BuIntradayForecastData
     */
    public function getForecastDataSummary()
    {
        return $this->container['forecastDataSummary'];
    }

    /**
     * Sets forecastDataSummary
     * @param \PureCloudSDK\BuIntradayForecastData $forecastDataSummary Forecast data summary for this date range
     * @return $this
     */
    public function setForecastDataSummary($forecastDataSummary)
    {
        $this->container['forecastDataSummary'] = $forecastDataSummary;

        return $this;
    }

    /**
     * Gets forecastDataPerInterval
     * @return \PureCloudSDK\BuIntradayForecastData[]
     */
    public function getForecastDataPerInterval()
    {
        return $this->container['forecastDataPerInterval'];
    }

    /**
     * Sets forecastDataPerInterval
     * @param \PureCloudSDK\BuIntradayForecastData[] $forecastDataPerInterval Forecast data per interval for this date range
     * @return $this
     */
    public function setForecastDataPerInterval($forecastDataPerInterval)
    {
        $this->container['forecastDataPerInterval'] = $forecastDataPerInterval;

        return $this;
    }

    /**
     * Gets scheduleDataSummary
     * @return \PureCloudSDK\BuIntradayScheduleData
     */
    public function getScheduleDataSummary()
    {
        return $this->container['scheduleDataSummary'];
    }

    /**
     * Sets scheduleDataSummary
     * @param \PureCloudSDK\BuIntradayScheduleData $scheduleDataSummary Schedule data summary for this date range
     * @return $this
     */
    public function setScheduleDataSummary($scheduleDataSummary)
    {
        $this->container['scheduleDataSummary'] = $scheduleDataSummary;

        return $this;
    }

    /**
     * Gets scheduleDataPerInterval
     * @return \PureCloudSDK\BuIntradayScheduleData[]
     */
    public function getScheduleDataPerInterval()
    {
        return $this->container['scheduleDataPerInterval'];
    }

    /**
     * Sets scheduleDataPerInterval
     * @param \PureCloudSDK\BuIntradayScheduleData[] $scheduleDataPerInterval Schedule data per interval for this date range
     * @return $this
     */
    public function setScheduleDataPerInterval($scheduleDataPerInterval)
    {
        $this->container['scheduleDataPerInterval'] = $scheduleDataPerInterval;

        return $this;
    }

    /**
     * Gets performancePredictionDataSummary
     * @return \PureCloudSDK\IntradayPerformancePredictionData
     */
    public function getPerformancePredictionDataSummary()
    {
        return $this->container['performancePredictionDataSummary'];
    }

    /**
     * Sets performancePredictionDataSummary
     * @param \PureCloudSDK\IntradayPerformancePredictionData $performancePredictionDataSummary Performance prediction data summary for this date range
     * @return $this
     */
    public function setPerformancePredictionDataSummary($performancePredictionDataSummary)
    {
        $this->container['performancePredictionDataSummary'] = $performancePredictionDataSummary;

        return $this;
    }

    /**
     * Gets performancePredictionDataPerInterval
     * @return \PureCloudSDK\IntradayPerformancePredictionData[]
     */
    public function getPerformancePredictionDataPerInterval()
    {
        return $this->container['performancePredictionDataPerInterval'];
    }

    /**
     * Sets performancePredictionDataPerInterval
     * @param \PureCloudSDK\IntradayPerformancePredictionData[] $performancePredictionDataPerInterval Performance prediction data per interval for this date range
     * @return $this
     */
    public function setPerformancePredictionDataPerInterval($performancePredictionDataPerInterval)
    {
        $this->container['performancePredictionDataPerInterval'] = $performancePredictionDataPerInterval;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
