<?php

/**
 * Condition
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * Condition Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Condition implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Condition';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'inverted' => 'bool',
        'attributeName' => 'string',
        'value' => 'string',
        'valueType' => 'string',
        'operator' => 'string',
        'codes' => 'string[]',
        'property' => 'string',
        'propertyType' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'inverted' => 'inverted',
        'attributeName' => 'attributeName',
        'value' => 'value',
        'valueType' => 'valueType',
        'operator' => 'operator',
        'codes' => 'codes',
        'property' => 'property',
        'propertyType' => 'propertyType'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'inverted' => 'setInverted',
        'attributeName' => 'setAttributeName',
        'value' => 'setValue',
        'valueType' => 'setValueType',
        'operator' => 'setOperator',
        'codes' => 'setCodes',
        'property' => 'setProperty',
        'propertyType' => 'setPropertyType'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'inverted' => 'getInverted',
        'attributeName' => 'getAttributeName',
        'value' => 'getValue',
        'valueType' => 'getValueType',
        'operator' => 'getOperator',
        'codes' => 'getCodes',
        'property' => 'getProperty',
        'propertyType' => 'getPropertyType'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_WRAPUP_CONDITION = 'wrapupCondition';
    public const TYPE_CONTACT_ATTRIBUTE_CONDITION = 'contactAttributeCondition';
    public const TYPE_PHONE_NUMBER_CONDITION = 'phoneNumberCondition';
    public const TYPE_PHONE_NUMBER_TYPE_CONDITION = 'phoneNumberTypeCondition';
    public const TYPE_CALL_ANALYSIS_CONDITION = 'callAnalysisCondition';
    public const TYPE_CONTACT_PROPERTY_CONDITION = 'contactPropertyCondition';
    public const TYPE_DATA_ACTION_CONDITION = 'dataActionCondition';
    public const VALUE_TYPE_STRING = 'STRING';
    public const VALUE_TYPE_NUMERIC = 'NUMERIC';
    public const VALUE_TYPE_DATETIME = 'DATETIME';
    public const VALUE_TYPE_PERIOD = 'PERIOD';
    public const OPERATOR_EQUALS = 'EQUALS';
    public const OPERATOR_LESS_THAN = 'LESS_THAN';
    public const OPERATOR_LESS_THAN_EQUALS = 'LESS_THAN_EQUALS';
    public const OPERATOR_GREATER_THAN = 'GREATER_THAN';
    public const OPERATOR_GREATER_THAN_EQUALS = 'GREATER_THAN_EQUALS';
    public const OPERATOR_CONTAINS = 'CONTAINS';
    public const OPERATOR_BEGINS_WITH = 'BEGINS_WITH';
    public const OPERATOR_ENDS_WITH = 'ENDS_WITH';
    public const OPERATOR_BEFORE = 'BEFORE';
    public const OPERATOR_AFTER = 'AFTER';
    public const OPERATOR_IN = 'IN';
    public const PROPERTY_TYPE_ATTEMPT_BY_COLUMN = 'LAST_ATTEMPT_BY_COLUMN';
    public const PROPERTY_TYPE_ATTEMPT_OVERALL = 'LAST_ATTEMPT_OVERALL';
    public const PROPERTY_TYPE_WRAPUP_BY_COLUMN = 'LAST_WRAPUP_BY_COLUMN';
    public const PROPERTY_TYPE_WRAPUP_OVERALL = 'LAST_WRAPUP_OVERALL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_WRAPUP_CONDITION,
            self::TYPE_CONTACT_ATTRIBUTE_CONDITION,
            self::TYPE_PHONE_NUMBER_CONDITION,
            self::TYPE_PHONE_NUMBER_TYPE_CONDITION,
            self::TYPE_CALL_ANALYSIS_CONDITION,
            self::TYPE_CONTACT_PROPERTY_CONDITION,
            self::TYPE_DATA_ACTION_CONDITION,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getValueTypeAllowableValues()
    {
        return [
            self::VALUE_TYPE_STRING,
            self::VALUE_TYPE_NUMERIC,
            self::VALUE_TYPE_DATETIME,
            self::VALUE_TYPE_PERIOD,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_EQUALS,
            self::OPERATOR_LESS_THAN,
            self::OPERATOR_LESS_THAN_EQUALS,
            self::OPERATOR_GREATER_THAN,
            self::OPERATOR_GREATER_THAN_EQUALS,
            self::OPERATOR_CONTAINS,
            self::OPERATOR_BEGINS_WITH,
            self::OPERATOR_ENDS_WITH,
            self::OPERATOR_BEFORE,
            self::OPERATOR_AFTER,
            self::OPERATOR_IN,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPropertyTypeAllowableValues()
    {
        return [
            self::PROPERTY_TYPE_ATTEMPT_BY_COLUMN,
            self::PROPERTY_TYPE_ATTEMPT_OVERALL,
            self::PROPERTY_TYPE_WRAPUP_BY_COLUMN,
            self::PROPERTY_TYPE_WRAPUP_OVERALL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['inverted'] = isset($data['inverted']) ? $data['inverted'] : null;
        $this->container['attributeName'] = isset($data['attributeName']) ? $data['attributeName'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['valueType'] = isset($data['valueType']) ? $data['valueType'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['codes'] = isset($data['codes']) ? $data['codes'] : null;
        $this->container['property'] = isset($data['property']) ? $data['property'] : null;
        $this->container['propertyType'] = isset($data['propertyType']) ? $data['propertyType'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("wrapupCondition", "contactAttributeCondition", "phoneNumberCondition", "phoneNumberTypeCondition", "callAnalysisCondition", "contactPropertyCondition", "dataActionCondition");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("STRING", "NUMERIC", "DATETIME", "PERIOD");
        if (!in_array($this->container['valueType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'valueType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("EQUALS", "LESS_THAN", "LESS_THAN_EQUALS", "GREATER_THAN", "GREATER_THAN_EQUALS", "CONTAINS", "BEGINS_WITH", "ENDS_WITH", "BEFORE", "AFTER", "IN");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        $allowed_values = array("LAST_ATTEMPT_BY_COLUMN", "LAST_ATTEMPT_OVERALL", "LAST_WRAPUP_BY_COLUMN", "LAST_WRAPUP_OVERALL");
        if (!in_array($this->container['propertyType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'propertyType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("wrapupCondition", "contactAttributeCondition", "phoneNumberCondition", "phoneNumberTypeCondition", "callAnalysisCondition", "contactPropertyCondition", "dataActionCondition");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("STRING", "NUMERIC", "DATETIME", "PERIOD");
        if (!in_array($this->container['valueType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("EQUALS", "LESS_THAN", "LESS_THAN_EQUALS", "GREATER_THAN", "GREATER_THAN_EQUALS", "CONTAINS", "BEGINS_WITH", "ENDS_WITH", "BEFORE", "AFTER", "IN");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("LAST_ATTEMPT_BY_COLUMN", "LAST_ATTEMPT_OVERALL", "LAST_WRAPUP_BY_COLUMN", "LAST_WRAPUP_OVERALL");
        if (!in_array($this->container['propertyType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The type of the condition.
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('wrapupCondition', 'contactAttributeCondition', 'phoneNumberCondition', 'phoneNumberTypeCondition', 'callAnalysisCondition', 'contactPropertyCondition', 'dataActionCondition');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'wrapupCondition', 'contactAttributeCondition', 'phoneNumberCondition', 'phoneNumberTypeCondition', 'callAnalysisCondition', 'contactPropertyCondition', 'dataActionCondition'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets inverted
     * @return bool
     */
    public function getInverted()
    {
        return $this->container['inverted'];
    }

    /**
     * Sets inverted
     * @param bool $inverted If true, inverts the result of evaluating this Condition. Default is false.
     * @return $this
     */
    public function setInverted($inverted)
    {
        $this->container['inverted'] = $inverted;

        return $this;
    }

    /**
     * Gets attributeName
     * @return string
     */
    public function getAttributeName()
    {
        return $this->container['attributeName'];
    }

    /**
     * Sets attributeName
     * @param string $attributeName An attribute name associated with this Condition. Required for a contactAttributeCondition.
     * @return $this
     */
    public function setAttributeName($attributeName)
    {
        $this->container['attributeName'] = $attributeName;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value A value associated with this Condition. This could be text, a number, or a relative time. Not used for a DataActionCondition.
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets valueType
     * @return string
     */
    public function getValueType()
    {
        return $this->container['valueType'];
    }

    /**
     * Sets valueType
     * @param string $valueType The type of the value associated with this Condition. Not used for a DataActionCondition.
     * @return $this
     */
    public function setValueType($valueType)
    {
        $allowed_values = array('STRING', 'NUMERIC', 'DATETIME', 'PERIOD');
        if (!in_array($valueType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'valueType', must be one of 'STRING', 'NUMERIC', 'DATETIME', 'PERIOD'");
        }
        $this->container['valueType'] = $valueType;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator An operation with which to evaluate the Condition. Not used for a DataActionCondition.
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('EQUALS', 'LESS_THAN', 'LESS_THAN_EQUALS', 'GREATER_THAN', 'GREATER_THAN_EQUALS', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', 'BEFORE', 'AFTER', 'IN');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'EQUALS', 'LESS_THAN', 'LESS_THAN_EQUALS', 'GREATER_THAN', 'GREATER_THAN_EQUALS', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', 'BEFORE', 'AFTER', 'IN'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets codes
     * @return string[]
     */
    public function getCodes()
    {
        return $this->container['codes'];
    }

    /**
     * Sets codes
     * @param string[] $codes List of wrap-up code identifiers. Required for a wrapupCondition.
     * @return $this
     */
    public function setCodes($codes)
    {
        $this->container['codes'] = $codes;

        return $this;
    }

    /**
     * Gets property
     * @return string
     */
    public function getProperty()
    {
        return $this->container['property'];
    }

    /**
     * Sets property
     * @param string $property A value associated with the property type of this Condition. Required for a contactPropertyCondition.
     * @return $this
     */
    public function setProperty($property)
    {
        $this->container['property'] = $property;

        return $this;
    }

    /**
     * Gets propertyType
     * @return string
     */
    public function getPropertyType()
    {
        return $this->container['propertyType'];
    }

    /**
     * Sets propertyType
     * @param string $propertyType The type of the property associated with this Condition. Required for a contactPropertyCondition.
     * @return $this
     */
    public function setPropertyType($propertyType)
    {
        $allowed_values = array('LAST_ATTEMPT_BY_COLUMN', 'LAST_ATTEMPT_OVERALL', 'LAST_WRAPUP_BY_COLUMN', 'LAST_WRAPUP_OVERALL');
        if (!in_array($propertyType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'propertyType', must be one of 'LAST_ATTEMPT_BY_COLUMN', 'LAST_ATTEMPT_OVERALL', 'LAST_WRAPUP_BY_COLUMN', 'LAST_WRAPUP_OVERALL'");
        }
        $this->container['propertyType'] = $propertyType;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
