<?php

/**
 * ConversationDetailQueryPredicate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ConversationDetailQueryPredicate Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConversationDetailQueryPredicate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConversationDetailQueryPredicate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'dimension' => 'string',
        'metric' => 'string',
        'operator' => 'string',
        'value' => 'string',
        'range' => '\PureCloudSDK\NumericRange'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'dimension' => 'dimension',
        'metric' => 'metric',
        'operator' => 'operator',
        'value' => 'value',
        'range' => 'range'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'dimension' => 'setDimension',
        'metric' => 'setMetric',
        'operator' => 'setOperator',
        'value' => 'setValue',
        'range' => 'setRange'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'dimension' => 'getDimension',
        'metric' => 'getMetric',
        'operator' => 'getOperator',
        'value' => 'getValue',
        'range' => 'getRange'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_DIMENSION = 'dimension';
    public const TYPE_PROPERTY = 'property';
    public const TYPE_METRIC = 'metric';
    public const DIMENSION_CONVERSATION_END = 'conversationEnd';
    public const DIMENSION_CONVERSATION_ID = 'conversationId';
    public const DIMENSION_DIVISION_ID = 'divisionId';
    public const DIMENSION_MEDIA_STATS_MIN_CONVERSATION_MOS = 'mediaStatsMinConversationMos';
    public const DIMENSION_MEDIA_STATS_MIN_CONVERSATION_R_FACTOR = 'mediaStatsMinConversationRFactor';
    public const DIMENSION_ORIGINATING_DIRECTION = 'originatingDirection';
    public const METRIC_N_BLIND_TRANSFERRED = 'nBlindTransferred';
    public const METRIC_N_CONNECTED = 'nConnected';
    public const METRIC_N_CONSULT = 'nConsult';
    public const METRIC_N_CONSULT_TRANSFERRED = 'nConsultTransferred';
    public const METRIC_N_ERROR = 'nError';
    public const METRIC_N_FLOW = 'nFlow';
    public const METRIC_N_FLOW_MILESTONE = 'nFlowMilestone';
    public const METRIC_N_FLOW_OUTCOME = 'nFlowOutcome';
    public const METRIC_N_FLOW_OUTCOME_FAILED = 'nFlowOutcomeFailed';
    public const METRIC_N_OFFERED = 'nOffered';
    public const METRIC_N_OUTBOUND = 'nOutbound';
    public const METRIC_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    public const METRIC_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    public const METRIC_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    public const METRIC_N_OVER_SLA = 'nOverSla';
    public const METRIC_N_STATE_TRANSITION_ERROR = 'nStateTransitionError';
    public const METRIC_N_TRANSFERRED = 'nTransferred';
    public const METRIC_O_EXTERNAL_MEDIA_COUNT = 'oExternalMediaCount';
    public const METRIC_O_FLOW_MILESTONE = 'oFlowMilestone';
    public const METRIC_O_MEDIA_COUNT = 'oMediaCount';
    public const METRIC_T_ABANDON = 'tAbandon';
    public const METRIC_T_ACD = 'tAcd';
    public const METRIC_T_ACW = 'tAcw';
    public const METRIC_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    public const METRIC_T_ALERT = 'tAlert';
    public const METRIC_T_ANSWERED = 'tAnswered';
    public const METRIC_T_CONTACTING = 'tContacting';
    public const METRIC_T_CONVERSATION_DURATION = 'tConversationDuration';
    public const METRIC_T_DIALING = 'tDialing';
    public const METRIC_T_FLOW = 'tFlow';
    public const METRIC_T_FLOW_DISCONNECT = 'tFlowDisconnect';
    public const METRIC_T_FLOW_EXIT = 'tFlowExit';
    public const METRIC_T_FLOW_OUT = 'tFlowOut';
    public const METRIC_T_FLOW_OUTCOME = 'tFlowOutcome';
    public const METRIC_T_HANDLE = 'tHandle';
    public const METRIC_T_HELD = 'tHeld';
    public const METRIC_T_HELD_COMPLETE = 'tHeldComplete';
    public const METRIC_T_IVR = 'tIvr';
    public const METRIC_T_MONITORING = 'tMonitoring';
    public const METRIC_T_NOT_RESPONDING = 'tNotResponding';
    public const METRIC_T_SHORT_ABANDON = 'tShortAbandon';
    public const METRIC_T_TALK = 'tTalk';
    public const METRIC_T_TALK_COMPLETE = 'tTalkComplete';
    public const METRIC_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    public const METRIC_T_VOICEMAIL = 'tVoicemail';
    public const OPERATOR_MATCHES = 'matches';
    public const OPERATOR_EXISTS = 'exists';
    public const OPERATOR_NOT_EXISTS = 'notExists';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_DIMENSION,
            self::TYPE_PROPERTY,
            self::TYPE_METRIC,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDimensionAllowableValues()
    {
        return [
            self::DIMENSION_CONVERSATION_END,
            self::DIMENSION_CONVERSATION_ID,
            self::DIMENSION_DIVISION_ID,
            self::DIMENSION_MEDIA_STATS_MIN_CONVERSATION_MOS,
            self::DIMENSION_MEDIA_STATS_MIN_CONVERSATION_R_FACTOR,
            self::DIMENSION_ORIGINATING_DIRECTION,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_N_BLIND_TRANSFERRED,
            self::METRIC_N_CONNECTED,
            self::METRIC_N_CONSULT,
            self::METRIC_N_CONSULT_TRANSFERRED,
            self::METRIC_N_ERROR,
            self::METRIC_N_FLOW,
            self::METRIC_N_FLOW_MILESTONE,
            self::METRIC_N_FLOW_OUTCOME,
            self::METRIC_N_FLOW_OUTCOME_FAILED,
            self::METRIC_N_OFFERED,
            self::METRIC_N_OUTBOUND,
            self::METRIC_N_OUTBOUND_ABANDONED,
            self::METRIC_N_OUTBOUND_ATTEMPTED,
            self::METRIC_N_OUTBOUND_CONNECTED,
            self::METRIC_N_OVER_SLA,
            self::METRIC_N_STATE_TRANSITION_ERROR,
            self::METRIC_N_TRANSFERRED,
            self::METRIC_O_EXTERNAL_MEDIA_COUNT,
            self::METRIC_O_FLOW_MILESTONE,
            self::METRIC_O_MEDIA_COUNT,
            self::METRIC_T_ABANDON,
            self::METRIC_T_ACD,
            self::METRIC_T_ACW,
            self::METRIC_T_AGENT_RESPONSE_TIME,
            self::METRIC_T_ALERT,
            self::METRIC_T_ANSWERED,
            self::METRIC_T_CONTACTING,
            self::METRIC_T_CONVERSATION_DURATION,
            self::METRIC_T_DIALING,
            self::METRIC_T_FLOW,
            self::METRIC_T_FLOW_DISCONNECT,
            self::METRIC_T_FLOW_EXIT,
            self::METRIC_T_FLOW_OUT,
            self::METRIC_T_FLOW_OUTCOME,
            self::METRIC_T_HANDLE,
            self::METRIC_T_HELD,
            self::METRIC_T_HELD_COMPLETE,
            self::METRIC_T_IVR,
            self::METRIC_T_MONITORING,
            self::METRIC_T_NOT_RESPONDING,
            self::METRIC_T_SHORT_ABANDON,
            self::METRIC_T_TALK,
            self::METRIC_T_TALK_COMPLETE,
            self::METRIC_T_USER_RESPONSE_TIME,
            self::METRIC_T_VOICEMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_MATCHES,
            self::OPERATOR_EXISTS,
            self::OPERATOR_NOT_EXISTS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['dimension'] = isset($data['dimension']) ? $data['dimension'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['range'] = isset($data['range']) ? $data['range'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("dimension", "property", "metric");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("conversationEnd", "conversationId", "divisionId", "mediaStatsMinConversationMos", "mediaStatsMinConversationRFactor", "originatingDirection");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dimension', must be one of #{allowed_values}.";
        }

        $allowed_values = array("nBlindTransferred", "nConnected", "nConsult", "nConsultTransferred", "nError", "nFlow", "nFlowMilestone", "nFlowOutcome", "nFlowOutcomeFailed", "nOffered", "nOutbound", "nOutboundAbandoned", "nOutboundAttempted", "nOutboundConnected", "nOverSla", "nStateTransitionError", "nTransferred", "oExternalMediaCount", "oFlowMilestone", "oMediaCount", "tAbandon", "tAcd", "tAcw", "tAgentResponseTime", "tAlert", "tAnswered", "tContacting", "tConversationDuration", "tDialing", "tFlow", "tFlowDisconnect", "tFlowExit", "tFlowOut", "tFlowOutcome", "tHandle", "tHeld", "tHeldComplete", "tIvr", "tMonitoring", "tNotResponding", "tShortAbandon", "tTalk", "tTalkComplete", "tUserResponseTime", "tVoicemail");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        $allowed_values = array("matches", "exists", "notExists");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("dimension", "property", "metric");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("conversationEnd", "conversationId", "divisionId", "mediaStatsMinConversationMos", "mediaStatsMinConversationRFactor", "originatingDirection");
        if (!in_array($this->container['dimension'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("nBlindTransferred", "nConnected", "nConsult", "nConsultTransferred", "nError", "nFlow", "nFlowMilestone", "nFlowOutcome", "nFlowOutcomeFailed", "nOffered", "nOutbound", "nOutboundAbandoned", "nOutboundAttempted", "nOutboundConnected", "nOverSla", "nStateTransitionError", "nTransferred", "oExternalMediaCount", "oFlowMilestone", "oMediaCount", "tAbandon", "tAcd", "tAcw", "tAgentResponseTime", "tAlert", "tAnswered", "tContacting", "tConversationDuration", "tDialing", "tFlow", "tFlowDisconnect", "tFlowExit", "tFlowOut", "tFlowOutcome", "tHandle", "tHeld", "tHeldComplete", "tIvr", "tMonitoring", "tNotResponding", "tShortAbandon", "tTalk", "tTalkComplete", "tUserResponseTime", "tVoicemail");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("matches", "exists", "notExists");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Optional type, can usually be inferred
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('dimension', 'property', 'metric');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'dimension', 'property', 'metric'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets dimension
     * @return string
     */
    public function getDimension()
    {
        return $this->container['dimension'];
    }

    /**
     * Sets dimension
     * @param string $dimension Left hand side for dimension predicates
     * @return $this
     */
    public function setDimension($dimension)
    {
        $allowed_values = array('conversationEnd', 'conversationId', 'divisionId', 'mediaStatsMinConversationMos', 'mediaStatsMinConversationRFactor', 'originatingDirection');
        if (!in_array($dimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dimension', must be one of 'conversationEnd', 'conversationId', 'divisionId', 'mediaStatsMinConversationMos', 'mediaStatsMinConversationRFactor', 'originatingDirection'");
        }
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric Left hand side for metric predicates
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('nBlindTransferred', 'nConnected', 'nConsult', 'nConsultTransferred', 'nError', 'nFlow', 'nFlowMilestone', 'nFlowOutcome', 'nFlowOutcomeFailed', 'nOffered', 'nOutbound', 'nOutboundAbandoned', 'nOutboundAttempted', 'nOutboundConnected', 'nOverSla', 'nStateTransitionError', 'nTransferred', 'oExternalMediaCount', 'oFlowMilestone', 'oMediaCount', 'tAbandon', 'tAcd', 'tAcw', 'tAgentResponseTime', 'tAlert', 'tAnswered', 'tContacting', 'tConversationDuration', 'tDialing', 'tFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlowOut', 'tFlowOutcome', 'tHandle', 'tHeld', 'tHeldComplete', 'tIvr', 'tMonitoring', 'tNotResponding', 'tShortAbandon', 'tTalk', 'tTalkComplete', 'tUserResponseTime', 'tVoicemail');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'nBlindTransferred', 'nConnected', 'nConsult', 'nConsultTransferred', 'nError', 'nFlow', 'nFlowMilestone', 'nFlowOutcome', 'nFlowOutcomeFailed', 'nOffered', 'nOutbound', 'nOutboundAbandoned', 'nOutboundAttempted', 'nOutboundConnected', 'nOverSla', 'nStateTransitionError', 'nTransferred', 'oExternalMediaCount', 'oFlowMilestone', 'oMediaCount', 'tAbandon', 'tAcd', 'tAcw', 'tAgentResponseTime', 'tAlert', 'tAnswered', 'tContacting', 'tConversationDuration', 'tDialing', 'tFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlowOut', 'tFlowOutcome', 'tHandle', 'tHeld', 'tHeldComplete', 'tIvr', 'tMonitoring', 'tNotResponding', 'tShortAbandon', 'tTalk', 'tTalkComplete', 'tUserResponseTime', 'tVoicemail'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator Optional operator, default is matches
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('matches', 'exists', 'notExists');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'matches', 'exists', 'notExists'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value Right hand side for dimension or metric predicates
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets range
     * @return \PureCloudSDK\NumericRange
     */
    public function getRange()
    {
        return $this->container['range'];
    }

    /**
     * Sets range
     * @param \PureCloudSDK\NumericRange $range Right hand side for dimension or metric predicates
     * @return $this
     */
    public function setRange($range)
    {
        $this->container['range'] = $range;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
