<?php

/**
 * Coretype
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * Coretype Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Coretype implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Coretype';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'version' => 'int',
        'dateCreated' => '\DateTime',
        'schema' => '\PureCloudSDK\Schema',
        'current' => 'bool',
        'validationFields' => 'string[]',
        'validationLimits' => '\PureCloudSDK\ValidationLimits',
        'itemValidationFields' => 'string[]',
        'itemValidationLimits' => '\PureCloudSDK\ItemValidationLimits',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'version' => 'version',
        'dateCreated' => 'dateCreated',
        'schema' => 'schema',
        'current' => 'current',
        'validationFields' => 'validationFields',
        'validationLimits' => 'validationLimits',
        'itemValidationFields' => 'itemValidationFields',
        'itemValidationLimits' => 'itemValidationLimits',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'version' => 'setVersion',
        'dateCreated' => 'setDateCreated',
        'schema' => 'setSchema',
        'current' => 'setCurrent',
        'validationFields' => 'setValidationFields',
        'validationLimits' => 'setValidationLimits',
        'itemValidationFields' => 'setItemValidationFields',
        'itemValidationLimits' => 'setItemValidationLimits',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'version' => 'getVersion',
        'dateCreated' => 'getDateCreated',
        'schema' => 'getSchema',
        'current' => 'getCurrent',
        'validationFields' => 'getValidationFields',
        'validationLimits' => 'getValidationLimits',
        'itemValidationFields' => 'getItemValidationFields',
        'itemValidationLimits' => 'getItemValidationLimits',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['schema'] = isset($data['schema']) ? $data['schema'] : null;
        $this->container['current'] = isset($data['current']) ? $data['current'] : null;
        $this->container['validationFields'] = isset($data['validationFields']) ? $data['validationFields'] : null;
        $this->container['validationLimits'] = isset($data['validationLimits']) ? $data['validationLimits'] : null;
        $this->container['itemValidationFields'] = isset($data['itemValidationFields']) ? $data['itemValidationFields'] : null;
        $this->container['itemValidationLimits'] = isset($data['itemValidationLimits']) ? $data['itemValidationLimits'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version A positive integer denoting the core type's version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated The date the core type was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets schema
     * @return \PureCloudSDK\Schema
     */
    public function getSchema()
    {
        return $this->container['schema'];
    }

    /**
     * Sets schema
     * @param \PureCloudSDK\Schema $schema The core type's built-in schema
     * @return $this
     */
    public function setSchema($schema)
    {
        $this->container['schema'] = $schema;

        return $this;
    }

    /**
     * Gets current
     * @return bool
     */
    public function getCurrent()
    {
        return $this->container['current'];
    }

    /**
     * Sets current
     * @param bool $current A boolean indicating if the core type's version is the current one in use by the system
     * @return $this
     */
    public function setCurrent($current)
    {
        $this->container['current'] = $current;

        return $this;
    }

    /**
     * Gets validationFields
     * @return string[]
     */
    public function getValidationFields()
    {
        return $this->container['validationFields'];
    }

    /**
     * Sets validationFields
     * @param string[] $validationFields An array of strings naming the fields of the core type subject to validation.  Validation constraints are specified by a schema author using the core type.
     * @return $this
     */
    public function setValidationFields($validationFields)
    {
        $this->container['validationFields'] = $validationFields;

        return $this;
    }

    /**
     * Gets validationLimits
     * @return \PureCloudSDK\ValidationLimits
     */
    public function getValidationLimits()
    {
        return $this->container['validationLimits'];
    }

    /**
     * Sets validationLimits
     * @param \PureCloudSDK\ValidationLimits $validationLimits A structure denoting the system-imposed minimum and maximum string length (for text-based core types) or numeric values (for number-based) core types.  For example, the validationLimits for a text-based core type specify the min/max values for a minimum string length (minLength) constraint supplied by a schemaauthor on a text field.  Similarly, the maxLength's min/max specifies maximum string length constraint supplied by a schema author for the same field.
     * @return $this
     */
    public function setValidationLimits($validationLimits)
    {
        $this->container['validationLimits'] = $validationLimits;

        return $this;
    }

    /**
     * Gets itemValidationFields
     * @return string[]
     */
    public function getItemValidationFields()
    {
        return $this->container['itemValidationFields'];
    }

    /**
     * Sets itemValidationFields
     * @param string[] $itemValidationFields Specific to the \"tag\" core type, this is an array of strings naming the tag item fields of the core type subject to validation
     * @return $this
     */
    public function setItemValidationFields($itemValidationFields)
    {
        $this->container['itemValidationFields'] = $itemValidationFields;

        return $this;
    }

    /**
     * Gets itemValidationLimits
     * @return \PureCloudSDK\ItemValidationLimits
     */
    public function getItemValidationLimits()
    {
        return $this->container['itemValidationLimits'];
    }

    /**
     * Sets itemValidationLimits
     * @param \PureCloudSDK\ItemValidationLimits $itemValidationLimits A structure denoting the system-imposed minimum and maximum string length for string-array based core types such as \"tag\" and \"enum\".  Forexample, the validationLimits for a schema field using a tag core type specify the min/max values for a minimum string length (minLength) constraint supplied by a schema author on individual tags.  Similarly, the maxLength's min/max specifies maximum string length constraint supplied by a schema author for the same field's tags.
     * @return $this
     */
    public function setItemValidationLimits($itemValidationLimits)
    {
        $this->container['itemValidationLimits'] = $itemValidationLimits;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
