<?php

/**
 * CreateBusinessUnitSettings
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CreateBusinessUnitSettings Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateBusinessUnitSettings implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateBusinessUnitSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'startDayOfWeek' => 'string',
        'timeZone' => 'string',
        'shortTermForecasting' => '\PureCloudSDK\BuShortTermForecastingSettings'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'startDayOfWeek' => 'startDayOfWeek',
        'timeZone' => 'timeZone',
        'shortTermForecasting' => 'shortTermForecasting'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'startDayOfWeek' => 'setStartDayOfWeek',
        'timeZone' => 'setTimeZone',
        'shortTermForecasting' => 'setShortTermForecasting'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'startDayOfWeek' => 'getStartDayOfWeek',
        'timeZone' => 'getTimeZone',
        'shortTermForecasting' => 'getShortTermForecasting'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const START_DAY_OF_WEEK_SUNDAY = 'Sunday';
    public const START_DAY_OF_WEEK_MONDAY = 'Monday';
    public const START_DAY_OF_WEEK_TUESDAY = 'Tuesday';
    public const START_DAY_OF_WEEK_WEDNESDAY = 'Wednesday';
    public const START_DAY_OF_WEEK_THURSDAY = 'Thursday';
    public const START_DAY_OF_WEEK_FRIDAY = 'Friday';
    public const START_DAY_OF_WEEK_SATURDAY = 'Saturday';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStartDayOfWeekAllowableValues()
    {
        return [
            self::START_DAY_OF_WEEK_SUNDAY,
            self::START_DAY_OF_WEEK_MONDAY,
            self::START_DAY_OF_WEEK_TUESDAY,
            self::START_DAY_OF_WEEK_WEDNESDAY,
            self::START_DAY_OF_WEEK_THURSDAY,
            self::START_DAY_OF_WEEK_FRIDAY,
            self::START_DAY_OF_WEEK_SATURDAY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['startDayOfWeek'] = isset($data['startDayOfWeek']) ? $data['startDayOfWeek'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['shortTermForecasting'] = isset($data['shortTermForecasting']) ? $data['shortTermForecasting'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['startDayOfWeek'] === null) {
            $invalid_properties[] = "'startDayOfWeek' can't be null";
        }
        $allowed_values = array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        if (!in_array($this->container['startDayOfWeek'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'startDayOfWeek', must be one of #{allowed_values}.";
        }

        if ($this->container['timeZone'] === null) {
            $invalid_properties[] = "'timeZone' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['startDayOfWeek'] === null) {
            return false;
        }
        $allowed_values = array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        if (!in_array($this->container['startDayOfWeek'], $allowed_values)) {
            return false;
        }
        if ($this->container['timeZone'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets startDayOfWeek
     * @return string
     */
    public function getStartDayOfWeek()
    {
        return $this->container['startDayOfWeek'];
    }

    /**
     * Sets startDayOfWeek
     * @param string $startDayOfWeek The start day of week for this business unit
     * @return $this
     */
    public function setStartDayOfWeek($startDayOfWeek)
    {
        $allowed_values = array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
        if (!in_array($startDayOfWeek, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'startDayOfWeek', must be one of 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'");
        }
        $this->container['startDayOfWeek'] = $startDayOfWeek;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone The time zone for this business unit, using the Olsen tz database format
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets shortTermForecasting
     * @return \PureCloudSDK\BuShortTermForecastingSettings
     */
    public function getShortTermForecasting()
    {
        return $this->container['shortTermForecasting'];
    }

    /**
     * Sets shortTermForecasting
     * @param \PureCloudSDK\BuShortTermForecastingSettings $shortTermForecasting Short term forecasting settings
     * @return $this
     */
    public function setShortTermForecasting($shortTermForecasting)
    {
        $this->container['shortTermForecasting'] = $shortTermForecasting;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
