<?php

/**
 * FlowRuntimeExecution
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * FlowRuntimeExecution Class Doc Comment
 *
 * @category    Class */
 // @description Details about the current state of a Flow execution
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowRuntimeExecution implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowRuntimeExecution';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'flowVersion' => '\PureCloudSDK\FlowVersion',
        'dateLaunched' => '\DateTime',
        'status' => 'string',
        'dateCompleted' => '\DateTime',
        'completionReason' => 'string',
        'flowErrorInfo' => '\PureCloudSDK\ErrorBody',
        'outputData' => 'map[string,object]',
        'conversation' => '\PureCloudSDK\DomainEntityRef',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'flowVersion' => 'flowVersion',
        'dateLaunched' => 'dateLaunched',
        'status' => 'status',
        'dateCompleted' => 'dateCompleted',
        'completionReason' => 'completionReason',
        'flowErrorInfo' => 'flowErrorInfo',
        'outputData' => 'outputData',
        'conversation' => 'conversation',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'flowVersion' => 'setFlowVersion',
        'dateLaunched' => 'setDateLaunched',
        'status' => 'setStatus',
        'dateCompleted' => 'setDateCompleted',
        'completionReason' => 'setCompletionReason',
        'flowErrorInfo' => 'setFlowErrorInfo',
        'outputData' => 'setOutputData',
        'conversation' => 'setConversation',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'flowVersion' => 'getFlowVersion',
        'dateLaunched' => 'getDateLaunched',
        'status' => 'getStatus',
        'dateCompleted' => 'getDateCompleted',
        'completionReason' => 'getCompletionReason',
        'flowErrorInfo' => 'getFlowErrorInfo',
        'outputData' => 'getOutputData',
        'conversation' => 'getConversation',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_UNKNOWN = 'UNKNOWN';
    public const STATUS_RUNNING = 'RUNNING';
    public const STATUS_ERROR = 'ERROR';
    public const STATUS_TERMINATED = 'TERMINATED';
    public const STATUS_COMPLETED = 'COMPLETED';
    public const STATUS_FAILED = 'FAILED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_UNKNOWN,
            self::STATUS_RUNNING,
            self::STATUS_ERROR,
            self::STATUS_TERMINATED,
            self::STATUS_COMPLETED,
            self::STATUS_FAILED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['flowVersion'] = isset($data['flowVersion']) ? $data['flowVersion'] : null;
        $this->container['dateLaunched'] = isset($data['dateLaunched']) ? $data['dateLaunched'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['dateCompleted'] = isset($data['dateCompleted']) ? $data['dateCompleted'] : null;
        $this->container['completionReason'] = isset($data['completionReason']) ? $data['completionReason'] : null;
        $this->container['flowErrorInfo'] = isset($data['flowErrorInfo']) ? $data['flowErrorInfo'] : null;
        $this->container['outputData'] = isset($data['outputData']) ? $data['outputData'] : null;
        $this->container['conversation'] = isset($data['conversation']) ? $data['conversation'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['flowVersion'] === null) {
            $invalid_properties[] = "'flowVersion' can't be null";
        }
        if ($this->container['dateLaunched'] === null) {
            $invalid_properties[] = "'dateLaunched' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalid_properties[] = "'status' can't be null";
        }
        $allowed_values = array("UNKNOWN", "RUNNING", "ERROR", "TERMINATED", "COMPLETED", "FAILED");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['flowVersion'] === null) {
            return false;
        }
        if ($this->container['dateLaunched'] === null) {
            return false;
        }
        if ($this->container['status'] === null) {
            return false;
        }
        $allowed_values = array("UNKNOWN", "RUNNING", "ERROR", "TERMINATED", "COMPLETED", "FAILED");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The flow execution ID
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The flow execution name.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets flowVersion
     * @return \PureCloudSDK\FlowVersion
     */
    public function getFlowVersion()
    {
        return $this->container['flowVersion'];
    }

    /**
     * Sets flowVersion
     * @param \PureCloudSDK\FlowVersion $flowVersion The Version of the flow definition of the flow execution.
     * @return $this
     */
    public function setFlowVersion($flowVersion)
    {
        $this->container['flowVersion'] = $flowVersion;

        return $this;
    }

    /**
     * Gets dateLaunched
     * @return \DateTime
     */
    public function getDateLaunched()
    {
        return $this->container['dateLaunched'];
    }

    /**
     * Sets dateLaunched
     * @param \DateTime $dateLaunched The time the flow was launched. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateLaunched($dateLaunched)
    {
        $this->container['dateLaunched'] = $dateLaunched;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The flow's running status, which indicates whether the flow is running normally or completed, etc.
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('UNKNOWN', 'RUNNING', 'ERROR', 'TERMINATED', 'COMPLETED', 'FAILED');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'UNKNOWN', 'RUNNING', 'ERROR', 'TERMINATED', 'COMPLETED', 'FAILED'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets dateCompleted
     * @return \DateTime
     */
    public function getDateCompleted()
    {
        return $this->container['dateCompleted'];
    }

    /**
     * Sets dateCompleted
     * @param \DateTime $dateCompleted The time the flow completed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCompleted($dateCompleted)
    {
        $this->container['dateCompleted'] = $dateCompleted;

        return $this;
    }

    /**
     * Gets completionReason
     * @return string
     */
    public function getCompletionReason()
    {
        return $this->container['completionReason'];
    }

    /**
     * Sets completionReason
     * @param string $completionReason The completion reason set at the flow completion time, if applicable.
     * @return $this
     */
    public function setCompletionReason($completionReason)
    {
        $this->container['completionReason'] = $completionReason;

        return $this;
    }

    /**
     * Gets flowErrorInfo
     * @return \PureCloudSDK\ErrorBody
     */
    public function getFlowErrorInfo()
    {
        return $this->container['flowErrorInfo'];
    }

    /**
     * Sets flowErrorInfo
     * @param \PureCloudSDK\ErrorBody $flowErrorInfo Additional information if the flow is in error
     * @return $this
     */
    public function setFlowErrorInfo($flowErrorInfo)
    {
        $this->container['flowErrorInfo'] = $flowErrorInfo;

        return $this;
    }

    /**
     * Gets outputData
     * @return map[string,object]
     */
    public function getOutputData()
    {
        return $this->container['outputData'];
    }

    /**
     * Sets outputData
     * @param map[string,object] $outputData List of the flow's output variables, if any. Output variables are only supplied for Completed flows.
     * @return $this
     */
    public function setOutputData($outputData)
    {
        $this->container['outputData'] = $outputData;

        return $this;
    }

    /**
     * Gets conversation
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getConversation()
    {
        return $this->container['conversation'];
    }

    /**
     * Sets conversation
     * @param \PureCloudSDK\DomainEntityRef $conversation The conversation to which this Flow execution is related
     * @return $this
     */
    public function setConversation($conversation)
    {
        $this->container['conversation'] = $conversation;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
