<?php

/**
 * HistoricalAdherenceDayMetrics
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * HistoricalAdherenceDayMetrics Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HistoricalAdherenceDayMetrics implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HistoricalAdherenceDayMetrics';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'dayStartOffsetSecs' => 'int',
        'adherenceScheduleSecs' => 'int',
        'conformanceScheduleSecs' => 'int',
        'conformanceActualSecs' => 'int',
        'exceptionCount' => 'int',
        'exceptionDurationSecs' => 'int',
        'impactSeconds' => 'int',
        'scheduleLengthSecs' => 'int',
        'actualLengthSecs' => 'int',
        'adherencePercentage' => 'double',
        'conformancePercentage' => 'double'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'dayStartOffsetSecs' => 'dayStartOffsetSecs',
        'adherenceScheduleSecs' => 'adherenceScheduleSecs',
        'conformanceScheduleSecs' => 'conformanceScheduleSecs',
        'conformanceActualSecs' => 'conformanceActualSecs',
        'exceptionCount' => 'exceptionCount',
        'exceptionDurationSecs' => 'exceptionDurationSecs',
        'impactSeconds' => 'impactSeconds',
        'scheduleLengthSecs' => 'scheduleLengthSecs',
        'actualLengthSecs' => 'actualLengthSecs',
        'adherencePercentage' => 'adherencePercentage',
        'conformancePercentage' => 'conformancePercentage'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'dayStartOffsetSecs' => 'setDayStartOffsetSecs',
        'adherenceScheduleSecs' => 'setAdherenceScheduleSecs',
        'conformanceScheduleSecs' => 'setConformanceScheduleSecs',
        'conformanceActualSecs' => 'setConformanceActualSecs',
        'exceptionCount' => 'setExceptionCount',
        'exceptionDurationSecs' => 'setExceptionDurationSecs',
        'impactSeconds' => 'setImpactSeconds',
        'scheduleLengthSecs' => 'setScheduleLengthSecs',
        'actualLengthSecs' => 'setActualLengthSecs',
        'adherencePercentage' => 'setAdherencePercentage',
        'conformancePercentage' => 'setConformancePercentage'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'dayStartOffsetSecs' => 'getDayStartOffsetSecs',
        'adherenceScheduleSecs' => 'getAdherenceScheduleSecs',
        'conformanceScheduleSecs' => 'getConformanceScheduleSecs',
        'conformanceActualSecs' => 'getConformanceActualSecs',
        'exceptionCount' => 'getExceptionCount',
        'exceptionDurationSecs' => 'getExceptionDurationSecs',
        'impactSeconds' => 'getImpactSeconds',
        'scheduleLengthSecs' => 'getScheduleLengthSecs',
        'actualLengthSecs' => 'getActualLengthSecs',
        'adherencePercentage' => 'getAdherencePercentage',
        'conformancePercentage' => 'getConformancePercentage'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['dayStartOffsetSecs'] = isset($data['dayStartOffsetSecs']) ? $data['dayStartOffsetSecs'] : null;
        $this->container['adherenceScheduleSecs'] = isset($data['adherenceScheduleSecs']) ? $data['adherenceScheduleSecs'] : null;
        $this->container['conformanceScheduleSecs'] = isset($data['conformanceScheduleSecs']) ? $data['conformanceScheduleSecs'] : null;
        $this->container['conformanceActualSecs'] = isset($data['conformanceActualSecs']) ? $data['conformanceActualSecs'] : null;
        $this->container['exceptionCount'] = isset($data['exceptionCount']) ? $data['exceptionCount'] : null;
        $this->container['exceptionDurationSecs'] = isset($data['exceptionDurationSecs']) ? $data['exceptionDurationSecs'] : null;
        $this->container['impactSeconds'] = isset($data['impactSeconds']) ? $data['impactSeconds'] : null;
        $this->container['scheduleLengthSecs'] = isset($data['scheduleLengthSecs']) ? $data['scheduleLengthSecs'] : null;
        $this->container['actualLengthSecs'] = isset($data['actualLengthSecs']) ? $data['actualLengthSecs'] : null;
        $this->container['adherencePercentage'] = isset($data['adherencePercentage']) ? $data['adherencePercentage'] : null;
        $this->container['conformancePercentage'] = isset($data['conformancePercentage']) ? $data['conformancePercentage'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets dayStartOffsetSecs
     * @return int
     */
    public function getDayStartOffsetSecs()
    {
        return $this->container['dayStartOffsetSecs'];
    }

    /**
     * Sets dayStartOffsetSecs
     * @param int $dayStartOffsetSecs Start of day offset in seconds relative to query start time
     * @return $this
     */
    public function setDayStartOffsetSecs($dayStartOffsetSecs)
    {
        $this->container['dayStartOffsetSecs'] = $dayStartOffsetSecs;

        return $this;
    }

    /**
     * Gets adherenceScheduleSecs
     * @return int
     */
    public function getAdherenceScheduleSecs()
    {
        return $this->container['adherenceScheduleSecs'];
    }

    /**
     * Sets adherenceScheduleSecs
     * @param int $adherenceScheduleSecs Duration of schedule in seconds included for adherence percentage calculation
     * @return $this
     */
    public function setAdherenceScheduleSecs($adherenceScheduleSecs)
    {
        $this->container['adherenceScheduleSecs'] = $adherenceScheduleSecs;

        return $this;
    }

    /**
     * Gets conformanceScheduleSecs
     * @return int
     */
    public function getConformanceScheduleSecs()
    {
        return $this->container['conformanceScheduleSecs'];
    }

    /**
     * Sets conformanceScheduleSecs
     * @param int $conformanceScheduleSecs Total scheduled duration in seconds for OnQueue activities
     * @return $this
     */
    public function setConformanceScheduleSecs($conformanceScheduleSecs)
    {
        $this->container['conformanceScheduleSecs'] = $conformanceScheduleSecs;

        return $this;
    }

    /**
     * Gets conformanceActualSecs
     * @return int
     */
    public function getConformanceActualSecs()
    {
        return $this->container['conformanceActualSecs'];
    }

    /**
     * Sets conformanceActualSecs
     * @param int $conformanceActualSecs Total actually worked duration in seconds for OnQueue activities
     * @return $this
     */
    public function setConformanceActualSecs($conformanceActualSecs)
    {
        $this->container['conformanceActualSecs'] = $conformanceActualSecs;

        return $this;
    }

    /**
     * Gets exceptionCount
     * @return int
     */
    public function getExceptionCount()
    {
        return $this->container['exceptionCount'];
    }

    /**
     * Sets exceptionCount
     * @param int $exceptionCount Total number of adherence exceptions for this user
     * @return $this
     */
    public function setExceptionCount($exceptionCount)
    {
        $this->container['exceptionCount'] = $exceptionCount;

        return $this;
    }

    /**
     * Gets exceptionDurationSecs
     * @return int
     */
    public function getExceptionDurationSecs()
    {
        return $this->container['exceptionDurationSecs'];
    }

    /**
     * Sets exceptionDurationSecs
     * @param int $exceptionDurationSecs Total duration in seconds of adherence exceptions for this user
     * @return $this
     */
    public function setExceptionDurationSecs($exceptionDurationSecs)
    {
        $this->container['exceptionDurationSecs'] = $exceptionDurationSecs;

        return $this;
    }

    /**
     * Gets impactSeconds
     * @return int
     */
    public function getImpactSeconds()
    {
        return $this->container['impactSeconds'];
    }

    /**
     * Sets impactSeconds
     * @param int $impactSeconds The impact duration in seconds of current adherence state for this user
     * @return $this
     */
    public function setImpactSeconds($impactSeconds)
    {
        $this->container['impactSeconds'] = $impactSeconds;

        return $this;
    }

    /**
     * Gets scheduleLengthSecs
     * @return int
     */
    public function getScheduleLengthSecs()
    {
        return $this->container['scheduleLengthSecs'];
    }

    /**
     * Sets scheduleLengthSecs
     * @param int $scheduleLengthSecs Total duration in seconds for all scheduled activities
     * @return $this
     */
    public function setScheduleLengthSecs($scheduleLengthSecs)
    {
        $this->container['scheduleLengthSecs'] = $scheduleLengthSecs;

        return $this;
    }

    /**
     * Gets actualLengthSecs
     * @return int
     */
    public function getActualLengthSecs()
    {
        return $this->container['actualLengthSecs'];
    }

    /**
     * Sets actualLengthSecs
     * @param int $actualLengthSecs Total duration in seconds for all actually worked activities
     * @return $this
     */
    public function setActualLengthSecs($actualLengthSecs)
    {
        $this->container['actualLengthSecs'] = $actualLengthSecs;

        return $this;
    }

    /**
     * Gets adherencePercentage
     * @return double
     */
    public function getAdherencePercentage()
    {
        return $this->container['adherencePercentage'];
    }

    /**
     * Sets adherencePercentage
     * @param double $adherencePercentage Total adherence percentage for this user, in the scale of 0 - 100
     * @return $this
     */
    public function setAdherencePercentage($adherencePercentage)
    {
        $this->container['adherencePercentage'] = $adherencePercentage;

        return $this;
    }

    /**
     * Gets conformancePercentage
     * @return double
     */
    public function getConformancePercentage()
    {
        return $this->container['conformancePercentage'];
    }

    /**
     * Sets conformancePercentage
     * @param double $conformancePercentage Total conformance percentage for this user, in the scale of 0 - 100. Conformance percentage can be greater than 100 when the actual on queue time is greater than the scheduled on queue time for the same period.
     * @return $this
     */
    public function setConformancePercentage($conformancePercentage)
    {
        $this->container['conformancePercentage'] = $conformancePercentage;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
