<?php
/**
 * AnalyticsRoutingStatusRecord
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsRoutingStatusRecord Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsRoutingStatusRecord implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsRoutingStatusRecord';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'startTime' => '\DateTime',
        'endTime' => '\DateTime',
        'routingStatus' => 'string',
        'durationMilliseconds' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'startTime' => 'startTime',
        'endTime' => 'endTime',
        'routingStatus' => 'routingStatus',
        'durationMilliseconds' => 'durationMilliseconds'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'startTime' => 'setStartTime',
        'endTime' => 'setEndTime',
        'routingStatus' => 'setRoutingStatus',
        'durationMilliseconds' => 'setDurationMilliseconds'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'startTime' => 'getStartTime',
        'endTime' => 'getEndTime',
        'routingStatus' => 'getRoutingStatus',
        'durationMilliseconds' => 'getDurationMilliseconds'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ROUTING_STATUS_OFF_QUEUE = 'OFF_QUEUE';
    const ROUTING_STATUS_IDLE = 'IDLE';
    const ROUTING_STATUS_INTERACTING = 'INTERACTING';
    const ROUTING_STATUS_NOT_RESPONDING = 'NOT_RESPONDING';
    const ROUTING_STATUS_COMMUNICATING = 'COMMUNICATING';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRoutingStatusAllowableValues()
    {
        return [
            self::ROUTING_STATUS_OFF_QUEUE,
            self::ROUTING_STATUS_IDLE,
            self::ROUTING_STATUS_INTERACTING,
            self::ROUTING_STATUS_NOT_RESPONDING,
            self::ROUTING_STATUS_COMMUNICATING,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['startTime'] = isset($data['startTime']) ? $data['startTime'] : null;
        $this->container['endTime'] = isset($data['endTime']) ? $data['endTime'] : null;
        $this->container['routingStatus'] = isset($data['routingStatus']) ? $data['routingStatus'] : null;
        $this->container['durationMilliseconds'] = isset($data['durationMilliseconds']) ? $data['durationMilliseconds'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("OFF_QUEUE", "IDLE", "INTERACTING", "NOT_RESPONDING", "COMMUNICATING");
        if (!in_array($this->container['routingStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'routingStatus', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("OFF_QUEUE", "IDLE", "INTERACTING", "NOT_RESPONDING", "COMMUNICATING");
        if (!in_array($this->container['routingStatus'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets startTime
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['startTime'];
    }

    /**
     * Sets startTime
     * @param \DateTime $startTime The start time of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartTime($startTime)
    {
        $this->container['startTime'] = $startTime;

        return $this;
    }

    /**
     * Gets endTime
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['endTime'];
    }

    /**
     * Sets endTime
     * @param \DateTime $endTime The end time of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndTime($endTime)
    {
        $this->container['endTime'] = $endTime;

        return $this;
    }

    /**
     * Gets routingStatus
     * @return string
     */
    public function getRoutingStatus()
    {
        return $this->container['routingStatus'];
    }

    /**
     * Sets routingStatus
     * @param string $routingStatus The user's ACD routing status
     * @return $this
     */
    public function setRoutingStatus($routingStatus)
    {
        $allowed_values = array('OFF_QUEUE', 'IDLE', 'INTERACTING', 'NOT_RESPONDING', 'COMMUNICATING');
        if (!in_array($routingStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'routingStatus', must be one of 'OFF_QUEUE', 'IDLE', 'INTERACTING', 'NOT_RESPONDING', 'COMMUNICATING'");
        }
        $this->container['routingStatus'] = $routingStatus;

        return $this;
    }

    /**
     * Gets durationMilliseconds
     * @return int
     */
    public function getDurationMilliseconds()
    {
        return $this->container['durationMilliseconds'];
    }

    /**
     * Sets durationMilliseconds
     * @param int $durationMilliseconds The duration of the status (in milliseconds)
     * @return $this
     */
    public function setDurationMilliseconds($durationMilliseconds)
    {
        $this->container['durationMilliseconds'] = $durationMilliseconds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


